/*
 * Decompiled with CFR 0.152.
 */
package team.cqr.cqrepoured.objects.entity.projectiles;

import com.google.common.base.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import team.cqr.cqrepoured.CQRMain;
import team.cqr.cqrepoured.init.CQRSerializers;
import team.cqr.cqrepoured.network.server.packet.SPacketHookShotPlayerStop;
import team.cqr.cqrepoured.objects.entity.projectiles.ProjectileBase;
import team.cqr.cqrepoured.objects.items.ItemHookshotBase;
import team.cqr.cqrepoured.util.CQRConfig;

public class ProjectileHookShotHook
extends ProjectileBase {
    private static final double STOP_LATCH_DISTANCE = 3.0;
    private static final double STOP_PULL_DISTANCE = 2.0;
    private Vec3d startLocation = null;
    protected double hookRange = 20.0;
    private EnumHookState travelState = EnumHookState.SHOOT;
    private int ticksThisState = 0;
    private Entity pulledEntity = null;
    private Vec3d lastCheckedPosition = null;
    private int lastMovementCheckTick = 0;
    private ItemHookshotBase hookshot = null;
    private ItemStack shooterItemStack = null;
    protected static final DataParameter<Vec3d> DESTINATION_POS = EntityDataManager.func_187226_a(ProjectileHookShotHook.class, CQRSerializers.VEC3D);
    protected static final DataParameter<Vec3d> SHOOTER_POS = EntityDataManager.func_187226_a(ProjectileHookShotHook.class, CQRSerializers.VEC3D);
    protected static final DataParameter<Integer> PULL_STATUS = EntityDataManager.func_187226_a(ProjectileHookShotHook.class, (DataSerializer)DataSerializers.field_187192_b);
    protected static final DataParameter<Optional<UUID>> SHOOTER_UUID = EntityDataManager.func_187226_a(ProjectileHookShotHook.class, (DataSerializer)DataSerializers.field_187203_m);
    protected static final DataParameter<Optional<UUID>> PULLING_UUID = EntityDataManager.func_187226_a(ProjectileHookShotHook.class, (DataSerializer)DataSerializers.field_187203_m);

    public ProjectileHookShotHook(World worldIn) {
        super(worldIn);
    }

    public ProjectileHookShotHook(World worldIn, double x, double y, double z, double range) {
        super(worldIn, x, y, z);
        this.hookRange = range;
    }

    public ProjectileHookShotHook(World worldIn, EntityLivingBase shooter, ItemHookshotBase hookshot, ItemStack stack) {
        super(worldIn, shooter);
        this.field_70180_af.func_187227_b(SHOOTER_UUID, (Object)Optional.of((Object)shooter.getPersistentID()));
        this.startLocation = this.calcShooterBodyPosition();
        this.setShooterPosition(this.startLocation);
        this.hookshot = hookshot;
        this.hookRange = hookshot.getHookRange();
        this.shooterItemStack = stack;
        this.setHookItemShootingTag(true);
    }

    @Override
    public boolean func_189652_ae() {
        return true;
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(DESTINATION_POS, (Object)new Vec3d(0.0, 0.0, 0.0));
        this.field_70180_af.func_187214_a(SHOOTER_POS, (Object)new Vec3d(0.0, 0.0, 0.0));
        this.field_70180_af.func_187214_a(PULL_STATUS, (Object)EnumHookState.SHOOT.toInt());
        this.field_70180_af.func_187214_a(SHOOTER_UUID, (Object)Optional.absent());
        this.field_70180_af.func_187214_a(PULLING_UUID, (Object)Optional.absent());
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        this.periodicSaveShooterPosition();
        if (!this.isPullingShooter() && this.func_85052_h() instanceof EntityPlayerMP) {
            this.zeroizePlayerVelocity((EntityPlayerMP)this.func_85052_h());
        }
        if (this.func_85052_h() != null && this.func_85052_h().field_70128_L) {
            this.stopPulling();
            this.func_70106_y();
            this.setHookItemShootingTag(false);
        } else if (!this.field_70170_p.field_72995_K) {
            this.hookStateMachine();
        } else if (this.isPullingShooter() && this.field_70170_p.field_72995_K) {
            this.pullIfClientIsShooter();
        } else if (this.isPullingPlayer() && this.field_70170_p.field_72995_K) {
            this.pullIfClientIsPulledEntity();
        }
    }

    private void hookStateMachine() {
        switch (this.travelState) {
            case SHOOT: {
                this.shootState();
                break;
            }
            case PRE_NO_LATCH: {
                this.preNoLatchState();
                break;
            }
            case RETRACT_NO_LATCH: {
                this.noLatchRetractState();
                break;
            }
            case PRE_PULL_ENTITY: {
                this.prePullEntityState();
                break;
            }
            case RETRACT_PULL_ENTITY: {
                this.retractPullEntityState();
                break;
            }
            case PRE_LATCH: {
                this.preLatchState();
                break;
            }
            case LATCHED_PULL_SHOOTER: {
                this.latchedPullShooterState();
                break;
            }
            case STOPPED: {
                this.func_70106_y();
                this.zeroizeHookVelocity();
                this.setHookItemShootingTag(false);
            }
        }
        ++this.ticksThisState;
    }

    public void func_70030_z() {
        super.func_70030_z();
        if (this.func_85052_h() == null && this.getShooterUUID() == null) {
            this.func_70106_y();
            this.setHookItemShootingTag(false);
        } else if (this.func_85052_h() == null && !this.field_70170_p.field_72995_K) {
            this.field_70192_c = (EntityLivingBase)((WorldServer)this.field_70170_p).func_175733_a(this.getShooterUUID());
        }
    }

    @Override
    protected void func_70184_a(RayTraceResult result) {
        if (!this.field_70170_p.field_72995_K && this.travelState == EnumHookState.SHOOT) {
            if (result.field_72313_a == RayTraceResult.Type.BLOCK) {
                IBlockState state = this.field_70170_p.func_180495_p(result.func_178782_a());
                if (!state.func_177230_c().func_176205_b((IBlockAccess)this.field_70170_p, result.func_178782_a())) {
                    if (this.hookshot.canLatchToBlock(state.func_177230_c())) {
                        this.triggerLatch();
                    } else {
                        this.triggerNoLatchRetract();
                    }
                }
            } else if (result.field_72313_a == RayTraceResult.Type.ENTITY && result.field_72308_g != this.field_70192_c && result.field_72308_g instanceof EntityLivingBase) {
                if (CQRConfig.general.hookOnlyPullsSmallerEntities) {
                    double sizeOwner = this.field_70192_c != null ? (double)(this.field_70192_c.field_70130_N * this.field_70192_c.field_70131_O) : 2.0;
                    double sizeHit = result.field_72308_g.field_70130_N * result.field_72308_g.field_70131_O;
                    if ((sizeOwner *= 1.25) >= sizeHit) {
                        this.triggerEntityPull(result.field_72308_g);
                    } else {
                        this.triggerLatch();
                    }
                } else {
                    this.triggerEntityPull(result.field_72308_g);
                }
            }
        }
    }

    private void shootState() {
        if (this.getDistanceToHook() > this.hookRange) {
            this.triggerNoLatchRetract();
        }
    }

    private void preNoLatchState() {
        if (this.ticksThisState >= 1) {
            this.changeState(EnumHookState.RETRACT_NO_LATCH);
            this.reverseVelocity();
        }
    }

    private void noLatchRetractState() {
        if (this.func_174791_d().func_72438_d(this.getShooterPosition()) < 3.0) {
            this.stopPulling();
        }
    }

    private void prePullEntityState() {
        if (this.ticksThisState >= 1) {
            this.reverseVelocity();
            this.field_70180_af.func_187227_b(DESTINATION_POS, (Object)this.startLocation);
            this.changeState(EnumHookState.RETRACT_PULL_ENTITY);
        }
    }

    private void retractPullEntityState() {
        this.checkForEntityBlockedPath();
        if (!(this.pulledEntity instanceof EntityPlayerMP)) {
            if (this.func_174791_d().func_72438_d(this.getShooterPosition()) < 2.0) {
                this.zeroizeHookVelocity();
                this.stopPulling();
            }
            if (this.pulledEntity.func_174791_d().func_72438_d(this.getShooterPosition()) < 2.0) {
                this.stopPulling();
                this.pulledEntity.field_70159_w = 0.0;
                this.pulledEntity.field_70181_x = 0.0;
                this.pulledEntity.field_70179_y = 0.0;
                this.pulledEntity.field_70133_I = true;
            } else {
                this.pulledEntity.field_70159_w = this.field_70159_w;
                this.pulledEntity.field_70181_x = this.field_70181_x;
                this.pulledEntity.field_70179_y = this.field_70179_y;
                this.pulledEntity.field_70133_I = true;
            }
        }
    }

    public boolean isReturning() {
        return this.travelState == EnumHookState.RETRACT_NO_LATCH || this.travelState == EnumHookState.RETRACT_PULL_ENTITY;
    }

    private void preLatchState() {
        if (this.ticksThisState >= 1) {
            this.zeroizeHookVelocity();
            this.field_70180_af.func_187227_b(DESTINATION_POS, (Object)this.func_174791_d());
            this.changeState(EnumHookState.LATCHED_PULL_SHOOTER);
        }
    }

    private void latchedPullShooterState() {
        if (this.func_85052_h() instanceof EntityLivingBase) {
            this.checkForShooterBlockedPath();
            Vec3d playerPos = this.func_85052_h().func_174791_d();
            double distanceToHook = playerPos.func_72438_d(this.func_174791_d());
            if (distanceToHook < 3.0) {
                this.stopPulling();
            }
        }
    }

    private void triggerEntityPull(Entity entityHit) {
        this.pulledEntity = entityHit;
        if (this.pulledEntity instanceof EntityPlayerMP) {
            this.field_70180_af.func_187227_b(PULLING_UUID, (Object)Optional.of((Object)this.pulledEntity.getPersistentID()));
        }
        this.changeState(EnumHookState.PRE_PULL_ENTITY);
    }

    private void triggerLatch() {
        this.changeState(EnumHookState.PRE_LATCH);
    }

    private void triggerNoLatchRetract() {
        this.changeState(EnumHookState.PRE_NO_LATCH);
    }

    private void changeState(EnumHookState stateIn) {
        this.travelState = stateIn;
        this.field_70180_af.func_187227_b(PULL_STATUS, (Object)this.travelState.toInt());
        this.ticksThisState = 0;
    }

    private void zeroizeHookVelocity() {
        this.field_70159_w = 0.0;
        this.field_70181_x = 0.0;
        this.field_70179_y = 0.0;
        this.field_70133_I = true;
    }

    private void reverseVelocity() {
        this.field_70159_w = -this.field_70159_w;
        this.field_70181_x = -this.field_70181_x;
        this.field_70179_y = -this.field_70179_y;
        this.field_70133_I = true;
    }

    private void zeroizePlayerVelocity(EntityPlayerMP shootingPlayer) {
        if (!this.field_70170_p.field_72995_K) {
            SPacketHookShotPlayerStop pullPacket = new SPacketHookShotPlayerStop();
            CQRMain.NETWORK.sendTo((IMessage)pullPacket, shootingPlayer);
        }
    }

    private double getDistanceToHook() {
        double result = 0.0;
        if (this.func_85052_h() != null) {
            EntityLivingBase shootingPlayer = this.func_85052_h();
            Vec3d playerPos = shootingPlayer.func_174791_d();
            result = playerPos.func_72438_d(this.func_174791_d());
        }
        return result;
    }

    private void checkForShooterBlockedPath() {
        if (this.field_70173_aa - this.lastMovementCheckTick >= 4 && this.func_85052_h() != null) {
            double distanceTraveled;
            Vec3d currentPos = this.func_85052_h().func_174791_d();
            if (this.lastCheckedPosition != null && (distanceTraveled = currentPos.func_72438_d(this.lastCheckedPosition)) < 0.4) {
                this.stopPulling();
            }
            this.lastMovementCheckTick = this.field_70173_aa;
            this.lastCheckedPosition = this.func_85052_h().func_174791_d();
        }
    }

    private void checkForEntityBlockedPath() {
        if (this.field_70173_aa - this.lastMovementCheckTick >= 4) {
            double distanceTraveled;
            Vec3d currentPos = this.pulledEntity.func_174791_d();
            if (this.lastCheckedPosition != null && (distanceTraveled = currentPos.func_72438_d(this.lastCheckedPosition)) < 0.4) {
                this.stopPulling();
            }
            this.lastMovementCheckTick = this.field_70173_aa;
            this.lastCheckedPosition = this.pulledEntity.func_174791_d();
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void pullIfClientIsShooter() {
        if (this.field_70170_p.field_72995_K) {
            EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
            Optional shooterUUID = (Optional)this.field_70180_af.func_187225_a(SHOOTER_UUID);
            if (shooterUUID.isPresent() && player.func_110124_au().equals(shooterUUID.get())) {
                Vec3d playerPos = player.func_174791_d();
                Vec3d latchPos = this.getDestinationPosition();
                if (latchPos != null) {
                    double distanceToHook = playerPos.func_72438_d(latchPos);
                    if (distanceToHook < 3.0) {
                        player.func_70016_h(0.0, 0.0, 0.0);
                        player.field_70133_I = true;
                        return;
                    }
                    Vec3d hookDirection = latchPos.func_178788_d(playerPos);
                    Vec3d pullV = hookDirection.func_72432_b().func_186678_a(this.getTravelSpeed());
                    player.func_70016_h(pullV.field_72450_a, pullV.field_72448_b, pullV.field_72449_c);
                    player.field_70133_I = true;
                }
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void pullIfClientIsPulledEntity() {
        if (this.field_70170_p.field_72995_K) {
            EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
            Optional pulledUUID = (Optional)this.field_70180_af.func_187225_a(PULLING_UUID);
            if (pulledUUID.isPresent() && player.func_110124_au().equals(pulledUUID.get())) {
                Vec3d playerPos = player.func_174791_d();
                Vec3d destPos = this.getDestinationPosition();
                if (destPos != null) {
                    double distanceToHook = playerPos.func_72438_d(destPos);
                    if (distanceToHook < 2.0) {
                        player.func_70016_h(0.0, 0.0, 0.0);
                        player.field_70133_I = true;
                        return;
                    }
                    player.func_70016_h(this.field_70159_w, this.field_70181_x, this.field_70179_y);
                    player.field_70133_I = true;
                }
            }
        }
    }

    public void func_70037_a(NBTTagCompound compound) {
        double x = compound.func_74769_h("cqrdata.impactX");
        double y = compound.func_74769_h("cqrdata.impactY");
        double z = compound.func_74769_h("cqrdata.impactZ");
        this.field_70180_af.func_187227_b(DESTINATION_POS, (Object)new Vec3d(x, y, z));
        x = compound.func_74769_h("cqrdata.shooterX");
        y = compound.func_74769_h("cqrdata.shooterY");
        z = compound.func_74769_h("cqrdata.shooterZ");
        this.field_70180_af.func_187227_b(SHOOTER_POS, (Object)new Vec3d(x, y, z));
        this.field_70180_af.func_187227_b(PULL_STATUS, (Object)compound.func_74762_e("cqrdata.travelState"));
        if (compound.func_74764_b("cqrdata.shooterUUID")) {
            this.field_70180_af.func_187227_b(SHOOTER_UUID, (Object)Optional.of((Object)compound.func_186857_a("cqrdata.shooterUUID")));
        }
    }

    public void func_70014_b(NBTTagCompound compound) {
        Vec3d impactLocation = (Vec3d)this.field_70180_af.func_187225_a(DESTINATION_POS);
        compound.func_74780_a("cqrdata.impactX", impactLocation.field_72450_a);
        compound.func_74780_a("cqrdata.impactY", impactLocation.field_72448_b);
        compound.func_74780_a("cqrdata.impactZ", impactLocation.field_72449_c);
        Vec3d shooterPosition = (Vec3d)this.field_70180_af.func_187225_a(SHOOTER_POS);
        compound.func_74780_a("cqrdata.shooterX", shooterPosition.field_72450_a);
        compound.func_74780_a("cqrdata.shooterY", shooterPosition.field_72448_b);
        compound.func_74780_a("cqrdata.shooterZ", shooterPosition.field_72449_c);
        compound.func_74768_a("cqrdata.travelState", ((Integer)this.field_70180_af.func_187225_a(PULL_STATUS)).intValue());
        if (((Optional)this.field_70180_af.func_187225_a(SHOOTER_UUID)).isPresent()) {
            compound.func_186854_a("cqrdata.shooterUUID", (UUID)((Optional)this.field_70180_af.func_187225_a(SHOOTER_UUID)).get());
        }
    }

    private void stopPulling() {
        this.changeState(EnumHookState.STOPPED);
    }

    public boolean isPullingShooter() {
        return this.getTravelState() == EnumHookState.LATCHED_PULL_SHOOTER;
    }

    public boolean isPullingPlayer() {
        return this.getTravelState() == EnumHookState.RETRACT_PULL_ENTITY && this.getPulledPlayerUUID() != null;
    }

    private EnumHookState getTravelState() {
        return EnumHookState.fromInt((Integer)this.field_70180_af.func_187225_a(PULL_STATUS));
    }

    public double getTravelSpeed() {
        return 1.8;
    }

    private void periodicSaveShooterPosition() {
        if (!this.field_70170_p.field_72995_K && this.field_70192_c != null) {
            this.setShooterPosition(this.calcShooterBodyPosition());
        }
    }

    private Vec3d calcShooterBodyPosition() {
        return this.field_70192_c.func_174791_d().func_72441_c(0.0, (double)this.field_70192_c.func_70047_e() * 0.6, 0.0);
    }

    private void setShooterPosition(Vec3d shooterPos) {
        this.field_70180_af.func_187227_b(SHOOTER_POS, (Object)shooterPos);
    }

    public Vec3d getShooterPosition() {
        return (Vec3d)this.field_70180_af.func_187225_a(SHOOTER_POS);
    }

    @Nullable
    public UUID getShooterUUID() {
        if (((Optional)this.field_70180_af.func_187225_a(SHOOTER_UUID)).isPresent()) {
            return (UUID)((Optional)this.field_70180_af.func_187225_a(SHOOTER_UUID)).get();
        }
        return null;
    }

    public UUID getPulledPlayerUUID() {
        if (((Optional)this.field_70180_af.func_187225_a(PULLING_UUID)).isPresent()) {
            return (UUID)((Optional)this.field_70180_af.func_187225_a(PULLING_UUID)).get();
        }
        return null;
    }

    @Nullable
    public Vec3d getDestinationPosition() {
        return (Vec3d)this.field_70180_af.func_187225_a(DESTINATION_POS);
    }

    private void setHookItemShootingTag(boolean isShooting) {
        if (this.shooterItemStack != null) {
            NBTTagCompound hookNbt = this.shooterItemStack.func_77942_o() ? this.shooterItemStack.func_77978_p() : new NBTTagCompound();
            hookNbt.func_74757_a("isShooting", isShooting);
            this.shooterItemStack.func_77982_d(hookNbt);
        }
    }

    private static enum EnumHookState {
        SHOOT(0),
        PRE_NO_LATCH(1),
        RETRACT_NO_LATCH(2),
        PRE_PULL_ENTITY(3),
        RETRACT_PULL_ENTITY(4),
        PRE_LATCH(5),
        LATCHED_PULL_SHOOTER(6),
        STOPPED(7);

        private final int value;

        private EnumHookState(int valIn) {
            this.value = valIn;
        }

        public int toInt() {
            return this.value;
        }

        public static EnumHookState fromInt(int value) {
            for (EnumHookState ps : EnumHookState.values()) {
                if (ps.value != value) continue;
                return ps;
            }
            return SHOOT;
        }
    }
}

