/*
 * Decompiled with CFR 0.152.
 */
package team.cqr.cqrepoured.objects.factories;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.MobSpawnerBaseLogic;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityMobSpawner;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.WeightedSpawnerEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import team.cqr.cqrepoured.init.CQRBlocks;
import team.cqr.cqrepoured.init.CQRItems;
import team.cqr.cqrepoured.objects.entity.bases.AbstractEntityCQR;
import team.cqr.cqrepoured.objects.entity.bases.AbstractEntityCQRBoss;
import team.cqr.cqrepoured.tileentity.TileEntitySpawner;

public abstract class SpawnerFactory {
    public static void placeSpawner(Entity[] entities, boolean multiUseSpawner, @Nullable NBTTagCompound spawnerSettingsOverrides, World world, BlockPos pos) {
        NBTTagCompound[] entCompounds = new NBTTagCompound[entities.length];
        for (int i = 0; i < entities.length; ++i) {
            Entity ent = entities[i];
            if (ent == null) continue;
            entCompounds[i] = SpawnerFactory.createSpawnerNBTFromEntity(ent);
        }
        SpawnerFactory.placeSpawner(entCompounds, multiUseSpawner, spawnerSettingsOverrides, world, pos);
    }

    public static void placeSpawner(NBTTagCompound[] entities, boolean multiUseSpawner, @Nullable NBTTagCompound spawnerSettingsOverrides, World world, BlockPos pos) {
        world.func_175656_a(pos, multiUseSpawner ? Blocks.field_150474_ac.func_176223_P() : CQRBlocks.SPAWNER.func_176223_P());
        TileEntity tileEntity = world.func_175625_s(pos);
        if (multiUseSpawner) {
            TileEntityMobSpawner tileEntityMobSpawner = (TileEntityMobSpawner)tileEntity;
            NBTTagCompound compound = tileEntityMobSpawner.func_189515_b(new NBTTagCompound());
            NBTTagList spawnPotentials = new NBTTagList();
            for (int i = 0; i < entities.length; ++i) {
                if (entities[i] == null) continue;
                entities[i].func_82580_o("UUIDLeast");
                entities[i].func_82580_o("UUIDMost");
                entities[i].func_82580_o("Pos");
                NBTTagList passengers = entities[i].func_150295_c("Passengers", 10);
                for (NBTBase passenger : passengers) {
                    ((NBTTagCompound)passenger).func_82580_o("UUIDLeast");
                    ((NBTTagCompound)passenger).func_82580_o("UUIDMost");
                    ((NBTTagCompound)passenger).func_82580_o("Pos");
                }
                NBTTagCompound spawnPotential = new NBTTagCompound();
                spawnPotential.func_74768_a("Weight", 1);
                spawnPotential.func_74782_a("Entity", (NBTBase)entities[i]);
                spawnPotentials.func_74742_a((NBTBase)spawnPotential);
            }
            compound.func_74782_a("SpawnPotentials", (NBTBase)spawnPotentials);
            compound.func_82580_o("SpawnData");
            if (spawnerSettingsOverrides != null) {
                compound.func_74768_a("MinSpawnDelay", spawnerSettingsOverrides.func_74762_e("MinSpawnDelay"));
                compound.func_74768_a("MaxSpawnDelay", spawnerSettingsOverrides.func_74762_e("MaxSpawnDelay"));
                compound.func_74768_a("SpawnCount", spawnerSettingsOverrides.func_74762_e("SpawnCount"));
                compound.func_74768_a("MaxNearbyEntities", spawnerSettingsOverrides.func_74762_e("MaxNearbyEntities"));
                compound.func_74768_a("SpawnRange", spawnerSettingsOverrides.func_74762_e("SpawnRange"));
                compound.func_74768_a("RequiredPlayerRange", spawnerSettingsOverrides.func_74762_e("RequiredPlayerRange"));
            }
            tileEntityMobSpawner.func_145839_a(compound);
            tileEntityMobSpawner.func_70296_d();
        } else {
            TileEntitySpawner tileEntitySpawner = (TileEntitySpawner)tileEntity;
            for (int i = 0; i < entities.length && i < 9; ++i) {
                if (entities[i] == null) continue;
                tileEntitySpawner.inventory.setStackInSlot(i, SpawnerFactory.getSoulBottleItemStackForEntity(entities[i]));
            }
            tileEntitySpawner.func_70296_d();
        }
    }

    public static void createSimpleMultiUseSpawner(World world, BlockPos pos, ResourceLocation entityResLoc) {
        world.func_175656_a(pos, Blocks.field_150474_ac.func_176223_P());
        TileEntityMobSpawner spawner = (TileEntityMobSpawner)world.func_175625_s(pos);
        spawner.func_145881_a().func_190894_a(entityResLoc);
        spawner.func_145836_u();
        spawner.func_73660_a();
    }

    public static TileEntityMobSpawner getSpawnerTile(World world, ResourceLocation entity, BlockPos pos) {
        TileEntityMobSpawner spawner = (TileEntityMobSpawner)world.func_175625_s(pos);
        spawner.func_145881_a().func_190894_a(entity);
        return spawner;
    }

    public static void createSimpleMultiUseSpawner(World world, BlockPos pos, Entity entity) {
        SpawnerFactory.createSimpleMultiUseSpawner(world, pos, EntityList.func_191301_a((Entity)entity));
    }

    public static void convertCQSpawnerToVanillaSpawner(World world, BlockPos pos, @Nullable NBTTagCompound spawnerSettings) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileEntitySpawner) {
            TileEntitySpawner spawner = (TileEntitySpawner)tile;
            NBTTagCompound[] entities = new NBTTagCompound[spawner.inventory.getSlots()];
            for (int i = 0; i < entities.length; ++i) {
                ItemStack stack = spawner.inventory.extractItem(i, spawner.inventory.getStackInSlot(i).func_190916_E(), false);
                if (stack != null && !stack.func_190926_b() && stack.func_190916_E() >= 1) {
                    try {
                        NBTTagCompound tag = stack.func_77978_p();
                        entities[i] = tag.func_74775_l("EntityIn");
                    }
                    catch (NullPointerException nullPointerException) {}
                    continue;
                }
                entities[i] = null;
            }
            world.func_175698_g(pos);
            SpawnerFactory.placeSpawner(entities, true, spawnerSettings, world, pos);
        }
    }

    public static void convertVanillaSpawnerToCQSpawner(World world, BlockPos pos) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile != null && tile instanceof TileEntityMobSpawner) {
            TileEntityMobSpawner spawnerMultiUseTile = (TileEntityMobSpawner)tile;
            List spawnerEntries = new ArrayList();
            spawnerEntries = (List)ObfuscationReflectionHelper.getPrivateValue(MobSpawnerBaseLogic.class, (Object)spawnerMultiUseTile.func_145881_a(), (int)1);
            if (spawnerEntries != null && !spawnerEntries.isEmpty()) {
                Iterator iterator = spawnerEntries.iterator();
                NBTTagCompound[] entityCompound = new NBTTagCompound[9];
                for (int entriesRead = 0; entriesRead < 9 && iterator.hasNext(); ++entriesRead) {
                    entityCompound[entriesRead] = ((WeightedSpawnerEntity)iterator.next()).func_185277_b();
                }
                SpawnerFactory.placeSpawner(entityCompound, false, null, world, pos);
            }
        }
    }

    public static Entity createEntityFromNBTWithoutSpawningIt(NBTTagCompound tag, World worldIn) {
        Entity entity = EntityList.func_75615_a((NBTTagCompound)tag, (World)worldIn);
        entity.func_70020_e(tag);
        return entity;
    }

    public static NBTTagCompound createSpawnerNBTFromEntity(Entity entity) {
        return SpawnerFactory.createSpawnerNBTFromEntity(entity, !(entity instanceof AbstractEntityCQRBoss) && entity.func_184222_aU());
    }

    public static NBTTagCompound createSpawnerNBTFromEntity(Entity entity, boolean removeUUID) {
        NBTTagCompound entityCompound = new NBTTagCompound();
        if (entity instanceof AbstractEntityCQR) {
            ((AbstractEntityCQR)entity).onPutInSpawner();
        }
        entity.func_70039_c(entityCompound);
        if (removeUUID) {
            entityCompound.func_82580_o("UUIDLeast");
            entityCompound.func_82580_o("UUIDMost");
        }
        entityCompound.func_82580_o("Pos");
        NBTTagList passengerList = entityCompound.func_150295_c("Passengers", 10);
        for (NBTBase passengerTag : passengerList) {
            if (removeUUID) {
                ((NBTTagCompound)passengerTag).func_82580_o("UUIDLeast");
                ((NBTTagCompound)passengerTag).func_82580_o("UUIDMost");
            }
            ((NBTTagCompound)passengerTag).func_82580_o("Pos");
        }
        return entityCompound;
    }

    public static ItemStack getSoulBottleItemStackForEntity(Entity entity) {
        if (entity == null) {
            return null;
        }
        NBTTagCompound entityTag = new NBTTagCompound();
        if (entity.func_70039_c(entityTag)) {
            return SpawnerFactory.getSoulBottleItemStackForEntity(entityTag);
        }
        return null;
    }

    public static ItemStack getSoulBottleItemStackForEntity(NBTTagCompound entityTag) {
        ItemStack bottle = new ItemStack(CQRItems.SOUL_BOTTLE);
        bottle.func_190920_e(1);
        NBTTagCompound mobToSpawnerItem = new NBTTagCompound();
        mobToSpawnerItem.func_74782_a("EntityIn", (NBTBase)entityTag);
        bottle.func_77982_d(mobToSpawnerItem);
        return bottle;
    }
}

