/*
 * Decompiled with CFR 0.152.
 */
package team.cqr.cqrepoured.objects.items;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.IItemPropertyGetter;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.lwjgl.input.Keyboard;
import team.cqr.cqrepoured.CQRMain;
import team.cqr.cqrepoured.init.CQRSounds;
import team.cqr.cqrepoured.objects.entity.projectiles.ProjectileHookShotHook;
import team.cqr.cqrepoured.util.CQRBlockUtil;
import team.cqr.cqrepoured.util.PropertyFileHelper;

public abstract class ItemHookshotBase
extends Item {
    protected ArrayList<Block> validLatchBlocks = new ArrayList();
    protected ArrayList<BlockGroup> latchGroups = new ArrayList();

    public ItemHookshotBase(String hookshotName) {
        this.func_77656_e(300);
        this.func_77625_d(1);
        this.loadPropertiesFromFile(hookshotName);
        this.func_185043_a(new ResourceLocation("hook_out"), new IItemPropertyGetter(){

            @SideOnly(value=Side.CLIENT)
            public float func_185085_a(ItemStack stack, @Nullable World worldIn, @Nullable EntityLivingBase entityIn) {
                NBTTagCompound stackTag;
                if (entityIn != null && stack.func_77973_b() instanceof ItemHookshotBase && (stackTag = stack.func_77978_p()) != null && stackTag.func_74767_n("isShooting")) {
                    return 1.0f;
                }
                return 0.0f;
            }
        });
    }

    private void loadPropertiesFromFile(String hookshotName) {
        Collection files = FileUtils.listFiles((File)CQRMain.CQ_ITEM_FOLDER, (String[])new String[]{"properties", "prop", "cfg"}, (boolean)true);
        Optional<File> configFile = files.stream().filter(f -> FilenameUtils.getBaseName((String)f.getName()).equalsIgnoreCase(hookshotName)).findFirst();
        if (configFile.isPresent()) {
            Properties hookshotConfig = new Properties();
            FileInputStream stream = null;
            try {
                String[] latchBlocks;
                stream = new FileInputStream(configFile.get());
                hookshotConfig.load(stream);
                for (String blockType : latchBlocks = PropertyFileHelper.getStringArrayProperty(hookshotConfig, "latchblocks", new String[0], true)) {
                    Optional<BlockGroup> groupMatch = BlockGroup.fromConfigString(blockType);
                    if (groupMatch.isPresent()) {
                        this.latchGroups.add(groupMatch.get());
                        continue;
                    }
                    Block blockMatch = Block.func_149684_b((String)blockType);
                    if (blockMatch != null) {
                        this.validLatchBlocks.add(blockMatch);
                        continue;
                    }
                    CQRMain.logger.error(configFile.get().getName() + ": Invalid latch block: " + blockType);
                }
            }
            catch (IOException e) {
                CQRMain.logger.error(configFile.get().getName() + ": Failed to load file!");
            }
        }
    }

    public boolean canLatchToBlock(Block block) {
        for (BlockGroup bg : this.latchGroups) {
            if (!bg.containsBlock(block)) continue;
            return true;
        }
        return this.validLatchBlocks.contains(block);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        if (Keyboard.isKeyDown((int)42) || Keyboard.isKeyDown((int)54)) {
            tooltip.add(TextFormatting.BLUE + I18n.func_135052_a((String)this.func_77658_a(), (Object[])new Object[0]));
        } else {
            tooltip.add(TextFormatting.BLUE + I18n.func_135052_a((String)"description.click_shift.name", (Object[])new Object[0]));
        }
    }

    public abstract String func_77658_a();

    public abstract double getHookRange();

    public abstract ProjectileHookShotHook getNewHookEntity(World var1, EntityLivingBase var2, ItemStack var3);

    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, EnumHand handIn) {
        ItemStack stack = playerIn.func_184586_b(handIn);
        this.shoot(stack, worldIn, playerIn);
        return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
    }

    public void shoot(ItemStack stack, World worldIn, EntityPlayer player) {
        if (!worldIn.field_72995_K) {
            ProjectileHookShotHook hookEntity = this.getNewHookEntity(worldIn, (EntityLivingBase)player, stack);
            hookEntity.func_184538_a((Entity)player, player.field_70125_A, player.field_70177_z, 0.0f, (float)hookEntity.getTravelSpeed(), 0.0f);
            player.func_184811_cZ().func_185145_a(stack.func_77973_b(), this.getCooldown());
            worldIn.func_72838_d((Entity)hookEntity);
            stack.func_77972_a(1, (EntityLivingBase)player);
        }
        worldIn.func_184134_a(player.field_70165_t, player.field_70163_u, player.field_70161_v, CQRSounds.GUN_SHOOT, SoundCategory.MASTER, 1.0f, 1.0f, false);
    }

    public ProjectileHookShotHook entityAIshoot(World worldIn, EntityLivingBase shooter, Entity target, EnumHand handIn) {
        if (!worldIn.field_72995_K) {
            ProjectileHookShotHook hookEntity = this.getNewHookEntity(worldIn, shooter, shooter.func_184607_cu());
            Vec3d v = target.func_174791_d().func_178788_d(shooter.func_174791_d());
            hookEntity.func_70186_c(v.field_72450_a, v.field_72448_b, v.field_72449_c, (float)hookEntity.getTravelSpeed(), 0.0f);
            worldIn.func_72838_d((Entity)hookEntity);
            return hookEntity;
        }
        return null;
    }

    public SoundEvent getShootSound() {
        return CQRSounds.GUN_SHOOT;
    }

    public double getRange() {
        return 16.0;
    }

    public int getCooldown() {
        return 300;
    }

    public int getChargeTicks() {
        return 0;
    }

    private static enum BlockGroup {
        BASE_SOLID("BASE_SOLID"),
        BASE_WOOD("BASE_WOOD"),
        BASE_STONE("BASE_STONE"),
        BASE_DIRT("BASE_DIRT");

        private final String configName;

        private BlockGroup(String configName) {
            this.configName = configName;
        }

        public static Optional<BlockGroup> fromConfigString(String string) {
            for (BlockGroup bg : BlockGroup.values()) {
                if (!bg.configName.equalsIgnoreCase(string)) continue;
                return Optional.of(bg);
            }
            return Optional.empty();
        }

        public boolean containsBlock(Block block) {
            switch (this) {
                case BASE_SOLID: {
                    return true;
                }
                case BASE_WOOD: {
                    return CQRBlockUtil.VANILLA_WOOD_SET.contains(block);
                }
                case BASE_STONE: {
                    return CQRBlockUtil.VANILLA_STONE_SET.contains(block);
                }
                case BASE_DIRT: {
                    return CQRBlockUtil.VANILLA_DIRT_SET.contains(block);
                }
            }
            return false;
        }
    }
}

