/*
 * Decompiled with CFR 0.152.
 */
package team.cqr.cqrepoured.objects.items;

import it.unimi.dsi.fastutil.ints.IntListIterator;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import team.cqr.cqrepoured.CQRMain;
import team.cqr.cqrepoured.capability.pathtool.CapabilityPath;
import team.cqr.cqrepoured.capability.pathtool.CapabilityPathProvider;
import team.cqr.cqrepoured.objects.entity.bases.AbstractEntityCQR;
import team.cqr.cqrepoured.objects.entity.pathfinding.Path;

public class ItemPathTool
extends Item {
    public ItemPathTool() {
        this.func_77625_d(1);
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, NBTTagCompound nbt) {
        return CapabilityPathProvider.createProvider(stack);
    }

    public static Path getPath(ItemStack stack) {
        return ((CapabilityPath)stack.getCapability(CapabilityPathProvider.PATH, null)).getPath();
    }

    public static void setSelectedNode(ItemStack stack, Path.PathNode node) {
        ((CapabilityPath)stack.getCapability(CapabilityPathProvider.PATH, null)).setSelectedNode(node);
    }

    @Nullable
    public static Path.PathNode getSelectedNode(ItemStack stack) {
        return ((CapabilityPath)stack.getCapability(CapabilityPathProvider.PATH, null)).getSelectedNode();
    }

    public boolean onLeftClickEntity(ItemStack stack, EntityPlayer player, Entity entity) {
        if (!player.field_70170_p.field_72995_K && entity instanceof AbstractEntityCQR) {
            if (player.func_70093_af()) {
                BlockPos pos = ((AbstractEntityCQR)entity).getHomePositionCQR();
                ((AbstractEntityCQR)entity).getPath().copyFrom(ItemPathTool.getPath(stack), pos != null ? new BlockPos(-pos.func_177958_n(), -pos.func_177956_o(), -pos.func_177952_p()) : BlockPos.field_177992_a);
                ((WorldServer)player.field_70170_p).func_184161_a((EntityPlayerMP)player, EnumParticleTypes.VILLAGER_HAPPY, false, entity.field_70165_t, entity.field_70163_u + 0.5, entity.field_70161_v, 8, 0.5, 0.5, 0.5, 0.1, new int[0]);
                player.func_145747_a((ITextComponent)new TextComponentString("Applied path!"));
            } else {
                BlockPos pos = ((AbstractEntityCQR)entity).getHomePositionCQR();
                ItemPathTool.getPath(stack).copyFrom(((AbstractEntityCQR)entity).getPath(), pos != null ? pos : BlockPos.field_177992_a);
                player.func_145747_a((ITextComponent)new TextComponentString("Copied path!"));
            }
        }
        return true;
    }

    public EnumActionResult onItemUseFirst(EntityPlayer player, World world, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        BlockPos position = pos.func_177972_a(side);
        Path path = ItemPathTool.getPath(stack);
        Path.PathNode node = path.getNode(position);
        Path.PathNode selectedNode = ItemPathTool.getSelectedNode(stack);
        if (world.field_72995_K) {
            if (node == null) {
                CQRMain.proxy.openGui(13, player, world, hand.ordinal(), selectedNode != null ? selectedNode.getIndex() : -1, position.func_177958_n(), position.func_177956_o(), position.func_177952_p());
            }
        } else if (node != null) {
            if (selectedNode != null && player.func_70093_af()) {
                if (selectedNode.addConnectedNode(node, false)) {
                    ItemPathTool.setSelectedNode(stack, node);
                    player.func_145747_a((ITextComponent)new TextComponentString("Added connection!"));
                }
            } else {
                ItemPathTool.setSelectedNode(stack, node);
                player.func_145747_a((ITextComponent)new TextComponentString("Selected node!"));
            }
        }
        return EnumActionResult.SUCCESS;
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, EnumHand handIn) {
        if (!worldIn.field_72995_K && playerIn.func_70093_af()) {
            ItemStack stack = playerIn.func_184586_b(handIn);
            ItemPathTool.getPath(stack).clear();
            playerIn.func_145747_a((ITextComponent)new TextComponentString("Cleared Path!"));
            return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
        }
        return super.func_77659_a(worldIn, playerIn, handIn);
    }

    public void func_77624_a(ItemStack stack, World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
    }

    public void func_77663_a(ItemStack stack, World worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        super.func_77663_a(stack, worldIn, entityIn, itemSlot, isSelected);
        if (isSelected && entityIn instanceof EntityPlayer && !worldIn.field_72995_K) {
            Path path = ItemPathTool.getPath(stack);
            Path.PathNode selectedNode = ItemPathTool.getSelectedNode(stack);
            for (Path.PathNode node : path.getNodes()) {
                BlockPos pos = node.getPos();
                Vec3d vec = new Vec3d((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5);
                ((WorldServer)worldIn).func_184161_a((EntityPlayerMP)entityIn, node != selectedNode ? EnumParticleTypes.VILLAGER_HAPPY : EnumParticleTypes.FLAME, true, vec.field_72450_a, vec.field_72448_b, vec.field_72449_c, 0, 0.0, 0.025, 0.0, 1.0, new int[0]);
                IntListIterator intListIterator = node.getConnectedNodes().iterator();
                while (intListIterator.hasNext()) {
                    int index = (Integer)intListIterator.next();
                    Path.PathNode connectedNode = path.getNode(index);
                    BlockPos pos1 = connectedNode.getPos();
                    Vec3d vec1 = new Vec3d((double)pos1.func_177958_n() + 0.5 - vec.field_72450_a, (double)pos1.func_177956_o() + 0.5 - vec.field_72448_b, (double)pos1.func_177952_p() + 0.5 - vec.field_72449_c);
                    double dist = vec1.func_72433_c();
                    vec1 = vec1.func_72432_b();
                    for (double d = 0.25; d < dist; d += 0.5) {
                        ((WorldServer)worldIn).func_184161_a((EntityPlayerMP)entityIn, EnumParticleTypes.CRIT_MAGIC, true, vec.field_72450_a + d * vec1.field_72450_a, vec.field_72448_b + d * vec1.field_72448_b, vec.field_72449_c + d * vec1.field_72449_c, 0, vec1.field_72450_a * 0.1, vec1.field_72448_b * 0.1, vec1.field_72449_c * 0.1, 1.0, new int[0]);
                    }
                }
            }
        }
    }
}

