/*
 * Decompiled with CFR 0.152.
 */
package team.cqr.cqrepoured.objects.items;

import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import team.cqr.cqrepoured.CQRMain;
import team.cqr.cqrepoured.init.CQRBlocks;
import team.cqr.cqrepoured.network.client.packet.CPacketStructureSelector;
import team.cqr.cqrepoured.tileentity.TileEntityExporter;
import team.cqr.cqrepoured.util.DungeonGenUtils;

public class ItemStructureSelector
extends Item {
    public ItemStructureSelector() {
        this.func_77625_d(1);
    }

    public boolean canDestroyBlockInCreative(World world, BlockPos pos, ItemStack stack, EntityPlayer player) {
        Block block = world.func_180495_p(pos).func_177230_c();
        return block != CQRBlocks.EXPORTER;
    }

    public EnumActionResult onItemUseFirst(EntityPlayer player, World world, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (world.func_175625_s(pos) instanceof TileEntityExporter) {
            if (world.field_72995_K) {
                if (!this.hasFirstAndSecondPos(stack)) {
                    player.func_145747_a((ITextComponent)new TextComponentString("Set both positions before using on a exporter"));
                    return EnumActionResult.SUCCESS;
                }
                TileEntityExporter tileEntity = (TileEntityExporter)world.func_175625_s(pos);
                BlockPos pos1 = this.getFirstPos(stack);
                BlockPos pos2 = this.getSecondPos(stack);
                if (tileEntity.isRelativeMode()) {
                    pos1 = pos1.func_177973_b((Vec3i)pos);
                    pos2 = pos2.func_177973_b((Vec3i)pos);
                }
                tileEntity.setValues(tileEntity.getStructureName(), DungeonGenUtils.getMinPos(pos1, pos2), DungeonGenUtils.getMaxPos(pos1, pos2), tileEntity.isRelativeMode(), tileEntity.isIgnoreEntities(), tileEntity.getUnprotectedBlocks());
            }
        } else if (!world.field_72995_K) {
            if (player.func_70093_af()) {
                BlockPos pos1 = new BlockPos((Entity)player);
                this.setSecondPos(stack, pos1);
                player.func_145747_a((ITextComponent)new TextComponentString("Second position set to " + pos1));
            } else {
                this.setSecondPos(stack, pos);
                player.func_145747_a((ITextComponent)new TextComponentString("Second position set to " + pos));
            }
        }
        return EnumActionResult.SUCCESS;
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, EnumHand handIn) {
        ItemStack stack = playerIn.func_184586_b(handIn);
        if (!playerIn.field_70170_p.field_72995_K && playerIn.func_70093_af()) {
            BlockPos pos1 = new BlockPos((Entity)playerIn);
            this.setSecondPos(stack, pos1);
            playerIn.func_145747_a((ITextComponent)new TextComponentString("Second position set to " + pos1));
        }
        return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
    }

    public void func_77624_a(ItemStack stack, World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        BlockPos pos1 = this.getFirstPos(stack);
        BlockPos pos2 = this.getSecondPos(stack);
        if (pos1 != null) {
            tooltip.add("First position: " + pos1);
        } else {
            tooltip.add("First position: not set");
        }
        if (pos2 != null) {
            tooltip.add("Second position: " + pos2);
        } else {
            tooltip.add("Second position: not set");
        }
    }

    public void setFirstPos(ItemStack stack, BlockPos pos) {
        NBTTagCompound compound = stack.func_77978_p();
        if (compound == null) {
            compound = new NBTTagCompound();
            stack.func_77982_d(compound);
        }
        compound.func_74782_a("pos1", (NBTBase)NBTUtil.func_186859_a((BlockPos)pos));
    }

    public void setSecondPos(ItemStack stack, BlockPos pos) {
        NBTTagCompound compound = stack.func_77978_p();
        if (compound == null) {
            compound = new NBTTagCompound();
            stack.func_77982_d(compound);
        }
        compound.func_74782_a("pos2", (NBTBase)NBTUtil.func_186859_a((BlockPos)pos));
    }

    public BlockPos getFirstPos(ItemStack stack) {
        NBTTagCompound compound = stack.func_77978_p();
        if (compound == null || !compound.func_150297_b("pos1", 10)) {
            return null;
        }
        return NBTUtil.func_186861_c((NBTTagCompound)compound.func_74775_l("pos1"));
    }

    public BlockPos getSecondPos(ItemStack stack) {
        NBTTagCompound compound = stack.func_77978_p();
        if (compound == null || !compound.func_150297_b("pos2", 10)) {
            return null;
        }
        return NBTUtil.func_186861_c((NBTTagCompound)compound.func_74775_l("pos2"));
    }

    public boolean hasFirstPos(ItemStack stack) {
        return this.getFirstPos(stack) != null;
    }

    public boolean hasSecondPos(ItemStack stack) {
        return this.getSecondPos(stack) != null;
    }

    public boolean hasFirstAndSecondPos(ItemStack stack) {
        return this.hasFirstPos(stack) && this.hasSecondPos(stack);
    }

    @Mod.EventBusSubscriber(modid="cqrepoured")
    public static class EventHandler {
        @SubscribeEvent
        public static void onLeftClickBlockEvent(PlayerInteractEvent.LeftClickBlock event) {
            EntityPlayer player = event.getEntityPlayer();
            ItemStack stack = player.func_184586_b(event.getHand());
            if (stack.func_77973_b() instanceof ItemStructureSelector) {
                if (!player.field_70170_p.field_72995_K) {
                    ItemStructureSelector structureSelector = (ItemStructureSelector)stack.func_77973_b();
                    if (player.func_70093_af()) {
                        BlockPos pos = new BlockPos((Entity)player);
                        structureSelector.setFirstPos(stack, pos);
                        player.func_145747_a((ITextComponent)new TextComponentString("First position set to " + pos));
                    } else {
                        BlockPos pos = event.getPos();
                        structureSelector.setFirstPos(stack, pos);
                        player.func_145747_a((ITextComponent)new TextComponentString("First position set to " + pos));
                    }
                }
                event.setCanceled(true);
            }
        }

        @SubscribeEvent
        public static void onLeftClickEmptyEvent(PlayerInteractEvent.LeftClickEmpty event) {
            EntityPlayer player = event.getEntityPlayer();
            ItemStack stack = player.func_184586_b(event.getHand());
            if (stack.func_77973_b() instanceof ItemStructureSelector && player.func_70093_af()) {
                CQRMain.NETWORK.sendToServer((IMessage)new CPacketStructureSelector(event.getHand()));
            }
        }
    }
}

