/*
 * Decompiled with CFR 0.152.
 */
package team.cqr.cqrepoured.objects.items;

import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;

public class ItemSuperTool
extends Item {
    private static final String MODE_TAG = "Mode";
    private static final String BLOCK_TAG = "Block";

    public ItemSuperTool() {
        this.func_77625_d(1);
    }

    public boolean onLeftClickEntity(ItemStack stack, EntityPlayer player, Entity entity) {
        if (player.func_184812_l_() && !(entity instanceof EntityPlayer)) {
            entity.func_174812_G();
            return true;
        }
        return false;
    }

    public void func_77624_a(ItemStack stack, World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        tooltip.add(TextFormatting.BLUE + "Mode: " + this.getModeName(this.getMode(stack)));
        tooltip.add(TextFormatting.BLUE + "Block: " + this.getBlock(stack).func_149732_F());
    }

    public String getModeName(int mode) {
        if (mode == 0) {
            return "Build";
        }
        if (mode == 1) {
            return "Fill";
        }
        if (mode == 2) {
            return "Mine";
        }
        return "";
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, EnumHand handIn) {
        ItemStack stack = playerIn.func_184586_b(handIn);
        if (!playerIn.func_184812_l_()) {
            return new ActionResult(EnumActionResult.FAIL, (Object)stack);
        }
        if (playerIn.func_70093_af()) {
            int mode = this.getMode(stack) + 1;
            if (mode < 0 || mode > 2) {
                mode = 0;
            }
            this.setMode(stack, mode);
            if (!worldIn.field_72995_K) {
                playerIn.func_146105_b((ITextComponent)new TextComponentString("Pickaxe Mode: " + this.getModeName(mode)), true);
            }
            return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
        }
        return new ActionResult(EnumActionResult.FAIL, (Object)stack);
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World worldIn, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        EnumFacing facing2;
        EnumFacing facing1;
        ItemStack stack = player.func_184586_b(hand);
        if (!player.func_184812_l_()) {
            return EnumActionResult.PASS;
        }
        if (player.func_70093_af()) {
            this.setBlock(stack, worldIn.func_180495_p(pos).func_177230_c());
            return EnumActionResult.SUCCESS;
        }
        int size = 1;
        if (facing.func_176740_k() == EnumFacing.Axis.Y) {
            facing1 = EnumFacing.NORTH;
            facing2 = EnumFacing.EAST;
        } else {
            facing1 = EnumFacing.UP;
            facing2 = facing.func_176746_e();
        }
        for (int i = -size; i <= size; ++i) {
            for (int j = -size; j <= size; ++j) {
                this.performAction(worldIn, pos.func_177967_a(facing1, i).func_177967_a(facing2, j), stack);
            }
        }
        return EnumActionResult.SUCCESS;
    }

    private void performAction(World worldIn, BlockPos pos, ItemStack stack) {
        Block block;
        int mode = this.getMode(stack);
        if (mode == 0) {
            worldIn.func_175656_a(pos, this.getBlock(stack).func_176223_P());
        } else if (mode == 1) {
            Block block2 = worldIn.func_180495_p(pos).func_177230_c();
            if (block2 != Blocks.field_150350_a) {
                worldIn.func_175656_a(pos, this.getBlock(stack).func_176223_P());
            }
        } else if (mode == 2 && (block = worldIn.func_180495_p(pos).func_177230_c()) != Blocks.field_150350_a) {
            worldIn.func_175698_g(pos);
            for (int i = 0; i < 5; ++i) {
                worldIn.func_175688_a(EnumParticleTypes.BLOCK_CRACK, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, 0.0, 0.0, 0.0, new int[]{Block.func_149682_b((Block)block)});
            }
        }
    }

    public int getMode(ItemStack stack) {
        int mode;
        NBTTagCompound stackTag = stack.func_77978_p();
        if (stackTag == null) {
            stackTag = new NBTTagCompound();
            stack.func_77982_d(stackTag);
        }
        if ((mode = stackTag.func_74762_e(MODE_TAG)) < 0 || mode > 2) {
            mode = 0;
            this.setMode(stack, mode);
        }
        return mode;
    }

    public Block getBlock(ItemStack stack) {
        Block block;
        NBTTagCompound stackTag = stack.func_77978_p();
        if (stackTag == null) {
            stackTag = new NBTTagCompound();
            stack.func_77982_d(stackTag);
        }
        return (block = (Block)Block.field_149771_c.func_82594_a((Object)new ResourceLocation(stackTag.func_74779_i(BLOCK_TAG)))) != Blocks.field_150350_a ? block : Blocks.field_150348_b;
    }

    public void setMode(ItemStack stack, int mode) {
        NBTTagCompound stackTag = stack.func_77978_p();
        if (stackTag == null) {
            stackTag = new NBTTagCompound();
            stack.func_77982_d(stackTag);
        }
        if (mode < 0 || mode > 2) {
            mode = 0;
        }
        stackTag.func_74768_a(MODE_TAG, mode);
    }

    public void setBlock(ItemStack stack, Block blockIn) {
        NBTTagCompound stackTag = stack.func_77978_p();
        if (stackTag == null) {
            stackTag = new NBTTagCompound();
            stack.func_77982_d(stackTag);
        }
        stackTag.func_74778_a(BLOCK_TAG, blockIn.getRegistryName().toString());
    }
}

