/*
 * Decompiled with CFR 0.152.
 */
package team.cqr.cqrepoured.objects.items.armor;

import com.google.common.collect.Multimap;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Keyboard;
import team.cqr.cqrepoured.capability.armor.CapabilityCooldownHandlerHelper;
import team.cqr.cqrepoured.client.init.CQRArmorModels;
import team.cqr.cqrepoured.init.CQRItems;
import team.cqr.cqrepoured.objects.entity.EntitySlimePart;
import team.cqr.cqrepoured.util.ItemUtil;

public class ItemArmorSlime
extends ItemArmor {
    private AttributeModifier health = new AttributeModifier("SlimeHealthModifier", 2.0, 0);
    private AttributeModifier knockBack = new AttributeModifier("SlimeKnockbackModifier", -0.25, 0);

    public ItemArmorSlime(ItemArmor.ArmorMaterial materialIn, int renderIndexIn, EntityEquipmentSlot equipmentSlotIn) {
        super(materialIn, renderIndexIn, equipmentSlotIn);
    }

    public Multimap<String, AttributeModifier> getAttributeModifiers(EntityEquipmentSlot slot, ItemStack stack) {
        Multimap multimap = super.getAttributeModifiers(slot, stack);
        if (slot == EntityLiving.func_184640_d((ItemStack)stack)) {
            multimap.put((Object)SharedMonsterAttributes.field_111267_a.func_111108_a(), (Object)this.health);
            multimap.put((Object)SharedMonsterAttributes.field_111266_c.func_111108_a(), (Object)this.knockBack);
        }
        return multimap;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        if (Keyboard.isKeyDown((int)42) || Keyboard.isKeyDown((int)54)) {
            tooltip.add(TextFormatting.BLUE + I18n.func_135052_a((String)"description.slime_armor.name", (Object[])new Object[0]));
        } else {
            tooltip.add(TextFormatting.BLUE + I18n.func_135052_a((String)"description.click_shift.name", (Object[])new Object[0]));
        }
    }

    @SideOnly(value=Side.CLIENT)
    @Nullable
    public ModelBiped getArmorModel(EntityLivingBase entityLiving, ItemStack itemStack, EntityEquipmentSlot armorSlot, ModelBiped _default) {
        return armorSlot == EntityEquipmentSlot.LEGS ? CQRArmorModels.slimeArmorLegs : CQRArmorModels.slimeArmor;
    }

    @Mod.EventBusSubscriber(modid="cqrepoured")
    public static class EventHandler {
        @SubscribeEvent
        public static void onLivingHurtEvent(LivingHurtEvent event) {
            EntityLivingBase entity = event.getEntityLiving();
            if (ItemUtil.hasFullSet(entity, ItemArmorSlime.class) && !CapabilityCooldownHandlerHelper.onCooldown(entity, CQRItems.CHESTPLATE_SLIME)) {
                if (!entity.field_70170_p.field_72995_K) {
                    EntitySlimePart slime = new EntitySlimePart(entity.field_70170_p, entity);
                    double x = entity.field_70165_t - 5.0 + 2.5 * slime.func_70681_au().nextDouble();
                    double y = entity.field_70163_u;
                    double z = entity.field_70161_v - 5.0 + 2.5 * slime.func_70681_au().nextDouble();
                    slime.func_70107_b(x, y, z);
                    entity.field_70170_p.func_72838_d((Entity)slime);
                }
                CapabilityCooldownHandlerHelper.setCooldown(entity, CQRItems.CHESTPLATE_SLIME, 160);
            }
        }
    }
}

