/*
 * Decompiled with CFR 0.152.
 */
package team.cqr.cqrepoured.objects.items.armor;

import com.google.common.collect.Multimap;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Keyboard;
import team.cqr.cqrepoured.client.init.CQRArmorModels;
import team.cqr.cqrepoured.util.ItemUtil;

public class ItemArmorSpider
extends ItemArmor {
    private AttributeModifier movementSpeed = new AttributeModifier("SpiderArmorModifier", 0.05, 2);

    public ItemArmorSpider(ItemArmor.ArmorMaterial materialIn, int renderIndexIn, EntityEquipmentSlot equipmentSlotIn) {
        super(materialIn, renderIndexIn, equipmentSlotIn);
    }

    public Multimap<String, AttributeModifier> getAttributeModifiers(EntityEquipmentSlot slot, ItemStack stack) {
        Multimap multimap = super.getAttributeModifiers(slot, stack);
        if (slot == EntityLiving.func_184640_d((ItemStack)stack)) {
            multimap.put((Object)SharedMonsterAttributes.field_111263_d.func_111108_a(), (Object)this.movementSpeed);
        }
        return multimap;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        if (Keyboard.isKeyDown((int)42) || Keyboard.isKeyDown((int)54)) {
            tooltip.add(TextFormatting.BLUE + I18n.func_135052_a((String)"description.spider_armor.name", (Object[])new Object[0]));
        } else {
            tooltip.add(TextFormatting.BLUE + I18n.func_135052_a((String)"description.click_shift.name", (Object[])new Object[0]));
        }
    }

    public void onArmorTick(World world, EntityPlayer player, ItemStack itemStack) {
        if (ItemUtil.hasFullSet((EntityLivingBase)player, ItemArmorSpider.class)) {
            if (player.func_175149_v()) {
                return;
            }
            if (player.field_70123_F) {
                if (world.field_72995_K) {
                    if (player.field_191988_bg > 0.0f) {
                        player.field_70181_x = 0.2;
                        this.createClimbingParticles(player, world);
                    } else {
                        player.field_70181_x = player.func_70093_af() ? 0.0 : -0.2;
                    }
                }
                player.field_70122_E = true;
            }
            player.field_70143_R = 0.0f;
            player.field_70747_aH = (float)((double)player.field_70747_aH + 0.005);
            player.func_70690_d(new PotionEffect(MobEffects.field_76430_j, 0, 1, false, false));
        }
    }

    private void createClimbingParticles(EntityPlayer player, World world) {
        BlockPos blockpos;
        IBlockState iblockstate;
        int i = (int)player.field_70165_t;
        int j = MathHelper.func_76141_d((float)player.func_180425_c().func_177956_o());
        int k = (int)player.field_70161_v;
        int direction = MathHelper.func_76128_c((double)((double)(player.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3;
        if (direction == 0) {
            if (k > 0) {
                ++k;
            }
            if (i < 0) {
                --i;
            }
            if (!(iblockstate = world.func_180495_p(blockpos = new BlockPos(i, j, k))).func_177230_c().addRunningEffects(iblockstate, world, blockpos, (Entity)player) && iblockstate.func_185901_i() != EnumBlockRenderType.INVISIBLE) {
                world.func_175688_a(EnumParticleTypes.BLOCK_CRACK, player.field_70165_t + ((double)field_77697_d.nextFloat() - 0.5) * (double)player.field_70130_N, player.func_174813_aQ().field_72338_b + 0.1, player.field_70161_v + 0.3 + ((double)field_77697_d.nextFloat() - 0.5) * (double)player.field_70130_N, -player.field_70159_w * 4.0, 1.5, -player.field_70179_y * 4.0, new int[]{Block.func_176210_f((IBlockState)iblockstate)});
            }
        }
        if (direction == 1) {
            if (i > 0) {
                --i;
            }
            if (k < 0) {
                --k;
            }
            if (i < 0) {
                i -= 2;
            }
            if (!(iblockstate = world.func_180495_p(blockpos = new BlockPos(i, j, k))).func_177230_c().addRunningEffects(iblockstate, world, blockpos, (Entity)player) && iblockstate.func_185901_i() != EnumBlockRenderType.INVISIBLE) {
                world.func_175688_a(EnumParticleTypes.BLOCK_CRACK, player.field_70165_t - 0.3 + ((double)field_77697_d.nextFloat() - 0.5) * (double)player.field_70130_N, player.func_174813_aQ().field_72338_b + 0.1, player.field_70161_v + ((double)field_77697_d.nextFloat() - 0.5) * (double)player.field_70130_N, -player.field_70159_w * 4.0, 1.5, -player.field_70179_y * 4.0, new int[]{Block.func_176210_f((IBlockState)iblockstate)});
            }
        }
        if (direction == 2) {
            if (i < 0) {
                --i;
            }
            if (k > 0) {
                --k;
            }
            if (i > 0 && k < 0 || i < 0 && k < 0) {
                k -= 2;
            }
            if (!(iblockstate = world.func_180495_p(blockpos = new BlockPos(i, j, k))).func_177230_c().addRunningEffects(iblockstate, world, blockpos, (Entity)player) && iblockstate.func_185901_i() != EnumBlockRenderType.INVISIBLE) {
                world.func_175688_a(EnumParticleTypes.BLOCK_CRACK, player.field_70165_t + ((double)field_77697_d.nextFloat() - 0.5) * (double)player.field_70130_N, player.func_174813_aQ().field_72338_b + 0.1, player.field_70161_v - 0.3 + ((double)field_77697_d.nextFloat() - 0.5) * (double)player.field_70130_N, -player.field_70159_w * 4.0, 1.5, -player.field_70179_y * 4.0, new int[]{Block.func_176210_f((IBlockState)iblockstate)});
            }
        }
        if (direction == 3) {
            if (i > 0) {
                ++i;
            }
            if (k < 0) {
                --k;
            }
            if (!(iblockstate = world.func_180495_p(blockpos = new BlockPos(i, j, k))).func_177230_c().addRunningEffects(iblockstate, world, blockpos, (Entity)player) && iblockstate.func_185901_i() != EnumBlockRenderType.INVISIBLE) {
                world.func_175688_a(EnumParticleTypes.BLOCK_CRACK, player.field_70165_t + 0.3 + ((double)field_77697_d.nextFloat() - 0.5) * (double)player.field_70130_N, player.func_174813_aQ().field_72338_b + 0.1, player.field_70161_v + ((double)field_77697_d.nextFloat() - 0.5) * (double)player.field_70130_N, -player.field_70159_w * 4.0, 1.5, -player.field_70179_y * 4.0, new int[]{Block.func_176210_f((IBlockState)iblockstate)});
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    @Nullable
    public ModelBiped getArmorModel(EntityLivingBase entityLiving, ItemStack itemStack, EntityEquipmentSlot armorSlot, ModelBiped _default) {
        return armorSlot == EntityEquipmentSlot.LEGS ? CQRArmorModels.spiderArmorLegs : CQRArmorModels.spiderArmor;
    }
}

