/*
 * Decompiled with CFR 0.152.
 */
package team.cqr.cqrepoured.objects.items.armor;

import com.google.common.collect.Multimap;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.init.MobEffects;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Keyboard;
import team.cqr.cqrepoured.capability.armor.CapabilityCooldownHandlerHelper;
import team.cqr.cqrepoured.client.init.CQRArmorModels;
import team.cqr.cqrepoured.init.CQRItems;
import team.cqr.cqrepoured.util.ItemUtil;

public class ItemArmorTurtle
extends ItemArmor {
    private AttributeModifier health = new AttributeModifier("TurtleHealthModifier", 2.0, 0);

    public ItemArmorTurtle(ItemArmor.ArmorMaterial materialIn, int renderIndexIn, EntityEquipmentSlot equipmentSlotIn) {
        super(materialIn, renderIndexIn, equipmentSlotIn);
    }

    public Multimap<String, AttributeModifier> getAttributeModifiers(EntityEquipmentSlot slot, ItemStack stack) {
        Multimap multimap = super.getAttributeModifiers(slot, stack);
        if (slot == EntityLiving.func_184640_d((ItemStack)stack)) {
            multimap.put((Object)SharedMonsterAttributes.field_111267_a.func_111108_a(), (Object)this.health);
        }
        return multimap;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        int cooldown;
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        if (player != null && (cooldown = CapabilityCooldownHandlerHelper.getCooldown((EntityLivingBase)player, CQRItems.CHESTPLATE_TURTLE)) > 0) {
            tooltip.add(TextFormatting.RED + I18n.func_135052_a((String)"description.turtle_armor_charging.name", (Object[])new Object[0]) + this.convertCooldown(cooldown));
        }
        if (Keyboard.isKeyDown((int)42) || Keyboard.isKeyDown((int)54)) {
            tooltip.add(TextFormatting.BLUE + I18n.func_135052_a((String)"description.turtle_armor.name", (Object[])new Object[0]));
        } else {
            tooltip.add(TextFormatting.BLUE + I18n.func_135052_a((String)"description.click_shift.name", (Object[])new Object[0]));
        }
    }

    private String convertCooldown(int cd) {
        int i = cd / 20;
        int minutes = i / 60;
        int seconds = i % 60;
        if (seconds < 10) {
            return minutes + ":0" + seconds;
        }
        return minutes + ":" + seconds;
    }

    @SideOnly(value=Side.CLIENT)
    @Nullable
    public ModelBiped getArmorModel(EntityLivingBase entityLiving, ItemStack itemStack, EntityEquipmentSlot armorSlot, ModelBiped _default) {
        return armorSlot == EntityEquipmentSlot.LEGS ? CQRArmorModels.turtleArmorLegs : CQRArmorModels.turtleArmor;
    }

    @Mod.EventBusSubscriber(modid="cqrepoured")
    public static class EventHandler {
        @SubscribeEvent
        public static void onLivingUpdateEvent(LivingEvent.LivingUpdateEvent event) {
            EntityLivingBase entity = event.getEntityLiving();
            if (ItemUtil.hasFullSet(entity, ItemArmorTurtle.class)) {
                double z;
                double y;
                double x;
                if (!entity.field_70170_p.field_72995_K && entity.field_70173_aa % 200 == 0) {
                    entity.func_70691_i(1.0f);
                    x = entity.field_70165_t;
                    y = entity.field_70163_u + (double)entity.func_70047_e();
                    z = entity.field_70161_v;
                    ((WorldServer)entity.field_70170_p).func_175739_a(EnumParticleTypes.HEART, x, y, z, 2, 0.5, 0.5, 0.5, 1.0, new int[0]);
                }
                if (!CapabilityCooldownHandlerHelper.onCooldown(entity, CQRItems.CHESTPLATE_TURTLE) && entity.func_110143_aJ() < Math.max(5.0f, entity.func_110138_aP() * 0.2f)) {
                    if (!entity.field_70170_p.field_72995_K) {
                        entity.func_70690_d(new PotionEffect(MobEffects.field_76428_l, 100, 2, false, true));
                        x = entity.field_70165_t;
                        y = entity.field_70163_u + (double)entity.func_70047_e();
                        z = entity.field_70161_v;
                        ((WorldServer)entity.field_70170_p).func_175739_a(EnumParticleTypes.HEART, x, y, z, 4, 0.5, 0.5, 0.5, 1.0, new int[0]);
                        entity.field_70170_p.func_184148_a(null, x, y, z, SoundEvents.field_187664_bz, SoundCategory.PLAYERS, 0.6f, 1.2f);
                    }
                    CapabilityCooldownHandlerHelper.setCooldown(entity, CQRItems.CHESTPLATE_TURTLE, 12000);
                }
            }
        }

        @SubscribeEvent
        public static void onLivingHurtEvent(LivingHurtEvent event) {
            EntityLivingBase entity = event.getEntityLiving();
            DamageSource source = event.getSource();
            if (entity.func_184582_a(EntityEquipmentSlot.CHEST).func_77973_b() == CQRItems.CHESTPLATE_TURTLE && source.func_188404_v() != null) {
                double y;
                double pitch;
                Vec3d hitVec = source.func_188404_v();
                double x = entity.field_70165_t - hitVec.field_72450_a;
                double z = entity.field_70161_v - hitVec.field_72449_c;
                double yaw = Math.toDegrees(Math.atan2(-x, z));
                if (ItemUtil.compareRotations(entity.field_70761_aq, yaw, 45.0) && ItemUtil.compareRotations(0.0, pitch = -Math.toDegrees(Math.asin(y = entity.field_70163_u + (double)entity.field_70131_O * 0.5 - hitVec.field_72448_b)), 60.0)) {
                    if (event.getSource().func_76364_f() instanceof EntityArrow) {
                        event.getSource().func_76364_f().func_70106_y();
                    }
                    if (!entity.field_70170_p.field_72995_K) {
                        entity.field_70170_p.func_184148_a(null, hitVec.field_72450_a, hitVec.field_72448_b, hitVec.field_72449_c, SoundEvents.field_187767_eL, SoundCategory.NEUTRAL, 0.5f, 0.8f);
                    }
                    event.setCanceled(true);
                }
            }
        }
    }
}

