/*
 * Decompiled with CFR 0.152.
 */
package team.cqr.cqrepoured.objects.items.guns;

import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttribute;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.oredict.OreDictionary;
import team.cqr.cqrepoured.objects.items.guns.ItemMusket;

public class ItemMusketKnife
extends ItemMusket {
    private final float attackDamage;
    private final Item.ToolMaterial material;

    public ItemMusketKnife(Item.ToolMaterial material) {
        this.material = material;
        this.attackDamage = 3.0f + material.func_78000_c();
    }

    public Multimap<String, AttributeModifier> getAttributeModifiers(EntityEquipmentSlot slot, ItemStack stack) {
        Multimap modifiers = super.getAttributeModifiers(slot, stack);
        this.replaceModifier((Multimap<String, AttributeModifier>)modifiers, SharedMonsterAttributes.field_188790_f, field_185050_h, -0.8f);
        return modifiers;
    }

    protected void replaceModifier(Multimap<String, AttributeModifier> modifierMultimap, IAttribute attribute, UUID id, double value) {
        Collection modifiers = modifierMultimap.get((Object)attribute.func_111108_a());
        Optional<AttributeModifier> modifierOptional = modifiers.stream().filter(attributeModifier -> attributeModifier.func_111167_a().equals(id)).findFirst();
        if (modifierOptional.isPresent()) {
            AttributeModifier modifier = modifierOptional.get();
            modifiers.remove(modifier);
            modifiers.add(new AttributeModifier(modifier.func_111167_a(), modifier.func_111166_b(), modifier.func_111164_d() + value, modifier.func_111169_c()));
        }
    }

    public float func_150893_a(ItemStack stack, IBlockState state) {
        Block block = state.func_177230_c();
        if (block == Blocks.field_150321_G) {
            return 15.0f;
        }
        Material material1 = state.func_185904_a();
        return material1 != Material.field_151585_k && material1 != Material.field_151582_l && material1 != Material.field_151589_v && material1 != Material.field_151584_j && material1 != Material.field_151572_C ? 1.0f : 1.5f;
    }

    public boolean func_77644_a(ItemStack stack, EntityLivingBase target, EntityLivingBase attacker) {
        stack.func_77972_a(1, attacker);
        return true;
    }

    public boolean func_179218_a(ItemStack stack, World worldIn, IBlockState state, BlockPos pos, EntityLivingBase entityLiving) {
        if ((double)state.func_185887_b(worldIn, pos) != 0.0) {
            stack.func_77972_a(2, entityLiving);
        }
        return true;
    }

    public boolean func_150897_b(IBlockState blockIn) {
        return blockIn.func_177230_c() == Blocks.field_150321_G;
    }

    public int func_77619_b() {
        return this.material.func_77995_e();
    }

    public boolean func_82789_a(ItemStack toRepair, ItemStack repair) {
        ItemStack mat = this.material.getRepairItemStack();
        if (!mat.func_190926_b() && OreDictionary.itemMatches((ItemStack)mat, (ItemStack)repair, (boolean)false)) {
            return true;
        }
        return super.func_82789_a(toRepair, repair);
    }

    public Multimap<String, AttributeModifier> func_111205_h(EntityEquipmentSlot equipmentSlot) {
        Multimap multimap = super.func_111205_h(equipmentSlot);
        if (equipmentSlot == EntityEquipmentSlot.MAINHAND) {
            multimap.put((Object)SharedMonsterAttributes.field_111264_e.func_111108_a(), (Object)new AttributeModifier(field_111210_e, "Weapon modifier", (double)this.attackDamage, 0));
            multimap.put((Object)SharedMonsterAttributes.field_188790_f.func_111108_a(), (Object)new AttributeModifier(field_185050_h, "Weapon modifier", (double)-2.4f, 0));
        }
        return multimap;
    }
}

