/*
 * Decompiled with CFR 0.152.
 */
package team.cqr.cqrepoured.objects.items.staves;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.BlockTorch;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Keyboard;
import team.cqr.cqrepoured.init.CQRBlocks;
import team.cqr.cqrepoured.util.IRangedWeapon;

public class ItemStaffFire
extends Item
implements IRangedWeapon {
    public ItemStaffFire() {
        this.func_77625_d(1);
        this.func_77656_e(2048);
    }

    public boolean func_77644_a(ItemStack stack, EntityLivingBase target, EntityLivingBase attacker) {
        boolean flag = super.func_77644_a(stack, target, attacker);
        if (flag && field_77697_d.nextInt(5) == 0 && target.func_184187_bx() != null) {
            target.func_184210_p();
        }
        return flag;
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, EnumHand handIn) {
        ItemStack stack = playerIn.func_184586_b(handIn);
        playerIn.func_184609_a(handIn);
        this.shootFromEntity((EntityLivingBase)playerIn);
        this.changeTorch(worldIn, playerIn);
        stack.func_77972_a(1, (EntityLivingBase)playerIn);
        playerIn.func_184811_cZ().func_185145_a(stack.func_77973_b(), 20);
        return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
    }

    public void changeTorch(World worldIn, EntityPlayer player) {
        BlockPos pos;
        IBlockState blockStateLookingAt;
        Vec3d end;
        Vec3d start = player.func_174824_e(1.0f);
        RayTraceResult result = worldIn.func_72933_a(start, end = start.func_178787_e(player.func_70040_Z().func_186678_a(10.0)));
        if (result != null && !worldIn.field_72995_K && (blockStateLookingAt = worldIn.func_180495_p(pos = new BlockPos(result.field_72307_f))).func_177230_c() == CQRBlocks.UNLIT_TORCH) {
            worldIn.func_175656_a(pos, Blocks.field_150478_aa.func_176223_P().func_177226_a((IProperty)BlockTorch.field_176596_a, blockStateLookingAt.func_177229_b((IProperty)BlockTorch.field_176596_a)));
        }
    }

    public void shootFromEntity(EntityLivingBase shooter) {
        World world = shooter.field_70170_p;
        float x = (float)(-Math.sin(Math.toRadians(shooter.field_70177_z)));
        float z = (float)Math.cos(Math.toRadians(shooter.field_70177_z));
        float y = (float)(-Math.sin(Math.toRadians(shooter.field_70125_A)));
        x *= 1.0f - Math.abs(y);
        z *= 1.0f - Math.abs(y);
        if (world.field_72995_K) {
            for (int i = 0; i < 50; ++i) {
                double flameRandomMotion = field_77697_d.nextDouble() + 0.2;
                float height = shooter.field_70131_O;
                world.func_175682_a(EnumParticleTypes.FLAME, true, shooter.field_70165_t, shooter.field_70163_u + (double)height, shooter.field_70161_v, ((double)x + (field_77697_d.nextDouble() - 0.5) / 3.0) * flameRandomMotion, ((double)y + (field_77697_d.nextDouble() - 0.5) / 3.0) * flameRandomMotion, ((double)z + (field_77697_d.nextDouble() - 0.5) / 3.0) * flameRandomMotion, new int[0]);
            }
        }
        if (!world.field_72995_K) {
            int dist = 15;
            List list = world.func_72839_b((Entity)shooter, shooter.func_174813_aQ().func_72314_b(shooter.func_70040_Z().field_72450_a * (double)dist, shooter.func_70040_Z().field_72448_b * (double)dist, shooter.func_70040_Z().field_72449_c * (double)dist).func_72321_a(1.0, 1.0, 1.0));
            for (Entity e : list) {
                if (!(e instanceof EntityLivingBase)) continue;
                double rotDiff = Math.abs(this.getAngleBetweenEntities((Entity)shooter, e));
                double rot = rotDiff - (double)Math.abs(MathHelper.func_76142_g((float)shooter.field_70177_z));
                if (!((rot = Math.abs(rot)) < 10.0) || !shooter.func_70685_l(e)) continue;
                e.func_70015_d(6);
                e.func_70097_a(DamageSource.field_76372_a, 4.0f);
            }
        }
    }

    public double getAngleBetweenEntities(Entity attacker, Entity target) {
        double d = attacker.field_70165_t - target.field_70165_t;
        double d2 = attacker.field_70161_v - target.field_70161_v;
        double angle = Math.atan2(d, d2);
        angle = angle * 180.0 / 3.141592;
        angle = -MathHelper.func_76138_g((double)(angle - 180.0));
        return angle;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        if (Keyboard.isKeyDown((int)42) || Keyboard.isKeyDown((int)54)) {
            tooltip.add(TextFormatting.BLUE + I18n.func_135052_a((String)"description.staff_fire.name", (Object[])new Object[0]));
        } else {
            tooltip.add(TextFormatting.BLUE + I18n.func_135052_a((String)"description.click_shift.name", (Object[])new Object[0]));
        }
    }

    @Override
    public void shoot(World worldIn, EntityLivingBase shooter, Entity target, EnumHand handIn) {
        this.shootFromEntity(shooter);
    }

    @Override
    public SoundEvent getShootSound() {
        return SoundEvents.field_187557_bK;
    }

    @Override
    public double getRange() {
        return 14.0;
    }

    @Override
    public int getCooldown() {
        return 60;
    }

    @Override
    public int getChargeTicks() {
        return 0;
    }
}

