/*
 * Decompiled with CFR 0.152.
 */
package team.cqr.cqrepoured.objects.items.swords;

import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttribute;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.util.ActionResult;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Keyboard;
import team.cqr.cqrepoured.util.EntityUtil;
import team.cqr.cqrepoured.util.ItemUtil;

public class ItemDagger
extends ItemSword {
    private int cooldown;
    private float attackSpeed;
    private AttributeModifier movementSpeed;

    public ItemDagger(Item.ToolMaterial material, int cooldown, float attackSpeed) {
        super(material);
        this.cooldown = cooldown;
        this.attackSpeed = attackSpeed;
        this.movementSpeed = new AttributeModifier("DaggerSpeedModifier", 0.05, 2);
    }

    public Multimap<String, AttributeModifier> getAttributeModifiers(EntityEquipmentSlot slot, ItemStack stack) {
        Multimap multimap = super.getAttributeModifiers(slot, stack);
        if (slot == EntityEquipmentSlot.MAINHAND) {
            multimap.put((Object)SharedMonsterAttributes.field_111263_d.func_111108_a(), (Object)this.movementSpeed);
            this.replaceModifier((Multimap<String, AttributeModifier>)multimap, SharedMonsterAttributes.field_188790_f, field_185050_h, this.attackSpeed);
        }
        return multimap;
    }

    protected void replaceModifier(Multimap<String, AttributeModifier> modifierMultimap, IAttribute attribute, UUID id, double value) {
        Collection modifiers = modifierMultimap.get((Object)attribute.func_111108_a());
        Optional<AttributeModifier> modifierOptional = modifiers.stream().filter(attributeModifier -> attributeModifier.func_111167_a().equals(id)).findFirst();
        if (modifierOptional.isPresent()) {
            AttributeModifier modifier = modifierOptional.get();
            modifiers.remove(modifier);
            modifiers.add(new AttributeModifier(modifier.func_111167_a(), modifier.func_111166_b(), modifier.func_111164_d() + value, modifier.func_111169_c()));
        }
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, EnumHand handIn) {
        ItemStack stack = playerIn.func_184586_b(handIn);
        if (playerIn.field_70122_E && !playerIn.field_82175_bq) {
            EntityUtil.move2D((Entity)playerIn, playerIn.field_70702_br, playerIn.field_191988_bg, 1.0, playerIn.field_70177_z);
            playerIn.field_70181_x = 0.2;
            playerIn.func_184811_cZ().func_185145_a(stack.func_77973_b(), this.cooldown);
        }
        return super.func_77659_a(worldIn, playerIn, handIn);
    }

    public boolean func_77644_a(ItemStack stack, EntityLivingBase target, EntityLivingBase attacker) {
        if (!attacker.field_70170_p.field_72995_K && ItemUtil.compareRotations(target.field_70177_z, attacker.field_70177_z, 50.0)) {
            float damage = (float)attacker.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e();
            DamageSource source = attacker instanceof EntityPlayer ? DamageSource.func_76365_a((EntityPlayer)((EntityPlayer)attacker)) : DamageSource.func_76358_a((EntityLivingBase)attacker);
            target.func_70097_a(source, damage * 2.0f * (attacker.field_70143_R > 0.0f ? 1.5f : 1.0f));
            ((WorldServer)attacker.field_70170_p).func_175739_a(EnumParticleTypes.CRIT, target.field_70165_t, target.field_70163_u, target.field_70161_v, 12, 0.5, 0.5, 0.5, 1.0, new int[0]);
        }
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        tooltip.add(TextFormatting.BLUE + "200% " + I18n.func_135052_a((String)"description.rear_damage.name", (Object[])new Object[0]));
        if (Keyboard.isKeyDown((int)42) || Keyboard.isKeyDown((int)54)) {
            tooltip.add(TextFormatting.BLUE + I18n.func_135052_a((String)"description.dagger.name", (Object[])new Object[0]));
        } else {
            tooltip.add(TextFormatting.BLUE + I18n.func_135052_a((String)"description.click_shift.name", (Object[])new Object[0]));
        }
    }
}

