/*
 * Decompiled with CFR 0.152.
 */
package team.cqr.cqrepoured.objects.items.swords;

import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttribute;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.util.ActionResult;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.input.Keyboard;

public class ItemGreatSword
extends ItemSword {
    private float damage;
    private int cooldown;
    private float attackSpeed;

    public ItemGreatSword(Item.ToolMaterial material, float damage, int cooldown, float attackSpeed) {
        super(material);
        this.damage = damage;
        this.cooldown = cooldown;
        this.attackSpeed = attackSpeed;
    }

    public Multimap<String, AttributeModifier> getAttributeModifiers(EntityEquipmentSlot slot, ItemStack stack) {
        Multimap modifiers = super.getAttributeModifiers(slot, stack);
        this.replaceModifier((Multimap<String, AttributeModifier>)modifiers, SharedMonsterAttributes.field_188790_f, field_185050_h, this.attackSpeed);
        return modifiers;
    }

    protected void replaceModifier(Multimap<String, AttributeModifier> modifierMultimap, IAttribute attribute, UUID id, double value) {
        Collection modifiers = modifierMultimap.get((Object)attribute.func_111108_a());
        Optional<AttributeModifier> modifierOptional = modifiers.stream().filter(attributeModifier -> attributeModifier.func_111167_a().equals(id)).findFirst();
        if (modifierOptional.isPresent()) {
            AttributeModifier modifier = modifierOptional.get();
            modifiers.remove(modifier);
            modifiers.add(new AttributeModifier(modifier.func_111167_a(), modifier.func_111166_b(), modifier.func_111164_d() + value, modifier.func_111169_c()));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        if (Keyboard.isKeyDown((int)42) || Keyboard.isKeyDown((int)54)) {
            tooltip.add(TextFormatting.BLUE + I18n.func_135052_a((String)"description.great_sword.name", (Object[])new Object[0]));
        } else {
            tooltip.add(TextFormatting.BLUE + I18n.func_135052_a((String)"description.click_shift.name", (Object[])new Object[0]));
        }
    }

    public void func_77615_a(ItemStack stack, World worldIn, EntityLivingBase entityLiving, int timeLeft) {
        float range = 3.0f;
        double mx = entityLiving.field_70165_t - (double)range;
        double my = entityLiving.field_70163_u - (double)range;
        double mz = entityLiving.field_70161_v - (double)range;
        double max = entityLiving.field_70165_t + (double)range;
        double may = entityLiving.field_70163_u + (double)range;
        double maz = entityLiving.field_70161_v + (double)range;
        AxisAlignedBB bb = new AxisAlignedBB(mx, my, mz, max, may, maz);
        List entitiesInAABB = worldIn.func_72872_a(EntityLiving.class, bb);
        for (int i = 0; i < entitiesInAABB.size(); ++i) {
            EntityLiving entityInAABB = (EntityLiving)entitiesInAABB.get(i);
            if (this.func_77626_a(stack) - timeLeft <= 30) {
                entityInAABB.func_70097_a(DamageSource.func_188405_b((EntityLivingBase)entityLiving), this.damage);
            }
            if (this.func_77626_a(stack) - timeLeft > 30 && this.func_77626_a(stack) - timeLeft <= 60) {
                entityInAABB.func_70097_a(DamageSource.func_188405_b((EntityLivingBase)entityLiving), this.damage * 3.0f);
            }
            if (this.func_77626_a(stack) - timeLeft <= 60) continue;
            entityInAABB.func_70097_a(DamageSource.func_188405_b((EntityLivingBase)entityLiving), this.damage * 4.0f);
        }
        if (entityLiving instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)entityLiving;
            float x = (float)(-Math.sin(Math.toRadians(player.field_70177_z)));
            float z = (float)Math.cos(Math.toRadians(player.field_70177_z));
            float y = (float)(-Math.sin(Math.toRadians(player.field_70125_A)));
            x *= 1.0f - Math.abs(y);
            z *= 1.0f - Math.abs(y);
            if (player.field_70122_E && this.func_77626_a(stack) - timeLeft > 40) {
                player.field_70163_u += 0.1;
                player.field_70181_x += 0.35;
            }
            player.func_184811_cZ().func_185145_a(stack.func_77973_b(), this.cooldown);
            player.func_184609_a(EnumHand.MAIN_HAND);
            worldIn.func_184134_a(player.field_70165_t, player.field_70163_u, player.field_70161_v, SoundEvents.field_187539_bB, SoundCategory.AMBIENT, 1.0f, 1.0f, false);
            worldIn.func_175688_a(EnumParticleTypes.EXPLOSION_LARGE, player.field_70165_t + (double)x, player.field_70163_u + (double)y + 1.5, player.field_70161_v + (double)z, 0.0, 0.0, 0.0, new int[0]);
            stack.func_77972_a(1, (EntityLivingBase)player);
        }
    }

    public int func_77626_a(ItemStack stack) {
        return 72000;
    }

    public EnumAction func_77661_b(ItemStack stack) {
        return EnumAction.BOW;
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, EnumHand handIn) {
        ItemStack stack = playerIn.func_184586_b(handIn);
        playerIn.func_184598_c(handIn);
        return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
    }

    public void func_77663_a(ItemStack stack, World worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        EntityPlayer player;
        if (!worldIn.field_72995_K && entityIn instanceof EntityPlayer && (player = (EntityPlayer)entityIn).func_184614_ca() == stack && !player.func_184592_cb().func_190926_b()) {
            ItemStack stack1 = player.func_184592_cb();
            player.func_184611_a(EnumHand.OFF_HAND, ItemStack.field_190927_a);
            if (!player.field_71071_by.func_70441_a(stack1)) {
                player.func_70099_a(stack1, 0.0f);
            }
        }
    }
}

