/*
 * Decompiled with CFR 0.152.
 */
package team.cqr.cqrepoured.structuregen;

import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import team.cqr.cqrepoured.CQRMain;
import team.cqr.cqrepoured.structuregen.dungeons.DungeonBase;
import team.cqr.cqrepoured.util.data.FileIOUtil;

public class DungeonDataManager {
    private static final Map<World, DungeonDataManager> INSTANCES = Collections.synchronizedMap(new HashMap());
    private final Map<String, Set<DungeonInfo>> dungeonData = Collections.synchronizedMap(new HashMap());
    private final File file;
    private boolean modifiedSinceLastSave = false;

    public DungeonDataManager(World world) {
        int dim = world.field_73011_w.getDimension();
        this.file = dim == 0 ? new File(world.func_72860_G().func_75765_b(), "data/CQR/structures.nbt") : new File(world.func_72860_G().func_75765_b(), "DIM" + dim + "/data/CQR/structures.nbt");
    }

    @Nullable
    public static DungeonDataManager getInstance(World world) {
        if (!world.field_72995_K) {
            return INSTANCES.get(world);
        }
        return null;
    }

    public static void handleWorldLoad(World world) {
        if (!world.field_72995_K && !INSTANCES.containsKey(world)) {
            INSTANCES.put(world, new DungeonDataManager(world));
            INSTANCES.get(world).readData();
        }
    }

    public static void handleWorldSave(World world) {
        if (!world.field_72995_K && INSTANCES.containsKey(world)) {
            INSTANCES.get(world).saveData();
        }
    }

    public static void handleWorldUnload(World world) {
        if (!world.field_72995_K && INSTANCES.containsKey(world)) {
            INSTANCES.get(world).saveData();
            INSTANCES.remove(world);
        }
    }

    public static void addDungeonEntry(World world, DungeonBase dungeon, BlockPos position, DungeonSpawnType spawnType) {
        if (INSTANCES.containsKey(world)) {
            INSTANCES.get(world).addDungeonEntry(dungeon, position, spawnType);
        }
    }

    public static Set<String> getSpawnedDungeonNames(World world) {
        if (INSTANCES.containsKey(world)) {
            return INSTANCES.get(world).getSpawnedDungeonNames();
        }
        return Collections.emptySet();
    }

    public static Set<DungeonInfo> getLocationsOfDungeon(World world, DungeonBase dungeon) {
        if (INSTANCES.containsKey(world)) {
            return INSTANCES.get(world).getLocationsOfDungeon(dungeon);
        }
        return Collections.emptySet();
    }

    public static boolean isDungeonSpawnLimitMet(World world, DungeonBase dungeon) {
        if (INSTANCES.containsKey(world)) {
            return INSTANCES.get(world).isDungeonSpawnLimitMet(dungeon);
        }
        return false;
    }

    public void saveData() {
        if (this.modifiedSinceLastSave) {
            this.file.delete();
            try {
                if (!this.file.createNewFile()) {
                    CQRMain.logger.warn("Unable to create file: " + this.file.getAbsolutePath() + "! Information about dungeons may be lost!");
                    return;
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            NBTTagCompound root = new NBTTagCompound();
            for (Map.Entry<String, Set<DungeonInfo>> data : this.dungeonData.entrySet()) {
                Set<DungeonInfo> dungeonInfos = data.getValue();
                if (dungeonInfos.isEmpty()) continue;
                NBTTagList nbtTagList = new NBTTagList();
                for (DungeonInfo dungeonInfo : dungeonInfos) {
                    nbtTagList.func_74742_a((NBTBase)dungeonInfo.writeToNBT());
                }
                root.func_74782_a(data.getKey(), (NBTBase)nbtTagList);
            }
            FileIOUtil.saveNBTCompoundToFile(root, this.file);
            this.modifiedSinceLastSave = false;
        }
    }

    public void readData() {
        this.dungeonData.clear();
        NBTTagCompound root = FileIOUtil.getRootNBTTagOfFile(this.file);
        if (root == null) {
            return;
        }
        for (String key : root.func_150296_c()) {
            HashSet<DungeonInfo> dungeonInfos = new HashSet<DungeonInfo>();
            for (NBTBase nbt : root.func_150295_c(key, 10)) {
                dungeonInfos.add(new DungeonInfo((NBTTagCompound)nbt));
            }
            if (dungeonInfos.isEmpty()) continue;
            String dungeonName = key.substring(0, 4).equals("dun-") ? key.substring(4) : key;
            this.dungeonData.put(dungeonName, dungeonInfos);
        }
    }

    private void addDungeonEntry(DungeonBase dungeon, BlockPos location, DungeonSpawnType spawnType) {
        Set spawnedLocs = this.dungeonData.computeIfAbsent(dungeon.getDungeonName(), key -> Collections.synchronizedSet(new HashSet()));
        if (spawnedLocs.add(new DungeonInfo(location, spawnType))) {
            this.modifiedSinceLastSave = true;
        }
    }

    private Set<String> getSpawnedDungeonNames() {
        return this.dungeonData.keySet();
    }

    private Set<DungeonInfo> getLocationsOfDungeon(DungeonBase dungeon) {
        return this.dungeonData.getOrDefault(dungeon.getDungeonName(), Collections.emptySet());
    }

    private boolean isDungeonSpawnLimitMet(DungeonBase dungeon) {
        if (dungeon.getSpawnLimit() < 0) {
            return false;
        }
        if (this.dungeonData.isEmpty()) {
            return false;
        }
        Set<DungeonInfo> spawnedLocs = this.dungeonData.get(dungeon.getDungeonName());
        if (spawnedLocs == null) {
            return false;
        }
        return spawnedLocs.stream().filter(dungeonInfo -> ((DungeonInfo)dungeonInfo).spawnType == DungeonSpawnType.DUNGEON_GENERATION).count() >= (long)dungeon.getSpawnLimit();
    }

    public static enum DungeonSpawnType {
        DUNGEON_GENERATION,
        LOCKED_COORDINATE,
        DUNGEON_PLACER_ITEM;

    }

    public static class DungeonInfo {
        private BlockPos pos;
        private DungeonSpawnType spawnType;

        public DungeonInfo(BlockPos pos, DungeonSpawnType spawnType) {
            this.pos = pos.func_185334_h();
            this.spawnType = spawnType;
        }

        public DungeonInfo(NBTTagCompound compound) {
            this.readFromNBT(compound);
        }

        public NBTTagCompound writeToNBT() {
            NBTTagCompound compound = new NBTTagCompound();
            compound.func_74782_a("pos", (NBTBase)NBTUtil.func_186859_a((BlockPos)this.pos));
            compound.func_74768_a("spawnType", this.spawnType.ordinal());
            return compound;
        }

        public void readFromNBT(NBTTagCompound compound) {
            this.pos = compound.func_150297_b("pos", 10) ? NBTUtil.func_186861_c((NBTTagCompound)compound.func_74775_l("pos")) : NBTUtil.func_186861_c((NBTTagCompound)compound);
            this.spawnType = DungeonSpawnType.values()[compound.func_74762_e("spawnType")];
        }
    }
}

