/*
 * Decompiled with CFR 0.152.
 */
package team.cqr.cqrepoured.structuregen;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.ForgeChunkManager;
import net.minecraftforge.event.entity.EntityTravelToDimensionEvent;
import net.minecraftforge.event.world.ChunkEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.PlayerEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import team.cqr.cqrepoured.CQRMain;
import team.cqr.cqrepoured.util.ChunkUtil;
import team.cqr.cqrepoured.util.reflection.ReflectionField;

@Mod.EventBusSubscriber(modid="cqrepoured")
public class DungeonGenerationHelper {
    private static final ReflectionField<Boolean> FINDING_SPAWN_POINT = new ReflectionField(World.class, "field_72987_B", "findingSpawnPoint");
    private static final Map<Integer, Set<TravelingPlayer>> TRAVELING_PLAYERS = new HashMap<Integer, Set<TravelingPlayer>>();
    private static final Map<Integer, Set<ChunkPos>> DELAYED_CHUNKS = new HashMap<Integer, Set<ChunkPos>>();
    private static boolean isGeneratingDelayedChunks = false;

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onWorldUnloadEvent(WorldEvent.Unload event) {
        if (!event.getWorld().field_72995_K) {
            Integer dim = event.getWorld().field_73011_w.getDimension();
            if (TRAVELING_PLAYERS.containsKey(dim)) {
                TRAVELING_PLAYERS.get(dim).clear();
            }
            DungeonGenerationHelper.generateDelayedChunks(event.getWorld());
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onWorldTickEvent(TickEvent.WorldTickEvent event) {
        DungeonGenerationHelper.generateDelayedChunks(event.world);
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onEntityTravelToDimensionEvent(EntityTravelToDimensionEvent event) {
        if (event.getEntity() instanceof EntityPlayer) {
            TRAVELING_PLAYERS.computeIfAbsent(event.getDimension(), key -> new HashSet()).add(new TravelingPlayer((EntityPlayer)event.getEntity()));
        }
    }

    @SubscribeEvent
    public static void onChunkLoadEvent(ChunkEvent.Load event) {
        Integer dim;
        World world = event.getWorld();
        if (!world.field_72995_K && TRAVELING_PLAYERS.containsKey(dim = Integer.valueOf(world.field_73011_w.getDimension())) && !TRAVELING_PLAYERS.get(dim).isEmpty()) {
            for (TravelingPlayer travelingPlayer : TRAVELING_PLAYERS.get(dim)) {
                if (travelingPlayer.flag) continue;
                travelingPlayer.flag = true;
                EntityPlayer player = travelingPlayer.player;
                int chunkX = MathHelper.func_76128_c((double)player.field_70165_t) >> 4;
                int chunkZ = MathHelper.func_76128_c((double)player.field_70161_v) >> 4;
                int radius = 4;
                ForgeChunkManager.Ticket ticket = ChunkUtil.getTicket(world, chunkX - radius, chunkZ - radius, chunkX + radius + 1, chunkZ + radius + 1, true);
                for (int x = -radius; x <= radius + 1; ++x) {
                    for (int z = -radius; z <= radius + 1; ++z) {
                        world.func_72964_e(chunkX + x, chunkZ + z);
                    }
                }
                if (ticket == null) continue;
                ForgeChunkManager.releaseTicket((ForgeChunkManager.Ticket)ticket);
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onPlayerChangedDimensionEvent(PlayerEvent.PlayerChangedDimensionEvent event) {
        if (TRAVELING_PLAYERS.containsKey(event.toDim)) {
            TRAVELING_PLAYERS.get(event.toDim).removeIf(travellingPlayer -> ((TravelingPlayer)travellingPlayer).player.equals((Object)event.player));
        }
    }

    public static boolean shouldDelayDungeonGeneration(World world) {
        return Boolean.TRUE.equals(FINDING_SPAWN_POINT.get(world));
    }

    public static void addDelayedChunk(World world, int chunkX, int chunkZ) {
        DELAYED_CHUNKS.computeIfAbsent(world.field_73011_w.getDimension(), key -> new HashSet()).add(new ChunkPos(chunkX, chunkZ));
    }

    public static boolean shouldGenerateDungeonImmediately(World world) {
        if (isGeneratingDelayedChunks) {
            return true;
        }
        if (world.field_73010_i.isEmpty()) {
            return true;
        }
        Integer dim = world.field_73011_w.getDimension();
        return TRAVELING_PLAYERS.containsKey(dim) && !TRAVELING_PLAYERS.get(dim).isEmpty();
    }

    private static void generateDelayedChunks(World world) {
        if (world.field_72995_K) {
            return;
        }
        Integer dim = world.field_73011_w.getDimension();
        if (!DELAYED_CHUNKS.containsKey(dim)) {
            return;
        }
        for (ChunkPos chunkPos : DELAYED_CHUNKS.get(dim)) {
            long worldSeed = world.func_72905_C();
            Random fmlRandom = new Random(worldSeed);
            long xSeed = fmlRandom.nextLong() >> 3;
            long zSeed = fmlRandom.nextLong() >> 3;
            long chunkSeed = xSeed * (long)chunkPos.field_77276_a + zSeed * (long)chunkPos.field_77275_b ^ worldSeed;
            fmlRandom.setSeed(chunkSeed);
            isGeneratingDelayedChunks = true;
            CQRMain.DUNGEON_GENERATOR.generate(fmlRandom, chunkPos.field_77276_a, chunkPos.field_77275_b, world, ((WorldServer)world).func_72863_F().field_186029_c, world.func_72863_F());
            CQRMain.WALL_GENERATOR.generate(fmlRandom, chunkPos.field_77276_a, chunkPos.field_77275_b, world, ((WorldServer)world).func_72863_F().field_186029_c, world.func_72863_F());
            isGeneratingDelayedChunks = false;
        }
        DELAYED_CHUNKS.remove(dim);
    }

    private static class TravelingPlayer {
        private final EntityPlayer player;
        private boolean flag;

        public TravelingPlayer(EntityPlayer player) {
            this.player = player;
        }
    }
}

