/*
 * Decompiled with CFR 0.152.
 */
package team.cqr.cqrepoured.structuregen;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMaps;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import team.cqr.cqrepoured.structuregen.generators.AbstractDungeonGenerator;

@Mod.EventBusSubscriber(modid="cqrepoured")
public class DungeonGeneratorThread
extends Thread {
    private static final Int2ObjectMap<DungeonGeneratorThread> DUNGEON_GENERATOR_THREADS = Int2ObjectMaps.synchronize((Int2ObjectMap)new Int2ObjectOpenHashMap());
    private final BlockingQueue<GeneratorInfo> queue = new LinkedBlockingQueue<GeneratorInfo>();
    private static final GeneratorInfo STOP = new GeneratorInfo(null);

    private DungeonGeneratorThread() {
        this.setName("CQR Dungeon Generator Thread");
    }

    @Override
    public void run() {
        while (true) {
            try {
                GeneratorInfo generatorInfo;
                while ((generatorInfo = this.queue.take()) != STOP) {
                    generatorInfo.dungeonGenerator.generate(false);
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                continue;
            }
            break;
        }
    }

    public void stopAndWait() {
        try {
            this.queue.put(STOP);
            this.join();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    public static boolean add(AbstractDungeonGenerator<?> dungeonGenerator) {
        if (dungeonGenerator == null) {
            return false;
        }
        DungeonGeneratorThread dungeonGeneratorThread = (DungeonGeneratorThread)DUNGEON_GENERATOR_THREADS.get(dungeonGenerator.getWorld().field_73011_w.getDimension());
        if (dungeonGeneratorThread == null) {
            return false;
        }
        return dungeonGeneratorThread.queue.offer(new GeneratorInfo(dungeonGenerator));
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onWorldLoadEvent(WorldEvent.Load event) {
        int dim = event.getWorld().field_73011_w.getDimension();
        if (DUNGEON_GENERATOR_THREADS.containsKey(dim)) {
            return;
        }
        DungeonGeneratorThread dungeonGeneratorThread = new DungeonGeneratorThread();
        DUNGEON_GENERATOR_THREADS.put(dim, (Object)dungeonGeneratorThread);
        dungeonGeneratorThread.start();
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onWorldUnloadEvent(WorldEvent.Unload event) {
        int dim = event.getWorld().field_73011_w.getDimension();
        DungeonGeneratorThread dungeonGeneratorThread = (DungeonGeneratorThread)DUNGEON_GENERATOR_THREADS.get(dim);
        if (dungeonGeneratorThread == null) {
            return;
        }
        dungeonGeneratorThread.stopAndWait();
        DUNGEON_GENERATOR_THREADS.remove(dim);
    }

    private static class GeneratorInfo {
        private final AbstractDungeonGenerator<?> dungeonGenerator;

        public GeneratorInfo(AbstractDungeonGenerator<?> dungeonGenerator) {
            this.dungeonGenerator = dungeonGenerator;
        }
    }
}

