/*
 * Decompiled with CFR 0.152.
 */
package team.cqr.cqrepoured.structuregen;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Properties;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import org.apache.commons.io.FileUtils;
import team.cqr.cqrepoured.CQRMain;
import team.cqr.cqrepoured.structuregen.EDungeonGenerator;
import team.cqr.cqrepoured.structuregen.dungeons.DungeonBase;
import team.cqr.cqrepoured.util.CQRConfig;
import team.cqr.cqrepoured.util.CQRWeightedRandom;
import team.cqr.cqrepoured.util.PropertyFileHelper;

public class DungeonRegistry {
    private static final DungeonRegistry INSTANCE = new DungeonRegistry();
    private final List<DungeonBase> dungeons = new ArrayList<DungeonBase>();

    public static DungeonRegistry getInstance() {
        return INSTANCE;
    }

    public List<DungeonBase> getDungeons() {
        return this.dungeons;
    }

    public DungeonBase getDungeon(String name) {
        for (DungeonBase dungeon : this.dungeons) {
            if (!dungeon.getDungeonName().equals(name)) continue;
            return dungeon;
        }
        return null;
    }

    public CQRWeightedRandom<DungeonBase> getDungeonsForPos(World world, BlockPos pos) {
        CQRWeightedRandom<DungeonBase> dungeonsForChunk = new CQRWeightedRandom<DungeonBase>();
        boolean isChunkBehindWall = CQRConfig.wall.enabled && pos.func_177952_p() >> 4 < -CQRConfig.wall.distance;
        for (DungeonBase dungeon : this.dungeons) {
            if (!dungeon.canSpawnAtPos(world, pos, isChunkBehindWall)) continue;
            dungeonsForChunk.add(dungeon, dungeon.getWeight());
        }
        return dungeonsForChunk;
    }

    public List<DungeonBase> getLocationSpecificDungeonsForChunk(World world, int chunkX, int chunkZ) {
        ArrayList<DungeonBase> dungeonsForChunk = new ArrayList<DungeonBase>();
        for (DungeonBase dungeon : this.dungeons) {
            if (!dungeon.canSpawnInChunkWithLockedPosition(world, chunkX, chunkZ)) continue;
            dungeonsForChunk.add(dungeon);
        }
        return dungeonsForChunk;
    }

    public void loadDungeonFiles() {
        this.dungeons.clear();
        Collection files = FileUtils.listFiles((File)CQRMain.CQ_DUNGEON_FOLDER, (String[])new String[]{"properties", "prop", "cfg"}, (boolean)true);
        CQRMain.logger.info("Loading {} dungeon configuration files...", (Object)files.size());
        for (File file : files) {
            DungeonBase dungeon = this.createDungeonFromFile(file);
            if (dungeon == null) continue;
            this.dungeons.add(dungeon);
            if (dungeon.isModDependencyMissing()) {
                CQRMain.logger.warn("{}: Dungeon is missing one or more mod dependencies!", (Object)file.getName());
            }
            if (!dungeon.isEnabled()) continue;
            if (dungeon.getWeight() <= 0) {
                CQRMain.logger.warn("{}: Dungeon is enabled and weight is set to or below 0!", (Object)file.getName());
            }
            if (dungeon.getChance() > 0) continue;
            CQRMain.logger.warn("{}: Dungeon is enabled and chance is set to or below 0!", (Object)file.getName());
        }
    }

    private DungeonBase createDungeonFromFile(File file) {
        Properties prop = PropertyFileHelper.readPropFile(file);
        if (prop == null) {
            return null;
        }
        String name = file.getName().substring(0, file.getName().lastIndexOf(46));
        String generatorType = prop.getProperty("generator", "");
        EDungeonGenerator dungeonGenerator = EDungeonGenerator.getDungeonGenerator(generatorType);
        return dungeonGenerator != null ? dungeonGenerator.createDungeon(name, prop) : null;
    }
}

