/*
 * Decompiled with CFR 0.152.
 */
package team.cqr.cqrepoured.structuregen;

import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.gen.structure.template.PlacementSettings;
import team.cqr.cqrepoured.structuregen.generation.DungeonGenerator;
import team.cqr.cqrepoured.structuregen.generation.DungeonPartBlock;
import team.cqr.cqrepoured.structuregen.inhabitants.DungeonInhabitantManager;
import team.cqr.cqrepoured.structuregen.structurefile.AbstractBlockInfo;
import team.cqr.cqrepoured.structuregen.structurefile.BlockInfo;
import team.cqr.cqrepoured.util.Perlin3D;

public class PlateauBuilder {
    public static DungeonPartBlock makeRandomBlob(Block fillBlock, BlockPos startPos, BlockPos endPos, int wallSize, long seed, World world, DungeonGenerator dungeonGenerator) {
        ArrayList<AbstractBlockInfo> blockInfoList = new ArrayList<AbstractBlockInfo>();
        Perlin3D perlinNoise1 = new Perlin3D(seed, 8);
        Perlin3D perlinNoise2 = new Perlin3D(seed, 32);
        int sizeX = endPos.func_177958_n() - startPos.func_177958_n();
        int sizeZ = endPos.func_177952_p() - startPos.func_177952_p();
        int sizeY = endPos.func_177956_o() - startPos.func_177956_o();
        sizeX = (int)((double)sizeX * 1.25);
        sizeZ = (int)((double)sizeZ * 1.25);
        sizeY = (int)((double)sizeY * 1.35);
        for (int iX = 0; iX < sizeX; ++iX) {
            for (int iY = 0; iY < sizeY; ++iY) {
                for (int iZ = 0; iZ < sizeZ; ++iZ) {
                    double perlin2;
                    double perlin1;
                    float noise = Math.max(0.0f, 2.0f - (float)(sizeY - iY) / 4.0f);
                    noise += Math.max(0.0f, (float)wallSize - (float)iX / 2.0f);
                    noise += Math.max(0.0f, (float)wallSize - (float)(sizeX - iX) / 2.0f);
                    noise += Math.max(0.0f, (float)wallSize - (float)iZ / 2.0f);
                    if ((noise += Math.max(0.0f, (float)wallSize - (float)(sizeZ - iZ) / 2.0f)) >= 0.5f && (perlin1 = (double)perlinNoise1.getNoiseAt(startPos.func_177958_n() + iX, startPos.func_177956_o() + iY, startPos.func_177952_p() + iZ)) * (double)noise >= 0.5 && perlin1 * (perlin2 = (double)perlinNoise2.getNoiseAt(startPos.func_177958_n() + iX, startPos.func_177956_o() + iY, startPos.func_177952_p() + iZ)) * (double)noise >= 0.5) continue;
                    blockInfoList.add(new BlockInfo(iX, iY, iZ, fillBlock.func_176223_P(), null));
                }
            }
        }
        return new DungeonPartBlock(world, dungeonGenerator, startPos, blockInfoList, new PlacementSettings(), DungeonInhabitantManager.DEFAULT_DUNGEON_INHABITANT);
    }

    public static DungeonPartBlock makeRandomBlob2(Block fillBlock, BlockPos startPos, BlockPos endPos, int wallSize, long seed, World world, DungeonGenerator dungeonGenerator) {
        ArrayList<AbstractBlockInfo> blockInfoList = new ArrayList<AbstractBlockInfo>();
        Perlin3D perlinNoise1 = new Perlin3D(seed, 8);
        Perlin3D perlinNoise2 = new Perlin3D(seed, 32);
        int sizeX = endPos.func_177958_n() - startPos.func_177958_n() + 1 + wallSize * 2;
        int sizeZ = endPos.func_177952_p() - startPos.func_177952_p() + 1 + wallSize * 2;
        int sizeY = endPos.func_177956_o() - startPos.func_177956_o() + 1 + wallSize * 2;
        for (int iX = 0; iX < sizeX; ++iX) {
            for (int iY = 0; iY < sizeY; ++iY) {
                for (int iZ = 0; iZ < sizeZ; ++iZ) {
                    double perlin2;
                    double perlin1;
                    float noise = Math.max(0.0f, (float)wallSize - (float)iY * 0.5f);
                    noise += Math.max(0.0f, (float)wallSize - (float)(sizeY - iY) * 0.5f);
                    noise += Math.max(0.0f, (float)wallSize - (float)iX * 0.5f);
                    noise += Math.max(0.0f, (float)wallSize - (float)(sizeX - iX) * 0.5f);
                    noise += Math.max(0.0f, (float)wallSize - (float)iZ * 0.5f);
                    if ((noise += Math.max(0.0f, (float)wallSize - (float)(sizeZ - iZ) * 0.5f)) >= 0.5f && (perlin1 = (double)perlinNoise1.getNoiseAt(startPos.func_177958_n() + iX, startPos.func_177956_o() + iY, startPos.func_177952_p() + iZ)) * (double)noise >= 0.5 && perlin1 * (perlin2 = (double)perlinNoise2.getNoiseAt(startPos.func_177958_n() + iX, startPos.func_177956_o() + iY, startPos.func_177952_p() + iZ)) * (double)noise >= 0.5) continue;
                    blockInfoList.add(new BlockInfo(iX, iY, iZ, fillBlock.func_176223_P(), null));
                }
            }
        }
        return new DungeonPartBlock(world, dungeonGenerator, startPos.func_177982_a(-wallSize, -wallSize, -wallSize), blockInfoList, new PlacementSettings(), DungeonInhabitantManager.DEFAULT_DUNGEON_INHABITANT);
    }
}

