/*
 * Decompiled with CFR 0.152.
 */
package team.cqr.cqrepoured.structuregen;

import java.util.List;
import java.util.Random;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.WorldType;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraftforge.fml.common.IWorldGenerator;
import team.cqr.cqrepoured.CQRMain;
import team.cqr.cqrepoured.integration.IntegrationInformation;
import team.cqr.cqrepoured.structuregen.DungeonDataManager;
import team.cqr.cqrepoured.structuregen.DungeonGenerationHelper;
import team.cqr.cqrepoured.structuregen.DungeonRegistry;
import team.cqr.cqrepoured.structuregen.DungeonSpawnPos;
import team.cqr.cqrepoured.structuregen.dungeons.DungeonBase;
import team.cqr.cqrepoured.util.CQRConfig;
import team.cqr.cqrepoured.util.CQRWeightedRandom;
import team.cqr.cqrepoured.util.DungeonGenUtils;
import team.cqr.cqrepoured.util.VanillaStructureHelper;

public class WorldDungeonGenerator
implements IWorldGenerator {
    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkGenerator chunkGenerator, IChunkProvider chunkProvider) {
        Random rand;
        if (DungeonGenerationHelper.shouldDelayDungeonGeneration(world)) {
            DungeonGenerationHelper.addDelayedChunk(world, chunkX, chunkZ);
            return;
        }
        if (!world.func_72912_H().func_76089_r()) {
            return;
        }
        if (world.func_175624_G() == WorldType.field_77138_c && !CQRConfig.general.dungeonsInFlat) {
            return;
        }
        List<DungeonBase> locationSpecificDungeons = DungeonRegistry.getInstance().getLocationSpecificDungeonsForChunk(world, chunkX, chunkZ);
        if (!locationSpecificDungeons.isEmpty()) {
            if (locationSpecificDungeons.size() > 1) {
                CQRMain.logger.warn("Found {} location specific dungeons for chunkX={}, chunkZ={}!", (Object)locationSpecificDungeons.size(), (Object)chunkX, (Object)chunkZ);
            }
            for (DungeonBase dungeon : locationSpecificDungeons) {
                for (DungeonSpawnPos dungeonSpawnPos : dungeon.getLockedPositionsInChunk(world, chunkX, chunkZ)) {
                    int x = dungeonSpawnPos.getX(world);
                    int z = dungeonSpawnPos.getZ(world);
                    dungeon.generate(world, x, z, new Random(WorldDungeonGenerator.getSeed(world, x, z)), DungeonDataManager.DungeonSpawnType.LOCKED_COORDINATE, DungeonGenerationHelper.shouldGenerateDungeonImmediately(world));
                }
            }
            return;
        }
        if (DungeonGenUtils.isInWallRange(world, chunkX, chunkZ)) {
            return;
        }
        int dungeonSeparation = CQRConfig.general.dungeonSeparation;
        if (CQRConfig.wall.enabled && chunkZ < -CQRConfig.wall.distance && CQRConfig.general.moreDungeonsBehindWall) {
            dungeonSeparation = MathHelper.func_76143_f((double)((double)dungeonSeparation / CQRConfig.general.densityBehindWallFactor));
        }
        if ((chunkX - (DungeonGenUtils.getSpawnX(world) >> 4)) % dungeonSeparation != 0 || (chunkZ - (DungeonGenUtils.getSpawnZ(world) >> 4)) % dungeonSeparation != 0) {
            return;
        }
        if (!DungeonGenUtils.isFarAwayEnoughFromSpawn(world, chunkX, chunkZ)) {
            return;
        }
        if (!DungeonGenUtils.isFarAwayEnoughFromLocationSpecifics(world, chunkX, chunkZ, dungeonSeparation)) {
            return;
        }
        if (CQRConfig.advanced.generationRespectOtherStructures) {
            if (VanillaStructureHelper.isStructureInRange(world, new BlockPos((chunkX << 4) + 8, 64, (chunkZ << 4) + 8), MathHelper.func_76143_f((double)(CQRConfig.advanced.generationMinDistanceToOtherStructure / 16.0)))) {
                return;
            }
            if (IntegrationInformation.isAW2StructureAlreadyThere((chunkX << 4) + 8, 64, (chunkZ << 4) + 8, world)) {
                return;
            }
        }
        if (!DungeonGenUtils.percentageRandom(CQRConfig.general.overallDungeonChance, rand = new Random(WorldDungeonGenerator.getSeed(world, (chunkX << 4) + 8, (chunkZ << 4) + 8)))) {
            return;
        }
        CQRWeightedRandom<DungeonBase> possibleDungeons = DungeonRegistry.getInstance().getDungeonsForPos(world, new BlockPos((chunkX << 4) + 8, 0, (chunkZ << 4) + 8));
        DungeonBase dungeon = possibleDungeons.next(rand);
        if (dungeon != null && DungeonGenUtils.percentageRandom(dungeon.getChance(), rand)) {
            dungeon.generate(world, (chunkX << 4) + 8, (chunkZ << 4) + 8, rand, DungeonDataManager.DungeonSpawnType.DUNGEON_GENERATION, DungeonGenerationHelper.shouldGenerateDungeonImmediately(world));
        }
    }

    public static long getSeed(World world, int chunkX, int chunkZ) {
        long mix = WorldDungeonGenerator.xorShift64(chunkX) + Long.rotateLeft(WorldDungeonGenerator.xorShift64(chunkZ), 32) + -1094792450L;
        long result = WorldDungeonGenerator.xorShift64(mix);
        return world.func_72905_C() + result;
    }

    private static long xorShift64(long x) {
        x ^= x << 21;
        x ^= x >>> 35;
        x ^= x << 4;
        return x;
    }
}

