/*
 * Decompiled with CFR 0.152.
 */
package team.cqr.cqrepoured.structuregen.dungeons;

import java.io.File;
import java.util.Properties;
import java.util.Random;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import team.cqr.cqrepoured.structuregen.DungeonDataManager;
import team.cqr.cqrepoured.structuregen.dungeons.DungeonBase;
import team.cqr.cqrepoured.structuregen.generators.AbstractDungeonGenerator;
import team.cqr.cqrepoured.structuregen.generators.GeneratorGridCity;
import team.cqr.cqrepoured.util.DungeonGenUtils;
import team.cqr.cqrepoured.util.PropertyFileHelper;

public class DungeonGridCity
extends DungeonBase {
    private int minRowsX = 5;
    private int maxRowsX = 7;
    private int minRowsZ = 5;
    private int maxRowsZ = 7;
    private int heightY = 31;
    private double bridgeSizeMultiplier = 1.2;
    private boolean specialUseForCentralBuilding = false;
    private boolean makeSpaceForBuildings = true;
    private IBlockState bridgeBlock = Blocks.field_150385_bj.func_176223_P();
    private IBlockState floorBlock = Blocks.field_150353_l.func_176223_P();
    private IBlockState airBlockForPocket = Blocks.field_150350_a.func_176223_P();
    protected File buildingFolder;
    protected File centralBuildingsFolder;

    public DungeonGridCity(String name, Properties prop) {
        super(name, prop);
        this.minRowsX = PropertyFileHelper.getIntProperty(prop, "minRowsX", 5);
        this.maxRowsX = PropertyFileHelper.getIntProperty(prop, "maxRowsX", 7);
        this.minRowsX = PropertyFileHelper.getIntProperty(prop, "minRowsZ", 5);
        this.maxRowsZ = PropertyFileHelper.getIntProperty(prop, "maxRowsZ", 7);
        this.heightY = PropertyFileHelper.getIntProperty(prop, "height", 40);
        this.makeSpaceForBuildings = PropertyFileHelper.getBooleanProperty(prop, "createAirPocket", true);
        this.specialUseForCentralBuilding = PropertyFileHelper.getBooleanProperty(prop, "centralBuildingIsSpecial", true);
        this.bridgeSizeMultiplier = PropertyFileHelper.getDoubleProperty(prop, "bridgelengthmultiplier", 1.2);
        this.bridgeBlock = PropertyFileHelper.getBlockStateProperty(prop, "streetblock", Blocks.field_150385_bj.func_176223_P());
        this.floorBlock = PropertyFileHelper.getBlockStateProperty(prop, "floorblock", Blocks.field_150353_l.func_176223_P());
        this.airBlockForPocket = PropertyFileHelper.getBlockStateProperty(prop, "airPocketBlock", Blocks.field_150350_a.func_176223_P());
        this.buildingFolder = PropertyFileHelper.getStructureFolderProperty(prop, "structureFolder", "nether_city_buildings");
        this.centralBuildingsFolder = PropertyFileHelper.getStructureFolderProperty(prop, "centralStructureFolder", "nether_city_buildings");
    }

    public AbstractDungeonGenerator<DungeonGridCity> createDungeonGenerator(World world, int x, int y, int z, Random rand, DungeonDataManager.DungeonSpawnType spawnType) {
        return new GeneratorGridCity(world, new BlockPos(x, y, z), this, rand, spawnType);
    }

    public int getCaveHeight() {
        return this.heightY;
    }

    public IBlockState getBridgeBlock() {
        return this.bridgeBlock;
    }

    public IBlockState getFloorBlock() {
        return this.floorBlock;
    }

    public IBlockState getAirPocketBlock() {
        return this.airBlockForPocket;
    }

    public int getXRows(Random rand) {
        return DungeonGenUtils.randomBetween(this.minRowsX, this.maxRowsX, rand);
    }

    public int getZRows(Random rand) {
        return DungeonGenUtils.randomBetween(this.minRowsZ, this.maxRowsZ, rand);
    }

    public boolean centralBuildingIsSpecial() {
        return this.specialUseForCentralBuilding;
    }

    public boolean makeSpaceForBuildings() {
        return this.makeSpaceForBuildings;
    }

    public File getBuildingFolder() {
        return this.buildingFolder;
    }

    public File getRandomBuilding(Random rand) {
        return this.getStructureFileFromDirectory(this.getBuildingFolder(), rand);
    }

    public File getCentralBuildingFolder() {
        return this.centralBuildingsFolder;
    }

    public File getRandomCentralBuilding(Random rand) {
        return this.getStructureFileFromDirectory(this.getCentralBuildingFolder(), rand);
    }

    public double getBridgeSizeMultiplier() {
        return this.bridgeSizeMultiplier;
    }
}

