/*
 * Decompiled with CFR 0.152.
 */
package team.cqr.cqrepoured.structuregen.dungeons;

import java.io.File;
import java.util.Properties;
import java.util.Random;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import team.cqr.cqrepoured.structuregen.DungeonDataManager;
import team.cqr.cqrepoured.structuregen.dungeons.DungeonBase;
import team.cqr.cqrepoured.structuregen.generators.AbstractDungeonGenerator;
import team.cqr.cqrepoured.structuregen.generators.GeneratorHangingCity;
import team.cqr.cqrepoured.util.DungeonGenUtils;
import team.cqr.cqrepoured.util.PropertyFileHelper;

public class DungeonHangingCity
extends DungeonBase {
    private int minBuildings = 6;
    private int maxBuildings = 12;
    private int minIslandDistance = 15;
    private int maxIslandDistance = 30;
    private int yFactorHeight = 20;
    private int heightVariation = 10;
    private boolean digAirCave = true;
    private IBlockState islandMaterial = Blocks.field_150424_aL.func_176223_P();
    private IBlockState chainBlock = Blocks.field_150343_Z.func_176223_P();
    private boolean buildChains = true;
    private File structureFolder;
    private File centralStructureFolder;

    public DungeonHangingCity(String name, Properties prop) {
        super(name, prop);
        this.minBuildings = PropertyFileHelper.getIntProperty(prop, "minBuildings", 6);
        this.maxBuildings = PropertyFileHelper.getIntProperty(prop, "maxBuildings", 12);
        this.minIslandDistance = PropertyFileHelper.getIntProperty(prop, "minIslandDistance", 15);
        this.maxIslandDistance = PropertyFileHelper.getIntProperty(prop, "maxIslandDistance", 30);
        this.yFactorHeight = PropertyFileHelper.getIntProperty(prop, "islandFloorCeilingsDistance", 20);
        this.heightVariation = PropertyFileHelper.getIntProperty(prop, "islandHeightVariation", 10);
        this.digAirCave = PropertyFileHelper.getBooleanProperty(prop, "digAirCave", true);
        this.buildChains = PropertyFileHelper.getBooleanProperty(prop, "buildChains", true);
        this.structureFolder = PropertyFileHelper.getStructureFolderProperty(prop, "structureFolder", "floatingCity/islands");
        this.centralStructureFolder = PropertyFileHelper.getStructureFolderProperty(prop, "centralStructureFolder", "floatingCity/centers");
        this.islandMaterial = PropertyFileHelper.getBlockStateProperty(prop, "islandBlock", Blocks.field_150424_aL.func_176223_P());
        this.chainBlock = PropertyFileHelper.getBlockStateProperty(prop, "chainBlock", Blocks.field_150343_Z.func_176223_P());
    }

    public AbstractDungeonGenerator<DungeonHangingCity> createDungeonGenerator(World world, int x, int y, int z, Random rand, DungeonDataManager.DungeonSpawnType spawnType) {
        return new GeneratorHangingCity(world, new BlockPos(x, y, z), this, rand, spawnType);
    }

    public File pickStructure(Random rand) {
        if (this.structureFolder == null) {
            return null;
        }
        return this.getStructureFileFromDirectory(this.structureFolder, rand);
    }

    public File pickCentralStructure(Random rand) {
        if (this.centralStructureFolder == null) {
            return null;
        }
        return this.getStructureFileFromDirectory(this.centralStructureFolder, rand);
    }

    public boolean doBuildChains() {
        return this.buildChains;
    }

    public int getMinBuildings() {
        return this.minBuildings;
    }

    public int getMaxBuildings() {
        return this.maxBuildings;
    }

    public IBlockState getChainBlock() {
        return this.chainBlock;
    }

    public IBlockState getIslandBlock() {
        return this.islandMaterial;
    }

    public int getMinIslandDistance() {
        return this.minIslandDistance;
    }

    public int getMaxIslandDistance() {
        return this.maxIslandDistance;
    }

    public int getYFactorHeight() {
        return this.yFactorHeight;
    }

    public boolean digAirCave() {
        return this.digAirCave;
    }

    public int getRandomHeightVariation(Random rand) {
        if (this.heightVariation != 0) {
            int var = Math.abs(this.heightVariation);
            int rvar = DungeonGenUtils.randomBetween(0, var, rand);
            return var / 2 - rvar;
        }
        return 0;
    }
}

