/*
 * Decompiled with CFR 0.152.
 */
package team.cqr.cqrepoured.structuregen.generation;

import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import team.cqr.cqrepoured.CQRMain;
import team.cqr.cqrepoured.structuregen.generation.DungeonGenerator;
import team.cqr.cqrepoured.structuregen.generation.DungeonPartBlock;
import team.cqr.cqrepoured.structuregen.generation.DungeonPartBlockSpecial;
import team.cqr.cqrepoured.structuregen.generation.DungeonPartCover;
import team.cqr.cqrepoured.structuregen.generation.DungeonPartEntity;
import team.cqr.cqrepoured.structuregen.generation.DungeonPartLight;
import team.cqr.cqrepoured.structuregen.generation.DungeonPartPlateau;
import team.cqr.cqrepoured.util.DungeonGenUtils;

public abstract class AbstractDungeonPart {
    public static final String DUNGEON_PART_BLOCK_ID = "dungeon_part_block";
    public static final String DUNGEON_PART_BLOCK_SPECIAL_ID = "dungeon_part_block_special";
    public static final String DUNGEON_PART_COVER_ID = "dungeon_part_cover";
    public static final String DUNGEON_PART_ENTITY_ID = "dungeon_part_entity";
    public static final String DUNGEON_PART_LIGHT_ID = "dungeon_part_light";
    public static final String DUNGEON_PART_PLATEAU_ID = "dungeon_part_plateau";
    protected final World world;
    protected final DungeonGenerator dungeonGenerator;
    protected BlockPos partPos;
    protected BlockPos minPos;
    protected BlockPos maxPos;

    public AbstractDungeonPart(World world, DungeonGenerator dungeonGenerator) {
        this(world, dungeonGenerator, BlockPos.field_177992_a);
    }

    public AbstractDungeonPart(World world, DungeonGenerator dungeonGenerator, BlockPos partPos) {
        this.world = world;
        this.dungeonGenerator = dungeonGenerator;
        this.partPos = partPos;
        this.minPos = partPos;
        this.maxPos = partPos;
    }

    public static AbstractDungeonPart createDungeonPart(World world, DungeonGenerator dungeonGenerator, NBTTagCompound compound) {
        if (compound.func_150297_b("id", 8)) {
            String id = compound.func_74779_i("id");
            try {
                AbstractDungeonPart dungeonPart = null;
                switch (id) {
                    case "dungeon_part_block": {
                        dungeonPart = new DungeonPartBlock(world, dungeonGenerator);
                        break;
                    }
                    case "dungeon_part_block_special": {
                        dungeonPart = new DungeonPartBlockSpecial(world, dungeonGenerator);
                        break;
                    }
                    case "dungeon_part_cover": {
                        dungeonPart = new DungeonPartCover(world, dungeonGenerator);
                        break;
                    }
                    case "dungeon_part_entity": {
                        dungeonPart = new DungeonPartEntity(world, dungeonGenerator);
                        break;
                    }
                    case "dungeon_part_light": {
                        dungeonPart = new DungeonPartLight(world, dungeonGenerator);
                        break;
                    }
                    case "dungeon_part_plateau": {
                        dungeonPart = new DungeonPartPlateau(world, dungeonGenerator);
                        break;
                    }
                }
                if (dungeonPart != null) {
                    dungeonPart.readFromNBT(compound);
                }
                return dungeonPart;
            }
            catch (Exception e) {
                CQRMain.logger.error(String.format("Failed to create dungeon part for id %s", id), (Throwable)e);
            }
        }
        return null;
    }

    public NBTTagCompound writeToNBT() {
        NBTTagCompound compound = new NBTTagCompound();
        compound.func_74778_a("id", this.getId());
        compound.func_74782_a("partPos", (NBTBase)NBTUtil.func_186859_a((BlockPos)this.partPos));
        compound.func_74782_a("minPos", (NBTBase)NBTUtil.func_186859_a((BlockPos)this.minPos));
        compound.func_74782_a("maxPos", (NBTBase)NBTUtil.func_186859_a((BlockPos)this.maxPos));
        return compound;
    }

    public void readFromNBT(NBTTagCompound compound) {
        if (!compound.func_74764_b("id") || !compound.func_74779_i("id").equals(this.getId())) {
            throw new IllegalArgumentException();
        }
        this.partPos = NBTUtil.func_186861_c((NBTTagCompound)compound.func_74775_l("partPos"));
        this.minPos = NBTUtil.func_186861_c((NBTTagCompound)compound.func_74775_l("minPos"));
        this.maxPos = NBTUtil.func_186861_c((NBTTagCompound)compound.func_74775_l("maxPos"));
    }

    public abstract String getId();

    public abstract void generateNext();

    public abstract boolean isGenerated();

    public BlockPos getPartPos() {
        return this.partPos;
    }

    public BlockPos getMinPos() {
        return this.minPos;
    }

    public BlockPos getMaxPos() {
        return this.maxPos;
    }

    protected void updateMinAndMaxPos(BlockPos pos) {
        this.minPos = DungeonGenUtils.getValidMinPos(pos, this.minPos);
        this.maxPos = DungeonGenUtils.getValidMaxPos(pos, this.maxPos);
    }

    protected BlockPos.MutableBlockPos transformedXYZasMutablePos(BlockPos pos, int x, int y, int z, Mirror mirror, Rotation rotation, BlockPos.MutableBlockPos mutablePos) {
        switch (mirror) {
            case LEFT_RIGHT: {
                z = -z;
                break;
            }
            case FRONT_BACK: {
                x = -x;
                break;
            }
        }
        switch (rotation) {
            case COUNTERCLOCKWISE_90: {
                return mutablePos.func_181079_c(pos.func_177958_n() + z, pos.func_177956_o() + y, pos.func_177952_p() - x);
            }
            case CLOCKWISE_90: {
                return mutablePos.func_181079_c(pos.func_177958_n() - z, pos.func_177956_o() + y, pos.func_177952_p() + x);
            }
            case CLOCKWISE_180: {
                return mutablePos.func_181079_c(pos.func_177958_n() - x, pos.func_177956_o() + y, pos.func_177952_p() - z);
            }
        }
        return mutablePos.func_181079_c(pos.func_177958_n() + x, pos.func_177956_o() + y, pos.func_177952_p() + z);
    }

    protected BlockPos.MutableBlockPos transformedXYZasMutablePos(BlockPos pos, double x, double y, double z, Mirror mirror, Rotation rotation, BlockPos.MutableBlockPos mutablePos) {
        switch (mirror) {
            case LEFT_RIGHT: {
                z = -z;
                break;
            }
            case FRONT_BACK: {
                x = -x;
                break;
            }
        }
        switch (rotation) {
            case COUNTERCLOCKWISE_90: {
                return mutablePos.func_189532_c((double)pos.func_177958_n() + z, (double)pos.func_177956_o() + y, (double)pos.func_177952_p() - x);
            }
            case CLOCKWISE_90: {
                return mutablePos.func_189532_c((double)pos.func_177958_n() - z, (double)pos.func_177956_o() + y, (double)pos.func_177952_p() + x);
            }
            case CLOCKWISE_180: {
                return mutablePos.func_189532_c((double)pos.func_177958_n() - x, (double)pos.func_177956_o() + y, (double)pos.func_177952_p() - z);
            }
        }
        return mutablePos.func_189533_g((Vec3i)pos);
    }
}

