/*
 * Decompiled with CFR 0.152.
 */
package team.cqr.cqrepoured.structuregen.generation;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeModContainer;
import org.apache.commons.io.FileUtils;
import team.cqr.cqrepoured.CQRMain;
import team.cqr.cqrepoured.structuregen.DungeonDataManager;
import team.cqr.cqrepoured.structuregen.dungeons.DungeonBase;
import team.cqr.cqrepoured.structuregen.generation.DungeonGenerator;

public class DungeonGenerationManager {
    private static final Map<World, DungeonGenerationManager> INSTANCES = Collections.synchronizedMap(new HashMap());
    private final List<DungeonGenerator> dungeonGeneratorList = Collections.synchronizedList(new ArrayList());
    private final World world;
    private final File folder;

    public DungeonGenerationManager(World world) {
        this.world = world;
        int dim = world.field_73011_w.getDimension();
        this.folder = dim == 0 ? new File(world.func_72860_G().func_75765_b(), "data/CQR/structure_parts") : new File(world.func_72860_G().func_75765_b(), "DIM" + dim + "/data/CQR/structure_parts");
    }

    @Nullable
    public static DungeonGenerationManager getInstance(World world) {
        if (!world.field_72995_K) {
            return INSTANCES.get(world);
        }
        return null;
    }

    public static void handleWorldLoad(World world) {
        if (!world.field_72995_K && !INSTANCES.containsKey(world)) {
            INSTANCES.put(world, new DungeonGenerationManager(world));
            INSTANCES.get(world).loadData();
            CQRMain.logger.info("Loaded {} parts to generate", (Object)DungeonGenerationManager.INSTANCES.get((Object)world).dungeonGeneratorList.size());
        }
    }

    public static void handleWorldSave(World world) {
        if (!world.field_72995_K && INSTANCES.containsKey(world)) {
            INSTANCES.get(world).saveData();
        }
    }

    public static void handleWorldUnload(World world) {
        if (!world.field_72995_K && INSTANCES.containsKey(world)) {
            INSTANCES.get(world).saveData();
            CQRMain.logger.info("Saved {} parts to generate", (Object)DungeonGenerationManager.INSTANCES.get((Object)world).dungeonGeneratorList.size());
            INSTANCES.remove(world);
        }
    }

    public static void handleWorldTick(World world) {
        if (!world.field_72995_K && INSTANCES.containsKey(world)) {
            INSTANCES.get(world).tick();
        }
    }

    public static void addStructure(World world, DungeonGenerator structure, @Nullable DungeonBase dungeon, DungeonDataManager.DungeonSpawnType spawnType, boolean generateImmediately) {
        if (world != null && !world.field_72995_K) {
            structure.startGeneration(dungeon);
            if (dungeon != null) {
                DungeonDataManager.addDungeonEntry(world, dungeon, structure.getPos(), spawnType);
            }
            if (generateImmediately) {
                boolean logCascadingWorldGeneration = ForgeModContainer.logCascadingWorldGeneration;
                ForgeModContainer.logCascadingWorldGeneration = false;
                while (!structure.isGenerated()) {
                    structure.tick();
                }
                ForgeModContainer.logCascadingWorldGeneration = logCascadingWorldGeneration;
                CQRMain.logger.info("Generated dungeon {} at {}", (Object)structure.getDungeonName(), (Object)structure.getPos());
            } else {
                DungeonGenerationManager.INSTANCES.get((Object)world).dungeonGeneratorList.add(structure);
            }
        }
    }

    private void saveData() {
        if (!this.world.field_72995_K) {
            if (!this.folder.exists()) {
                this.folder.mkdirs();
            }
            for (File file : FileUtils.listFiles((File)this.folder, (String[])new String[]{"nbt"}, (boolean)false)) {
                file.delete();
            }
            for (DungeonGenerator structure : this.dungeonGeneratorList) {
                this.createFileFromStructure(this.folder, structure);
            }
        }
    }

    private void createFileFromStructure(File folder, DungeonGenerator dungeonGenerator) {
        File file = new File(folder, dungeonGenerator.getUuid().toString() + ".nbt");
        try {
            if (!file.exists() && !file.createNewFile()) {
                throw new FileNotFoundException();
            }
            try (FileOutputStream outputStream = new FileOutputStream(file);){
                CompressedStreamTools.func_74799_a((NBTTagCompound)dungeonGenerator.writeToNBT(), (OutputStream)outputStream);
            }
        }
        catch (IOException e) {
            CQRMain.logger.info("Failed to save structure to file: " + file.getName(), (Throwable)e);
        }
    }

    private void loadData() {
        if (!this.world.field_72995_K) {
            if (!this.folder.exists()) {
                this.folder.mkdirs();
            }
            this.dungeonGeneratorList.clear();
            for (File file : FileUtils.listFiles((File)this.folder, (String[])new String[]{"nbt"}, (boolean)false)) {
                this.createStructureFromFile(file);
            }
        }
    }

    private void createStructureFromFile(File file) {
        try (FileInputStream inputStream = new FileInputStream(file);){
            NBTTagCompound compound = CompressedStreamTools.func_74796_a((InputStream)inputStream);
            this.dungeonGeneratorList.add(new DungeonGenerator(this.world, compound));
        }
        catch (IOException e) {
            CQRMain.logger.info("Failed to load structure from file: " + file.getName(), (Throwable)e);
        }
    }

    private void tick() {
        for (int i = 0; i < this.dungeonGeneratorList.size(); ++i) {
            DungeonGenerator dungeonGenerator = this.dungeonGeneratorList.get(i);
            dungeonGenerator.tick();
            if (!dungeonGenerator.isGenerated()) continue;
            this.dungeonGeneratorList.remove(i--);
            CQRMain.logger.info("Generated dungeon {} at {}", (Object)dungeonGenerator.getDungeonName(), (Object)dungeonGenerator.getPos());
        }
    }
}

