/*
 * Decompiled with CFR 0.152.
 */
package team.cqr.cqrepoured.structuregen.generation;

import java.util.Collection;
import java.util.Deque;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagIntArray;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeChunkManager;
import team.cqr.cqrepoured.structuregen.dungeons.DungeonBase;
import team.cqr.cqrepoured.structuregen.generation.AbstractDungeonPart;
import team.cqr.cqrepoured.structuregen.generation.DungeonPartLight;
import team.cqr.cqrepoured.structureprot.IProtectedRegionManager;
import team.cqr.cqrepoured.structureprot.ProtectedRegion;
import team.cqr.cqrepoured.structureprot.ProtectedRegionManager;
import team.cqr.cqrepoured.util.CQRConfig;
import team.cqr.cqrepoured.util.ChunkUtil;
import team.cqr.cqrepoured.util.DungeonGenUtils;

public class DungeonGenerator {
    protected final World world;
    protected final Deque<AbstractDungeonPart> parts = new LinkedList<AbstractDungeonPart>();
    protected UUID uuid = MathHelper.func_188210_a();
    protected String dungeonName;
    protected BlockPos pos;
    protected BlockPos minPos;
    protected BlockPos maxPos;
    protected final Set<BlockPos> unprotectedPositions = new HashSet<BlockPos>();
    protected ProtectedRegion protectedRegion;
    protected DungeonPartLight dungeonPartLight;
    protected EnumDungeonGeneratorState state = EnumDungeonGeneratorState.PRE_GENERATION;
    private long tickTime;
    private ForgeChunkManager.Ticket chunkTicket;
    private boolean ticketRequested;

    public DungeonGenerator(World world, BlockPos pos, String dungeonName) {
        this.world = world;
        this.pos = pos;
        this.minPos = pos;
        this.maxPos = pos;
        this.dungeonName = dungeonName;
    }

    public DungeonGenerator(World world, NBTTagCompound compound) {
        this.world = world;
        this.readFromNBT(compound);
    }

    public NBTTagCompound writeToNBT() {
        NBTTagCompound compound = new NBTTagCompound();
        NBTTagList nbtTagList = new NBTTagList();
        for (AbstractDungeonPart part : this.parts) {
            nbtTagList.func_74742_a((NBTBase)part.writeToNBT());
        }
        compound.func_74782_a("parts", (NBTBase)nbtTagList);
        compound.func_74782_a("uuid", (NBTBase)NBTUtil.func_186862_a((UUID)this.uuid));
        compound.func_74782_a("pos", (NBTBase)NBTUtil.func_186859_a((BlockPos)this.pos));
        compound.func_74782_a("minPos", (NBTBase)NBTUtil.func_186859_a((BlockPos)this.minPos));
        compound.func_74782_a("maxPos", (NBTBase)NBTUtil.func_186859_a((BlockPos)this.maxPos));
        compound.func_74782_a("partLight", (NBTBase)this.dungeonPartLight.writeToNBT());
        if (this.protectedRegion != null) {
            compound.func_74782_a("protectedRegion", (NBTBase)NBTUtil.func_186862_a((UUID)this.protectedRegion.getUuid()));
        }
        compound.func_74768_a("state", this.state.ordinal());
        compound.func_74778_a("dungeonName", this.dungeonName);
        int[] data = new int[this.unprotectedPositions.size() * 3];
        int i = 0;
        for (BlockPos p : this.unprotectedPositions) {
            data[i * 3] = p.func_177958_n();
            data[i * 3 + 1] = p.func_177956_o();
            data[i * 3 + 2] = p.func_177952_p();
            ++i;
        }
        compound.func_74782_a("unprotectedPositions", (NBTBase)new NBTTagIntArray(data));
        return compound;
    }

    public void readFromNBT(NBTTagCompound compound) {
        IProtectedRegionManager protectedRegionManager;
        this.parts.clear();
        for (NBTBase nbt : compound.func_150295_c("parts", 10)) {
            AbstractDungeonPart part = AbstractDungeonPart.createDungeonPart(this.world, this, (NBTTagCompound)nbt);
            if (part == null) continue;
            this.parts.add(part);
        }
        this.uuid = NBTUtil.func_186860_b((NBTTagCompound)compound.func_74775_l("uuid"));
        this.pos = NBTUtil.func_186861_c((NBTTagCompound)compound.func_74775_l("pos"));
        this.minPos = NBTUtil.func_186861_c((NBTTagCompound)compound.func_74775_l("minPos"));
        this.maxPos = NBTUtil.func_186861_c((NBTTagCompound)compound.func_74775_l("maxPos"));
        this.dungeonPartLight = new DungeonPartLight(this.world, this);
        this.dungeonPartLight.readFromNBT(compound.func_74775_l("partLight"));
        if (compound.func_150297_b("protectedRegion", 10) && (protectedRegionManager = ProtectedRegionManager.getInstance(this.world)) != null) {
            UUID protectedRegionUuid = NBTUtil.func_186860_b((NBTTagCompound)compound.func_74775_l("protectedRegion"));
            this.protectedRegion = protectedRegionManager.getProtectedRegion(protectedRegionUuid);
        }
        this.state = EnumDungeonGeneratorState.values()[compound.func_74762_e("state")];
        this.dungeonName = compound.func_74779_i("dungeonName");
        this.unprotectedPositions.clear();
        int[] data = compound.func_74759_k("unprotectedPositions");
        for (int i = 0; i < data.length / 3; ++i) {
            this.unprotectedPositions.add(new BlockPos(data[i * 3], data[i * 3 + 1], data[i * 3 + 2]));
        }
    }

    public void tick() {
        if (this.state == EnumDungeonGeneratorState.GENERATION) {
            if (!this.ticketRequested) {
                this.chunkTicket = ChunkUtil.getTicket(this.world, this.minPos, this.maxPos, true);
                this.ticketRequested = true;
            }
            this.tickTime = Math.min(this.tickTime + (long)(CQRConfig.advanced.generationSpeed * 1000000), (long)(CQRConfig.advanced.generationSpeed * 1000000));
            int i = 0;
            while (this.tickTime > 0L && i < CQRConfig.advanced.generationLimit && !this.isGenerated()) {
                long t = System.nanoTime();
                if (!this.parts.isEmpty()) {
                    AbstractDungeonPart part = this.parts.getFirst();
                    part.generateNext();
                    if (part.isGenerated()) {
                        this.parts.removeFirst();
                    }
                } else if (!this.dungeonPartLight.isGenerated()) {
                    this.dungeonPartLight.generateNext();
                } else {
                    this.endGeneration();
                }
                ++i;
                this.tickTime -= System.nanoTime() - t;
            }
        }
    }

    public boolean isGenerated() {
        return this.state == EnumDungeonGeneratorState.POST_GENERATION;
    }

    public UUID getUuid() {
        return this.uuid;
    }

    public String getDungeonName() {
        return this.dungeonName;
    }

    public BlockPos getPos() {
        return this.pos;
    }

    public BlockPos getMinPos() {
        return this.minPos;
    }

    public BlockPos getMaxPos() {
        return this.maxPos;
    }

    public ProtectedRegion getProtectedRegion() {
        return this.protectedRegion;
    }

    public void add(AbstractDungeonPart part) {
        if (this.state == EnumDungeonGeneratorState.PRE_GENERATION && part != null && !part.isGenerated()) {
            this.parts.add(part);
            this.minPos = DungeonGenUtils.getValidMinPos(part.getMinPos(), this.minPos);
            this.maxPos = DungeonGenUtils.getValidMaxPos(part.getMaxPos(), this.maxPos);
        }
    }

    public void addAll(Collection<AbstractDungeonPart> parts) {
        if (this.state == EnumDungeonGeneratorState.PRE_GENERATION) {
            for (AbstractDungeonPart part : parts) {
                this.add(part);
            }
        }
    }

    public void addUnprotectedPosition(BlockPos p) {
        this.unprotectedPositions.add(p.func_185334_h());
    }

    public void startGeneration(@Nullable DungeonBase dungeon) {
        if (this.state == EnumDungeonGeneratorState.PRE_GENERATION) {
            this.dungeonPartLight = new DungeonPartLight(this.world, this, this.minPos, this.maxPos);
            if (dungeon != null && dungeon.isProtectionSystemEnabled()) {
                this.protectedRegion = new ProtectedRegion(this.world, dungeon.getDungeonName(), this.pos.func_177981_b(dungeon.getUnderGroundOffset()), this.minPos, this.maxPos);
                this.protectedRegion.setup(dungeon.preventBlockBreaking(), dungeon.preventBlockPlacing(), dungeon.preventExplosionsTNT(), dungeon.preventExplosionsOther(), dungeon.preventFireSpreading(), dungeon.preventEntitySpawning(), dungeon.ignoreNoBossOrNexus());
                for (BlockPos p : this.unprotectedPositions) {
                    this.protectedRegion.setProtectionState(p, 1);
                }
                IProtectedRegionManager manager = ProtectedRegionManager.getInstance(this.world);
                if (manager != null) {
                    manager.addProtectedRegion(this.protectedRegion);
                }
            }
            this.state = EnumDungeonGeneratorState.GENERATION;
        }
    }

    public void endGeneration() {
        if (this.state == EnumDungeonGeneratorState.GENERATION) {
            if (this.chunkTicket != null) {
                ForgeChunkManager.releaseTicket((ForgeChunkManager.Ticket)this.chunkTicket);
            }
            this.state = EnumDungeonGeneratorState.POST_GENERATION;
            if (this.protectedRegion != null) {
                IProtectedRegionManager manager;
                this.protectedRegion.finishGenerating();
                if (!this.protectedRegion.isValid() && (manager = ProtectedRegionManager.getInstance(this.world)) != null) {
                    manager.removeProtectedRegion(this.protectedRegion);
                }
            }
        }
    }

    public static enum EnumDungeonGeneratorState {
        PRE_GENERATION,
        GENERATION,
        POST_GENERATION;

    }
}

