/*
 * Decompiled with CFR 0.152.
 */
package team.cqr.cqrepoured.structuregen.generation;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Queue;
import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagByteArray;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraft.world.gen.structure.template.PlacementSettings;
import net.minecraft.world.gen.structure.template.Template;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import team.cqr.cqrepoured.structuregen.generation.AbstractDungeonPart;
import team.cqr.cqrepoured.structuregen.generation.DungeonGenerator;
import team.cqr.cqrepoured.structuregen.inhabitants.DungeonInhabitant;
import team.cqr.cqrepoured.structuregen.inhabitants.DungeonInhabitantManager;
import team.cqr.cqrepoured.structuregen.structurefile.AbstractBlockInfo;
import team.cqr.cqrepoured.structuregen.structurefile.BlockStatePalette;
import team.cqr.cqrepoured.structuregen.structurefile.CQStructure;
import team.cqr.cqrepoured.util.DungeonGenUtils;

public class DungeonPartBlock
extends AbstractDungeonPart {
    protected final Queue<AbstractBlockInfo> blockInfoQueue = new ArrayDeque<AbstractBlockInfo>();
    protected PlacementSettings settings;
    protected DungeonInhabitant dungeonMobType;
    protected boolean keepOrder;

    public DungeonPartBlock(World world, DungeonGenerator dungeonGenerator) {
        this(world, dungeonGenerator, BlockPos.field_177992_a, Collections.emptyList(), new PlacementSettings(), DungeonInhabitantManager.DEFAULT_DUNGEON_INHABITANT, false);
    }

    public DungeonPartBlock(World world, DungeonGenerator dungeonGenerator, BlockPos partPos, Collection<AbstractBlockInfo> blocks, PlacementSettings settings, DungeonInhabitant dungeonMobType) {
        this(world, dungeonGenerator, partPos, blocks, settings, dungeonMobType, false);
    }

    public DungeonPartBlock(World world, DungeonGenerator dungeonGenerator, BlockPos partPos, Collection<AbstractBlockInfo> blocks, PlacementSettings settings, DungeonInhabitant dungeonMobType, boolean keepOrder) {
        super(world, dungeonGenerator, partPos);
        List list;
        this.settings = settings;
        this.dungeonMobType = dungeonMobType;
        this.keepOrder = keepOrder;
        if (!blocks.isEmpty() && !(list = Arrays.asList(blocks.stream().filter(Objects::nonNull).toArray(AbstractBlockInfo[]::new))).isEmpty()) {
            if (!keepOrder) {
                list.sort(CQStructure.SORT_FOR_GENERATION);
            }
            this.blockInfoQueue.addAll(list);
            this.calculateMinMaxPos();
        }
    }

    protected void calculateMinMaxPos() {
        if (this.blockInfoQueue.isEmpty()) {
            return;
        }
        AbstractBlockInfo firstBlockInfo = (AbstractBlockInfo)this.blockInfoQueue.iterator().next();
        this.maxPos = this.minPos = this.partPos.func_177971_a((Vec3i)Template.func_186266_a((PlacementSettings)this.settings, (BlockPos)firstBlockInfo.getPos()));
        BlockPos.MutableBlockPos p1 = new BlockPos.MutableBlockPos(this.minPos);
        BlockPos.MutableBlockPos p2 = new BlockPos.MutableBlockPos(this.minPos);
        BlockPos.MutableBlockPos p3 = new BlockPos.MutableBlockPos(this.minPos);
        for (AbstractBlockInfo blockInfo : this.blockInfoQueue) {
            this.transformedXYZasMutablePos(this.partPos, blockInfo.getX(), blockInfo.getY(), blockInfo.getZ(), this.settings.func_186212_b(), this.settings.func_186215_c(), p1);
            p2.func_181079_c(Math.min(p2.func_177958_n(), p1.func_177958_n()), Math.min(p2.func_177956_o(), p1.func_177956_o()), Math.min(p2.func_177952_p(), p1.func_177952_p()));
            p3.func_181079_c(Math.max(p3.func_177958_n(), p1.func_177958_n()), Math.max(p3.func_177956_o(), p1.func_177956_o()), Math.max(p3.func_177952_p(), p1.func_177952_p()));
        }
        this.updateMinAndMaxPos((BlockPos)p2);
        this.updateMinAndMaxPos((BlockPos)p3);
    }

    @Override
    public NBTTagCompound writeToNBT() {
        NBTTagCompound compound = super.writeToNBT();
        compound.func_74768_a("mirror", this.settings.func_186212_b().ordinal());
        compound.func_74768_a("rotation", this.settings.func_186215_c().ordinal());
        compound.func_74778_a("mob", this.dungeonMobType.getName());
        compound.func_74757_a("keepOrder", this.keepOrder);
        BlockPos offset = this.getMinPos(this.blockInfoQueue);
        BlockPos size = this.getMaxPos(this.blockInfoQueue).func_177973_b((Vec3i)offset).func_177982_a(1, 1, 1);
        compound.func_74782_a("offset", (NBTBase)DungeonGenUtils.writePosToList(offset));
        compound.func_74782_a("size", (NBTBase)DungeonGenUtils.writePosToList(size));
        BlockStatePalette blockStatePalette = new BlockStatePalette();
        NBTTagList compoundTagList = new NBTTagList();
        if (!this.keepOrder) {
            AbstractBlockInfo[][][] array = new AbstractBlockInfo[size.func_177958_n()][size.func_177956_o()][size.func_177952_p()];
            Iterator<Object> iterator = this.blockInfoQueue.iterator();
            while (iterator.hasNext()) {
                AbstractBlockInfo blockInfo;
                array[blockInfo.getX() - offset.func_177958_n()][blockInfo.getY() - offset.func_177956_o()][blockInfo.getZ() - offset.func_177952_p()] = blockInfo = (AbstractBlockInfo)iterator.next();
            }
            ByteBuf buf = Unpooled.buffer((int)(size.func_177958_n() * size.func_177956_o() * size.func_177952_p()));
            buf.writeInt(this.blockInfoQueue.size());
            for (int x = 0; x < array.length; ++x) {
                for (int y = 0; y < array[x].length; ++y) {
                    for (int z = 0; z < array[x][y].length; ++z) {
                        AbstractBlockInfo blockInfo = array[x][y][z];
                        if (blockInfo != null) {
                            blockInfo.writeToByteBuf(buf, blockStatePalette, compoundTagList);
                            continue;
                        }
                        buf.writeByte(255);
                    }
                }
            }
            compound.func_74782_a("blockInfoList", (NBTBase)new NBTTagByteArray(Arrays.copyOf(buf.array(), buf.writerIndex())));
        } else {
            ByteBuf buf = Unpooled.buffer((int)(this.blockInfoQueue.size() * 8));
            buf.writeInt(this.blockInfoQueue.size());
            for (AbstractBlockInfo blockInfo : this.blockInfoQueue) {
                ByteBufUtils.writeVarInt((ByteBuf)buf, (int)(blockInfo.getX() - offset.func_177958_n()), (int)5);
                ByteBufUtils.writeVarInt((ByteBuf)buf, (int)(blockInfo.getY() - offset.func_177956_o()), (int)5);
                ByteBufUtils.writeVarInt((ByteBuf)buf, (int)(blockInfo.getZ() - offset.func_177952_p()), (int)5);
                blockInfo.writeToByteBuf(buf, blockStatePalette, compoundTagList);
            }
            compound.func_74782_a("blockInfoList", (NBTBase)new NBTTagByteArray(Arrays.copyOf(buf.array(), buf.writerIndex())));
        }
        NBTTagList nbtTagList4 = new NBTTagList();
        for (IBlockState state : blockStatePalette) {
            nbtTagList4.func_74742_a((NBTBase)NBTUtil.func_190009_a((NBTTagCompound)new NBTTagCompound(), (IBlockState)state));
        }
        compound.func_74782_a("palette", (NBTBase)nbtTagList4);
        compound.func_74782_a("compoundTagList", (NBTBase)compoundTagList);
        return compound;
    }

    @Override
    public void readFromNBT(NBTTagCompound compound) {
        ByteBuf buf;
        super.readFromNBT(compound);
        this.blockInfoQueue.clear();
        this.settings = new PlacementSettings();
        this.settings.func_186214_a(Mirror.values()[compound.func_74762_e("mirror")]);
        this.settings.func_186220_a(Rotation.values()[compound.func_74762_e("rotation")]);
        this.dungeonMobType = DungeonInhabitantManager.instance().getInhabitant(compound.func_74779_i("mob"));
        this.keepOrder = compound.func_74767_n("keepOrder");
        BlockPos offset = DungeonGenUtils.readPosFromList(compound.func_150295_c("offset", 3));
        BlockPos size = DungeonGenUtils.readPosFromList(compound.func_150295_c("size", 3));
        BlockStatePalette blockStatePalette = new BlockStatePalette();
        NBTTagList compoundTagList = compound.func_150295_c("compoundTagList", 10);
        int blockStateIndex = 0;
        for (NBTBase nbt : compound.func_150295_c("palette", 10)) {
            blockStatePalette.addMapping(NBTUtil.func_190008_d((NBTTagCompound)((NBTTagCompound)nbt)), blockStateIndex++);
        }
        if (!this.keepOrder) {
            buf = Unpooled.wrappedBuffer((byte[])compound.func_74770_j("blockInfoList"));
            ArrayList<AbstractBlockInfo> list = new ArrayList<AbstractBlockInfo>(buf.readInt());
            for (int x = 0; x < size.func_177958_n(); ++x) {
                for (int y = 0; y < size.func_177956_o(); ++y) {
                    for (int z = 0; z < size.func_177952_p(); ++z) {
                        AbstractBlockInfo blockInfo = AbstractBlockInfo.create(x + offset.func_177958_n(), y + offset.func_177956_o(), z + offset.func_177952_p(), buf, blockStatePalette, compoundTagList);
                        if (blockInfo == null) continue;
                        list.add(blockInfo);
                    }
                }
            }
            list.sort(CQStructure.SORT_FOR_GENERATION);
            this.blockInfoQueue.addAll(list);
        } else {
            buf = Unpooled.wrappedBuffer((byte[])compound.func_74770_j("blockInfoList"));
            int i = buf.readInt();
            for (int j = 0; j < i; ++j) {
                int z;
                int y;
                int x = ByteBufUtils.readVarInt((ByteBuf)buf, (int)5) + offset.func_177958_n();
                AbstractBlockInfo blockInfo = AbstractBlockInfo.create(x, y = ByteBufUtils.readVarInt((ByteBuf)buf, (int)5) + offset.func_177956_o(), z = ByteBufUtils.readVarInt((ByteBuf)buf, (int)5) + offset.func_177952_p(), buf, blockStatePalette, compoundTagList);
                if (blockInfo == null) continue;
                this.blockInfoQueue.add(blockInfo);
            }
        }
    }

    @Override
    public String getId() {
        return "dungeon_part_block";
    }

    @Override
    public void generateNext() {
        if (!this.blockInfoQueue.isEmpty()) {
            this.blockInfoQueue.poll().generate(this.world, this.dungeonGenerator.getPos(), this.partPos, this.settings, this.dungeonMobType, this.dungeonGenerator.getProtectedRegion());
        }
    }

    @Override
    public boolean isGenerated() {
        return this.blockInfoQueue.isEmpty();
    }

    private BlockPos getMinPos(Collection<AbstractBlockInfo> collection) {
        if (collection.isEmpty()) {
            return BlockPos.field_177992_a;
        }
        int minX = Integer.MAX_VALUE;
        int minY = Integer.MAX_VALUE;
        int minZ = Integer.MAX_VALUE;
        for (AbstractBlockInfo blockInfo : collection) {
            BlockPos pos = blockInfo.getPos();
            if (pos.func_177958_n() < minX) {
                minX = pos.func_177958_n();
            }
            if (pos.func_177956_o() < minY) {
                minY = pos.func_177956_o();
            }
            if (pos.func_177952_p() >= minZ) continue;
            minZ = pos.func_177952_p();
        }
        return new BlockPos(minX, minY, minZ);
    }

    private BlockPos getMaxPos(Collection<AbstractBlockInfo> collection) {
        if (collection.isEmpty()) {
            return BlockPos.field_177992_a;
        }
        int maxX = Integer.MIN_VALUE;
        int maxY = Integer.MIN_VALUE;
        int maxZ = Integer.MIN_VALUE;
        for (AbstractBlockInfo blockInfo : collection) {
            BlockPos pos = blockInfo.getPos();
            if (pos.func_177958_n() > maxX) {
                maxX = pos.func_177958_n();
            }
            if (pos.func_177956_o() > maxY) {
                maxY = pos.func_177956_o();
            }
            if (pos.func_177952_p() <= maxZ) continue;
            maxZ = pos.func_177952_p();
        }
        return new BlockPos(maxX, maxY, maxZ);
    }
}

