/*
 * Decompiled with CFR 0.152.
 */
package team.cqr.cqrepoured.structuregen.generation;

import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import team.cqr.cqrepoured.structuregen.generation.AbstractDungeonPart;
import team.cqr.cqrepoured.structuregen.generation.DungeonGenerator;

public class DungeonPartCover
extends AbstractDungeonPart {
    private IBlockState coverBlock;
    private int x1;
    private int z1;

    public DungeonPartCover(World world, DungeonGenerator dungeonGenerator) {
        this(world, dungeonGenerator, 0, 0, 0, 0, Blocks.field_150350_a.func_176223_P());
    }

    public DungeonPartCover(World world, DungeonGenerator dungeonGenerator, int startX, int startZ, int endX, int endZ, IBlockState coverBlock) {
        super(world, dungeonGenerator, new BlockPos(Math.min(startX, endX), dungeonGenerator.getPos().func_177956_o(), Math.min(startZ, endZ)));
        this.maxPos = new BlockPos(Math.max(startX, endX), dungeonGenerator.getPos().func_177956_o(), Math.max(startZ, endZ));
        this.x1 = this.minPos.func_177958_n();
        this.z1 = this.minPos.func_177952_p();
        this.coverBlock = coverBlock;
    }

    @Override
    public NBTTagCompound writeToNBT() {
        NBTTagCompound compound = super.writeToNBT();
        compound.func_74778_a("coverBlock", this.coverBlock.func_177230_c().getRegistryName().toString());
        compound.func_74768_a("coverBlockMeta", this.coverBlock.func_177230_c().func_176201_c(this.coverBlock));
        compound.func_74768_a("x1", this.x1);
        compound.func_74768_a("z1", this.z1);
        return compound;
    }

    @Override
    public void readFromNBT(NBTTagCompound compound) {
        super.readFromNBT(compound);
        Block b = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(compound.func_74779_i("coverBlock")));
        this.coverBlock = b != null ? b.func_176203_a(compound.func_74762_e("coverBlockMeta")) : Blocks.field_150350_a.func_176223_P();
        this.x1 = compound.func_74762_e("x1");
        this.z1 = compound.func_74762_e("z1");
    }

    @Override
    public String getId() {
        return "dungeon_part_cover";
    }

    @Override
    public void generateNext() {
        if (this.x1 <= this.maxPos.func_177958_n()) {
            BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos(this.x1, 255, this.z1);
            if (this.world.func_180495_p((BlockPos)mutablePos).func_177230_c() == Blocks.field_150350_a) {
                mutablePos.func_185336_p(mutablePos.func_177956_o() - 1);
                while (mutablePos.func_177956_o() > 0) {
                    IBlockState state = this.world.func_180495_p((BlockPos)mutablePos);
                    if (state.func_177230_c() == Blocks.field_150350_a) {
                        mutablePos.func_185336_p(mutablePos.func_177956_o() - 1);
                        continue;
                    }
                    if (state.func_177230_c() == this.coverBlock) break;
                    mutablePos.func_185336_p(mutablePos.func_177956_o() + 1);
                    this.world.func_180501_a((BlockPos)mutablePos, this.coverBlock, 18);
                    break;
                }
            }
            ++this.z1;
            if (this.z1 > this.maxPos.func_177952_p()) {
                this.z1 = this.minPos.func_177952_p();
                ++this.x1;
            }
        }
    }

    @Override
    public boolean isGenerated() {
        return this.x1 > this.maxPos.func_177958_n();
    }
}

