/*
 * Decompiled with CFR 0.152.
 */
package team.cqr.cqrepoured.structuregen.generation;

import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.LinkedList;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraft.world.gen.structure.template.PlacementSettings;
import net.minecraft.world.gen.structure.template.Template;
import team.cqr.cqrepoured.structuregen.generation.AbstractDungeonPart;
import team.cqr.cqrepoured.structuregen.generation.DungeonGenerator;
import team.cqr.cqrepoured.structuregen.inhabitants.DungeonInhabitant;
import team.cqr.cqrepoured.structuregen.inhabitants.DungeonInhabitantManager;
import team.cqr.cqrepoured.structuregen.structurefile.EntityInfo;

public class DungeonPartEntity
extends AbstractDungeonPart {
    protected final Deque<EntityInfo> entityInfoList = new LinkedList<EntityInfo>();
    protected PlacementSettings settings;
    protected DungeonInhabitant dungeonMobType;

    public DungeonPartEntity(World world, DungeonGenerator dungeonGenerator) {
        this(world, dungeonGenerator, BlockPos.field_177992_a, Collections.emptyList(), new PlacementSettings(), DungeonInhabitantManager.DEFAULT_DUNGEON_INHABITANT);
    }

    public DungeonPartEntity(World world, DungeonGenerator dungeonGenerator, BlockPos partPos, Collection<EntityInfo> entities, PlacementSettings settings, DungeonInhabitant dungeonMobType) {
        super(world, dungeonGenerator, partPos);
        for (EntityInfo entityInfo : entities) {
            if (entityInfo == null) continue;
            this.updateMinAndMaxPos(partPos.func_177971_a((Vec3i)entityInfo.getPos()));
            this.entityInfoList.add(entityInfo);
        }
        this.settings = settings;
        this.dungeonMobType = dungeonMobType;
        if (!this.entityInfoList.isEmpty()) {
            EntityInfo firstEntityInfo = this.entityInfoList.getFirst();
            this.maxPos = this.minPos = partPos.func_177971_a((Vec3i)Template.func_186266_a((PlacementSettings)settings, (BlockPos)firstEntityInfo.getPos()));
            BlockPos.MutableBlockPos p1 = new BlockPos.MutableBlockPos(this.minPos);
            BlockPos.MutableBlockPos p2 = new BlockPos.MutableBlockPos(this.minPos);
            BlockPos.MutableBlockPos p3 = new BlockPos.MutableBlockPos(this.minPos);
            for (EntityInfo entityInfo : this.entityInfoList) {
                this.transformedXYZasMutablePos(partPos, entityInfo.getX(), entityInfo.getY(), entityInfo.getZ(), settings.func_186212_b(), settings.func_186215_c(), p1);
                p2.func_181079_c(Math.min(p2.func_177958_n(), p1.func_177958_n()), Math.min(p2.func_177956_o(), p1.func_177956_o()), Math.min(p2.func_177952_p(), p1.func_177952_p()));
                p3.func_181079_c(Math.max(p3.func_177958_n(), p1.func_177958_n()), Math.max(p3.func_177956_o(), p1.func_177956_o()), Math.max(p3.func_177952_p(), p1.func_177952_p()));
            }
            this.updateMinAndMaxPos((BlockPos)p2);
            this.updateMinAndMaxPos((BlockPos)p3);
        }
    }

    @Override
    public NBTTagCompound writeToNBT() {
        NBTTagCompound compound = super.writeToNBT();
        compound.func_74768_a("mirror", this.settings.func_186212_b().ordinal());
        compound.func_74768_a("rotation", this.settings.func_186215_c().ordinal());
        compound.func_74778_a("mob", this.dungeonMobType.getName());
        NBTTagList nbtTagList = new NBTTagList();
        for (EntityInfo entityInfo : this.entityInfoList) {
            nbtTagList.func_74742_a((NBTBase)entityInfo.getEntityData());
        }
        compound.func_74782_a("entityInfoList", (NBTBase)nbtTagList);
        return compound;
    }

    @Override
    public void readFromNBT(NBTTagCompound compound) {
        super.readFromNBT(compound);
        this.entityInfoList.clear();
        this.settings = new PlacementSettings();
        this.settings.func_186214_a(Mirror.values()[compound.func_74762_e("mirror")]);
        this.settings.func_186220_a(Rotation.values()[compound.func_74762_e("rotation")]);
        this.dungeonMobType = DungeonInhabitantManager.instance().getInhabitant(compound.func_74779_i("mob"));
        for (NBTBase nbt : compound.func_150295_c("entityInfoList", 10)) {
            this.entityInfoList.add(new EntityInfo((NBTTagCompound)nbt));
        }
    }

    @Override
    public String getId() {
        return "dungeon_part_entity";
    }

    @Override
    public void generateNext() {
        if (!this.entityInfoList.isEmpty()) {
            EntityInfo entityInfo = this.entityInfoList.removeFirst();
            entityInfo.generate(this.world, this.dungeonGenerator.getPos(), this.partPos, this.settings, this.dungeonMobType, this.dungeonGenerator.getProtectedRegion());
        }
    }

    @Override
    public boolean isGenerated() {
        return this.entityInfoList.isEmpty();
    }
}

