/*
 * Decompiled with CFR 0.152.
 */
package team.cqr.cqrepoured.structuregen.generation;

import java.util.EnumSet;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.WorldType;
import net.minecraftforge.event.ForgeEventFactory;
import team.cqr.cqrepoured.structuregen.generation.AbstractDungeonPart;
import team.cqr.cqrepoured.structuregen.generation.DungeonGenerator;
import team.cqr.cqrepoured.util.CQRConfig;
import team.cqr.cqrepoured.util.DungeonGenUtils;

public class DungeonPartLight
extends AbstractDungeonPart {
    private int chunkX;
    private int chunkZ;
    private BlockPos.MutableBlockPos mutablePos1;
    private BlockPos.MutableBlockPos mutablePos2;
    private BlockPos.MutableBlockPos mutablePos3;

    public DungeonPartLight(World world, DungeonGenerator dungeonGenerator) {
        this(world, dungeonGenerator, BlockPos.field_177992_a, BlockPos.field_177992_a);
    }

    public DungeonPartLight(World world, DungeonGenerator dungeonGenerator, BlockPos minPos, BlockPos maxPos) {
        super(world, dungeonGenerator, DungeonGenUtils.getValidMinPos(minPos, maxPos));
        this.maxPos = DungeonGenUtils.getValidMaxPos(minPos, maxPos);
        if (!CQRConfig.advanced.instantLightUpdates) {
            this.chunkX = this.minPos.func_177958_n() >> 4;
            this.chunkZ = this.minPos.func_177952_p() >> 4;
            this.mutablePos1 = new BlockPos.MutableBlockPos(this.minPos);
            this.mutablePos2 = new BlockPos.MutableBlockPos(this.minPos);
            this.mutablePos3 = new BlockPos.MutableBlockPos(this.minPos);
        } else {
            this.chunkX = Integer.MAX_VALUE;
            this.chunkZ = Integer.MAX_VALUE;
            this.mutablePos1 = new BlockPos.MutableBlockPos(Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE);
            this.mutablePos2 = new BlockPos.MutableBlockPos(Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE);
            this.mutablePos3 = new BlockPos.MutableBlockPos(this.minPos);
        }
    }

    @Override
    public NBTTagCompound writeToNBT() {
        NBTTagCompound compound = super.writeToNBT();
        compound.func_74768_a("chunkX", this.chunkX);
        compound.func_74768_a("chunkZ", this.chunkZ);
        compound.func_74782_a("pos1", (NBTBase)DungeonGenUtils.writePosToList((BlockPos)this.mutablePos1));
        compound.func_74782_a("pos2", (NBTBase)DungeonGenUtils.writePosToList((BlockPos)this.mutablePos2));
        compound.func_74782_a("pos3", (NBTBase)DungeonGenUtils.writePosToList((BlockPos)this.mutablePos3));
        return compound;
    }

    @Override
    public void readFromNBT(NBTTagCompound compound) {
        super.readFromNBT(compound);
        this.chunkX = compound.func_74762_e("chunkX");
        this.chunkZ = compound.func_74762_e("chunkZ");
        this.mutablePos1 = new BlockPos.MutableBlockPos(DungeonGenUtils.readPosFromList(compound.func_150295_c("pos1", 3)));
        this.mutablePos2 = new BlockPos.MutableBlockPos(DungeonGenUtils.readPosFromList(compound.func_150295_c("pos2", 3)));
        this.mutablePos3 = new BlockPos.MutableBlockPos(DungeonGenUtils.readPosFromList(compound.func_150295_c("pos3", 3)));
    }

    @Override
    public String getId() {
        return "dungeon_part_light";
    }

    @Override
    public void generateNext() {
        if (this.chunkX <= this.maxPos.func_177958_n() >> 4) {
            this.world.func_72964_e(this.chunkX, this.chunkZ).func_76603_b();
            ++this.chunkZ;
            if (this.chunkZ > this.maxPos.func_177952_p() >> 4) {
                this.chunkZ = this.minPos.func_177952_p() >> 4;
                ++this.chunkX;
            }
        } else if (this.mutablePos1.func_177958_n() <= this.maxPos.func_177958_n()) {
            this.world.func_175664_x((BlockPos)this.mutablePos1);
            if (this.mutablePos1.func_177952_p() < this.maxPos.func_177952_p()) {
                this.mutablePos1.func_181079_c(this.mutablePos1.func_177958_n(), this.mutablePos1.func_177956_o(), this.mutablePos1.func_177952_p() + 1);
            } else if (this.mutablePos1.func_177956_o() < this.maxPos.func_177956_o()) {
                this.mutablePos1.func_181079_c(this.mutablePos1.func_177958_n(), this.mutablePos1.func_177956_o() + 1, this.minPos.func_177952_p());
            } else {
                this.mutablePos1.func_181079_c(this.mutablePos1.func_177958_n() + 1, this.minPos.func_177956_o(), this.minPos.func_177952_p());
            }
        } else if (this.mutablePos2.func_177958_n() <= this.maxPos.func_177958_n()) {
            ((WorldServer)this.world).func_184164_w().func_180244_a((BlockPos)this.mutablePos2);
            if (this.mutablePos2.func_177952_p() < this.maxPos.func_177952_p()) {
                this.mutablePos2.func_181079_c(this.mutablePos2.func_177958_n(), this.mutablePos2.func_177956_o(), this.mutablePos2.func_177952_p() + 1);
            } else if (this.mutablePos2.func_177956_o() < this.maxPos.func_177956_o()) {
                this.mutablePos2.func_181079_c(this.mutablePos2.func_177958_n(), this.mutablePos2.func_177956_o() + 1, this.minPos.func_177952_p());
            } else {
                this.mutablePos2.func_181079_c(this.mutablePos2.func_177958_n() + 1, this.minPos.func_177956_o(), this.minPos.func_177952_p());
            }
        } else if (this.mutablePos3.func_177958_n() <= this.maxPos.func_177958_n()) {
            this.notifyNeighborsRespectDebug(this.world, (BlockPos)this.mutablePos3);
            if (this.mutablePos3.func_177952_p() < this.maxPos.func_177952_p()) {
                this.mutablePos3.func_181079_c(this.mutablePos3.func_177958_n(), this.mutablePos3.func_177956_o(), this.mutablePos3.func_177952_p() + 1);
            } else if (this.mutablePos3.func_177956_o() < this.maxPos.func_177956_o()) {
                this.mutablePos3.func_181079_c(this.mutablePos3.func_177958_n(), this.mutablePos3.func_177956_o() + 1, this.minPos.func_177952_p());
            } else {
                this.mutablePos3.func_181079_c(this.mutablePos3.func_177958_n() + 1, this.minPos.func_177956_o(), this.minPos.func_177952_p());
            }
        }
    }

    @Override
    public boolean isGenerated() {
        return this.mutablePos3.func_177958_n() > this.maxPos.func_177958_n();
    }

    private void notifyNeighborsRespectDebug(World world, BlockPos pos) {
        if (world.func_72912_H().func_76067_t() == WorldType.field_180272_g) {
            return;
        }
        IBlockState state = world.func_180495_p(pos);
        if (ForgeEventFactory.onNeighborNotify((World)world, (BlockPos)pos, (IBlockState)state, EnumSet.allOf(EnumFacing.class), (boolean)false).isCanceled()) {
            return;
        }
        Block block = state.func_177230_c();
        BlockPos.MutableBlockPos p = new BlockPos.MutableBlockPos();
        world.func_190524_a((BlockPos)p.func_181079_c(pos.func_177958_n() + 1, pos.func_177956_o(), pos.func_177952_p()), block, pos);
        world.func_190524_a((BlockPos)p.func_181079_c(pos.func_177958_n() - 1, pos.func_177956_o(), pos.func_177952_p()), block, pos);
        world.func_190524_a((BlockPos)p.func_181079_c(pos.func_177958_n(), pos.func_177956_o() + 1, pos.func_177952_p()), block, pos);
        world.func_190524_a((BlockPos)p.func_181079_c(pos.func_177958_n(), pos.func_177956_o() - 1, pos.func_177952_p()), block, pos);
        world.func_190524_a((BlockPos)p.func_181079_c(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p() + 1), block, pos);
        world.func_190524_a((BlockPos)p.func_181079_c(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p() - 1), block, pos);
    }
}

