/*
 * Decompiled with CFR 0.152.
 */
package team.cqr.cqrepoured.structuregen.generation;

import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import team.cqr.cqrepoured.structuregen.generation.AbstractDungeonPart;
import team.cqr.cqrepoured.structuregen.generation.DungeonGenerator;
import team.cqr.cqrepoured.util.DungeonGenUtils;
import team.cqr.cqrepoured.util.Perlin3D;

public class DungeonPartPlateau
extends AbstractDungeonPart {
    private IBlockState supportHillBlock;
    private IBlockState supportHillTopBlock;
    private int wallSize;
    private BlockPos.MutableBlockPos pos1 = new BlockPos.MutableBlockPos();
    private BlockPos.MutableBlockPos pos2 = new BlockPos.MutableBlockPos();
    private Perlin3D perlin1;
    private Perlin3D perlin2;

    public DungeonPartPlateau(World world, DungeonGenerator dungeonGenerator) {
        this(world, dungeonGenerator, 0, 0, 0, 0, 0, null, null, 0);
    }

    public DungeonPartPlateau(World world, DungeonGenerator dungeonGenerator, int startX, int startZ, int endX, int endY, int endZ, IBlockState supportHillBlock, IBlockState supportHillTopBlock, int wallSize) {
        super(world, dungeonGenerator, new BlockPos(Math.min(startX, endX) - wallSize, endY, Math.min(startZ, endZ) - wallSize));
        this.maxPos = new BlockPos(Math.max(startX, endX) + wallSize, endY, Math.max(startZ, endZ) + wallSize);
        this.supportHillBlock = supportHillBlock;
        this.supportHillTopBlock = supportHillTopBlock;
        this.wallSize = wallSize;
        this.pos1.func_181079_c(this.minPos.func_177958_n(), 0, this.minPos.func_177952_p());
        this.pos2.func_181079_c(this.minPos.func_177958_n(), 0, this.minPos.func_177952_p());
        this.perlin1 = new Perlin3D(this.world.func_72905_C(), this.wallSize);
        this.perlin2 = new Perlin3D(this.world.func_72905_C(), this.wallSize * 4);
    }

    @Override
    public NBTTagCompound writeToNBT() {
        NBTTagCompound compound = super.writeToNBT();
        if (this.supportHillBlock != null) {
            compound.func_74778_a("supportHillBlock", this.supportHillBlock.func_177230_c().getRegistryName().toString());
            compound.func_74768_a("supportHillBlockMeta", this.supportHillBlock.func_177230_c().func_176201_c(this.supportHillBlock));
        }
        if (this.supportHillTopBlock != null) {
            compound.func_74778_a("supportHillTopBlock", this.supportHillTopBlock.func_177230_c().getRegistryName().toString());
            compound.func_74768_a("supportHillTopBlockMeta", this.supportHillTopBlock.func_177230_c().func_176201_c(this.supportHillTopBlock));
        }
        compound.func_74768_a("wallSize", this.wallSize);
        compound.func_74768_a("x1", this.pos1.func_177958_n());
        compound.func_74768_a("z1", this.pos1.func_177952_p());
        compound.func_74768_a("x2", this.pos2.func_177958_n());
        compound.func_74768_a("z2", this.pos2.func_177952_p());
        return compound;
    }

    @Override
    public void readFromNBT(NBTTagCompound compound) {
        Block b2;
        Block b1;
        super.readFromNBT(compound);
        this.supportHillBlock = null;
        if (compound.func_150297_b("supportHillBlock", 8) && (b1 = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(compound.func_74779_i("supportHillBlock")))) != null) {
            this.supportHillBlock = b1.func_176203_a(compound.func_74762_e("supportHillBlockMeta"));
        }
        this.supportHillTopBlock = null;
        if (compound.func_150297_b("supportHillTopBlock", 8) && (b2 = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(compound.func_74779_i("supportHillTopBlock")))) != null) {
            this.supportHillTopBlock = b2.func_176203_a(compound.func_74762_e("supportHillTopBlockMeta"));
        }
        this.wallSize = compound.func_74762_e("wallSize");
        this.pos1.func_181079_c(compound.func_74762_e("x1"), 0, compound.func_74762_e("z1"));
        this.pos2.func_181079_c(compound.func_74762_e("x2"), 0, compound.func_74762_e("z2"));
        this.perlin1 = new Perlin3D(this.world.func_72905_C(), this.wallSize);
        this.perlin2 = new Perlin3D(this.world.func_72905_C(), this.wallSize * 4);
    }

    @Override
    public String getId() {
        return "dungeon_part_plateau";
    }

    @Override
    public void generateNext() {
        if (this.pos1.func_177958_n() <= this.maxPos.func_177958_n()) {
            int y1;
            Biome biome = this.world.func_180494_b((BlockPos)this.pos1);
            IBlockState state1 = this.supportHillBlock != null ? this.supportHillBlock : biome.field_76753_B;
            IBlockState state2 = this.supportHillTopBlock != null ? this.supportHillTopBlock : biome.field_76752_A;
            int posY = this.world.func_175672_r(new BlockPos(this.pos1.func_177958_n(), 0, this.pos1.func_177952_p())).func_177956_o();
            int i = Math.max(this.maxPos.func_177956_o() - 1 - posY, 1);
            for (y1 = posY; y1 < this.maxPos.func_177956_o(); ++y1) {
                double value;
                if (this.pos1.func_177958_n() >= this.minPos.func_177958_n() + this.wallSize && this.pos1.func_177958_n() <= this.maxPos.func_177958_n() - this.wallSize && this.pos1.func_177952_p() >= this.minPos.func_177952_p() + this.wallSize && this.pos1.func_177952_p() <= this.maxPos.func_177952_p() - this.wallSize) {
                    this.pos1.func_185336_p(y1);
                    this.world.func_180501_a((BlockPos)this.pos1, state1, 18);
                    continue;
                }
                float noiseVar = (float)(y1 - (this.maxPos.func_177956_o() - 1)) / ((float)i * 1.5f);
                noiseVar += Math.max((float)(this.wallSize - (this.pos1.func_177958_n() - this.minPos.func_177958_n())) / 8.0f, 0.0f);
                noiseVar += Math.max((float)(this.wallSize - (this.maxPos.func_177958_n() + 1 - this.pos1.func_177958_n())) / 8.0f, 0.0f);
                noiseVar += Math.max((float)(this.wallSize - (this.pos1.func_177952_p() - this.minPos.func_177952_p())) / 8.0f, 0.0f);
                if ((double)(noiseVar += Math.max((float)(this.wallSize - (this.maxPos.func_177952_p() + 1 - this.pos1.func_177952_p())) / 8.0f, 0.0f)) / 3.0 + (double)((y1 - posY) / i) * 0.25 >= 0.5 || !((value = (double)(this.perlin1.getNoiseAt(this.pos1.func_177958_n(), y1, this.pos1.func_177952_p()) + this.perlin2.getNoiseAt(this.pos1.func_177958_n(), y1, this.pos1.func_177952_p()) + noiseVar) / 3.0 + (double)((y1 - posY) / i) * 0.25) < 0.5)) break;
                this.world.func_180501_a(new BlockPos(this.pos1.func_177958_n(), y1, this.pos1.func_177952_p()), state1, 18);
            }
            if (y1 <= this.maxPos.func_177956_o()) {
                this.world.func_180501_a(new BlockPos(this.pos1.func_177958_n(), y1, this.pos1.func_177952_p()), state2, 18);
            }
            this.pos1.func_181079_c(this.pos1.func_177958_n(), this.pos1.func_177956_o(), this.pos1.func_177952_p() + 1);
            if (this.pos1.func_177952_p() > this.maxPos.func_177952_p()) {
                this.pos1.func_181079_c(this.pos1.func_177958_n() + 1, this.pos1.func_177956_o(), this.minPos.func_177952_p());
            }
        } else if (this.pos2.func_177958_n() <= this.maxPos.func_177958_n()) {
            this.pos2.func_185336_p(255);
            if (this.world.func_180495_p((BlockPos)this.pos2).func_177230_c() == Blocks.field_150350_a) {
                this.pos2.func_185336_p(this.pos2.func_177956_o() - 1);
                while (this.pos2.func_177956_o() > 0) {
                    IBlockState state = this.world.func_180495_p((BlockPos)this.pos2);
                    if (state.func_177230_c() == Blocks.field_150350_a) {
                        this.pos2.func_185336_p(this.pos2.func_177956_o() - 1);
                        continue;
                    }
                    if (this.pos2.func_177956_o() != this.maxPos.func_177956_o()) break;
                    Biome biome = this.world.func_180494_b((BlockPos)this.pos2);
                    if (!DungeonGenUtils.percentageRandom((double)biome.field_76760_I.field_76803_B / 512.0)) break;
                    biome.func_76730_b(this.world.field_73012_v).func_180709_b(this.world, this.world.field_73012_v, (BlockPos)this.pos2);
                    break;
                }
            }
            this.pos2.func_181079_c(this.pos2.func_177958_n(), this.pos2.func_177956_o(), this.pos2.func_177952_p() + 1);
            if (this.pos2.func_177952_p() > this.maxPos.func_177952_p()) {
                this.pos2.func_181079_c(this.pos2.func_177958_n() + 1, this.pos2.func_177956_o(), this.minPos.func_177952_p());
            }
        }
    }

    @Override
    public boolean isGenerated() {
        return this.pos2.func_177958_n() > this.maxPos.func_177958_n();
    }
}

