/*
 * Decompiled with CFR 0.152.
 */
package team.cqr.cqrepoured.structuregen.generators;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraft.world.gen.structure.template.PlacementSettings;
import team.cqr.cqrepoured.structuregen.DungeonDataManager;
import team.cqr.cqrepoured.structuregen.PlateauBuilder;
import team.cqr.cqrepoured.structuregen.WorldDungeonGenerator;
import team.cqr.cqrepoured.structuregen.dungeons.DungeonGridCity;
import team.cqr.cqrepoured.structuregen.generation.DungeonPartBlock;
import team.cqr.cqrepoured.structuregen.generators.AbstractDungeonGenerator;
import team.cqr.cqrepoured.structuregen.inhabitants.DungeonInhabitant;
import team.cqr.cqrepoured.structuregen.inhabitants.DungeonInhabitantManager;
import team.cqr.cqrepoured.structuregen.structurefile.AbstractBlockInfo;
import team.cqr.cqrepoured.structuregen.structurefile.BlockInfo;
import team.cqr.cqrepoured.structuregen.structurefile.CQStructure;
import team.cqr.cqrepoured.util.DungeonGenUtils;

public class GeneratorGridCity
extends AbstractDungeonGenerator<DungeonGridCity> {
    private int longestSide;
    private int distanceBetweenBuildings;
    private BlockPos[][] gridPositions;
    private Set<BlockPos> bridgeBuilderStartPositionsX = new HashSet<BlockPos>();
    private Set<BlockPos> bridgeBuilderStartPositionsZ = new HashSet<BlockPos>();
    private Set<BlockPos> bridgeBlocks = new HashSet<BlockPos>();
    private Set<BlockPos> lavaBlocks = new HashSet<BlockPos>();
    private Map<BlockPos, IBlockState> blockMap = new HashMap<BlockPos, IBlockState>();
    private int minX;
    private int maxX;
    private int minZ;
    private int maxZ;
    private CQStructure[][] structures;

    public GeneratorGridCity(World world, BlockPos pos, DungeonGridCity dungeon, Random rand, DungeonDataManager.DungeonSpawnType spawnType) {
        super(world, pos, dungeon, rand, spawnType);
    }

    @Override
    public void preProcess() {
        int iZ;
        int iX;
        int rowsX = ((DungeonGridCity)this.dungeon).getXRows(this.random) >> 1;
        int rowsZ = ((DungeonGridCity)this.dungeon).getZRows(this.random) >> 1;
        this.structures = new CQStructure[(rowsX << 1) + 1][(rowsZ << 1) + 1];
        this.gridPositions = new BlockPos[(rowsX << 1) + 1][(rowsZ << 1) + 1];
        for (iX = -rowsX; iX <= rowsX; ++iX) {
            for (iZ = -rowsZ; iZ <= rowsZ; ++iZ) {
                int k;
                CQStructure structure;
                File file = ((DungeonGridCity)this.dungeon).centralBuildingIsSpecial() && iX == 0 && iZ == 0 ? ((DungeonGridCity)this.dungeon).getRandomCentralBuilding(this.random) : ((DungeonGridCity)this.dungeon).getRandomBuilding(this.random);
                this.structures[iX + rowsX][iZ + rowsZ] = structure = this.loadStructureFromFile(file);
                if (structure == null || (k = Math.max(structure.getSize().func_177958_n(), structure.getSize().func_177952_p())) <= this.longestSide) continue;
                this.longestSide = k;
            }
        }
        this.distanceBetweenBuildings = (int)((double)this.longestSide * ((DungeonGridCity)this.dungeon).getBridgeSizeMultiplier());
        this.minX = this.pos.func_177958_n() - rowsX * this.distanceBetweenBuildings;
        this.minZ = this.pos.func_177952_p() - rowsZ * this.distanceBetweenBuildings;
        this.maxX = this.pos.func_177958_n() + rowsX * this.distanceBetweenBuildings;
        this.maxZ = this.pos.func_177952_p() + rowsZ * this.distanceBetweenBuildings;
        for (iX = -rowsX; iX <= rowsX; ++iX) {
            for (iZ = -rowsZ; iZ <= rowsZ; ++iZ) {
                BlockPos p;
                this.gridPositions[iX + rowsX][iZ + rowsZ] = p = this.pos.func_177982_a(iX * this.distanceBetweenBuildings, 0, iZ * this.distanceBetweenBuildings);
                if (iX == 0) {
                    this.bridgeBuilderStartPositionsZ.add(p);
                }
                if (iZ != 0) continue;
                this.bridgeBuilderStartPositionsX.add(p);
            }
        }
    }

    @Override
    public void buildStructure() {
        BlockPos pC;
        if (((DungeonGridCity)this.dungeon).makeSpaceForBuildings()) {
            BlockPos cLower = new BlockPos(this.minX, this.pos.func_177956_o() + 1, this.minZ).func_177982_a(-this.distanceBetweenBuildings, 0, -this.distanceBetweenBuildings);
            BlockPos cUpper = new BlockPos(this.maxX, this.pos.func_177956_o() + ((DungeonGridCity)this.dungeon).getCaveHeight(), this.maxZ).func_177963_a((double)this.distanceBetweenBuildings * 0.1, 0.0, (double)this.distanceBetweenBuildings * 0.05);
            this.dungeonGenerator.add(PlateauBuilder.makeRandomBlob(Blocks.field_150350_a, cLower, cUpper, 4, WorldDungeonGenerator.getSeed(this.world, this.minX, this.maxZ), this.world, this.dungeonGenerator));
        }
        for (BlockPos lavaPos : BlockPos.func_191532_a((int)(this.minX - this.distanceBetweenBuildings), (int)this.pos.func_177956_o(), (int)(this.minZ - this.distanceBetweenBuildings), (int)(this.maxX + this.distanceBetweenBuildings), (int)this.pos.func_177956_o(), (int)(this.maxZ + this.distanceBetweenBuildings))) {
            this.lavaBlocks.add(lavaPos);
        }
        for (BlockPos pX : this.bridgeBuilderStartPositionsX) {
            for (int iZ = this.minZ; iZ <= this.maxZ; ++iZ) {
                pC = new BlockPos(pX.func_177958_n(), pX.func_177956_o(), iZ);
                BlockPos pCE = pC.func_177974_f();
                BlockPos pCW = pC.func_177976_e();
                this.bridgeBlocks.add(pC);
                this.bridgeBlocks.add(pCE);
                this.bridgeBlocks.add(pCW);
            }
        }
        for (BlockPos pZ : this.bridgeBuilderStartPositionsZ) {
            for (int iX = this.minX; iX <= this.maxX; ++iX) {
                pC = new BlockPos(iX, pZ.func_177956_o(), pZ.func_177952_p());
                BlockPos pCN = pC.func_177978_c();
                BlockPos pCS = pC.func_177968_d();
                this.bridgeBlocks.add(pC);
                this.bridgeBlocks.add(pCN);
                this.bridgeBlocks.add(pCS);
            }
        }
        for (BlockPos p : this.lavaBlocks) {
            this.blockMap.put(p, ((DungeonGridCity)this.dungeon).getFloorBlock());
        }
        for (BlockPos p : this.bridgeBlocks) {
            this.blockMap.put(p, ((DungeonGridCity)this.dungeon).getBridgeBlock());
        }
    }

    @Override
    public void postProcess() {
        DungeonInhabitant mobType = DungeonInhabitantManager.instance().getInhabitantByDistanceIfDefault(((DungeonGridCity)this.dungeon).getDungeonMob(), this.world, this.pos.func_177958_n(), this.pos.func_177952_p());
        HashMap<BlockPos, CQStructure> structureMap = new HashMap<BlockPos, CQStructure>();
        for (int iX = 0; iX < this.gridPositions.length && iX < this.structures.length; ++iX) {
            for (int iZ = 0; iZ < this.gridPositions[iX].length && iZ < this.structures[iX].length; ++iZ) {
                BlockPos blockPos = this.gridPositions[iX][iZ];
                CQStructure structure = this.structures[iX][iZ];
                if (blockPos == null || structure == null) continue;
                BlockPos cL = blockPos.func_177973_b(new Vec3i(structure.getSize().func_177958_n() / 2 + 2, 0, structure.getSize().func_177952_p() / 2 + 2));
                BlockPos cU = blockPos.func_177982_a(structure.getSize().func_177958_n() / 2 + 2, 0, structure.getSize().func_177952_p() / 2 + 2);
                BlockPos.func_177980_a((BlockPos)cL, (BlockPos)cU).forEach(p -> this.blockMap.put((BlockPos)p, ((DungeonGridCity)this.dungeon).getBridgeBlock()));
                structureMap.put(blockPos.func_177984_a(), structure);
            }
        }
        ArrayList<AbstractBlockInfo> blockInfoList = new ArrayList<AbstractBlockInfo>(this.blockMap.size());
        for (Map.Entry<BlockPos, IBlockState> entry : this.blockMap.entrySet()) {
            blockInfoList.add(new BlockInfo(entry.getKey().func_177973_b((Vec3i)this.pos), entry.getValue(), null));
        }
        this.dungeonGenerator.add(new DungeonPartBlock(this.world, this.dungeonGenerator, this.pos, blockInfoList, new PlacementSettings(), mobType));
        for (Map.Entry<Object, Object> entry : structureMap.entrySet()) {
            PlacementSettings settings = new PlacementSettings();
            BlockPos p2 = DungeonGenUtils.getCentralizedPosForStructure((BlockPos)entry.getKey(), (CQStructure)entry.getValue(), settings);
            ((CQStructure)entry.getValue()).addAll(this.world, this.dungeonGenerator, p2, settings, mobType);
        }
    }
}

