/*
 * Decompiled with CFR 0.152.
 */
package team.cqr.cqrepoured.structuregen.generators;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraft.world.gen.structure.template.PlacementSettings;
import net.minecraft.world.gen.structure.template.Template;
import team.cqr.cqrepoured.structuregen.DungeonDataManager;
import team.cqr.cqrepoured.structuregen.dungeons.DungeonGuardedCastle;
import team.cqr.cqrepoured.structuregen.generation.DungeonPartCover;
import team.cqr.cqrepoured.structuregen.generation.DungeonPartPlateau;
import team.cqr.cqrepoured.structuregen.generators.AbstractDungeonGenerator;
import team.cqr.cqrepoured.structuregen.inhabitants.DungeonInhabitant;
import team.cqr.cqrepoured.structuregen.inhabitants.DungeonInhabitantManager;
import team.cqr.cqrepoured.structuregen.structurefile.CQStructure;
import team.cqr.cqrepoured.util.CQRConfig;
import team.cqr.cqrepoured.util.DungeonGenUtils;
import team.cqr.cqrepoured.util.VectorUtil;

public class GeneratorGuardedStructure
extends AbstractDungeonGenerator<DungeonGuardedCastle> {
    private Map<BlockPos, CQStructure> toGenerate = new HashMap<BlockPos, CQStructure>();
    private Map<BlockPos, PlacementSettings> settingsMap = new HashMap<BlockPos, PlacementSettings>();

    public GeneratorGuardedStructure(World world, BlockPos pos, DungeonGuardedCastle dungeon, Random rand, DungeonDataManager.DungeonSpawnType spawnType) {
        super(world, pos, dungeon, rand, spawnType);
    }

    private void processStructure(CQStructure structure, BlockPos position) {
        PlacementSettings settings = new PlacementSettings();
        if (((DungeonGuardedCastle)this.dungeon).rotateDungeon()) {
            settings.func_186220_a(Rotation.values()[this.random.nextInt(Rotation.values().length)]);
            settings.func_186214_a(Mirror.values()[this.random.nextInt(Mirror.values().length)]);
        }
        BlockPos structurePos = DungeonGenUtils.getCentralizedPosForStructure(position, structure, settings);
        if (((DungeonGuardedCastle)this.dungeon).doBuildSupportPlatform()) {
            BlockPos startPos = structurePos.func_177981_b(((DungeonGuardedCastle)this.dungeon).getUnderGroundOffset()).func_177977_b();
            BlockPos endPos = startPos.func_177971_a((Vec3i)Template.func_186266_a((PlacementSettings)settings, (BlockPos)new BlockPos(structure.getSize().func_177958_n() - 1, 0, structure.getSize().func_177952_p() - 1)));
            BlockPos pos1 = DungeonGenUtils.getValidMinPos(startPos, endPos);
            BlockPos pos2 = DungeonGenUtils.getValidMaxPos(startPos, endPos);
            this.dungeonGenerator.add(new DungeonPartPlateau(this.world, this.dungeonGenerator, pos1.func_177958_n(), pos1.func_177952_p(), pos2.func_177958_n(), pos2.func_177956_o(), pos2.func_177952_p(), ((DungeonGuardedCastle)this.dungeon).getSupportBlock(), ((DungeonGuardedCastle)this.dungeon).getSupportTopBlock(), CQRConfig.general.supportHillWallSize));
        }
        this.settingsMap.put(structurePos, settings);
        this.toGenerate.put(structurePos, structure);
    }

    @Override
    public void preProcess() {
        int buildings = DungeonGenUtils.randomBetween(((DungeonGuardedCastle)this.dungeon).getMinBuildings(), ((DungeonGuardedCastle)this.dungeon).getMaxBuilding(), this.random);
        Double degrees = 360.0 / (double)buildings;
        File structure = ((DungeonGuardedCastle)this.dungeon).getStructureFileFromDirectory(((DungeonGuardedCastle)this.dungeon).getCenterStructureFolder(), this.random);
        BlockPos position = this.pos;
        for (int i = 0; i < buildings; ++i) {
            this.processStructure(this.loadStructureFromFile(structure), position);
            structure = ((DungeonGuardedCastle)this.dungeon).getStructureFileFromDirectory(((DungeonGuardedCastle)this.dungeon).getStructureFolder(), this.random);
            Vec3i v = new Vec3i(DungeonGenUtils.randomBetween(((DungeonGuardedCastle)this.dungeon).getMinDistance(), ((DungeonGuardedCastle)this.dungeon).getMaxDistance(), this.random), 0, 0);
            v = VectorUtil.rotateVectorAroundY(v, degrees * (double)i);
            position = this.pos.func_177971_a(v);
            position = new BlockPos(position.func_177958_n(), ((DungeonGuardedCastle)this.dungeon).getYForPos(this.getWorld(), position.func_177958_n(), position.func_177952_p(), this.random), position.func_177952_p());
        }
        this.processStructure(this.loadStructureFromFile(structure), position);
    }

    @Override
    public void buildStructure() {
        DungeonInhabitant mobType = DungeonInhabitantManager.instance().getInhabitantByDistanceIfDefault(((DungeonGuardedCastle)this.dungeon).getDungeonMob(), this.world, this.pos.func_177958_n(), this.pos.func_177952_p());
        for (Map.Entry<BlockPos, CQStructure> entry : this.toGenerate.entrySet()) {
            PlacementSettings settings = this.settingsMap.get(entry.getKey());
            CQStructure structure = entry.getValue();
            BlockPos structurePos = entry.getKey();
            structure.addAll(this.world, this.dungeonGenerator, structurePos, settings, mobType);
        }
    }

    @Override
    public void postProcess() {
        if (((DungeonGuardedCastle)this.dungeon).isCoverBlockEnabled()) {
            for (Map.Entry<BlockPos, CQStructure> entry : this.toGenerate.entrySet()) {
                BlockPos structurePos;
                PlacementSettings settings = this.settingsMap.get(entry.getKey());
                CQStructure structure = entry.getValue();
                BlockPos startPos = structurePos = entry.getKey();
                BlockPos endPos = startPos.func_177971_a((Vec3i)Template.func_186266_a((PlacementSettings)settings, (BlockPos)new BlockPos(structure.getSize().func_177958_n() - 1, 0, structure.getSize().func_177952_p() - 1)));
                BlockPos pos1 = DungeonGenUtils.getValidMinPos(startPos, endPos);
                BlockPos pos2 = DungeonGenUtils.getValidMaxPos(startPos, endPos);
                this.dungeonGenerator.add(new DungeonPartCover(this.world, this.dungeonGenerator, pos1.func_177958_n(), pos1.func_177952_p(), pos2.func_177958_n(), pos2.func_177952_p(), ((DungeonGuardedCastle)this.dungeon).getCoverBlock()));
            }
        }
    }
}

