/*
 * Decompiled with CFR 0.152.
 */
package team.cqr.cqrepoured.structuregen.generators;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraft.world.gen.structure.template.PlacementSettings;
import team.cqr.cqrepoured.structuregen.DungeonDataManager;
import team.cqr.cqrepoured.structuregen.PlateauBuilder;
import team.cqr.cqrepoured.structuregen.WorldDungeonGenerator;
import team.cqr.cqrepoured.structuregen.dungeons.DungeonHangingCity;
import team.cqr.cqrepoured.structuregen.generation.DungeonPartBlock;
import team.cqr.cqrepoured.structuregen.generators.AbstractDungeonGenerator;
import team.cqr.cqrepoured.structuregen.inhabitants.DungeonInhabitant;
import team.cqr.cqrepoured.structuregen.inhabitants.DungeonInhabitantManager;
import team.cqr.cqrepoured.structuregen.structurefile.AbstractBlockInfo;
import team.cqr.cqrepoured.structuregen.structurefile.BlockInfo;
import team.cqr.cqrepoured.structuregen.structurefile.CQStructure;
import team.cqr.cqrepoured.util.DungeonGenUtils;
import team.cqr.cqrepoured.util.VectorUtil;

public class GeneratorHangingCity
extends AbstractDungeonGenerator<DungeonHangingCity> {
    private int islandCount = 1;
    private int islandDistance = 1;
    private Map<BlockPos, CQStructure> structureMap = new HashMap<BlockPos, CQStructure>();

    public GeneratorHangingCity(World world, BlockPos pos, DungeonHangingCity dungeon, Random rand, DungeonDataManager.DungeonSpawnType spawnType) {
        super(world, pos, dungeon, rand, spawnType);
    }

    @Override
    public void preProcess() {
        this.islandCount = DungeonGenUtils.randomBetween(((DungeonHangingCity)this.dungeon).getMinBuildings(), ((DungeonHangingCity)this.dungeon).getMaxBuildings(), this.random);
        this.islandDistance = DungeonGenUtils.randomBetween(((DungeonHangingCity)this.dungeon).getMinIslandDistance(), ((DungeonHangingCity)this.dungeon).getMaxIslandDistance(), this.random);
        for (int i = 0; i < this.islandCount; ++i) {
            BlockPos nextIslandPos = this.getNextIslandPos(this.pos, i);
            File file = ((DungeonHangingCity)this.dungeon).pickStructure(this.random);
            CQStructure structure = this.loadStructureFromFile(file);
            this.structureMap.put(nextIslandPos, structure);
            if (!((DungeonHangingCity)this.dungeon).digAirCave()) continue;
            int radius = structure != null ? 2 * Math.max(structure.getSize().func_177958_n(), structure.getSize().func_177952_p()) : 16;
            BlockPos startPos = nextIslandPos.func_177982_a(-radius, -((DungeonHangingCity)this.dungeon).getYFactorHeight(), -radius);
            BlockPos endPos = nextIslandPos.func_177982_a(radius, ((DungeonHangingCity)this.dungeon).getYFactorHeight(), radius);
            this.dungeonGenerator.add(PlateauBuilder.makeRandomBlob2(Blocks.field_150350_a, startPos, endPos, 8, WorldDungeonGenerator.getSeed(this.world, this.pos.func_177958_n() >> 4, this.pos.func_177952_p() >> 4), this.world, this.dungeonGenerator));
        }
        CQStructure structure = this.loadStructureFromFile(((DungeonHangingCity)this.dungeon).pickCentralStructure(this.random));
        this.structureMap.put(this.pos, structure);
        if (((DungeonHangingCity)this.dungeon).digAirCave()) {
            int radius = structure != null ? 2 * Math.max(structure.getSize().func_177958_n(), structure.getSize().func_177952_p()) : 16;
            BlockPos startPos = this.pos.func_177982_a(-radius, -((DungeonHangingCity)this.dungeon).getYFactorHeight(), -radius);
            BlockPos endPos = this.pos.func_177982_a(radius, ((DungeonHangingCity)this.dungeon).getYFactorHeight(), radius);
            this.dungeonGenerator.add(PlateauBuilder.makeRandomBlob2(Blocks.field_150350_a, startPos, endPos, 8, WorldDungeonGenerator.getSeed(this.world, this.pos.func_177958_n() >> 4, this.pos.func_177952_p() >> 4), this.world, this.dungeonGenerator));
        }
    }

    @Override
    public void buildStructure() {
        DungeonInhabitant mobType = DungeonInhabitantManager.instance().getInhabitantByDistanceIfDefault(((DungeonHangingCity)this.dungeon).getDungeonMob(), this.world, this.pos.func_177958_n(), this.pos.func_177952_p());
        for (Map.Entry<BlockPos, CQStructure> entry : this.structureMap.entrySet()) {
            BlockPos bp = entry.getKey();
            CQStructure structure = entry.getValue();
            this.buildBuilding(bp, structure, mobType);
        }
    }

    @Override
    public void postProcess() {
    }

    private BlockPos getNextIslandPos(BlockPos centerPos, int islandIndex) {
        BlockPos retPos = new BlockPos((Vec3i)centerPos);
        Vec3i vector = new Vec3i(0.0, 0.0, (double)this.islandDistance * 3.0 * (double)(islandIndex / 10 + 1));
        int degreeMultiplier = islandIndex;
        if (this.islandCount > 10) {
            degreeMultiplier -= islandIndex / 10 * 10;
        }
        double angle = this.islandCount >= 10 ? 36.0 : 360.0 / (double)this.islandCount;
        retPos = retPos.func_177971_a(VectorUtil.rotateVectorAroundY(vector, (double)degreeMultiplier * angle));
        retPos = retPos.func_177982_a(0, ((DungeonHangingCity)this.dungeon).getRandomHeightVariation(this.random), 0);
        return retPos;
    }

    private void buildBuilding(BlockPos centeredPos, CQStructure structure, DungeonInhabitant mobType) {
        int longestSide = structure != null ? Math.max(structure.getSize().func_177958_n(), structure.getSize().func_177952_p()) : 16;
        int radius = longestSide / 2;
        radius *= radius;
        radius *= 2;
        radius = (int)Math.round(Math.sqrt(radius)) + 5;
        this.buildPlatform(centeredPos, radius, mobType);
        if (structure != null) {
            PlacementSettings settings = new PlacementSettings();
            BlockPos p = DungeonGenUtils.getCentralizedPosForStructure(centeredPos.func_177984_a(), structure, settings);
            structure.addAll(this.world, this.dungeonGenerator, p, settings, mobType);
        }
    }

    private void buildPlatform(BlockPos center, int radius, DungeonInhabitant mobType) {
        HashMap<BlockPos, IBlockState> stateMap = new HashMap<BlockPos, IBlockState>();
        int rad = (int)(1.5 * (double)radius);
        for (int decrementor = 0; decrementor < rad / 2; ++decrementor) {
            for (int iX = -(rad -= decrementor); iX <= rad; ++iX) {
                for (int iZ = -rad; iZ <= rad; ++iZ) {
                    if (!DungeonGenUtils.isInsideCircle(iX, iZ, rad)) continue;
                    stateMap.put(center.func_177982_a(iX, -decrementor, iZ), ((DungeonHangingCity)this.dungeon).getIslandBlock());
                }
            }
        }
        if (((DungeonHangingCity)this.dungeon).doBuildChains()) {
            this.buildChain(center.func_177963_a((double)radius * 0.9, -2.0, (double)radius * 0.9), 0, stateMap);
            this.buildChain(center.func_177963_a((double)(-radius) * 0.9, -2.0, (double)(-radius) * 0.9), 0, stateMap);
            this.buildChain(center.func_177963_a((double)(-radius) * 0.9, -2.0, (double)radius * 0.9), 1, stateMap);
            this.buildChain(center.func_177963_a((double)radius * 0.9, -2.0, (double)(-radius) * 0.9), 1, stateMap);
        }
        ArrayList<AbstractBlockInfo> blockInfoList = new ArrayList<AbstractBlockInfo>();
        for (Map.Entry entry : stateMap.entrySet()) {
            blockInfoList.add(new BlockInfo(((BlockPos)entry.getKey()).func_177973_b((Vec3i)center), (IBlockState)entry.getValue(), null));
        }
        this.dungeonGenerator.add(new DungeonPartBlock(this.world, this.dungeonGenerator, center, blockInfoList, new PlacementSettings(), mobType));
    }

    private void buildChain(BlockPos pos, int iOffset, Map<BlockPos, IBlockState> stateMap) {
        int deltaYPerChainSegment = 5;
        int maxY = 255;
        int chainCount = (maxY - pos.func_177956_o()) / deltaYPerChainSegment;
        for (int i = 0; i < chainCount; ++i) {
            int yOffset = i * deltaYPerChainSegment;
            BlockPos startPos = pos.func_177982_a(0, yOffset, 0);
            if ((i + iOffset) % 2 > 0) {
                this.buildChainSegment(startPos, startPos.func_177978_c(), startPos.func_177968_d(), startPos.func_177964_d(2).func_177984_a(), startPos.func_177970_e(2).func_177984_a(), stateMap);
                continue;
            }
            this.buildChainSegment(startPos, startPos.func_177974_f(), startPos.func_177976_e(), startPos.func_177965_g(2).func_177984_a(), startPos.func_177985_f(2).func_177984_a(), stateMap);
        }
    }

    private void buildChainSegment(BlockPos lowerCenter, BlockPos lowerLeft, BlockPos lowerRight, BlockPos lowerBoundL, BlockPos lowerBoundR, Map<BlockPos, IBlockState> stateMap) {
        stateMap.put(lowerCenter, ((DungeonHangingCity)this.dungeon).getChainBlock());
        stateMap.put(lowerCenter.func_177982_a(0, 6, 0), ((DungeonHangingCity)this.dungeon).getChainBlock());
        stateMap.put(lowerLeft, ((DungeonHangingCity)this.dungeon).getChainBlock());
        stateMap.put(lowerLeft.func_177982_a(0, 6, 0), ((DungeonHangingCity)this.dungeon).getChainBlock());
        stateMap.put(lowerRight, ((DungeonHangingCity)this.dungeon).getChainBlock());
        stateMap.put(lowerRight.func_177982_a(0, 6, 0), ((DungeonHangingCity)this.dungeon).getChainBlock());
        for (int i = 0; i < 5; ++i) {
            stateMap.put(lowerBoundL.func_177982_a(0, i, 0), ((DungeonHangingCity)this.dungeon).getChainBlock());
            stateMap.put(lowerBoundR.func_177982_a(0, i, 0), ((DungeonHangingCity)this.dungeon).getChainBlock());
        }
    }
}

