/*
 * Decompiled with CFR 0.152.
 */
package team.cqr.cqrepoured.structuregen.generators;

import java.io.File;
import java.util.Random;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraft.world.gen.structure.template.PlacementSettings;
import net.minecraft.world.gen.structure.template.Template;
import team.cqr.cqrepoured.structuregen.DungeonDataManager;
import team.cqr.cqrepoured.structuregen.dungeons.DungeonTemplateSurface;
import team.cqr.cqrepoured.structuregen.generation.DungeonPartCover;
import team.cqr.cqrepoured.structuregen.generation.DungeonPartPlateau;
import team.cqr.cqrepoured.structuregen.generators.AbstractDungeonGenerator;
import team.cqr.cqrepoured.structuregen.inhabitants.DungeonInhabitant;
import team.cqr.cqrepoured.structuregen.inhabitants.DungeonInhabitantManager;
import team.cqr.cqrepoured.structuregen.structurefile.CQStructure;
import team.cqr.cqrepoured.util.CQRConfig;
import team.cqr.cqrepoured.util.DungeonGenUtils;

public class GeneratorTemplateSurface
extends AbstractDungeonGenerator<DungeonTemplateSurface> {
    private CQStructure structure;
    private PlacementSettings settings;
    private BlockPos structurePos;

    public GeneratorTemplateSurface(World world, BlockPos pos, DungeonTemplateSurface dungeon, Random rand, DungeonDataManager.DungeonSpawnType spawnType) {
        super(world, pos, dungeon, rand, spawnType);
    }

    @Override
    protected void preProcess() {
        File file = ((DungeonTemplateSurface)this.dungeon).getStructureFileFromDirectory(((DungeonTemplateSurface)this.dungeon).getStructureFolderPath(), this.random);
        if (file == null) {
            throw new NullPointerException("No structure file found in folder " + ((DungeonTemplateSurface)this.dungeon).getStructureFolderPath());
        }
        this.structure = this.loadStructureFromFile(file);
        this.settings = new PlacementSettings();
        if (((DungeonTemplateSurface)this.dungeon).rotateDungeon()) {
            this.settings.func_186220_a(Rotation.values()[this.random.nextInt(Rotation.values().length)]);
            this.settings.func_186214_a(Mirror.values()[this.random.nextInt(Mirror.values().length)]);
        }
        this.structurePos = DungeonGenUtils.getCentralizedPosForStructure(this.pos, this.structure, this.settings);
        if (((DungeonTemplateSurface)this.dungeon).doBuildSupportPlatform()) {
            BlockPos startPos = this.structurePos.func_177981_b(((DungeonTemplateSurface)this.dungeon).getUnderGroundOffset()).func_177977_b();
            BlockPos endPos = startPos.func_177971_a((Vec3i)Template.func_186266_a((PlacementSettings)this.settings, (BlockPos)new BlockPos(this.structure.getSize().func_177958_n() - 1, 0, this.structure.getSize().func_177952_p() - 1)));
            BlockPos pos1 = DungeonGenUtils.getValidMinPos(startPos, endPos);
            BlockPos pos2 = DungeonGenUtils.getValidMaxPos(startPos, endPos);
            this.dungeonGenerator.add(new DungeonPartPlateau(this.world, this.dungeonGenerator, pos1.func_177958_n(), pos1.func_177952_p(), pos2.func_177958_n(), pos2.func_177956_o(), pos2.func_177952_p(), ((DungeonTemplateSurface)this.dungeon).getSupportBlock(), ((DungeonTemplateSurface)this.dungeon).getSupportTopBlock(), CQRConfig.general.supportHillWallSize));
        }
    }

    @Override
    protected void buildStructure() {
        DungeonInhabitant mobType = DungeonInhabitantManager.instance().getInhabitantByDistanceIfDefault(((DungeonTemplateSurface)this.dungeon).getDungeonMob(), this.world, this.pos.func_177958_n(), this.pos.func_177952_p());
        this.structure.addAll(this.world, this.dungeonGenerator, this.structurePos, this.settings, mobType);
    }

    @Override
    protected void postProcess() {
        if (((DungeonTemplateSurface)this.dungeon).isCoverBlockEnabled()) {
            BlockPos startPos = this.structurePos;
            BlockPos endPos = startPos.func_177971_a((Vec3i)Template.func_186266_a((PlacementSettings)this.settings, (BlockPos)new BlockPos(this.structure.getSize().func_177958_n() - 1, 0, this.structure.getSize().func_177952_p() - 1)));
            BlockPos pos1 = DungeonGenUtils.getValidMinPos(startPos, endPos);
            BlockPos pos2 = DungeonGenUtils.getValidMaxPos(startPos, endPos);
            this.dungeonGenerator.add(new DungeonPartCover(this.world, this.dungeonGenerator, pos1.func_177958_n(), pos1.func_177952_p(), pos2.func_177958_n(), pos2.func_177952_p(), ((DungeonTemplateSurface)this.dungeon).getCoverBlock()));
        }
    }
}

