/*
 * Decompiled with CFR 0.152.
 */
package team.cqr.cqrepoured.structuregen.generators;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Predicate;
import net.minecraft.block.Block;
import net.minecraft.block.BlockChest;
import net.minecraft.block.BlockHugeMushroom;
import net.minecraft.block.BlockVine;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.tileentity.TileEntityMobSpawner;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraft.world.gen.structure.template.PlacementSettings;
import team.cqr.cqrepoured.structuregen.DungeonDataManager;
import team.cqr.cqrepoured.structuregen.WorldDungeonGenerator;
import team.cqr.cqrepoured.structuregen.dungeons.DungeonVegetatedCave;
import team.cqr.cqrepoured.structuregen.generation.DungeonPartBlock;
import team.cqr.cqrepoured.structuregen.generators.AbstractDungeonGenerator;
import team.cqr.cqrepoured.structuregen.inhabitants.DungeonInhabitant;
import team.cqr.cqrepoured.structuregen.inhabitants.DungeonInhabitantManager;
import team.cqr.cqrepoured.structuregen.structurefile.AbstractBlockInfo;
import team.cqr.cqrepoured.structuregen.structurefile.BlockInfo;
import team.cqr.cqrepoured.structuregen.structurefile.CQStructure;
import team.cqr.cqrepoured.util.DungeonGenUtils;
import team.cqr.cqrepoured.util.VectorUtil;

public class GeneratorVegetatedCave
extends AbstractDungeonGenerator<DungeonVegetatedCave> {
    private List<BlockPos> spawners = new ArrayList<BlockPos>();
    private List<BlockPos> chests = new ArrayList<BlockPos>();
    private Set<BlockPos> ceilingBlocks = new HashSet<BlockPos>();
    private Set<BlockPos> giantMushrooms = new HashSet<BlockPos>();
    private Map<BlockPos, Integer> heightMap = new ConcurrentHashMap<BlockPos, Integer>();
    private Set<BlockPos> floorBlocks = new HashSet<BlockPos>();
    private Map<BlockPos, IBlockState> blocks = new ConcurrentHashMap<BlockPos, IBlockState>();
    private IBlockState[][][] centralCaveBlocks;
    private DungeonInhabitant mobtype;

    public GeneratorVegetatedCave(World world, BlockPos pos, DungeonVegetatedCave dungeon, Random rand, DungeonDataManager.DungeonSpawnType spawnType) {
        super(world, pos, dungeon, rand, spawnType);
    }

    @Override
    public void preProcess() {
        this.mobtype = DungeonInhabitantManager.instance().getInhabitantByDistanceIfDefault(((DungeonVegetatedCave)this.dungeon).getDungeonMob(), this.world, this.pos.func_177958_n(), this.pos.func_177952_p());
        Random random = new Random(WorldDungeonGenerator.getSeed(this.world, this.pos.func_177958_n() / 16, this.pos.func_177952_p() / 16));
        IBlockState[][][] blocks = this.getRandomBlob(((DungeonVegetatedCave)this.dungeon).getAirBlock(), ((DungeonVegetatedCave)this.dungeon).getCentralCaveSize(), random);
        this.centralCaveBlocks = blocks;
        if (((DungeonVegetatedCave)this.dungeon).placeVines()) {
            this.ceilingBlocks.addAll(this.getCeilingBlocksOfBlob(blocks, this.pos, random));
        }
        this.floorBlocks.addAll(this.getFloorBlocksOfBlob(blocks, this.pos, random));
        this.storeBlockArrayInMap(blocks, this.pos);
        Vec3d center = new Vec3d((Vec3i)this.pos.func_177979_c(((DungeonVegetatedCave)this.dungeon).getCentralCaveSize() / 2));
        Vec3d rad = new Vec3d((double)((DungeonVegetatedCave)this.dungeon).getCentralCaveSize() * 1.75, 0.0, 0.0);
        int tunnelCount = ((DungeonVegetatedCave)this.dungeon).getTunnelCount(random);
        double angle = 360.0 / (double)tunnelCount;
        for (int i = 0; i < tunnelCount; ++i) {
            Vec3d v = VectorUtil.rotateVectorAroundY(rad, angle * (double)i);
            Vec3d startPos = center.func_178787_e(v);
            this.createTunnel(startPos, angle * (double)i, ((DungeonVegetatedCave)this.dungeon).getTunnelStartSize(), ((DungeonVegetatedCave)this.dungeon).getCaveSegmentCount(), random);
        }
        this.filterFloorBlocks();
        if (((DungeonVegetatedCave)this.dungeon).placeVines()) {
            this.filterCeilingBlocks(this.world);
        }
        if (((DungeonVegetatedCave)this.dungeon).placeVegetation()) {
            this.createVegetation(random);
        }
        if (((DungeonVegetatedCave)this.dungeon).placeVines()) {
            this.createVines(random);
        }
        ArrayList<AbstractBlockInfo> blockInfoList = new ArrayList<AbstractBlockInfo>();
        for (Map.Entry<BlockPos, IBlockState> entry : this.blocks.entrySet()) {
            blockInfoList.add(new BlockInfo(entry.getKey().func_177973_b((Vec3i)this.pos), entry.getValue(), null));
        }
        this.dungeonGenerator.add(new DungeonPartBlock(this.world, this.dungeonGenerator, this.pos, blockInfoList, new PlacementSettings(), this.mobtype));
    }

    @Override
    public void buildStructure() {
    }

    private int getLowestY(IBlockState[][][] blocks, int rX, int rZ, int origY) {
        int cZ;
        int radZ;
        int radX;
        int y = 255;
        int cX = blocks.length / 2;
        int n = radX = rX < cX ? rX : cX;
        if (cX + radX >= blocks.length) {
            radX = blocks.length - cX;
        }
        int n2 = radZ = rZ < (cZ = blocks[0][0].length / 2) ? rZ : cZ;
        if (cZ + radZ >= blocks.length) {
            radZ = blocks.length - cZ;
        }
        for (int iX = cX - radX; iX <= cX + radX; ++iX) {
            block1: for (int iZ = cZ - radZ; iZ <= cZ + radZ; ++iZ) {
                if (iX < 0 || iX >= blocks.length || iZ < 0 || iZ >= blocks[0][0].length) continue;
                for (int iY = 0; iY < blocks[iX].length; ++iY) {
                    if (blocks[iX][iY][iZ] == null) continue;
                    if (y <= iY) continue block1;
                    y = iY;
                    continue block1;
                }
            }
        }
        int radius = blocks.length / 2;
        y -= radius;
        return y += origY;
    }

    @Override
    public void postProcess() {
        HashMap<BlockPos, IBlockState> stateMap = new HashMap<BlockPos, IBlockState>();
        Random random = new Random(WorldDungeonGenerator.getSeed(this.world, this.pos.func_177958_n() / 16, this.pos.func_177952_p() / 16));
        for (BlockPos mushroompos : this.giantMushrooms) {
            if (random.nextBoolean()) {
                this.generateGiantMushroom(mushroompos, random, stateMap);
            }
            if (random.nextInt(3) != 0) continue;
            BlockPos spawner = new BlockPos(mushroompos.func_177958_n() + (random.nextBoolean() ? -1 : 1), mushroompos.func_177956_o() + 1, mushroompos.func_177952_p() + (random.nextBoolean() ? -1 : 1));
            this.spawners.add(spawner);
            if (random.nextInt(3) < 1) continue;
            this.chests.add(spawner.func_177977_b());
        }
        ArrayList<AbstractBlockInfo> blockInfoList = new ArrayList<AbstractBlockInfo>();
        for (Map.Entry entry : stateMap.entrySet()) {
            blockInfoList.add(new BlockInfo(((BlockPos)entry.getKey()).func_177973_b((Vec3i)this.pos), (IBlockState)entry.getValue(), null));
        }
        this.dungeonGenerator.add(new DungeonPartBlock(this.world, this.dungeonGenerator, this.pos, blockInfoList, new PlacementSettings(), this.mobtype));
        this.placeSpawners();
        this.fillChests();
        this.generateCenterStructure();
    }

    public void fillChests() {
        ArrayList<AbstractBlockInfo> blockInfoList = new ArrayList<AbstractBlockInfo>();
        Random random = new Random(WorldDungeonGenerator.getSeed(this.world, this.pos.func_177958_n() / 16, this.pos.func_177952_p() / 16));
        ResourceLocation[] chestIDs = ((DungeonVegetatedCave)this.dungeon).getChestIDs();
        for (BlockPos chestpos : this.chests) {
            ResourceLocation resLoc;
            BlockChest block = Blocks.field_150486_ae;
            IBlockState state = block.func_176223_P();
            TileEntityChest chest = (TileEntityChest)block.createTileEntity(this.world, state);
            if (chest != null && (resLoc = chestIDs[random.nextInt(chestIDs.length)]) != null) {
                long seed = WorldDungeonGenerator.getSeed(this.world, this.pos.func_177958_n() + chestpos.func_177958_n() + chestpos.func_177956_o(), this.pos.func_177952_p() + chestpos.func_177952_p() + chestpos.func_177956_o());
                chest.func_189404_a(resLoc, seed);
            }
            NBTTagCompound nbt = chest.func_189515_b(new NBTTagCompound());
            blockInfoList.add(new BlockInfo(chestpos.func_177973_b((Vec3i)this.pos), state, nbt));
        }
        this.dungeonGenerator.add(new DungeonPartBlock(this.world, this.dungeonGenerator, this.pos, blockInfoList, new PlacementSettings(), this.mobtype));
    }

    public void placeSpawners() {
        ArrayList<AbstractBlockInfo> blockInfoList = new ArrayList<AbstractBlockInfo>();
        for (BlockPos spawnerpos : this.spawners) {
            Block block = Blocks.field_150474_ac;
            IBlockState state = block.func_176223_P();
            TileEntityMobSpawner spawner = (TileEntityMobSpawner)block.createTileEntity(this.world, state);
            spawner.func_145881_a().func_190894_a(this.mobtype.getEntityID());
            spawner.func_145836_u();
            NBTTagCompound nbt = spawner.func_189515_b(new NBTTagCompound());
            blockInfoList.add(new BlockInfo(spawnerpos.func_177973_b((Vec3i)this.pos), state, nbt));
        }
        this.dungeonGenerator.add(new DungeonPartBlock(this.world, this.dungeonGenerator, this.pos, blockInfoList, new PlacementSettings(), this.mobtype));
    }

    public void generateCenterStructure() {
        File file;
        if (((DungeonVegetatedCave)this.dungeon).placeBuilding() && (file = ((DungeonVegetatedCave)this.dungeon).getRandomCentralBuilding(this.random)) != null) {
            CQStructure structure = this.loadStructureFromFile(file);
            int pY = this.getLowestY(this.centralCaveBlocks, structure.getSize().func_177958_n() / 2, structure.getSize().func_177952_p() / 2, this.pos.func_177956_o());
            PlacementSettings settings = new PlacementSettings();
            BlockPos p = DungeonGenUtils.getCentralizedPosForStructure(new BlockPos(this.pos.func_177958_n(), pY, this.pos.func_177952_p()), structure, settings);
            structure.addAll(this.world, this.dungeonGenerator, p, settings, this.mobtype);
        }
    }

    private void createTunnel(Vec3d startPos, double initAngle, int startSize, int initLength, Random random) {
        double angle = 90.0;
        angle /= (double)initLength;
        angle /= (double)((startSize - 2) / 2);
        Vec3d expansionDir = VectorUtil.rotateVectorAroundY(new Vec3d((double)startSize, 0.0, 0.0), initAngle);
        for (int i = 0; i < initLength; ++i) {
            IBlockState[][][] blob = this.getRandomBlob(((DungeonVegetatedCave)this.dungeon).getAirBlock(), startSize, (int)((double)startSize * 0.8), random);
            if (((DungeonVegetatedCave)this.dungeon).placeVines()) {
                this.ceilingBlocks.addAll(this.getCeilingBlocksOfBlob(blob, new BlockPos(startPos.field_72450_a, startPos.field_72448_b, startPos.field_72449_c), random));
            }
            this.floorBlocks.addAll(this.getFloorBlocksOfBlob(blob, new BlockPos(startPos.field_72450_a, startPos.field_72448_b, startPos.field_72449_c), random));
            this.storeBlockArrayInMap(blob, new BlockPos(startPos.field_72450_a, startPos.field_72448_b, startPos.field_72449_c));
            expansionDir = VectorUtil.rotateVectorAroundY(expansionDir, angle);
            startPos = startPos.func_178787_e(expansionDir);
        }
        int szTmp = startSize;
        if ((startSize -= 2) > 3) {
            this.createTunnel(startPos, initAngle + angle * (double)initLength - 90.0, new Integer(startSize), initLength * (szTmp / startSize), random);
            this.createTunnel(startPos, initAngle + angle * (double)initLength, new Integer(startSize), initLength * (szTmp / startSize), random);
        }
    }

    private List<BlockPos> getCeilingBlocksOfBlob(IBlockState[][][] blob, BlockPos blobCenter, Random random) {
        ArrayList<BlockPos> ceilingBlocks = new ArrayList<BlockPos>();
        int radius = blob.length / 2;
        for (int iX = 0; iX < blob.length; ++iX) {
            block1: for (int iZ = 0; iZ < blob[0][0].length; ++iZ) {
                for (int iY = blob[0].length - 1; iY >= 1; --iY) {
                    if (blob[iX][iY - 1][iZ] == null || blob[iX][iY][iZ] != null) continue;
                    BlockPos p = blobCenter.func_177971_a((Vec3i)new BlockPos(iX - radius, iY - radius - 1, iZ - radius));
                    ceilingBlocks.add(p);
                    int height = 0;
                    int yTmp = iY - 1;
                    while (blob[iX][yTmp][iZ] != null && yTmp >= 0) {
                        --yTmp;
                        ++height;
                    }
                    this.heightMap.put(p, new Integer(height));
                    continue block1;
                }
            }
        }
        return ceilingBlocks;
    }

    private void storeBlockArrayInMap(IBlockState[][][] blob, BlockPos blobCenter) {
        int radius = blob.length / 2;
        for (int iX = 0; iX < blob.length; ++iX) {
            for (int iZ = 0; iZ < blob[0][0].length; ++iZ) {
                for (int iY = 1; iY < blob[0].length; ++iY) {
                    if (blob[iX][iY][iZ] == null) continue;
                    IBlockState state = blob[iX][iY][iZ];
                    BlockPos bp = new BlockPos(iX - radius, iY - radius, iZ - radius);
                    this.blocks.put(blobCenter.func_177971_a((Vec3i)bp), state);
                }
            }
        }
    }

    private List<BlockPos> getFloorBlocksOfBlob(IBlockState[][][] blob, BlockPos blobCenter, Random random) {
        ArrayList<BlockPos> floorBlocks = new ArrayList<BlockPos>();
        int radius = blob.length / 2;
        for (int iX = 0; iX < blob.length; ++iX) {
            block1: for (int iZ = 0; iZ < blob[0][0].length; ++iZ) {
                for (int iY = 1; iY < blob[0].length; ++iY) {
                    if (blob[iX][iY][iZ] == null || blob[iX][iY - 1][iZ] != null) continue;
                    blob[iX][iY][iZ] = ((DungeonVegetatedCave)this.dungeon).getFloorBlock(random);
                    floorBlocks.add(blobCenter.func_177971_a((Vec3i)new BlockPos(iX - radius, iY - radius, iZ - radius)));
                    continue block1;
                }
            }
        }
        return floorBlocks;
    }

    private IBlockState[][][] getRandomBlob(IBlockState block, int radius, Random random) {
        return this.getRandomBlob(block, radius, radius, random);
    }

    private IBlockState[][][] getRandomBlob(IBlockState block, int radius, int radiusY, Random random) {
        IBlockState[][][] blocks = new IBlockState[radius * 4][radiusY * 4][radius * 4];
        int subSphereCount = radius * 3;
        double sphereSurface = Math.PI * 4 * (double)(radius * radius);
        double counter = sphereSurface / (double)subSphereCount;
        double cI = 0.0;
        for (int iX = -radius; iX <= radius; ++iX) {
            for (int iY = -radiusY; iY <= radiusY; ++iY) {
                for (int iZ = -radius; iZ <= radius; ++iZ) {
                    double distance = iX * iX + iZ * iZ + iY * iY;
                    if ((distance = Math.sqrt(distance)) < (double)radius) {
                        blocks[iX + radius * 2][iY + radiusY * 2][iZ + radius * 2] = block;
                        continue;
                    }
                    if (!(distance <= (double)(radius + 1)) || (cI += 1.0) < counter) continue;
                    cI = 0.0;
                    int r1 = radius / 2;
                    int r1Y = radiusY / 2;
                    int r2 = (int)((double)radius * 0.75);
                    int r2Y = (int)((double)radiusY * 0.75);
                    int rSub = DungeonGenUtils.randomBetween(r1, r2, random);
                    int rSubY = DungeonGenUtils.randomBetween(r1Y, r2Y, random);
                    for (int jX = iX - rSub; jX <= iX + rSub; ++jX) {
                        for (int jY = iY - rSubY; jY <= iY + rSubY; ++jY) {
                            for (int jZ = iZ - rSub; jZ <= iZ + rSub; ++jZ) {
                                double distanceSub = (jX - iX) * (jX - iX) + (jY - iY) * (jY - iY) + (jZ - iZ) * (jZ - iZ);
                                if (!((distanceSub = Math.sqrt(distanceSub)) < (double)rSub)) continue;
                                try {
                                    if (blocks[jX + radius * 2][jY + radiusY * 2][jZ + radius * 2] == block) continue;
                                    blocks[jX + radius * 2][jY + radiusY * 2][jZ + radius * 2] = block;
                                    continue;
                                }
                                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                                    // empty catch block
                                }
                            }
                        }
                    }
                    --subSphereCount;
                }
            }
        }
        return blocks;
    }

    private void filterFloorBlocks() {
        this.floorBlocks.removeIf(new Predicate<BlockPos>(){

            @Override
            public boolean test(BlockPos floorPos) {
                BlockPos lower = floorPos.func_177977_b();
                if (GeneratorVegetatedCave.this.blocks.containsKey(lower)) {
                    GeneratorVegetatedCave.this.blocks.put(floorPos, ((DungeonVegetatedCave)GeneratorVegetatedCave.this.dungeon).getAirBlock());
                    return true;
                }
                return false;
            }
        });
    }

    private void filterCeilingBlocks(final World world) {
        this.ceilingBlocks.removeIf(new Predicate<BlockPos>(){

            @Override
            public boolean test(BlockPos arg0) {
                BlockPos upper = arg0.func_177984_a();
                if (GeneratorVegetatedCave.this.blocks.containsKey(upper)) {
                    GeneratorVegetatedCave.this.blocks.put(arg0, ((DungeonVegetatedCave)GeneratorVegetatedCave.this.dungeon).getAirBlock());
                    GeneratorVegetatedCave.this.heightMap.remove(arg0);
                    return true;
                }
                if (!((DungeonVegetatedCave)GeneratorVegetatedCave.this.dungeon).skipCeilingFiltering()) {
                    return world.func_189649_b(arg0.func_177958_n(), arg0.func_177952_p()) <= arg0.func_177956_o() || world.func_175645_m(arg0).func_177956_o() <= arg0.func_177956_o() || world.func_175710_j(arg0);
                }
                return false;
            }
        });
    }

    private void createVegetation(Random random) {
        for (BlockPos floorPos : this.floorBlocks) {
            int number = random.nextInt(300);
            IBlockState state = null;
            if (number >= 295) {
                boolean flag = true;
                for (BlockPos shroom : this.giantMushrooms) {
                    if (!(shroom.func_185332_f(floorPos.func_177958_n(), floorPos.func_177956_o(), floorPos.func_177952_p()) < 5.0)) continue;
                    flag = false;
                    break;
                }
                if (flag) {
                    this.giantMushrooms.add(floorPos.func_177984_a());
                }
            } else if (number >= 290) {
                state = ((DungeonVegetatedCave)this.dungeon).getPumpkinBlock();
            } else if (number <= 150) {
                state = number <= 100 ? ((DungeonVegetatedCave)this.dungeon).getGrassBlock(random) : (random.nextBoolean() ? ((DungeonVegetatedCave)this.dungeon).getFlowerBlock(random) : ((DungeonVegetatedCave)this.dungeon).getMushroomBlock(random));
            }
            if (state == null) continue;
            this.blocks.put(floorPos.func_177984_a(), state);
        }
    }

    private void createVines(Random random) {
        block0: for (BlockPos vineStart : this.ceilingBlocks) {
            IBlockState eState;
            if (random.nextInt(300) < 300 - ((DungeonVegetatedCave)this.dungeon).getVineChance()) continue;
            int vineLength = this.heightMap.get(vineStart);
            vineLength = new Double((double)vineLength / ((DungeonVegetatedCave)this.dungeon).getVineLengthModifier()).intValue();
            BlockPos vN = vineStart.func_177978_c();
            BlockPos vE = vineStart.func_177974_f();
            BlockPos vS = vineStart.func_177968_d();
            BlockPos vW = vineStart.func_177976_e();
            if (((DungeonVegetatedCave)this.dungeon).isVineShapeCross()) {
                this.blocks.put(vineStart, ((DungeonVegetatedCave)this.dungeon).getVineLatchBlock());
            }
            IBlockState airState = ((DungeonVegetatedCave)this.dungeon).getAirBlock();
            IBlockState sState = ((DungeonVegetatedCave)this.dungeon).isVineShapeCross() ? ((DungeonVegetatedCave)this.dungeon).getVineBlock().func_177226_a((IProperty)BlockVine.field_176273_b, (Comparable)Boolean.valueOf(true)) : null;
            IBlockState wState = ((DungeonVegetatedCave)this.dungeon).isVineShapeCross() ? ((DungeonVegetatedCave)this.dungeon).getVineBlock().func_177226_a((IProperty)BlockVine.field_176278_M, (Comparable)Boolean.valueOf(true)) : null;
            IBlockState nState = ((DungeonVegetatedCave)this.dungeon).isVineShapeCross() ? ((DungeonVegetatedCave)this.dungeon).getVineBlock().func_177226_a((IProperty)BlockVine.field_176279_N, (Comparable)Boolean.valueOf(true)) : null;
            IBlockState iBlockState = eState = ((DungeonVegetatedCave)this.dungeon).isVineShapeCross() ? ((DungeonVegetatedCave)this.dungeon).getVineBlock().func_177226_a((IProperty)BlockVine.field_176280_O, (Comparable)Boolean.valueOf(true)) : null;
            while (vineLength >= 0) {
                if (((DungeonVegetatedCave)this.dungeon).isVineShapeCross()) {
                    this.blocks.put(vN, nState);
                    this.blocks.put(vE, eState);
                    this.blocks.put(vS, sState);
                    this.blocks.put(vW, wState);
                    vN = vN.func_177977_b();
                    vE = vE.func_177977_b();
                    vS = vS.func_177977_b();
                    vW = vW.func_177977_b();
                    if (this.blocks.getOrDefault(vN, airState) != airState || this.blocks.getOrDefault(vE, airState) != airState || this.blocks.getOrDefault(vS, airState) != airState || this.blocks.getOrDefault(vW, airState) != airState) {
                        continue block0;
                    }
                } else {
                    this.blocks.put(vineStart, ((DungeonVegetatedCave)this.dungeon).getVineBlock());
                    vineStart = vineStart.func_177977_b();
                    if (this.blocks.getOrDefault(vineStart, airState) != airState) continue block0;
                }
                --vineLength;
            }
        }
    }

    private void generateGiantMushroom(BlockPos position, Random rand, Map<BlockPos, IBlockState> stateMap) {
        Block block = rand.nextBoolean() ? Blocks.field_150420_aW : Blocks.field_150419_aX;
        int i = 6;
        if (position.func_177956_o() >= 1 && position.func_177956_o() + i + 1 < 256) {
            int k2 = position.func_177956_o() + i;
            if (block == Blocks.field_150419_aX) {
                k2 = position.func_177956_o() + i - 3;
            }
            for (int l2 = k2; l2 <= position.func_177956_o() + i; ++l2) {
                int j3 = 1;
                if (l2 < position.func_177956_o() + i) {
                    ++j3;
                }
                if (block == Blocks.field_150420_aW) {
                    j3 = 3;
                }
                int k3 = position.func_177958_n() - j3;
                int l3 = position.func_177958_n() + j3;
                int j1 = position.func_177952_p() - j3;
                int k1 = position.func_177952_p() + j3;
                for (int l1 = k3; l1 <= l3; ++l1) {
                    for (int i2 = j1; i2 <= k1; ++i2) {
                        int j2 = 5;
                        if (l1 == k3) {
                            --j2;
                        } else if (l1 == l3) {
                            ++j2;
                        }
                        if (i2 == j1) {
                            j2 -= 3;
                        } else if (i2 == k1) {
                            j2 += 3;
                        }
                        BlockHugeMushroom.EnumType blockhugemushroom$enumtype = BlockHugeMushroom.EnumType.func_176895_a((int)j2);
                        if (block == Blocks.field_150420_aW || l2 < position.func_177956_o() + i) {
                            if ((l1 == k3 || l1 == l3) && (i2 == j1 || i2 == k1)) continue;
                            if (l1 == position.func_177958_n() - (j3 - 1) && i2 == j1) {
                                blockhugemushroom$enumtype = BlockHugeMushroom.EnumType.NORTH_WEST;
                            }
                            if (l1 == k3 && i2 == position.func_177952_p() - (j3 - 1)) {
                                blockhugemushroom$enumtype = BlockHugeMushroom.EnumType.NORTH_WEST;
                            }
                            if (l1 == position.func_177958_n() + (j3 - 1) && i2 == j1) {
                                blockhugemushroom$enumtype = BlockHugeMushroom.EnumType.NORTH_EAST;
                            }
                            if (l1 == l3 && i2 == position.func_177952_p() - (j3 - 1)) {
                                blockhugemushroom$enumtype = BlockHugeMushroom.EnumType.NORTH_EAST;
                            }
                            if (l1 == position.func_177958_n() - (j3 - 1) && i2 == k1) {
                                blockhugemushroom$enumtype = BlockHugeMushroom.EnumType.SOUTH_WEST;
                            }
                            if (l1 == k3 && i2 == position.func_177952_p() + (j3 - 1)) {
                                blockhugemushroom$enumtype = BlockHugeMushroom.EnumType.SOUTH_WEST;
                            }
                            if (l1 == position.func_177958_n() + (j3 - 1) && i2 == k1) {
                                blockhugemushroom$enumtype = BlockHugeMushroom.EnumType.SOUTH_EAST;
                            }
                            if (l1 == l3 && i2 == position.func_177952_p() + (j3 - 1)) {
                                blockhugemushroom$enumtype = BlockHugeMushroom.EnumType.SOUTH_EAST;
                            }
                        }
                        if (blockhugemushroom$enumtype == BlockHugeMushroom.EnumType.CENTER && l2 < position.func_177956_o() + i) {
                            blockhugemushroom$enumtype = BlockHugeMushroom.EnumType.ALL_INSIDE;
                        }
                        if (position.func_177956_o() < position.func_177956_o() + i - 1 && blockhugemushroom$enumtype == BlockHugeMushroom.EnumType.ALL_INSIDE) continue;
                        BlockPos blockpos = new BlockPos(l1, l2, i2);
                        stateMap.put(blockpos, block.func_176223_P().func_177226_a((IProperty)BlockHugeMushroom.field_176380_a, (Comparable)blockhugemushroom$enumtype));
                    }
                }
            }
            for (int i3 = 0; i3 < i; ++i3) {
                stateMap.put(position.func_177981_b(i3), block.func_176223_P().func_177226_a((IProperty)BlockHugeMushroom.field_176380_a, (Comparable)BlockHugeMushroom.EnumType.STEM));
            }
        }
    }
}

