/*
 * Decompiled with CFR 0.152.
 */
package team.cqr.cqrepoured.structuregen.generators.castleparts;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import team.cqr.cqrepoured.CQRMain;
import team.cqr.cqrepoured.factions.CQRFaction;
import team.cqr.cqrepoured.factions.FactionRegistry;
import team.cqr.cqrepoured.objects.factories.GearedMobFactory;
import team.cqr.cqrepoured.structuregen.dungeons.DungeonRandomizedCastle;
import team.cqr.cqrepoured.structuregen.generators.castleparts.RoomGrid;
import team.cqr.cqrepoured.structuregen.generators.castleparts.RoomGridCell;
import team.cqr.cqrepoured.structuregen.generators.castleparts.RoomGridPosition;
import team.cqr.cqrepoured.structuregen.generators.castleparts.addons.CastleAddonRoofBase;
import team.cqr.cqrepoured.structuregen.generators.castleparts.addons.CastleRoofFactory;
import team.cqr.cqrepoured.structuregen.generators.castleparts.rooms.CastleRoomBase;
import team.cqr.cqrepoured.structuregen.generators.castleparts.rooms.CastleRoomBossLandingEmpty;
import team.cqr.cqrepoured.structuregen.generators.castleparts.rooms.CastleRoomBossLandingMain;
import team.cqr.cqrepoured.structuregen.generators.castleparts.rooms.CastleRoomBossStairEmpty;
import team.cqr.cqrepoured.structuregen.generators.castleparts.rooms.CastleRoomBossStairMain;
import team.cqr.cqrepoured.structuregen.generators.castleparts.rooms.CastleRoomBridgeTop;
import team.cqr.cqrepoured.structuregen.generators.castleparts.rooms.CastleRoomDecoratedBase;
import team.cqr.cqrepoured.structuregen.generators.castleparts.rooms.CastleRoomHallway;
import team.cqr.cqrepoured.structuregen.generators.castleparts.rooms.CastleRoomJailCell;
import team.cqr.cqrepoured.structuregen.generators.castleparts.rooms.CastleRoomLandingDirected;
import team.cqr.cqrepoured.structuregen.generators.castleparts.rooms.CastleRoomLandingDirectedBoss;
import team.cqr.cqrepoured.structuregen.generators.castleparts.rooms.CastleRoomLandingSpiral;
import team.cqr.cqrepoured.structuregen.generators.castleparts.rooms.CastleRoomReplacedRoof;
import team.cqr.cqrepoured.structuregen.generators.castleparts.rooms.CastleRoomRoofBossEmpty;
import team.cqr.cqrepoured.structuregen.generators.castleparts.rooms.CastleRoomRoofBossMain;
import team.cqr.cqrepoured.structuregen.generators.castleparts.rooms.CastleRoomStaircaseDirected;
import team.cqr.cqrepoured.structuregen.generators.castleparts.rooms.CastleRoomStaircaseSpiral;
import team.cqr.cqrepoured.structuregen.generators.castleparts.rooms.CastleRoomTowerSquare;
import team.cqr.cqrepoured.structuregen.generators.castleparts.rooms.CastleRoomWalkableRoof;
import team.cqr.cqrepoured.structuregen.generators.castleparts.rooms.CastleRoomWalkableRoofTower;
import team.cqr.cqrepoured.structuregen.generators.castleparts.rooms.EnumRoomType;
import team.cqr.cqrepoured.structuregen.generators.castleparts.rooms.RoomFactoryCastle;
import team.cqr.cqrepoured.structuregen.generators.castleparts.rooms.segments.CastleMainStructWall;
import team.cqr.cqrepoured.structuregen.generators.castleparts.rooms.segments.EnumCastleDoorType;
import team.cqr.cqrepoured.structuregen.inhabitants.DungeonInhabitant;
import team.cqr.cqrepoured.structuregen.inhabitants.DungeonInhabitantManager;
import team.cqr.cqrepoured.util.BlockStateGenArray;
import team.cqr.cqrepoured.util.DungeonGenUtils;

public class CastleRoomSelector {
    private static final int FLOORS_PER_LAYER = 2;
    private static final int MAX_LAYERS = 5;
    private static final int PADDING_FLOORS = 2;
    private static final int MIN_TOWER_FLOORS = 3;
    private static final int MIN_TOWER_SIZE = 7;
    private static final int MIN_BRIDGE_LENGTH = 2;
    private static final int MIN_BOSS_ROOM_SIZE = 15;
    private DungeonRandomizedCastle dungeon;
    private int floorHeight;
    private int roomSize;
    private int minRoomsForBoss;
    private int floorsPerLayer;
    private int maxFloors;
    private int usedFloors;
    private Random random;
    private RoomGrid grid;
    private List<SupportArea> supportAreas;
    private List<CastleAddonRoofBase> castleRoofs;

    public CastleRoomSelector(DungeonRandomizedCastle dungeon, Random rand) {
        this.dungeon = dungeon;
        this.floorHeight = dungeon.getFloorHeight();
        this.roomSize = dungeon.getRoomSize();
        this.floorsPerLayer = 2;
        this.maxFloors = this.floorsPerLayer * 5;
        this.minRoomsForBoss = (int)Math.ceil(15.0 / (double)(this.roomSize - 1));
        this.random = rand;
        this.castleRoofs = new ArrayList<CastleAddonRoofBase>();
        this.supportAreas = new ArrayList<SupportArea>();
        int gridSizeX = dungeon.getMaxSize() / this.roomSize;
        int gridSizeZ = dungeon.getMaxSize() / this.roomSize;
        this.grid = new RoomGrid(this.maxFloors + 2, gridSizeX, gridSizeZ, this.roomSize, this.floorHeight, this.random);
    }

    public void randomizeCastle() {
        this.createCastleLayout();
        this.addBossRooms();
        this.addHallways();
        this.addStairCases();
        this.randomizeRooms();
        this.linkCells();
        this.determineRoofs();
        this.placeTowers();
        this.determineWalls();
        this.placeBridges();
        this.placeOuterDoors();
        this.pathBetweenRooms();
    }

    public void generate(World world, BlockStateGenArray genArray, DungeonRandomizedCastle dungeon, BlockPos startPos, ArrayList<String> bossUuids, DungeonInhabitant mobType) {
        this.generateRooms(startPos, dungeon, genArray, bossUuids);
        this.generateWalls(genArray, dungeon);
        this.addDecoration(world, startPos, dungeon, genArray, bossUuids, mobType);
        this.generateRoofs(startPos, genArray, dungeon);
    }

    private void generateRooms(BlockPos startPos, DungeonRandomizedCastle dungeon, BlockStateGenArray genArray, ArrayList<String> bossUuids) {
        for (RoomGridCell cell : this.grid.getAllCellsWhere(c -> c.isPopulated() && !(c.getRoom() instanceof CastleRoomWalkableRoof))) {
            cell.generateRoom(startPos, genArray, dungeon);
        }
    }

    private void generateWalls(BlockStateGenArray genArray, DungeonRandomizedCastle dungeon) {
        List<CastleMainStructWall> genList = this.grid.getWallListCopy();
        genList.sort(Comparator.comparingInt(CastleMainStructWall::getGenerationPriority));
        for (CastleMainStructWall wall : genList) {
            if (!wall.isEnabled()) continue;
            wall.generate(genArray, dungeon);
        }
    }

    private void addDecoration(World world, BlockPos startPos, DungeonRandomizedCastle dungeon, BlockStateGenArray genArray, ArrayList<String> bossUuids, DungeonInhabitant mobType) {
        ResourceLocation mobResLoc = mobType.getEntityID();
        ResourceLocation bossResLoc = mobType.getBossID();
        GearedMobFactory mobFactory = new GearedMobFactory(this.getBossFloor(), mobResLoc, this.random);
        for (RoomGridCell cell : this.grid.getAllCellsWhere(RoomGridCell::isPopulated)) {
            DungeonInhabitant jailInhabitant;
            cell.getRoom().decorate(world, genArray, dungeon, mobFactory);
            cell.getRoom().placeBoss(world, genArray, dungeon, bossResLoc, bossUuids);
            if (!(cell.getRoom() instanceof CastleRoomJailCell) || (jailInhabitant = this.selectJailInhabitant(world, mobType)) == null) continue;
            ((CastleRoomJailCell)cell.getRoom()).addPrisonerSpawners(jailInhabitant, genArray, world);
        }
    }

    private DungeonInhabitant selectJailInhabitant(World world, DungeonInhabitant mainInhabitant) {
        CQRFaction inhaFaction;
        DungeonInhabitant jailed = null;
        String factionOverride = mainInhabitant.getFactionOverride();
        if (factionOverride != null) {
            inhaFaction = FactionRegistry.instance().getFactionInstance(factionOverride);
        } else {
            Entity entity = EntityList.func_188429_b((ResourceLocation)mainInhabitant.getEntityID(), (World)world);
            inhaFaction = FactionRegistry.instance().getFactionOf(entity);
        }
        List<CQRFaction> enemies = inhaFaction.getEnemies();
        Collections.shuffle(enemies, this.random);
        for (CQRFaction enemyFaction : enemies) {
            List<DungeonInhabitant> possibleJailed = DungeonInhabitantManager.instance().getListOfFactionInhabitants(enemyFaction, world);
            if (possibleJailed.isEmpty()) continue;
            jailed = possibleJailed.get(this.random.nextInt(possibleJailed.size()));
            break;
        }
        return jailed;
    }

    private void generateRoofs(BlockPos startPos, BlockStateGenArray genArray, DungeonRandomizedCastle dungeon) {
        for (CastleAddonRoofBase roof : this.castleRoofs) {
            roof.generate(genArray, dungeon);
        }
        for (RoomGridCell cell : this.grid.getAllCellsWhere(c -> c.isPopulated() && c.getRoom() instanceof CastleRoomWalkableRoof)) {
            cell.generateRoom(startPos, genArray, dungeon);
        }
    }

    private void createCastleLayout() {
        this.setFirstLayerBuildable();
        boolean lastFloor = false;
        for (int layer = 0; !lastFloor && layer < 5; ++layer) {
            int firstFloorInLayer = layer * this.floorsPerLayer;
            ArrayList<RoomGrid.Area2D> buildableAreas = this.grid.getAllGridAreasWhere(firstFloorInLayer, RoomGridCell::isBuildable, 2, 2);
            if (!buildableAreas.isEmpty()) {
                for (RoomGrid.Area2D buildArea : buildableAreas) {
                    RoomGrid.Area2D structArea;
                    if (buildableAreas.get(0) == buildArea) {
                        if (!buildArea.dimensionsAreAtLeast(this.minRoomsForBoss, this.minRoomsForBoss + 1)) continue;
                        if (buildArea.dimensionsAre(this.minRoomsForBoss, this.minRoomsForBoss + 1)) {
                            this.grid.setBossArea(buildArea);
                            lastFloor = true;
                            continue;
                        }
                        if (layer >= 3) {
                            RoomGrid.Area2D bossArea = buildArea.getExactSubArea(this.random, this.minRoomsForBoss, this.minRoomsForBoss + 1);
                            this.grid.setBossArea(bossArea);
                            lastFloor = true;
                            continue;
                        }
                        structArea = buildArea.getRandomSubArea(this.random, this.minRoomsForBoss, this.minRoomsForBoss + 1, false);
                        this.grid.selectBlockOfCellsForBuilding(structArea, this.floorsPerLayer);
                        this.addSupportIfFirstLayer(layer, structArea);
                        this.addSideStructures(structArea, buildArea);
                        continue;
                    }
                    structArea = buildArea.getRandomSubArea(this.random, 2, 1, true);
                    this.grid.selectBlockOfCellsForBuilding(structArea, this.floorsPerLayer);
                    this.addSupportIfFirstLayer(layer, structArea);
                    this.addSideStructures(structArea, buildArea);
                }
            } else {
                CQRMain.logger.info("Buildable areas was empty (break here).");
            }
            this.usedFloors += this.floorsPerLayer;
        }
    }

    private void addSideStructures(RoomGrid.Area2D structArea, RoomGrid.Area2D buildArea) {
        for (EnumFacing side : EnumFacing.field_176754_o) {
            RoomGrid.Area2D sideAllowedArea = buildArea.sliceToSideOfArea(structArea, side);
            RoomGrid.Area2D lastBuiltArea = structArea;
            while (sideAllowedArea != null && DungeonGenUtils.percentageRandom(75, this.random)) {
                RoomGrid.Area2D sideSelectedArea = sideAllowedArea.getRandomSubArea(this.random, 1, 1, false);
                sideSelectedArea.alignToSide(this.random, lastBuiltArea, side, buildArea);
                this.grid.selectBlockOfCellsForBuilding(sideSelectedArea, this.floorsPerLayer);
                this.addSupportIfFirstLayer(structArea.start.getFloor(), sideSelectedArea);
                lastBuiltArea = sideSelectedArea;
                sideAllowedArea = buildArea.sliceToSideOfArea(lastBuiltArea, side);
            }
        }
    }

    private void setFirstLayerBuildable() {
        ArrayList<RoomGridCell> firstLayer = this.grid.getAllCellsWhere(c -> c.getFloor() < this.floorsPerLayer);
        for (RoomGridCell cell : firstLayer) {
            cell.setBuildable();
        }
    }

    private void addSupportIfFirstLayer(int layer, RoomGrid.Area2D area) {
        this.addSupportIfFirstLayer(layer, area.start.getX(), area.start.getZ(), area.sizeX, area.sizeZ);
    }

    private void addSupportIfFirstLayer(int layer, int gridIndexX, int gridIndexZ, int roomsX, int roomsZ) {
        if (layer == 0) {
            BlockPos startCorner = this.grid.getCellAt(0, gridIndexX, gridIndexZ).getOriginOffset();
            this.supportAreas.add(new SupportArea(startCorner, roomsX, roomsZ));
        }
    }

    public List<SupportArea> getSupportAreas() {
        return this.supportAreas;
    }

    private void placeTowers() {
        block0: for (int floor = 0; floor < this.usedFloors; floor += this.floorsPerLayer) {
            HashSet<EnumFacing> sidesToCheck = new HashSet<EnumFacing>(Arrays.asList(EnumFacing.field_176754_o));
            int f = floor;
            ArrayList<RoomGridCell> candidateCells = this.grid.getAllCellsWhere(c -> c.getFloor() == f && c.isPopulated());
            Collections.shuffle(candidateCells, this.random);
            for (RoomGridCell cell : candidateCells) {
                for (EnumFacing side : sidesToCheck) {
                    int maxHeight;
                    boolean canBuild;
                    if (floor == 0) {
                        canBuild = this.grid.cellIsOuterEdge(cell, side) && this.grid.canAttachTower(cell, side);
                    } else {
                        boolean bl = canBuild = this.grid.adjacentCellIsWalkableRoof(cell, side) && this.grid.canAttachTower(cell, side);
                    }
                    if (!canBuild || (maxHeight = this.usedFloors - floor + 1) <= 3) continue;
                    int height = 3 + this.random.nextInt(maxHeight - 3);
                    this.addTower(cell.getGridPosition().move(side), height, side.func_176734_d());
                    sidesToCheck.remove(side);
                    this.addSupportIfFirstLayer(floor, cell.getGridX(), cell.getGridZ(), 1, 1);
                    continue block0;
                }
            }
        }
    }

    private void addTower(RoomGridPosition position, int height, EnumFacing alignment) {
        int x = position.getX();
        int z = position.getZ();
        int startFloor = position.getFloor();
        CastleRoomTowerSquare tower = null;
        RoomGridCell cell = null;
        for (int floor = startFloor; floor < startFloor + height; ++floor) {
            cell = this.grid.getCellAt(floor, x, z);
            if (cell == null) {
                CQRMain.logger.info("Tried to place a tower @ null cell");
                continue;
            }
            tower = new CastleRoomTowerSquare(this.roomSize, this.floorHeight, alignment, this.roomSize, tower, cell.getFloor(), this.random);
            cell.setRoom(tower);
        }
        if (tower != null && this.grid.withinGridBounds(startFloor + height, x, z)) {
            cell = this.grid.getCellAt(startFloor + height, x, z);
            if (DungeonGenUtils.percentageRandom(50, this.random)) {
                cell.setRoom(new CastleRoomWalkableRoofTower(this.roomSize, this.floorHeight, tower, cell.getFloor(), this.random));
            } else {
                BlockPos startPos = cell.getOriginOffset().func_177978_c().func_177976_e();
                this.castleRoofs.add(CastleRoofFactory.createRoof(this.dungeon.getRandomTowerRoofType(this.random), startPos, tower.getRoomLengthX() + 1, tower.getRoomLengthZ() + 1));
            }
        }
    }

    private void placeBridges() {
        ArrayList<RoomGridCell> populated = this.grid.getAllCellsWhere(c -> c.isPopulated() && c.getFloor() > 0 && !(c.getRoom() instanceof CastleRoomReplacedRoof));
        for (RoomGridCell cell : populated) {
            ArrayList<EnumFacing> possibleDirections = cell.getPotentialBridgeDirections();
            if (possibleDirections.isEmpty()) continue;
            ArrayList<EnumFacing> validDirections = new ArrayList<EnumFacing>();
            for (EnumFacing direction : possibleDirections) {
                ArrayList<RoomGridCell> bridgeCells = this.grid.getBridgeCells(cell, direction);
                if (bridgeCells.size() < this.dungeon.getMinBridgeLength() || bridgeCells.size() > this.dungeon.getMaxBridgeLength()) continue;
                validDirections.add(direction);
            }
            if (validDirections.isEmpty() || !DungeonGenUtils.percentageRandom(this.dungeon.getBridgeChance(), this.random)) continue;
            Collections.shuffle(validDirections, this.random);
            EnumFacing selectedDirection = (EnumFacing)validDirections.get(0);
            cell.addDoorOnSideCentered(selectedDirection, EnumCastleDoorType.RANDOM, this.random);
            if (cell.getRoom() instanceof CastleRoomWalkableRoof) {
                cell.removeWall(selectedDirection);
            }
            ArrayList<RoomGridCell> bridgeCells = this.grid.getBridgeCells(cell, selectedDirection);
            for (RoomGridCell bridgeCell : bridgeCells) {
                if (bridgeCell.isPopulated()) continue;
                CastleRoomBridgeTop bridgeRoom = new CastleRoomBridgeTop(this.roomSize, this.floorHeight, selectedDirection, bridgeCell.getFloor(), this.random);
                bridgeCell.setRoom(bridgeRoom);
            }
            RoomGridCell endCell = this.grid.getAdjacentCell(bridgeCells.get(bridgeCells.size() - 1), selectedDirection);
            if (endCell == null || !endCell.isPopulated()) continue;
            endCell.addDoorOnSideCentered(selectedDirection.func_176734_d(), EnumCastleDoorType.RANDOM, this.random);
            if (!(endCell.getRoom() instanceof CastleRoomWalkableRoof)) continue;
            endCell.removeWall(selectedDirection.func_176734_d());
        }
    }

    private void randomizeRooms() {
        ArrayList<RoomGridCell> unTyped = this.grid.getAllCellsWhere(RoomGridCell::needsRoomType);
        while (!unTyped.isEmpty()) {
            RoomGridCell rootCell = unTyped.get(this.random.nextInt(unTyped.size()));
            RoomGrid.Area2D availableCells = this.grid.getPotentialRoomBuildArea(rootCell.getGridPosition());
            int availableX = availableCells.sizeX;
            int availableZ = availableCells.sizeZ;
            EnumRoomType type = this.dungeon.getRandomRoom(this.random);
            int maxX = Math.min(type.getMaxXCells(), availableX);
            int maxZ = Math.min(type.getMaxZCells(), availableZ);
            int sizeX = maxX > 1 ? 1 + this.random.nextInt(maxX - 1) : 1;
            int sizeZ = maxZ > 1 ? 1 + this.random.nextInt(maxZ - 1) : 1;
            ArrayList<CastleRoomBase> blockRooms = new ArrayList<CastleRoomBase>();
            for (int x = 0; x < sizeX; ++x) {
                for (int z = 0; z < sizeZ; ++z) {
                    RoomGridCell buildCell = this.grid.getCellAt(rootCell.getFloor(), rootCell.getGridX() + x, rootCell.getGridZ() + z);
                    CastleRoomDecoratedBase roomToBuild = RoomFactoryCastle.CreateGenericRoom(type, this.roomSize, this.floorHeight, buildCell.getFloor(), this.random);
                    buildCell.setRoom(roomToBuild);
                    blockRooms.add(roomToBuild);
                    if (x != 0 || z != 0 || roomToBuild == null) continue;
                    roomToBuild.setAsRootRoom();
                }
            }
            for (CastleRoomBase room : blockRooms) {
                room.setRoomsInBlock(blockRooms);
            }
            unTyped = this.grid.getAllCellsWhere(RoomGridCell::needsRoomType);
        }
    }

    private void addBossRooms() {
        RoomGrid.Area2D bossArea = this.grid.getBossArea();
        if (bossArea != null && bossArea.dimensionsAreAtLeast(this.minRoomsForBoss, this.minRoomsForBoss + 1)) {
            boolean horizontal = bossArea.sizeX > bossArea.sizeZ;
            int longSideLen = horizontal ? bossArea.sizeX : bossArea.sizeZ;
            int shortSideLen = horizontal ? bossArea.sizeZ : bossArea.sizeX;
            boolean dualStairs = shortSideLen % 2 == 0;
            HashMap<RoomGridPosition, EnumFacing> possibleStairs = new HashMap<RoomGridPosition, EnumFacing>();
            EnumFacing alongLongSide = horizontal ? EnumFacing.EAST : EnumFacing.SOUTH;
            EnumFacing alongShortSide = horizontal ? EnumFacing.SOUTH : EnumFacing.EAST;
            int shortSideOffset = dualStairs ? shortSideLen / 2 - 1 : shortSideLen / 2;
            RoomGridPosition closePos = bossArea.start.move(alongShortSide, shortSideOffset);
            possibleStairs.put(closePos, alongLongSide);
            possibleStairs.put(closePos.move(alongLongSide, longSideLen - 1), alongLongSide.func_176734_d());
            for (RoomGridPosition gridPos : new ArrayList(possibleStairs.keySet())) {
                if (this.cellValidForDirectedStairs(gridPos, (EnumFacing)possibleStairs.get(gridPos))) continue;
                possibleStairs.remove(gridPos);
            }
            if (!possibleStairs.isEmpty()) {
                RoomGridCell cell;
                ArrayList stairPosList = new ArrayList(possibleStairs.keySet());
                RoomGridPosition topOfBossStairs = (RoomGridPosition)stairPosList.remove(this.random.nextInt(stairPosList.size()));
                RoomGridPosition bottomOfBossStairs = topOfBossStairs.move(EnumFacing.DOWN);
                EnumFacing stairDoorSide = (EnumFacing)possibleStairs.get(topOfBossStairs);
                if (dualStairs) {
                    cell = this.grid.getCellAt(bottomOfBossStairs);
                    CastleRoomBossStairMain stairMain = new CastleRoomBossStairMain(this.roomSize, this.floorHeight, stairDoorSide, bottomOfBossStairs.getFloor(), this.random);
                    cell.setRoom(stairMain);
                    cell = this.grid.getCellAt(bottomOfBossStairs.move(alongShortSide));
                    CastleRoomBossStairEmpty stairEmpty = new CastleRoomBossStairEmpty(this.roomSize, this.floorHeight, stairDoorSide, bottomOfBossStairs.getFloor(), this.random);
                    cell.setRoom(stairEmpty);
                    cell = this.grid.getCellAt(topOfBossStairs);
                    CastleRoomBossLandingMain landingMain = new CastleRoomBossLandingMain(this.roomSize, this.floorHeight, stairDoorSide, topOfBossStairs.getFloor(), this.random);
                    cell.setRoom(landingMain);
                    cell = this.grid.getCellAt(topOfBossStairs.move(alongShortSide));
                    CastleRoomBossLandingEmpty landingEmpty = new CastleRoomBossLandingEmpty(this.roomSize, this.floorHeight, stairDoorSide, topOfBossStairs.getFloor(), this.random);
                    cell.setRoom(landingEmpty);
                } else {
                    cell = this.grid.getCellAt(bottomOfBossStairs);
                    CastleRoomStaircaseDirected stair = new CastleRoomStaircaseDirected(this.roomSize, this.floorHeight, stairDoorSide, bottomOfBossStairs.getFloor(), this.random);
                    cell.setRoom(stair);
                    cell = this.grid.getCellAt(topOfBossStairs);
                    CastleRoomLandingDirectedBoss landing = new CastleRoomLandingDirectedBoss(this.roomSize, this.floorHeight, stair, topOfBossStairs.getFloor(), this.random);
                    cell.setRoom(landing);
                }
                RoomGridPosition rootPos = bossArea.start;
                if (stairDoorSide == EnumFacing.SOUTH) {
                    rootPos = rootPos.move(EnumFacing.SOUTH);
                } else if (stairDoorSide == EnumFacing.EAST) {
                    rootPos = rootPos.move(EnumFacing.EAST);
                }
                RoomGridCell bossCell = this.grid.getCellAt(rootPos);
                CastleRoomRoofBossMain rootRoom = new CastleRoomRoofBossMain(this.roomSize, this.floorHeight, rootPos.getFloor(), this.random);
                bossCell.setRoom(rootRoom);
                bossCell.setBossRoomCell();
                for (int x = 0; x < this.minRoomsForBoss; ++x) {
                    for (int z = 0; z < this.minRoomsForBoss; ++z) {
                        if (x == 0 && z == 0) continue;
                        RoomGridPosition emptyRoomPos = rootPos.move(EnumFacing.EAST, x).move(EnumFacing.SOUTH, z);
                        RoomGridCell roofCell = this.grid.getCellAt(emptyRoomPos);
                        CastleRoomRoofBossEmpty emptyRoom = new CastleRoomRoofBossEmpty(this.roomSize, this.floorHeight, emptyRoomPos.getFloor(), this.random);
                        roofCell.setRoom(emptyRoom);
                        roofCell.setBossRoomCell();
                    }
                }
                EnumFacing snapToSide = stairDoorSide.func_176734_d();
                if (snapToSide == EnumFacing.NORTH) {
                    int distFromEdge = bossArea.sizeX * this.roomSize - rootRoom.getStaticSize();
                    int x = distFromEdge / 2 + 1;
                    rootRoom.setBossBuildOffset(new Vec3i(x, 0, 0));
                } else if (snapToSide == EnumFacing.WEST) {
                    int distFromEdge = bossArea.sizeZ * this.roomSize - rootRoom.getStaticSize();
                    int z = distFromEdge / 2 + 1;
                    rootRoom.setBossBuildOffset(new Vec3i(0, 0, z));
                } else if (snapToSide == EnumFacing.SOUTH) {
                    int distFromEdge = bossArea.sizeX * this.roomSize - rootRoom.getStaticSize();
                    int x = distFromEdge / 2 + 1;
                    int z = distFromEdge + 1;
                    rootRoom.setBossBuildOffset(new Vec3i(x, 0, z));
                } else {
                    int distFromEdge = bossArea.sizeZ * this.roomSize - rootRoom.getStaticSize();
                    int z = distFromEdge / 2 + 1;
                    int x = distFromEdge + 1;
                    rootRoom.setBossBuildOffset(new Vec3i(x, 0, z));
                }
            }
        } else {
            CQRMain.logger.warn("Error adding boss rooms: boss area was never set during castle shaping.");
        }
    }

    public boolean cellValidForDirectedStairs(RoomGridPosition position, EnumFacing direction) {
        RoomGridCell stairCell = this.grid.getCellAt(position);
        RoomGridCell roomToStairs = this.grid.getCellAt(position.move(direction));
        if (stairCell != null && stairCell.isBuildable() && roomToStairs != null && roomToStairs.isBuildable()) {
            ArrayList<EnumFacing> outerSides = new ArrayList<EnumFacing>(Arrays.asList(EnumFacing.field_176754_o));
            outerSides.remove(direction);
            for (EnumFacing side : outerSides) {
                RoomGridCell checkCell = this.grid.getAdjacentCell(stairCell, side);
                if (checkCell == null || !checkCell.isSelectedForBuilding()) continue;
                HashSet<RoomGridCell> invalid = new HashSet<RoomGridCell>();
                invalid.add(stairCell);
                LinkedList<PathNode> destToSrcPath = this.findPathBetweenRooms(checkCell, roomToStairs, invalid);
                if (!destToSrcPath.isEmpty()) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    private void linkCells() {
        for (int floor = 0; floor < this.usedFloors; ++floor) {
            this.linkCellsOnFloor(floor);
        }
    }

    private void linkCellsOnFloor(int floor) {
        ArrayList<RoomGridCell> floorCells = this.grid.getAllCellsWhere(c -> c.isPopulated() && c.getFloor() == floor && !c.getRoom().isWalkableRoof());
        for (RoomGridCell cell : floorCells) {
            this.linkCellToAdjacentCells(cell);
        }
    }

    private void linkCellToAdjacentCells(RoomGridCell cell) {
        cell.connectToCell(cell);
        for (EnumFacing direction : EnumFacing.field_176754_o) {
            RoomGridCell adjacent = this.grid.getAdjacentCell(cell, direction);
            if (adjacent == null || !adjacent.isPopulated() || cell.getRoom().getRoomType() != adjacent.getRoom().getRoomType() || adjacent.isConnectedToCell(cell)) continue;
            cell.connectToCell(adjacent);
            cell.connectToCells(adjacent.getConnectedCellsCopy());
        }
        for (RoomGridCell connectedCell : cell.getConnectedCellsCopy()) {
            connectedCell.connectToCells(cell.getConnectedCellsCopy());
        }
        cell.copyRoomPropertiesToConnectedCells();
    }

    private void placeOuterDoors() {
        ArrayList<RoomGridCell> mainEntranceCells = new ArrayList<RoomGridCell>();
        for (int floor = 0; floor < this.usedFloors; floor += this.floorsPerLayer) {
            HashSet<EnumFacing> doorDirections = new HashSet<EnumFacing>();
            int f = floor;
            ArrayList<RoomGridCell> floorRooms = this.grid.getAllCellsWhere(r -> r.getFloor() == f && r.isPopulated() && !r.getRoom().isTower() && !r.getRoom().isWalkableRoof());
            Collections.shuffle(floorRooms, this.random);
            block1: for (RoomGridCell cell : floorRooms) {
                for (EnumFacing side : EnumFacing.field_176754_o) {
                    boolean buildExit;
                    if (doorDirections.contains(side) || !cell.getRoom().canBuildDoorOnSide(side) || !(buildExit = floor == 0 ? !this.grid.adjacentCellIsPopulated(cell, side) : this.grid.adjacentCellIsWalkableRoof(cell, side))) continue;
                    doorDirections.add(side);
                    if (floor == 0) {
                        cell.addDoorOnSideCentered(side, EnumCastleDoorType.GRAND_ENTRY, this.random);
                        mainEntranceCells.add(cell);
                        continue block1;
                    }
                    cell.addDoorOnSideCentered(side, EnumCastleDoorType.RANDOM, this.random);
                    continue block1;
                }
            }
        }
        if (!mainEntranceCells.isEmpty()) {
            Collections.shuffle(mainEntranceCells, this.random);
            ((RoomGridCell)mainEntranceCells.get(0)).setReachable();
        }
    }

    private void addHallways() {
        for (int floor = 0; floor < this.grid.getBossArea().start.getFloor() - 1; ++floor) {
            ArrayList<RoomGridCell> hallwayCells;
            RoomGridPosition hallStartGridPos;
            boolean horizontal;
            ArrayList<RoomGrid.Area2D> largestAreas = this.grid.getAllGridAreasWhere(floor, RoomGridCell::isValidHallwayRoom, 2, 2);
            if (largestAreas.isEmpty()) continue;
            RoomGrid.Area2D hallwayArea = (RoomGrid.Area2D)largestAreas.get(0);
            boolean bl = hallwayArea.sizeX == hallwayArea.sizeZ ? this.random.nextBoolean() : (horizontal = hallwayArea.sizeX > hallwayArea.sizeZ);
            if (horizontal) {
                int zIndex = DungeonGenUtils.randomBetweenGaussian(hallwayArea.getStartZ(), hallwayArea.getEndZ(), this.random);
                hallStartGridPos = new RoomGridPosition(floor, hallwayArea.getStartX(), zIndex);
                hallwayCells = this.grid.getAdjacentSelectedCellsInRow(hallStartGridPos);
                for (RoomGridCell hallwayCell : hallwayCells) {
                    hallwayCell.setRoom(new CastleRoomHallway(this.roomSize, this.floorHeight, CastleRoomHallway.Alignment.HORIZONTAL, hallwayCell.getFloor(), this.random));
                }
                continue;
            }
            int xIndex = DungeonGenUtils.randomBetweenGaussian(hallwayArea.getStartX(), hallwayArea.getEndX(), this.random);
            hallStartGridPos = new RoomGridPosition(floor, xIndex, hallwayArea.getStartZ());
            hallwayCells = this.grid.getAdjacentSelectedCellsInColumn(hallStartGridPos);
            for (RoomGridCell hallwayCell : hallwayCells) {
                hallwayCell.setRoom(new CastleRoomHallway(this.roomSize, this.floorHeight, CastleRoomHallway.Alignment.VERTICAL, hallwayCell.getFloor(), this.random));
            }
            if (floor != 0) continue;
            if (this.random.nextBoolean()) {
                hallwayCells.get(0).addOuterWall(EnumFacing.NORTH);
                hallwayCells.get(0).addDoorOnSideCentered(EnumFacing.NORTH, EnumCastleDoorType.GRAND_ENTRY, this.random);
                hallwayCells.get(0).setReachable();
                continue;
            }
            hallwayCells.get(hallwayCells.size() - 1).addOuterWall(EnumFacing.SOUTH);
            hallwayCells.get(hallwayCells.size() - 1).addDoorOnSideCentered(EnumFacing.SOUTH, EnumCastleDoorType.GRAND_ENTRY, this.random);
            hallwayCells.get(hallwayCells.size() - 1).setReachable();
        }
    }

    private void addStairCases() {
        for (int floor = 0; floor < this.usedFloors; ++floor) {
            int f = floor;
            ArrayList<RoomGridCell> candidateCells = this.grid.getAllCellsWhere(r -> r.getFloor() == f && r.needsRoomType());
            Collections.shuffle(candidateCells, this.random);
            for (RoomGridCell cell : candidateCells) {
                RoomGridCell aboveCell = this.grid.getAdjacentCell(cell, EnumFacing.UP);
                if (aboveCell == null || !aboveCell.needsRoomType() || aboveCell.isOnFloorWithLanding()) continue;
                CastleRoomStaircaseSpiral stairs = new CastleRoomStaircaseSpiral(this.roomSize, this.floorHeight, cell.getFloor(), this.random);
                cell.setRoom(stairs);
                CastleRoomLandingSpiral landing = new CastleRoomLandingSpiral(this.roomSize, this.floorHeight, stairs, aboveCell.getFloor(), this.random);
                aboveCell.setRoom(landing);
                aboveCell.setReachable();
                aboveCell.setLandingForAllPathableCells();
            }
        }
    }

    private boolean buildDirectedStairsIfPossible(RoomGridCell cell) {
        EnumFacing side = this.getValidStairDoorSide(cell);
        if (side != EnumFacing.DOWN) {
            RoomGridCell aboveCell = this.grid.getAdjacentCell(cell, EnumFacing.UP);
            CastleRoomStaircaseDirected stairs = new CastleRoomStaircaseDirected(this.roomSize, this.floorHeight, side, cell.getFloor(), this.random);
            cell.setRoom(stairs);
            cell.addDoorOnSideCentered(side, EnumCastleDoorType.RANDOM, this.random);
            aboveCell.setRoom(new CastleRoomLandingDirected(this.roomSize, this.floorHeight, stairs, aboveCell.getFloor(), this.random));
            aboveCell.setReachable();
            return true;
        }
        return false;
    }

    private EnumFacing getValidStairDoorSide(RoomGridCell cell) {
        RoomGridCell aboveCell = this.grid.getAdjacentCell(cell, EnumFacing.UP);
        if (aboveCell != null && !aboveCell.isPopulated()) {
            for (EnumFacing side : EnumFacing.field_176754_o) {
                RoomGridCell adjacent = this.grid.getAdjacentCell(cell, side);
                if (adjacent == null || !adjacent.needsRoomType() || this.grid.cellBordersRoomType(cell, EnumRoomType.LANDING_DIRECTED) || this.grid.cellBordersRoomType(adjacent, EnumRoomType.LANDING_DIRECTED) || !this.grid.adjacentCellIsSelected(aboveCell, side) || this.grid.adjacentCellIsPopulated(aboveCell, side)) continue;
                return side;
            }
        }
        return EnumFacing.DOWN;
    }

    private void pathBetweenRooms() {
        for (int floor = 0; floor < this.maxFloors; ++floor) {
            int f = floor;
            ArrayList<RoomGridCell> unreachable = this.grid.getAllCellsWhere(c -> c.getFloor() == f && c.isValidPathStart());
            ArrayList<RoomGridCell> reachable = this.grid.getAllCellsWhere(c -> c.getFloor() == f && c.isValidPathDestination());
            while (!unreachable.isEmpty() && !reachable.isEmpty()) {
                RoomGridCell srcRoom = unreachable.get(this.random.nextInt(unreachable.size()));
                HashSet<RoomGridCell> pathableFromSrc = srcRoom.getPathableCellsCopy();
                pathableFromSrc.remove(srcRoom);
                pathableFromSrc.removeIf(c -> !c.isReachable());
                RoomGridCell destRoom = this.findNearestReachableRoom(srcRoom, pathableFromSrc);
                if (destRoom != null) {
                    LinkedList<PathNode> destToSrcPath = this.findPathBetweenRooms(srcRoom, destRoom, null);
                    if (!destToSrcPath.isEmpty()) {
                        for (PathNode node : destToSrcPath) {
                            RoomGridCell cell = this.grid.getCellAt(node.getCell().getGridPosition());
                            if (cell == null) continue;
                            if (node.getParent() != null) {
                                cell.addDoorOnSideRandomOffset(node.getParentDirection(), EnumCastleDoorType.RANDOM, this.random);
                            }
                            cell.setAllLinkedReachable(unreachable, reachable);
                        }
                        continue;
                    }
                    CQRMain.logger.info("Failed to find path from {} to {}", (Object)srcRoom.getGridPosition(), (Object)destRoom.getGridPosition());
                    continue;
                }
                CQRMain.logger.info("{} had no pathable rooms!", (Object)srcRoom);
                for (EnumFacing side : EnumFacing.field_176754_o) {
                    if (!srcRoom.getRoom().canBuildDoorOnSide(side)) continue;
                    srcRoom.addDoorOnSideCentered(side, EnumCastleDoorType.RANDOM, this.random);
                }
                unreachable.remove(srcRoom);
                reachable.add(srcRoom);
            }
        }
    }

    private LinkedList<PathNode> findPathBetweenRooms(RoomGridCell startCell, RoomGridCell endCell, @Nullable HashSet<RoomGridCell> invalidCells) {
        LinkedList<PathNode> open = new LinkedList<PathNode>();
        LinkedList<PathNode> closed = new LinkedList<PathNode>();
        LinkedList<PathNode> path = new LinkedList<PathNode>();
        if (invalidCells == null) {
            invalidCells = new HashSet();
        }
        open.add(new PathNode(null, EnumFacing.DOWN, startCell, 0.0, startCell.distanceTo(endCell)));
        while (!open.isEmpty()) {
            PathNode currentNode;
            open.sort(Comparator.comparingDouble(PathNode::getF));
            if (currentNode.getCell() == endCell) {
                for (currentNode = (PathNode)open.removeFirst(); currentNode != null; currentNode = currentNode.getParent()) {
                    path.add(currentNode);
                }
                break;
            }
            closed.add(currentNode);
            double neighborG = currentNode.getG() + 1.0;
            for (EnumFacing direction : EnumFacing.field_176754_o) {
                RoomGridCell neighborCell;
                if (!currentNode.getCell().reachableFromSide(direction) || (neighborCell = this.grid.getAdjacentCell(currentNode.getCell(), direction)) == null || !neighborCell.isPopulated() || !neighborCell.reachableFromSide(direction.func_176734_d()) || invalidCells.contains(neighborCell)) continue;
                PathNode neighborNode = new PathNode(currentNode, direction.func_176734_d(), neighborCell, neighborG, neighborCell.distanceTo(endCell));
                boolean cellAlreadyClosed = this.nodeListContainsCell(closed, neighborCell);
                if (cellAlreadyClosed) continue;
                boolean cellAlreadyOpen = this.nodeListContainsCell(open, neighborCell);
                if (cellAlreadyOpen) {
                    PathNode openNode = this.getNodeThatContainsCell(open, neighborCell);
                    if (!(openNode.getG() > neighborG)) continue;
                    openNode.updateParent(currentNode);
                    openNode.updateG(neighborG);
                    continue;
                }
                open.add(neighborNode);
            }
        }
        return path;
    }

    private boolean nodeListContainsCell(LinkedList<PathNode> nodeList, RoomGridCell cell) {
        return this.getNodeThatContainsCell(nodeList, cell) != null;
    }

    private PathNode getNodeThatContainsCell(LinkedList<PathNode> nodeList, RoomGridCell cell) {
        if (!nodeList.isEmpty()) {
            for (PathNode n : nodeList) {
                if (n.getCell() != cell) continue;
                return n;
            }
        }
        return null;
    }

    @Nullable
    private RoomGridCell findNearestReachableRoom(RoomGridCell origin, HashSet<RoomGridCell> pathableRooms) {
        ArrayList<RoomGridCell> sorted = new ArrayList<RoomGridCell>(pathableRooms);
        if (!sorted.isEmpty()) {
            sorted.sort((c1, c2) -> Double.compare(this.grid.distanceBetweenCells2D(origin, (RoomGridCell)c1), this.grid.distanceBetweenCells2D(origin, (RoomGridCell)c2)));
            return sorted.get(0);
        }
        return null;
    }

    private void determineWalls() {
        for (CastleMainStructWall wall : this.grid.getWallListCopy()) {
            wall.determineIfEnabled(this.random);
        }
    }

    private void determineWalkableRoofWalls(RoomGridCell cell) {
        for (EnumFacing side : EnumFacing.field_176754_o) {
            if (this.grid.adjacentCellIsPopulated(cell, side)) continue;
            cell.addRoofEdgeWall(side);
        }
    }

    private void determineNormalRoomWalls(RoomGridCell cell) {
        boolean outerEast;
        boolean outerSouth;
        boolean bl = outerSouth = !this.grid.adjacentCellIsFullRoom(cell, EnumFacing.SOUTH);
        if (outerSouth) {
            cell.addOuterWall(EnumFacing.SOUTH);
        } else if (!cell.isConnectedToCell(this.grid.getAdjacentCell(cell, EnumFacing.SOUTH))) {
            cell.addInnerWall(EnumFacing.SOUTH);
        }
        boolean bl2 = outerEast = !this.grid.adjacentCellIsFullRoom(cell, EnumFacing.EAST);
        if (outerEast) {
            cell.addOuterWall(EnumFacing.EAST);
        } else if (!cell.isConnectedToCell(this.grid.getAdjacentCell(cell, EnumFacing.EAST))) {
            cell.addInnerWall(EnumFacing.EAST);
        }
        if (!this.grid.adjacentCellIsFullRoom(cell, EnumFacing.NORTH)) {
            cell.addOuterWall(EnumFacing.NORTH);
        }
        if (!this.grid.adjacentCellIsFullRoom(cell, EnumFacing.WEST)) {
            cell.addOuterWall(EnumFacing.WEST);
        }
    }

    private void determineRoofs() {
        ArrayList<RoomGrid.Area2D> roofAreas = new ArrayList<RoomGrid.Area2D>();
        ArrayList<RoomGridCell> roofCells = this.grid.getAllCellsWhere(c -> this.grid.cellIsValidForRoof((RoomGridCell)c));
        for (int floor = this.floorsPerLayer; floor < this.usedFloors; floor += this.floorsPerLayer) {
            roofAreas.addAll(this.grid.getAllGridAreasWhere(floor, c -> this.grid.cellIsValidForRoof((RoomGridCell)c), 1, 2));
        }
        for (RoomGrid.Area2D roofArea : roofAreas) {
            if (!this.random.nextBoolean()) continue;
            this.addRoofFromRoofArea(roofArea);
            for (RoomGridPosition areaPos : roofArea.getPositionList()) {
                roofCells.remove(this.grid.getCellAt(areaPos));
                this.grid.getCellAt(areaPos).setRoom(new CastleRoomReplacedRoof(this.roomSize, this.floorHeight, areaPos.getFloor(), this.random));
            }
        }
        for (RoomGridCell cell : roofCells) {
            cell.setRoom(new CastleRoomWalkableRoof(this.roomSize, this.floorHeight, cell.getFloor(), this.random));
        }
    }

    private void addRoofFromRoofArea(RoomGrid.Area2D roofArea) {
        RoomGridCell roofStartCell = this.grid.getCellAt(roofArea.start);
        BlockPos roofStart = roofStartCell.getOriginOffset();
        roofStart = roofStart.func_177978_c().func_177976_e();
        int sizeX = roofArea.sizeX * (this.roomSize + 1) + 1;
        int sizeZ = roofArea.sizeZ * (this.roomSize + 1) + 1;
        this.castleRoofs.add(CastleRoofFactory.createRoof(this.dungeon.getRandomRoofType(this.random), roofStart, sizeX, sizeZ));
    }

    private int getBossFloor() {
        if (this.grid.getBossArea() != null) {
            return this.grid.getBossArea().start.getFloor();
        }
        return 0;
    }

    private class PathNode {
        private PathNode parent;
        private EnumFacing parentDirection;
        private RoomGridCell cell;
        private double f;
        private double g;
        private double h;

        private PathNode(PathNode parent, EnumFacing parentDirection, RoomGridCell cell, double g, double h) {
            this.parent = parent;
            this.parentDirection = parentDirection;
            this.cell = cell;
            this.g = g;
            this.h = h;
            this.f = g + h;
        }

        public RoomGridCell getCell() {
            return this.cell;
        }

        public PathNode getParent() {
            return this.parent;
        }

        public double getF() {
            return this.f;
        }

        public double getG() {
            return this.g;
        }

        public EnumFacing getParentDirection() {
            return this.parentDirection;
        }

        public void updateParent(PathNode parent) {
            this.parent = parent;
        }

        public void updateG(double g) {
            this.g = g;
            this.f = g + this.h;
        }
    }

    public class SupportArea {
        private BlockPos nwCorner;
        private int blocksX;
        private int blocksZ;
        private int PADDING_PER_SIDE = 2;

        private SupportArea(BlockPos nwCorner, int xCells, int zCells) {
            this.blocksX = xCells * CastleRoomSelector.this.roomSize + this.PADDING_PER_SIDE * 2;
            this.blocksZ = zCells * CastleRoomSelector.this.roomSize + this.PADDING_PER_SIDE * 2;
            this.nwCorner = nwCorner.func_177964_d(this.PADDING_PER_SIDE).func_177985_f(this.PADDING_PER_SIDE);
        }

        public BlockPos getNwCorner() {
            return this.nwCorner;
        }

        public int getBlocksX() {
            return this.blocksX;
        }

        public int getBlocksZ() {
            return this.blocksZ;
        }
    }
}

