/*
 * Decompiled with CFR 0.152.
 */
package team.cqr.cqrepoured.structuregen.generators.castleparts.rooms;

import java.util.Random;
import java.util.function.Predicate;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import team.cqr.cqrepoured.structuregen.dungeons.DungeonRandomizedCastle;
import team.cqr.cqrepoured.structuregen.generators.castleparts.rooms.CastleRoomBase;
import team.cqr.cqrepoured.structuregen.generators.castleparts.rooms.EnumRoomType;
import team.cqr.cqrepoured.util.BlockStateGenArray;
import team.cqr.cqrepoured.util.GenerationTemplate;

public class CastleRoomBridgeTop
extends CastleRoomBase {
    protected Alignment alignment;

    public CastleRoomBridgeTop(int sideLength, int height, EnumFacing direction, int floor, Random rand) {
        super(sideLength, height, floor, rand);
        this.roomType = EnumRoomType.BRIDGE_TOP;
        this.defaultCeiling = false;
        this.defaultFloor = false;
        this.alignment = Alignment.fromFacing(direction);
    }

    @Override
    public void generateRoom(BlockPos castleOrigin, BlockStateGenArray genArray, DungeonRandomizedCastle dungeon) {
        Predicate<Vec3i> edges;
        Predicate<Vec3i> bottom;
        boolean startX = true;
        boolean startZ = true;
        int endX = this.getRoomLengthX() - 3;
        int endZ = this.getRoomLengthZ() - 3;
        GenerationTemplate bridgeTopTemplate = new GenerationTemplate(this.getDecorationLengthX(), this.getDecorationLengthY(), this.getDecorationLengthZ());
        if (this.alignment == Alignment.HORIZONTAL) {
            bottom = v -> v.func_177956_o() == 0 && v.func_177952_p() >= 1 && v.func_177952_p() <= endZ;
            edges = v -> v.func_177956_o() == 1 && (v.func_177952_p() == 1 || v.func_177952_p() == endZ);
        } else {
            bottom = v -> v.func_177956_o() == 0 && v.func_177958_n() >= 1 && v.func_177958_n() <= endX;
            edges = v -> v.func_177956_o() == 1 && (v.func_177958_n() == 1 || v.func_177958_n() == endX);
        }
        bridgeTopTemplate.addRule(bottom, dungeon.getMainBlockState());
        bridgeTopTemplate.addRule(edges, dungeon.getFancyBlockState());
        bridgeTopTemplate.AddToGenArray(this.getNonWallStartPos(), genArray, BlockStateGenArray.GenerationPhase.MAIN);
    }

    @Override
    public boolean canBuildDoorOnSide(EnumFacing side) {
        return Alignment.fromFacing(side) == this.alignment;
    }

    @Override
    public boolean reachableFromSide(EnumFacing side) {
        return Alignment.fromFacing(side) == this.alignment;
    }

    public static enum Alignment {
        VERTICAL,
        HORIZONTAL;


        static Alignment fromFacing(EnumFacing facing) {
            return facing.func_176740_k() == EnumFacing.Axis.X ? HORIZONTAL : VERTICAL;
        }
    }
}

