/*
 * Decompiled with CFR 0.152.
 */
package team.cqr.cqrepoured.structuregen.generators.castleparts.rooms;

import java.util.Random;
import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import team.cqr.cqrepoured.structuregen.dungeons.DungeonRandomizedCastle;
import team.cqr.cqrepoured.structuregen.generators.castleparts.rooms.CastleRoomBase;
import team.cqr.cqrepoured.structuregen.generators.castleparts.rooms.CastleRoomGenericBase;
import team.cqr.cqrepoured.structuregen.generators.castleparts.rooms.EnumRoomType;
import team.cqr.cqrepoured.structuregen.generators.castleparts.rooms.decoration.IRoomDecor;
import team.cqr.cqrepoured.structuregen.generators.castleparts.rooms.decoration.RoomDecorTypes;
import team.cqr.cqrepoured.util.BlockStateGenArray;

public class CastleRoomHallway
extends CastleRoomGenericBase {
    private Alignment alignment;
    EnumFacing patternStartFacing;

    public CastleRoomHallway(int sideLength, int height, Alignment alignment, int floor, Random rand) {
        super(sideLength, height, floor, rand);
        this.roomType = EnumRoomType.HALLWAY;
        this.alignment = alignment;
        this.defaultFloor = true;
        this.defaultCeiling = true;
        this.patternStartFacing = EnumFacing.field_176754_o[this.random.nextInt(EnumFacing.field_176754_o.length)];
    }

    @Override
    protected void generateDefaultFloor(BlockStateGenArray genArray, DungeonRandomizedCastle dungeon) {
        for (int z = 0; z < this.getDecorationLengthZ(); ++z) {
            for (int x = 0; x < this.getDecorationLengthX(); ++x) {
                BlockPos pos = this.getNonWallStartPos().func_177982_a(x, 0, z);
                IBlockState tcBlock = Blocks.field_192434_dI.func_176223_P();
                EnumFacing tcFacing = pos.func_177952_p() % 2 == 0 ? (pos.func_177958_n() % 2 == 0 ? this.patternStartFacing : this.patternStartFacing.func_176746_e()) : (pos.func_177958_n() % 2 == 0 ? this.patternStartFacing.func_176735_f() : this.patternStartFacing.func_176746_e().func_176746_e());
                tcBlock = tcBlock.func_177226_a((IProperty)BlockHorizontal.field_185512_D, (Comparable)tcFacing);
                genArray.addBlockState(pos, tcBlock, BlockStateGenArray.GenerationPhase.MAIN, BlockStateGenArray.EnumPriority.MEDIUM);
            }
        }
    }

    @Override
    protected void addMidDecoration(World world, BlockStateGenArray genArray, DungeonRandomizedCastle dungeon) {
        IRoomDecor pillar = RoomDecorTypes.PILLAR;
        int halfX = this.getDecorationLengthX() / 2;
        int halfZ = this.getDecorationLengthZ() / 2;
        BlockPos pillarStart = this.roomOrigin.func_177982_a(--halfX, 1, --halfZ);
        pillar.build(world, genArray, this, dungeon, pillarStart, EnumFacing.NORTH, this.usedDecoPositions);
    }

    @Override
    protected IBlockState getFloorBlock(DungeonRandomizedCastle dungeon) {
        return Blocks.field_192434_dI.func_176223_P();
    }

    @Override
    public void copyPropertiesOf(CastleRoomBase room) {
        if (room instanceof CastleRoomHallway) {
            this.patternStartFacing = ((CastleRoomHallway)room).patternStartFacing;
        }
    }

    public static enum Alignment {
        VERTICAL,
        HORIZONTAL;


        private boolean canHaveInteriorWall(EnumFacing side) {
            if (this == VERTICAL) {
                return side == EnumFacing.WEST || side == EnumFacing.EAST;
            }
            return side == EnumFacing.NORTH || side == EnumFacing.SOUTH;
        }
    }
}

