/*
 * Decompiled with CFR 0.152.
 */
package team.cqr.cqrepoured.structuregen.generators.castleparts.rooms;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.function.Predicate;
import net.minecraft.block.BlockDoor;
import net.minecraft.block.BlockLever;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import team.cqr.cqrepoured.init.CQRBlocks;
import team.cqr.cqrepoured.objects.blocks.BlockSpawner;
import team.cqr.cqrepoured.objects.factories.SpawnerFactory;
import team.cqr.cqrepoured.structuregen.dungeons.DungeonRandomizedCastle;
import team.cqr.cqrepoured.structuregen.generators.castleparts.rooms.CastleRoomDecoratedBase;
import team.cqr.cqrepoured.structuregen.generators.castleparts.rooms.EnumRoomType;
import team.cqr.cqrepoured.structuregen.inhabitants.DungeonInhabitant;
import team.cqr.cqrepoured.tileentity.TileEntitySpawner;
import team.cqr.cqrepoured.util.BlockStateGenArray;
import team.cqr.cqrepoured.util.DungeonGenUtils;
import team.cqr.cqrepoured.util.GenerationTemplate;

public class CastleRoomJailCell
extends CastleRoomDecoratedBase {
    private EnumFacing doorSide;
    private ArrayList<BlockPos> prisonerSpawnerPositions = new ArrayList();

    public CastleRoomJailCell(int sideLength, int height, int floor, Random rand) {
        super(sideLength, height, floor, rand);
        this.roomType = EnumRoomType.JAIL;
        this.defaultCeiling = true;
        this.defaultFloor = true;
        this.doorSide = EnumFacing.field_176754_o[this.random.nextInt(EnumFacing.field_176754_o.length)];
    }

    @Override
    boolean shouldBuildEdgeDecoration() {
        return false;
    }

    @Override
    boolean shouldBuildWallDecoration() {
        return true;
    }

    @Override
    boolean shouldBuildMidDecoration() {
        return false;
    }

    @Override
    boolean shouldAddSpawners() {
        return false;
    }

    @Override
    boolean shouldAddChests() {
        return false;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void generateRoom(BlockPos castleOrigin, BlockStateGenArray genArray, DungeonRandomizedCastle dungeon) {
        Predicate<Vec3i> levers;
        Predicate<Vec3i> doorUpper2;
        Predicate<Vec3i> doorUpper1;
        Predicate<Vec3i> doorLower2;
        Object doorFrame;
        int half;
        int endX = this.getDecorationLengthX() - 1;
        int endZ = this.getDecorationLengthZ() - 1;
        Predicate<Vec3i> northRow = v -> v.func_177952_p() == 1 && v.func_177958_n() >= 1 && v.func_177958_n() <= endX - 1;
        Predicate<Vec3i> southRow = v -> v.func_177952_p() == endZ - 1 && v.func_177958_n() >= 1 && v.func_177958_n() <= endX - 1;
        Predicate<Vec3i> westRow = v -> v.func_177958_n() == 1 && v.func_177952_p() >= 1 && v.func_177952_p() <= endZ - 1;
        Predicate<Vec3i> eastRow = v -> v.func_177958_n() == endX - 1 && v.func_177952_p() >= 1 && v.func_177952_p() <= endZ - 1;
        GenerationTemplate template = new GenerationTemplate(this.getDecorationLengthX(), this.getDecorationLengthY(), this.getDecorationLengthZ());
        if (this.doorSide == EnumFacing.NORTH) {
            half = this.getDecorationLengthX() / 2;
            doorFrame = v -> v.func_177956_o() >= 0 && v.func_177956_o() <= 2 && v.func_177952_p() == 1 && v.func_177958_n() >= half - 1 && v.func_177958_n() <= half + 2;
            Predicate<Vec3i> predicate = v -> v.func_177956_o() == 0 && v.func_177952_p() == 1 && v.func_177958_n() == half;
            doorLower2 = v -> v.func_177956_o() == 0 && v.func_177952_p() == 1 && v.func_177958_n() == half + 1;
            doorUpper1 = v -> v.func_177956_o() == 1 && v.func_177952_p() == 1 && v.func_177958_n() == half;
            doorUpper2 = v -> v.func_177956_o() == 1 && v.func_177952_p() == 1 && v.func_177958_n() == half + 1;
            levers = v -> v.func_177956_o() == 1 && v.func_177952_p() == 0 && (v.func_177958_n() == half - 1 || v.func_177958_n() == half + 2);
            template.addRule(predicate, Blocks.field_150454_av.func_176223_P().func_177226_a((IProperty)BlockDoor.field_176520_a, (Comparable)EnumFacing.SOUTH).func_177226_a((IProperty)BlockDoor.field_176523_O, (Comparable)BlockDoor.EnumDoorHalf.LOWER).func_177226_a((IProperty)BlockDoor.field_176521_M, (Comparable)BlockDoor.EnumHingePosition.RIGHT));
            template.addRule(doorLower2, Blocks.field_150454_av.func_176223_P().func_177226_a((IProperty)BlockDoor.field_176520_a, (Comparable)EnumFacing.SOUTH).func_177226_a((IProperty)BlockDoor.field_176523_O, (Comparable)BlockDoor.EnumDoorHalf.LOWER).func_177226_a((IProperty)BlockDoor.field_176521_M, (Comparable)BlockDoor.EnumHingePosition.LEFT));
            template.addRule(doorUpper1, Blocks.field_150454_av.func_176223_P().func_177226_a((IProperty)BlockDoor.field_176520_a, (Comparable)EnumFacing.SOUTH).func_177226_a((IProperty)BlockDoor.field_176523_O, (Comparable)BlockDoor.EnumDoorHalf.UPPER).func_177226_a((IProperty)BlockDoor.field_176521_M, (Comparable)BlockDoor.EnumHingePosition.RIGHT));
            template.addRule(doorUpper2, Blocks.field_150454_av.func_176223_P().func_177226_a((IProperty)BlockDoor.field_176520_a, (Comparable)EnumFacing.SOUTH).func_177226_a((IProperty)BlockDoor.field_176523_O, (Comparable)BlockDoor.EnumDoorHalf.UPPER).func_177226_a((IProperty)BlockDoor.field_176521_M, (Comparable)BlockDoor.EnumHingePosition.LEFT));
            template.addRule((Predicate<Vec3i>)doorFrame, Blocks.field_150339_S.func_176223_P());
            template.addRule(levers, Blocks.field_150442_at.func_176223_P().func_177226_a((IProperty)BlockLever.field_176360_a, (Comparable)BlockLever.EnumOrientation.NORTH));
        } else if (this.doorSide == EnumFacing.SOUTH) {
            half = this.getDecorationLengthX() / 2;
            doorFrame = v -> v.func_177956_o() >= 0 && v.func_177956_o() <= 2 && v.func_177952_p() == endZ - 1 && v.func_177958_n() >= half - 1 && v.func_177958_n() <= half + 2;
            Predicate<Vec3i> predicate = v -> v.func_177956_o() == 0 && v.func_177952_p() == endZ - 1 && v.func_177958_n() == half;
            doorLower2 = v -> v.func_177956_o() == 0 && v.func_177952_p() == endZ - 1 && v.func_177958_n() == half + 1;
            doorUpper1 = v -> v.func_177956_o() == 1 && v.func_177952_p() == endZ - 1 && v.func_177958_n() == half;
            doorUpper2 = v -> v.func_177956_o() == 1 && v.func_177952_p() == endZ - 1 && v.func_177958_n() == half + 1;
            levers = v -> v.func_177956_o() == 1 && v.func_177952_p() == endZ && (v.func_177958_n() == half - 1 || v.func_177958_n() == half + 2);
            template.addRule(predicate, Blocks.field_150454_av.func_176223_P().func_177226_a((IProperty)BlockDoor.field_176520_a, (Comparable)EnumFacing.NORTH).func_177226_a((IProperty)BlockDoor.field_176523_O, (Comparable)BlockDoor.EnumDoorHalf.LOWER).func_177226_a((IProperty)BlockDoor.field_176521_M, (Comparable)BlockDoor.EnumHingePosition.LEFT));
            template.addRule(doorLower2, Blocks.field_150454_av.func_176223_P().func_177226_a((IProperty)BlockDoor.field_176520_a, (Comparable)EnumFacing.NORTH).func_177226_a((IProperty)BlockDoor.field_176523_O, (Comparable)BlockDoor.EnumDoorHalf.LOWER).func_177226_a((IProperty)BlockDoor.field_176521_M, (Comparable)BlockDoor.EnumHingePosition.RIGHT));
            template.addRule(doorUpper1, Blocks.field_150454_av.func_176223_P().func_177226_a((IProperty)BlockDoor.field_176520_a, (Comparable)EnumFacing.NORTH).func_177226_a((IProperty)BlockDoor.field_176523_O, (Comparable)BlockDoor.EnumDoorHalf.UPPER).func_177226_a((IProperty)BlockDoor.field_176521_M, (Comparable)BlockDoor.EnumHingePosition.LEFT));
            template.addRule(doorUpper2, Blocks.field_150454_av.func_176223_P().func_177226_a((IProperty)BlockDoor.field_176520_a, (Comparable)EnumFacing.NORTH).func_177226_a((IProperty)BlockDoor.field_176523_O, (Comparable)BlockDoor.EnumDoorHalf.UPPER).func_177226_a((IProperty)BlockDoor.field_176521_M, (Comparable)BlockDoor.EnumHingePosition.RIGHT));
            template.addRule((Predicate<Vec3i>)doorFrame, Blocks.field_150339_S.func_176223_P());
            template.addRule(levers, Blocks.field_150442_at.func_176223_P().func_177226_a((IProperty)BlockLever.field_176360_a, (Comparable)BlockLever.EnumOrientation.SOUTH));
        } else if (this.doorSide == EnumFacing.WEST) {
            half = this.getDecorationLengthZ() / 2;
            doorFrame = v -> v.func_177956_o() >= 0 && v.func_177956_o() <= 2 && v.func_177958_n() == 1 && v.func_177952_p() >= half - 1 && v.func_177952_p() <= half + 2;
            Predicate<Vec3i> predicate = v -> v.func_177956_o() == 0 && v.func_177958_n() == 1 && v.func_177952_p() == half;
            doorLower2 = v -> v.func_177956_o() == 0 && v.func_177958_n() == 1 && v.func_177952_p() == half + 1;
            doorUpper1 = v -> v.func_177956_o() == 1 && v.func_177958_n() == 1 && v.func_177952_p() == half;
            doorUpper2 = v -> v.func_177956_o() == 1 && v.func_177958_n() == 1 && v.func_177952_p() == half + 1;
            levers = v -> v.func_177956_o() == 1 && v.func_177958_n() == 0 && (v.func_177952_p() == half - 1 || v.func_177952_p() == half + 2);
            template.addRule(predicate, Blocks.field_150454_av.func_176223_P().func_177226_a((IProperty)BlockDoor.field_176520_a, (Comparable)EnumFacing.EAST).func_177226_a((IProperty)BlockDoor.field_176523_O, (Comparable)BlockDoor.EnumDoorHalf.LOWER).func_177226_a((IProperty)BlockDoor.field_176521_M, (Comparable)BlockDoor.EnumHingePosition.LEFT));
            template.addRule(doorLower2, Blocks.field_150454_av.func_176223_P().func_177226_a((IProperty)BlockDoor.field_176520_a, (Comparable)EnumFacing.EAST).func_177226_a((IProperty)BlockDoor.field_176523_O, (Comparable)BlockDoor.EnumDoorHalf.LOWER).func_177226_a((IProperty)BlockDoor.field_176521_M, (Comparable)BlockDoor.EnumHingePosition.RIGHT));
            template.addRule(doorUpper1, Blocks.field_150454_av.func_176223_P().func_177226_a((IProperty)BlockDoor.field_176520_a, (Comparable)EnumFacing.EAST).func_177226_a((IProperty)BlockDoor.field_176523_O, (Comparable)BlockDoor.EnumDoorHalf.UPPER).func_177226_a((IProperty)BlockDoor.field_176521_M, (Comparable)BlockDoor.EnumHingePosition.LEFT));
            template.addRule(doorUpper2, Blocks.field_150454_av.func_176223_P().func_177226_a((IProperty)BlockDoor.field_176520_a, (Comparable)EnumFacing.EAST).func_177226_a((IProperty)BlockDoor.field_176523_O, (Comparable)BlockDoor.EnumDoorHalf.UPPER).func_177226_a((IProperty)BlockDoor.field_176521_M, (Comparable)BlockDoor.EnumHingePosition.RIGHT));
            template.addRule((Predicate<Vec3i>)doorFrame, Blocks.field_150339_S.func_176223_P());
            template.addRule(levers, Blocks.field_150442_at.func_176223_P().func_177226_a((IProperty)BlockLever.field_176360_a, (Comparable)BlockLever.EnumOrientation.WEST));
        } else if (this.doorSide == EnumFacing.EAST) {
            half = this.getDecorationLengthZ() / 2;
            doorFrame = v -> v.func_177956_o() >= 0 && v.func_177956_o() <= 2 && v.func_177958_n() == endX - 1 && v.func_177952_p() >= half - 1 && v.func_177952_p() <= half + 2;
            Predicate<Vec3i> predicate = v -> v.func_177956_o() == 0 && v.func_177958_n() == endX - 1 && v.func_177952_p() == half;
            doorLower2 = v -> v.func_177956_o() == 0 && v.func_177958_n() == endX - 1 && v.func_177952_p() == half + 1;
            doorUpper1 = v -> v.func_177956_o() == 1 && v.func_177958_n() == endX - 1 && v.func_177952_p() == half;
            doorUpper2 = v -> v.func_177956_o() == 1 && v.func_177958_n() == endX - 1 && v.func_177952_p() == half + 1;
            levers = v -> v.func_177956_o() == 1 && v.func_177958_n() == endX && (v.func_177952_p() == half - 1 || v.func_177952_p() == half + 2);
            template.addRule(predicate, Blocks.field_150454_av.func_176223_P().func_177226_a((IProperty)BlockDoor.field_176520_a, (Comparable)EnumFacing.WEST).func_177226_a((IProperty)BlockDoor.field_176523_O, (Comparable)BlockDoor.EnumDoorHalf.LOWER).func_177226_a((IProperty)BlockDoor.field_176521_M, (Comparable)BlockDoor.EnumHingePosition.RIGHT));
            template.addRule(doorLower2, Blocks.field_150454_av.func_176223_P().func_177226_a((IProperty)BlockDoor.field_176520_a, (Comparable)EnumFacing.WEST).func_177226_a((IProperty)BlockDoor.field_176523_O, (Comparable)BlockDoor.EnumDoorHalf.LOWER).func_177226_a((IProperty)BlockDoor.field_176521_M, (Comparable)BlockDoor.EnumHingePosition.LEFT));
            template.addRule(doorUpper1, Blocks.field_150454_av.func_176223_P().func_177226_a((IProperty)BlockDoor.field_176520_a, (Comparable)EnumFacing.WEST).func_177226_a((IProperty)BlockDoor.field_176523_O, (Comparable)BlockDoor.EnumDoorHalf.UPPER).func_177226_a((IProperty)BlockDoor.field_176521_M, (Comparable)BlockDoor.EnumHingePosition.RIGHT));
            template.addRule(doorUpper2, Blocks.field_150454_av.func_176223_P().func_177226_a((IProperty)BlockDoor.field_176520_a, (Comparable)EnumFacing.WEST).func_177226_a((IProperty)BlockDoor.field_176523_O, (Comparable)BlockDoor.EnumDoorHalf.UPPER).func_177226_a((IProperty)BlockDoor.field_176521_M, (Comparable)BlockDoor.EnumHingePosition.LEFT));
            template.addRule((Predicate<Vec3i>)doorFrame, Blocks.field_150339_S.func_176223_P());
            template.addRule(levers, Blocks.field_150442_at.func_176223_P().func_177226_a((IProperty)BlockLever.field_176360_a, (Comparable)BlockLever.EnumOrientation.EAST));
        }
        template.addRule(northRow, Blocks.field_150411_aY.func_176223_P());
        template.addRule(southRow, Blocks.field_150411_aY.func_176223_P());
        template.addRule(westRow, Blocks.field_150411_aY.func_176223_P());
        template.addRule(eastRow, Blocks.field_150411_aY.func_176223_P());
        HashMap<BlockPos, IBlockState> genMap = template.GetGenerationMap(this.getDecorationStartPos(), true);
        genArray.addBlockStateMap(genMap, BlockStateGenArray.GenerationPhase.MAIN, BlockStateGenArray.EnumPriority.MEDIUM);
        for (Map.Entry entry : genMap.entrySet()) {
            if (((IBlockState)entry.getValue()).func_177230_c() == Blocks.field_150350_a) continue;
            this.usedDecoPositions.add(entry.getKey());
        }
        for (int x = 2; x < this.getDecorationLengthX() - 2; ++x) {
            void var13_23;
            int n = 2;
            while (var13_23 < this.getDecorationLengthZ() - 2) {
                this.prisonerSpawnerPositions.add(this.roomOrigin.func_177982_a(x, 1, (int)var13_23));
                ++var13_23;
            }
        }
    }

    public void addPrisonerSpawners(DungeonInhabitant jailInhabitant, BlockStateGenArray genArray, World world) {
        Collections.shuffle(this.prisonerSpawnerPositions, this.random);
        int spawnerCount = DungeonGenUtils.randomBetween(2, 5, this.random);
        for (int i = 0; i < spawnerCount && !this.prisonerSpawnerPositions.isEmpty(); ++i) {
            BlockPos pos = this.prisonerSpawnerPositions.get(i);
            Entity mobEntity = EntityList.func_188429_b((ResourceLocation)jailInhabitant.getEntityID(), (World)world);
            BlockSpawner spawnerBlock = CQRBlocks.SPAWNER;
            IBlockState state = spawnerBlock.func_176223_P();
            TileEntitySpawner spawner = (TileEntitySpawner)spawnerBlock.createTileEntity(world, state);
            if (spawner == null) continue;
            spawner.inventory.setStackInSlot(0, SpawnerFactory.getSoulBottleItemStackForEntity(mobEntity));
            NBTTagCompound spawnerCompound = spawner.func_189515_b(new NBTTagCompound());
            genArray.addBlockState(pos, state, spawnerCompound, BlockStateGenArray.GenerationPhase.POST, BlockStateGenArray.EnumPriority.HIGH);
            this.usedDecoPositions.add(pos);
        }
    }
}

