/*
 * Decompiled with CFR 0.152.
 */
package team.cqr.cqrepoured.structuregen.generators.castleparts.rooms;

import java.util.Random;
import net.minecraft.block.BlockStairs;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import team.cqr.cqrepoured.structuregen.dungeons.DungeonRandomizedCastle;
import team.cqr.cqrepoured.structuregen.generators.castleparts.rooms.CastleRoomBase;
import team.cqr.cqrepoured.structuregen.generators.castleparts.rooms.CastleRoomStaircaseDirected;
import team.cqr.cqrepoured.structuregen.generators.castleparts.rooms.EnumRoomType;
import team.cqr.cqrepoured.util.BlockStateGenArray;
import team.cqr.cqrepoured.util.DungeonGenUtils;

public class CastleRoomLandingDirected
extends CastleRoomBase {
    protected int openingWidth;
    protected int openingSeparation;
    protected int stairZ;
    protected EnumFacing stairStartSide;

    public CastleRoomLandingDirected(int sideLength, int height, CastleRoomStaircaseDirected stairsBelow, int floor, Random rand) {
        super(sideLength, height, floor, rand);
        this.roomType = EnumRoomType.LANDING_DIRECTED;
        this.openingWidth = stairsBelow.getUpperStairWidth();
        this.stairZ = stairsBelow.getUpperStairEndZ() + 1;
        this.openingSeparation = stairsBelow.getCenterStairWidth();
        this.stairStartSide = stairsBelow.getDoorSide();
        this.defaultCeiling = true;
    }

    @Override
    public void generateRoom(BlockPos castleOrigin, BlockStateGenArray genArray, DungeonRandomizedCastle dungeon) {
        int lenX = this.stairStartSide.func_176740_k() == EnumFacing.Axis.Z ? this.getDecorationLengthX() : this.getDecorationLengthZ();
        int lenZ = this.stairStartSide.func_176740_k() == EnumFacing.Axis.Z ? this.getDecorationLengthZ() : this.getDecorationLengthX();
        for (int x = 0; x < lenX - 1; ++x) {
            for (int z = 0; z < lenZ - 1; ++z) {
                for (int y = 0; y < this.height - 1; ++y) {
                    IBlockState blockToBuild = Blocks.field_150350_a.func_176223_P();
                    if (y == 0) {
                        if (z > this.stairZ) {
                            blockToBuild = dungeon.getFloorBlockState();
                        } else if (x < this.openingWidth || x >= this.openingSeparation + this.openingWidth && x < this.openingSeparation + this.openingWidth * 2) {
                            if (z == this.stairZ) {
                                EnumFacing stairFacing = DungeonGenUtils.rotateFacingNTimesAboutY(EnumFacing.SOUTH, DungeonGenUtils.getCWRotationsBetween(EnumFacing.SOUTH, this.stairStartSide));
                                blockToBuild = dungeon.getWoodStairBlockState().func_177226_a((IProperty)BlockStairs.field_176309_a, (Comparable)stairFacing);
                            }
                        } else {
                            blockToBuild = dungeon.getFloorBlockState();
                        }
                    }
                    genArray.addBlockState(this.getRotatedPlacement(x, y, z, this.stairStartSide), blockToBuild, BlockStateGenArray.GenerationPhase.MAIN, BlockStateGenArray.EnumPriority.MEDIUM);
                }
            }
        }
    }

    @Override
    public boolean canBuildDoorOnSide(EnumFacing side) {
        return side == this.stairStartSide;
    }

    @Override
    public boolean reachableFromSide(EnumFacing side) {
        return side == this.stairStartSide || side == this.stairStartSide.func_176734_d();
    }
}

