/*
 * Decompiled with CFR 0.152.
 */
package team.cqr.cqrepoured.structuregen.generators.castleparts.rooms;

import java.util.Random;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import team.cqr.cqrepoured.structuregen.dungeons.DungeonRandomizedCastle;
import team.cqr.cqrepoured.structuregen.generators.castleparts.rooms.CastleRoomBase;
import team.cqr.cqrepoured.structuregen.generators.castleparts.rooms.CastleRoomDecoratedBase;
import team.cqr.cqrepoured.structuregen.generators.castleparts.rooms.EnumRoomType;
import team.cqr.cqrepoured.util.BlockStateGenArray;
import team.cqr.cqrepoured.util.CQRWeightedRandom;

public class CastleRoomLibrary
extends CastleRoomDecoratedBase {
    private ShelfPattern pattern;
    private BlockPos shelfStart = null;
    private int shelfXLen = 0;
    private int shelfZLen = 0;
    private int shelfHeight = 0;

    public CastleRoomLibrary(int sideLength, int height, int floor, Random rand) {
        super(sideLength, height, floor, rand);
        this.roomType = EnumRoomType.LIBRARY;
        this.maxSlotsUsed = 2;
        this.defaultCeiling = true;
        this.defaultFloor = true;
        CQRWeightedRandom<ShelfPattern> randomPattern = new CQRWeightedRandom<ShelfPattern>();
        randomPattern.add(ShelfPattern.LONG_VERTICAL, 1);
        randomPattern.add(ShelfPattern.LONG_HORIZONTAL, 1);
        this.pattern = (ShelfPattern)((Object)randomPattern.next(this.random));
    }

    @Override
    protected void generateRoom(BlockPos castleOrigin, BlockStateGenArray genArray, DungeonRandomizedCastle dungeon) {
        this.shelfStart = this.getDecorationStartPos().func_177968_d().func_177974_f();
        this.shelfXLen = this.getDecorationLengthX() - 2;
        this.shelfZLen = this.getDecorationLengthZ() - 2;
        this.shelfHeight = this.getDecorationLengthY() - 2;
        switch (this.pattern) {
            case LONG_VERTICAL: {
                this.generateVertical(genArray);
                break;
            }
            case LONG_HORIZONTAL: {
                this.generateHorizontal(genArray);
                break;
            }
        }
    }

    @Override
    boolean shouldBuildEdgeDecoration() {
        return false;
    }

    @Override
    boolean shouldBuildWallDecoration() {
        return true;
    }

    @Override
    boolean shouldBuildMidDecoration() {
        return false;
    }

    @Override
    boolean shouldAddSpawners() {
        return true;
    }

    @Override
    boolean shouldAddChests() {
        return false;
    }

    private void generateVertical(BlockStateGenArray genArray) {
        for (int x = 0; x < this.shelfXLen; ++x) {
            for (int y = 0; y < this.shelfHeight; ++y) {
                for (int z = 0; z < this.shelfZLen; ++z) {
                    if (x % 2 != 0 || z == this.shelfZLen / 2) continue;
                    BlockPos pos = this.shelfStart.func_177982_a(x, y, z);
                    genArray.addBlockState(pos, Blocks.field_150342_X.func_176223_P(), BlockStateGenArray.GenerationPhase.MAIN, BlockStateGenArray.EnumPriority.MEDIUM);
                    this.usedDecoPositions.add(pos);
                }
            }
        }
    }

    private void generateHorizontal(BlockStateGenArray genArray) {
        for (int x = 0; x < this.shelfXLen; ++x) {
            for (int y = 0; y < this.shelfHeight; ++y) {
                for (int z = 0; z < this.shelfZLen; ++z) {
                    if (z % 2 != 0 || x == this.shelfXLen / 2) continue;
                    BlockPos pos = this.shelfStart.func_177982_a(x, y, z);
                    genArray.addBlockState(pos, Blocks.field_150342_X.func_176223_P(), BlockStateGenArray.GenerationPhase.MAIN, BlockStateGenArray.EnumPriority.MEDIUM);
                    this.usedDecoPositions.add(pos);
                }
            }
        }
    }

    @Override
    protected void makeRoomBlockAdjustments() {
        if (this.isRootRoomInBlock) {
            for (CastleRoomBase blockRoom : this.roomsInBlock) {
                if (!(blockRoom instanceof CastleRoomLibrary)) continue;
                ((CastleRoomLibrary)blockRoom).setPattern(this.pattern);
            }
        }
    }

    public void setPattern(ShelfPattern pattern) {
        this.pattern = pattern;
    }

    private static enum ShelfPattern {
        LONG_VERTICAL,
        LONG_HORIZONTAL;

    }
}

