/*
 * Decompiled with CFR 0.152.
 */
package team.cqr.cqrepoured.structuregen.generators.castleparts.rooms;

import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.function.Predicate;
import net.minecraft.block.BlockStairs;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import team.cqr.cqrepoured.structuregen.dungeons.DungeonRandomizedCastle;
import team.cqr.cqrepoured.structuregen.generators.castleparts.rooms.CastleRoomDecoratedBase;
import team.cqr.cqrepoured.structuregen.generators.castleparts.rooms.EnumRoomType;
import team.cqr.cqrepoured.util.BlockStateGenArray;
import team.cqr.cqrepoured.util.GenerationTemplate;

public class CastleRoomNetherPortal
extends CastleRoomDecoratedBase {
    private Alignment portalAlignment;

    public CastleRoomNetherPortal(int sideLength, int height, int floor, Random rand) {
        super(sideLength, height, floor, rand);
        this.roomType = EnumRoomType.PORTAL;
        this.maxSlotsUsed = 1;
        this.defaultCeiling = true;
        this.defaultFloor = true;
        this.portalAlignment = this.random.nextBoolean() ? Alignment.HORIZONTAL : Alignment.VERTICAL;
    }

    @Override
    protected void generateRoom(BlockPos castleOrigin, BlockStateGenArray genArray, DungeonRandomizedCastle dungeon) {
        int endX = this.getDecorationLengthX() - 1;
        int endZ = this.getDecorationLengthZ() - 1;
        int halfX = endX / 2;
        int halfZ = endZ / 2;
        int xStart = halfX - 2;
        int xEnd = halfX + 3;
        int zStart = halfZ - 2;
        int zEnd = halfZ + 2;
        Predicate<Vec3i> firstLayer = v -> v.func_177956_o() == 0;
        Predicate<Vec3i> northEdge = firstLayer.and(v -> v.func_177958_n() >= xStart && v.func_177958_n() <= xEnd && v.func_177952_p() == zStart);
        Predicate<Vec3i> southEdge = firstLayer.and(v -> v.func_177958_n() >= xStart && v.func_177958_n() <= xEnd && v.func_177952_p() == zEnd);
        Predicate<Vec3i> westEdge = firstLayer.and(v -> v.func_177952_p() >= zStart && v.func_177952_p() <= zEnd && v.func_177958_n() == xStart);
        Predicate<Vec3i> eastEdge = firstLayer.and(v -> v.func_177952_p() >= zStart && v.func_177952_p() <= zEnd && v.func_177958_n() == xEnd);
        Predicate<Vec3i> portalBot = v -> v.func_177956_o() == 0 && v.func_177952_p() == halfZ && v.func_177958_n() >= xStart + 1 && v.func_177958_n() <= xEnd - 1;
        Predicate<Vec3i> portalTop = v -> v.func_177956_o() == 4 && v.func_177952_p() == halfZ && v.func_177958_n() >= xStart + 1 && v.func_177958_n() <= xEnd - 1;
        Predicate<Vec3i> portalSides = v -> v.func_177956_o() > 0 && v.func_177956_o() < 4 && v.func_177952_p() == halfZ && (v.func_177958_n() == xStart + 1 || v.func_177958_n() == xEnd - 1);
        Predicate<Vec3i> portalMid = v -> v.func_177956_o() > 0 && v.func_177956_o() < 4 && v.func_177952_p() == halfZ && v.func_177958_n() > xStart + 1 && v.func_177958_n() < xEnd - 1;
        Predicate<Vec3i> portal = portalBot.or(portalTop).or(portalSides);
        Predicate<Vec3i> platform = portal.negate().and(firstLayer.and(v -> v.func_177958_n() >= xStart + 1 && v.func_177958_n() <= xEnd - 1 && v.func_177952_p() >= zStart + 1 && v.func_177952_p() <= zEnd - 1));
        GenerationTemplate portalRoomTemplate = new GenerationTemplate(this.getDecorationLengthX(), this.getDecorationLengthY(), this.getDecorationLengthZ());
        portalRoomTemplate.addRule(northEdge, dungeon.getWoodStairBlockState().func_177226_a((IProperty)BlockStairs.field_176309_a, (Comparable)EnumFacing.SOUTH));
        portalRoomTemplate.addRule(southEdge, dungeon.getWoodStairBlockState().func_177226_a((IProperty)BlockStairs.field_176309_a, (Comparable)EnumFacing.NORTH));
        portalRoomTemplate.addRule(westEdge, dungeon.getWoodStairBlockState().func_177226_a((IProperty)BlockStairs.field_176309_a, (Comparable)EnumFacing.EAST));
        portalRoomTemplate.addRule(eastEdge, dungeon.getWoodStairBlockState().func_177226_a((IProperty)BlockStairs.field_176309_a, (Comparable)EnumFacing.WEST));
        portalRoomTemplate.addRule(platform, dungeon.getMainBlockState());
        portalRoomTemplate.addRule(portal, Blocks.field_150343_Z.func_176223_P());
        portalRoomTemplate.addRule(portalMid, Blocks.field_150427_aO.func_176223_P());
        HashMap<BlockPos, IBlockState> genMap = portalRoomTemplate.GetGenerationMap(this.getDecorationStartPos(), true);
        genArray.addBlockStateMap(genMap, BlockStateGenArray.GenerationPhase.MAIN, BlockStateGenArray.EnumPriority.MEDIUM);
        for (Map.Entry<BlockPos, IBlockState> entry : genMap.entrySet()) {
            if (entry.getValue().func_177230_c() == Blocks.field_150350_a) continue;
            this.usedDecoPositions.add(entry.getKey());
        }
    }

    @Override
    protected IBlockState getFloorBlock(DungeonRandomizedCastle dungeon) {
        return dungeon.getMainBlockState();
    }

    @Override
    boolean shouldBuildEdgeDecoration() {
        return false;
    }

    @Override
    boolean shouldBuildWallDecoration() {
        return true;
    }

    @Override
    boolean shouldBuildMidDecoration() {
        return false;
    }

    @Override
    boolean shouldAddSpawners() {
        return true;
    }

    @Override
    boolean shouldAddChests() {
        return false;
    }

    private static enum Alignment {
        HORIZONTAL,
        VERTICAL;

    }
}

