/*
 * Decompiled with CFR 0.152.
 */
package team.cqr.cqrepoured.structuregen.generators.castleparts.rooms;

import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.function.Predicate;
import net.minecraft.block.BlockStairs;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import team.cqr.cqrepoured.structuregen.dungeons.DungeonRandomizedCastle;
import team.cqr.cqrepoured.structuregen.generators.castleparts.rooms.CastleRoomDecoratedBase;
import team.cqr.cqrepoured.structuregen.generators.castleparts.rooms.EnumRoomType;
import team.cqr.cqrepoured.util.BlockStateGenArray;
import team.cqr.cqrepoured.util.GenerationTemplate;

public class CastleRoomPool
extends CastleRoomDecoratedBase {
    public CastleRoomPool(int sideLength, int height, int floor, Random rand) {
        super(sideLength, height, floor, rand);
        this.roomType = EnumRoomType.POOL;
        this.maxSlotsUsed = 1;
        this.defaultCeiling = true;
        this.defaultFloor = true;
    }

    @Override
    protected void generateRoom(BlockPos castleOrigin, BlockStateGenArray genArray, DungeonRandomizedCastle dungeon) {
        int endX = this.getDecorationLengthX() - 1;
        int endZ = this.getDecorationLengthZ() - 1;
        Predicate<Vec3i> northRow = v -> v.func_177956_o() == 0 && v.func_177952_p() == 1 && v.func_177958_n() >= 1 && v.func_177958_n() <= endX - 1;
        Predicate<Vec3i> southRow = v -> v.func_177956_o() == 0 && v.func_177952_p() == endZ - 1 && v.func_177958_n() >= 1 && v.func_177958_n() <= endX - 1;
        Predicate<Vec3i> westRow = v -> v.func_177956_o() == 0 && v.func_177958_n() == 1 && v.func_177952_p() >= 1 && v.func_177952_p() <= endZ - 1;
        Predicate<Vec3i> eastRow = v -> v.func_177956_o() == 0 && v.func_177958_n() == endX - 1 && v.func_177952_p() >= 1 && v.func_177952_p() <= endZ - 1;
        Predicate<Vec3i> water = v -> v.func_177956_o() == 0 && v.func_177958_n() > 1 && v.func_177958_n() < endX - 1 && v.func_177952_p() > 1 && v.func_177952_p() < endZ - 1;
        GenerationTemplate poolRoomTemplate = new GenerationTemplate(this.getDecorationLengthX(), this.getDecorationLengthY(), this.getDecorationLengthZ());
        poolRoomTemplate.addRule(northRow, Blocks.field_150390_bg.func_176223_P().func_177226_a((IProperty)BlockStairs.field_176309_a, (Comparable)EnumFacing.SOUTH));
        poolRoomTemplate.addRule(southRow, Blocks.field_150390_bg.func_176223_P().func_177226_a((IProperty)BlockStairs.field_176309_a, (Comparable)EnumFacing.NORTH));
        poolRoomTemplate.addRule(westRow, Blocks.field_150390_bg.func_176223_P().func_177226_a((IProperty)BlockStairs.field_176309_a, (Comparable)EnumFacing.EAST));
        poolRoomTemplate.addRule(eastRow, Blocks.field_150390_bg.func_176223_P().func_177226_a((IProperty)BlockStairs.field_176309_a, (Comparable)EnumFacing.WEST));
        poolRoomTemplate.addRule(water, Blocks.field_150355_j.func_176223_P());
        HashMap<BlockPos, IBlockState> genMap = poolRoomTemplate.GetGenerationMap(this.getDecorationStartPos(), true);
        genArray.addBlockStateMap(genMap, BlockStateGenArray.GenerationPhase.MAIN, BlockStateGenArray.EnumPriority.MEDIUM);
        for (Map.Entry<BlockPos, IBlockState> entry : genMap.entrySet()) {
            if (entry.getValue().func_177230_c() == Blocks.field_150350_a) continue;
            this.usedDecoPositions.add(entry.getKey());
        }
    }

    @Override
    protected IBlockState getFloorBlock(DungeonRandomizedCastle dungeon) {
        return dungeon.getMainBlockState();
    }

    @Override
    boolean shouldBuildEdgeDecoration() {
        return false;
    }

    @Override
    boolean shouldBuildWallDecoration() {
        return true;
    }

    @Override
    boolean shouldBuildMidDecoration() {
        return false;
    }

    @Override
    boolean shouldAddSpawners() {
        return true;
    }

    @Override
    boolean shouldAddChests() {
        return false;
    }
}

