/*
 * Decompiled with CFR 0.152.
 */
package team.cqr.cqrepoured.structuregen.generators.castleparts.rooms;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import net.minecraft.block.BlockColored;
import net.minecraft.block.BlockSlab;
import net.minecraft.block.BlockStairs;
import net.minecraft.block.BlockTorch;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import team.cqr.cqrepoured.init.CQRLoottables;
import team.cqr.cqrepoured.objects.factories.GearedMobFactory;
import team.cqr.cqrepoured.structuregen.dungeons.DungeonRandomizedCastle;
import team.cqr.cqrepoured.structuregen.generators.castleparts.rooms.CastleRoomBase;
import team.cqr.cqrepoured.structuregen.generators.castleparts.rooms.EnumRoomType;
import team.cqr.cqrepoured.structuregen.structurefile.BlockInfoBoss;
import team.cqr.cqrepoured.util.BlockStateGenArray;
import team.cqr.cqrepoured.util.DungeonGenUtils;

public class CastleRoomRoofBossMain
extends CastleRoomBase {
    private Vec3i bossBuildOffset = new Vec3i(0, 0, 0);
    private static final int BOSS_ROOM_STATIC_SIZE = 17;
    private DungeonRandomizedCastle dungeon;

    public CastleRoomRoofBossMain(int sideLength, int height, int floor, Random rand) {
        super(sideLength, height, floor, rand);
        this.roomType = EnumRoomType.ROOF_BOSS_MAIN;
        this.pathable = false;
    }

    public void setBossBuildOffset(Vec3i bossBuildOffset) {
        this.bossBuildOffset = bossBuildOffset;
    }

    public int getStaticSize() {
        return 17;
    }

    @Override
    public void generateRoom(BlockPos castleOrigin, BlockStateGenArray genArray, DungeonRandomizedCastle dungeon) {
        BlockPos nwCorner = this.getBossRoomBuildStartPosition();
        this.dungeon = dungeon;
        for (int x = 0; x < 17; ++x) {
            for (int y = 0; y < 8; ++y) {
                for (int z = 0; z < 17; ++z) {
                    IBlockState blockToBuild = this.getBlockToBuild(x, y, z);
                    BlockPos pos = nwCorner.func_177982_a(x, y, z);
                    genArray.addBlockState(pos, blockToBuild, BlockStateGenArray.GenerationPhase.MAIN, BlockStateGenArray.EnumPriority.MEDIUM);
                }
            }
        }
    }

    @Override
    public void decorate(World world, BlockStateGenArray genArray, DungeonRandomizedCastle dungeon, GearedMobFactory mobFactory) {
        this.placeTorches(this.getBossRoomBuildStartPosition(), genArray);
        this.placeChests(world, this.getBossRoomBuildStartPosition(), genArray);
    }

    @Override
    public void placeBoss(World world, BlockStateGenArray genArray, DungeonRandomizedCastle dungeon, ResourceLocation bossResourceLocation, ArrayList<String> bossUuids) {
        BlockPos pos = this.getBossRoomBuildStartPosition().func_177982_a(8, 1, 8);
        genArray.addInternal(BlockStateGenArray.GenerationPhase.POST, new BlockInfoBoss(pos), BlockStateGenArray.EnumPriority.MEDIUM);
    }

    private void placeTorches(BlockPos nwCorner, BlockStateGenArray genArray) {
        IBlockState torchBase = Blocks.field_150478_aa.func_176223_P();
        genArray.addBlockState(nwCorner.func_177982_a(10, 3, 2), torchBase.func_177226_a((IProperty)BlockTorch.field_176596_a, (Comparable)EnumFacing.SOUTH), BlockStateGenArray.GenerationPhase.POST, BlockStateGenArray.EnumPriority.MEDIUM);
        genArray.addBlockState(nwCorner.func_177982_a(6, 3, 2), torchBase.func_177226_a((IProperty)BlockTorch.field_176596_a, (Comparable)EnumFacing.SOUTH), BlockStateGenArray.GenerationPhase.POST, BlockStateGenArray.EnumPriority.MEDIUM);
        genArray.addBlockState(nwCorner.func_177982_a(6, 3, 14), torchBase.func_177226_a((IProperty)BlockTorch.field_176596_a, (Comparable)EnumFacing.NORTH), BlockStateGenArray.GenerationPhase.POST, BlockStateGenArray.EnumPriority.MEDIUM);
        genArray.addBlockState(nwCorner.func_177982_a(10, 3, 14), torchBase.func_177226_a((IProperty)BlockTorch.field_176596_a, (Comparable)EnumFacing.NORTH), BlockStateGenArray.GenerationPhase.POST, BlockStateGenArray.EnumPriority.MEDIUM);
        genArray.addBlockState(nwCorner.func_177982_a(2, 3, 6), torchBase.func_177226_a((IProperty)BlockTorch.field_176596_a, (Comparable)EnumFacing.EAST), BlockStateGenArray.GenerationPhase.POST, BlockStateGenArray.EnumPriority.MEDIUM);
        genArray.addBlockState(nwCorner.func_177982_a(2, 3, 10), torchBase.func_177226_a((IProperty)BlockTorch.field_176596_a, (Comparable)EnumFacing.EAST), BlockStateGenArray.GenerationPhase.POST, BlockStateGenArray.EnumPriority.MEDIUM);
        genArray.addBlockState(nwCorner.func_177982_a(14, 3, 6), torchBase.func_177226_a((IProperty)BlockTorch.field_176596_a, (Comparable)EnumFacing.WEST), BlockStateGenArray.GenerationPhase.POST, BlockStateGenArray.EnumPriority.MEDIUM);
        genArray.addBlockState(nwCorner.func_177982_a(14, 3, 10), torchBase.func_177226_a((IProperty)BlockTorch.field_176596_a, (Comparable)EnumFacing.WEST), BlockStateGenArray.GenerationPhase.POST, BlockStateGenArray.EnumPriority.MEDIUM);
    }

    private void placeChests(World world, BlockPos nwCorner, BlockStateGenArray genArray) {
        int numChestsTotal = DungeonGenUtils.randomBetweenGaussian(4, 8, this.random);
        int numTreasureChests = DungeonGenUtils.randomBetween(2, 4, this.random);
        int treasureChestsPlaced = 0;
        HashMap<BlockPos, EnumFacing> possibleChestLocs = new HashMap<BlockPos, EnumFacing>();
        possibleChestLocs.put(nwCorner.func_177982_a(1, 5, 7), EnumFacing.WEST);
        possibleChestLocs.put(nwCorner.func_177982_a(1, 5, 9), EnumFacing.WEST);
        possibleChestLocs.put(nwCorner.func_177982_a(15, 5, 7), EnumFacing.EAST);
        possibleChestLocs.put(nwCorner.func_177982_a(15, 5, 9), EnumFacing.EAST);
        possibleChestLocs.put(nwCorner.func_177982_a(7, 5, 1), EnumFacing.NORTH);
        possibleChestLocs.put(nwCorner.func_177982_a(9, 5, 1), EnumFacing.NORTH);
        possibleChestLocs.put(nwCorner.func_177982_a(7, 5, 15), EnumFacing.SOUTH);
        possibleChestLocs.put(nwCorner.func_177982_a(9, 5, 15), EnumFacing.SOUTH);
        ArrayList locList = new ArrayList(possibleChestLocs.entrySet());
        Collections.shuffle(locList, this.random);
        for (int i = 0; i < numChestsTotal; ++i) {
            ResourceLocation lootTable;
            if (treasureChestsPlaced < numTreasureChests) {
                lootTable = CQRLoottables.CHESTS_TREASURE;
                ++treasureChestsPlaced;
            } else {
                lootTable = DungeonGenUtils.percentageRandom(50, this.random) ? CQRLoottables.CHESTS_MATERIAL : CQRLoottables.CHESTS_EQUIPMENT;
            }
            genArray.addChestWithLootTable(world, (BlockPos)((Map.Entry)locList.get(i)).getKey(), ((EnumFacing)((Map.Entry)locList.get(i)).getValue()).func_176734_d(), lootTable, BlockStateGenArray.GenerationPhase.POST);
        }
    }

    private BlockPos getBossRoomBuildStartPosition() {
        return this.getNonWallStartPos().func_177971_a(this.bossBuildOffset);
    }

    private IBlockState getBlockToBuild(int x, int y, int z) {
        IBlockState blockToBuild = Blocks.field_150350_a.func_176223_P();
        if (y == 0 || y == 7) {
            blockToBuild = this.floorDesignBlock(x, z) ? Blocks.field_192443_dR.func_176223_P() : this.dungeon.getMainBlockState();
        } else if (x == 0 || z == 0 || x == 16 || z == 16) {
            blockToBuild = this.getOuterEdgeBlock(x, y, z);
        } else if (x == 1 || x == 15 || z == 1 || z == 15) {
            blockToBuild = this.getInnerRing1Block(x, y, z);
        } else if (x == 2 || x == 14 || z == 2 || z == 14) {
            blockToBuild = this.getInnerRing2Block(x, y, z);
        } else if (x == 3 || x == 13 || z == 3 || z == 13) {
            blockToBuild = this.getInnerRing3Block(x, y, z);
        }
        return blockToBuild;
    }

    private boolean floorDesignBlock(int x, int z) {
        int[][] floorPattern = new int[][]{{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 1, 1, 1, 0, 0, 1, 0, 0, 1, 1, 1, 0, 0, 0}, {0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0}, {0, 0, 0, 1, 0, 0, 0, 1, 0, 1, 0, 0, 0, 1, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0, 0, 0, 0, 0, 0, 0}, {0, 0, 1, 0, 0, 1, 1, 1, 0, 1, 1, 1, 0, 0, 1, 0, 0}, {0, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 0, 0, 1, 0, 0, 0}, {0, 0, 1, 0, 0, 1, 1, 1, 0, 1, 1, 1, 0, 0, 1, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 1, 0, 0, 0, 1, 0, 1, 0, 0, 0, 1, 0, 0, 0}, {0, 0, 0, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1, 0, 0, 0}, {0, 0, 0, 1, 1, 1, 0, 0, 1, 0, 0, 1, 1, 1, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 1, 0, 1, 0, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}, {0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0}};
        return this.checkPatternIndex(x, z, floorPattern);
    }

    private boolean checkPatternIndex(int x, int z, int[][] pattern) {
        if (pattern != null && z >= 0 && z <= pattern.length && x >= 0 && x <= pattern[0].length) {
            return pattern[x][z] == 1;
        }
        return false;
    }

    private IBlockState getOuterEdgeBlock(int x, int y, int z) {
        if (x == 0 || x == 16) {
            if (z == 0 || z == 3 || z == 6 || z == 10 || z == 13 || z == 16) {
                return this.dungeon.getMainBlockState();
            }
            if (z >= 7 && z <= 9) {
                if (y >= 1 && y <= 3) {
                    return Blocks.field_150350_a.func_176223_P();
                }
                if (y == 4) {
                    if (z == 7 || z == 9) {
                        EnumFacing doorFrameFacing = z == 7 ? EnumFacing.NORTH : EnumFacing.SOUTH;
                        return this.dungeon.getStairBlockState().func_177226_a((IProperty)BlockStairs.field_176308_b, (Comparable)BlockStairs.EnumHalf.TOP).func_177226_a((IProperty)BlockStairs.field_176309_a, (Comparable)doorFrameFacing);
                    }
                    return Blocks.field_150350_a.func_176223_P();
                }
            } else {
                if (y == 6) {
                    return this.dungeon.getMainBlockState();
                }
                if (y == 2 || y == 3 || y == 4) {
                    return Blocks.field_150397_co.func_176223_P().func_177226_a((IProperty)BlockColored.field_176581_a, (Comparable)EnumDyeColor.RED);
                }
                if (y == 1) {
                    EnumFacing windowBotFacing = x == 0 ? EnumFacing.WEST : EnumFacing.EAST;
                    return this.dungeon.getStairBlockState().func_177226_a((IProperty)BlockStairs.field_176308_b, (Comparable)BlockStairs.EnumHalf.BOTTOM).func_177226_a((IProperty)BlockStairs.field_176309_a, (Comparable)windowBotFacing);
                }
                if (y == 5) {
                    EnumFacing windowTopFacing = x == 0 ? EnumFacing.EAST : EnumFacing.WEST;
                    return this.dungeon.getStairBlockState().func_177226_a((IProperty)BlockStairs.field_176308_b, (Comparable)BlockStairs.EnumHalf.TOP).func_177226_a((IProperty)BlockStairs.field_176309_a, (Comparable)windowTopFacing);
                }
            }
        } else if (z == 0 || z == 16) {
            if (x == 3 || x == 6 || x == 10 || x == 13) {
                return this.dungeon.getMainBlockState();
            }
            if (x >= 7 && x <= 9) {
                if (y >= 1 && y <= 3) {
                    return Blocks.field_150350_a.func_176223_P();
                }
                if (y == 4) {
                    if (x == 7 || x == 9) {
                        EnumFacing doorFrameFacing = x == 7 ? EnumFacing.WEST : EnumFacing.EAST;
                        return this.dungeon.getStairBlockState().func_177226_a((IProperty)BlockStairs.field_176308_b, (Comparable)BlockStairs.EnumHalf.TOP).func_177226_a((IProperty)BlockStairs.field_176309_a, (Comparable)doorFrameFacing);
                    }
                    return Blocks.field_150350_a.func_176223_P();
                }
            } else {
                if (y == 6) {
                    return this.dungeon.getMainBlockState();
                }
                if (y == 2 || y == 3 || y == 4) {
                    return Blocks.field_150397_co.func_176223_P().func_177226_a((IProperty)BlockColored.field_176581_a, (Comparable)EnumDyeColor.RED);
                }
                if (y == 1) {
                    EnumFacing windowBotFacing = z == 0 ? EnumFacing.NORTH : EnumFacing.SOUTH;
                    return this.dungeon.getStairBlockState().func_177226_a((IProperty)BlockStairs.field_176308_b, (Comparable)BlockStairs.EnumHalf.BOTTOM).func_177226_a((IProperty)BlockStairs.field_176309_a, (Comparable)windowBotFacing);
                }
                if (y == 5) {
                    EnumFacing windowTopFacing = z == 0 ? EnumFacing.SOUTH : EnumFacing.NORTH;
                    return this.dungeon.getStairBlockState().func_177226_a((IProperty)BlockStairs.field_176308_b, (Comparable)BlockStairs.EnumHalf.TOP).func_177226_a((IProperty)BlockStairs.field_176309_a, (Comparable)windowTopFacing);
                }
            }
        }
        return this.dungeon.getMainBlockState();
    }

    private IBlockState getInnerRing1Block(int x, int y, int z) {
        IBlockState detailBlock = this.dungeon.getFancyBlockState();
        if (x == 1 || x == 15) {
            if (z == 3 || z == 6 || z == 10 || z == 13) {
                return detailBlock;
            }
            if ((z == 1 || z == 2 || z == 14 || z == 15) && y == 1) {
                return Blocks.field_150353_l.func_176223_P();
            }
            if (z >= 7 && z <= 9) {
                if (y == 3 && (z == 7 || z == 9)) {
                    return this.dungeon.getSlabBlockState().func_177226_a((IProperty)BlockSlab.field_176554_a, (Comparable)BlockSlab.EnumBlockHalf.TOP);
                }
                if (y == 4) {
                    return detailBlock;
                }
                if (y == 5 && z == 8) {
                    EnumFacing frameTopStairFacing = x == 1 ? EnumFacing.WEST : EnumFacing.EAST;
                    return this.dungeon.getStairBlockState().func_177226_a((IProperty)BlockStairs.field_176308_b, (Comparable)BlockStairs.EnumHalf.BOTTOM).func_177226_a((IProperty)BlockStairs.field_176309_a, (Comparable)frameTopStairFacing);
                }
            }
        } else if (z == 1 || z == 15) {
            if (x == 3 || x == 6 || x == 10 || x == 13) {
                return detailBlock;
            }
            if ((x == 2 || x == 14) && y == 1) {
                return Blocks.field_150353_l.func_176223_P();
            }
            if (x >= 7 && x <= 9) {
                if (y == 3 && (x == 7 || x == 9)) {
                    return this.dungeon.getSlabBlockState().func_177226_a((IProperty)BlockSlab.field_176554_a, (Comparable)BlockSlab.EnumBlockHalf.TOP);
                }
                if (y == 4) {
                    return detailBlock;
                }
                if (y == 5 && x == 8) {
                    EnumFacing frameTopStairFacing = z == 1 ? EnumFacing.NORTH : EnumFacing.SOUTH;
                    return this.dungeon.getStairBlockState().func_177226_a((IProperty)BlockStairs.field_176308_b, (Comparable)BlockStairs.EnumHalf.BOTTOM).func_177226_a((IProperty)BlockStairs.field_176309_a, (Comparable)frameTopStairFacing);
                }
            }
        }
        return Blocks.field_150350_a.func_176223_P();
    }

    private IBlockState getInnerRing2Block(int x, int y, int z) {
        if (x == 2 || x == 14) {
            if ((z == 2 || z == 14) && y == 1) {
                return Blocks.field_150353_l.func_176223_P();
            }
            if (z == 3 || z == 13) {
                if (y == 1 || y == 6) {
                    EnumFacing stairFacing = z == 3 ? EnumFacing.NORTH : EnumFacing.SOUTH;
                    BlockStairs.EnumHalf stairHalf = y == 1 ? BlockStairs.EnumHalf.TOP : BlockStairs.EnumHalf.BOTTOM;
                    return this.dungeon.getStairBlockState().func_177226_a((IProperty)BlockStairs.field_176309_a, (Comparable)stairFacing).func_177226_a((IProperty)BlockStairs.field_176308_b, (Comparable)stairHalf);
                }
                if (y >= 2 && y <= 5) {
                    return Blocks.field_150411_aY.func_176223_P();
                }
            }
        } else if (!(z != 2 && z != 14 || x != 3 && x != 13)) {
            if (y == 1 || y == 6) {
                EnumFacing stairFacing = x == 3 ? EnumFacing.WEST : EnumFacing.EAST;
                BlockStairs.EnumHalf stairHalf = y == 1 ? BlockStairs.EnumHalf.TOP : BlockStairs.EnumHalf.BOTTOM;
                return this.dungeon.getStairBlockState().func_177226_a((IProperty)BlockStairs.field_176309_a, (Comparable)stairFacing).func_177226_a((IProperty)BlockStairs.field_176308_b, (Comparable)stairHalf);
            }
            if (y >= 2 && y <= 5) {
                return Blocks.field_150411_aY.func_176223_P();
            }
        }
        return Blocks.field_150350_a.func_176223_P();
    }

    private IBlockState getInnerRing3Block(int x, int y, int z) {
        if ((x == 3 || x == 13) && z == 3) {
            if (y >= 2 & y <= 5) {
                return Blocks.field_150411_aY.func_176223_P();
            }
            if (y == 1 || y == 6) {
                BlockStairs.EnumHalf stairHalf = y == 1 ? BlockStairs.EnumHalf.TOP : BlockStairs.EnumHalf.BOTTOM;
                EnumFacing stairFacing = x == 3 ? EnumFacing.WEST : EnumFacing.NORTH;
                return this.dungeon.getStairBlockState().func_177226_a((IProperty)BlockStairs.field_176308_b, (Comparable)stairHalf).func_177226_a((IProperty)BlockStairs.field_176309_a, (Comparable)stairFacing);
            }
        } else if ((x == 3 || x == 13) && z == 13) {
            if (y >= 2 & y <= 5) {
                return Blocks.field_150411_aY.func_176223_P();
            }
            if (y == 1 || y == 6) {
                BlockStairs.EnumHalf stairHalf = y == 1 ? BlockStairs.EnumHalf.TOP : BlockStairs.EnumHalf.BOTTOM;
                EnumFacing stairFacing = x == 3 ? EnumFacing.WEST : EnumFacing.SOUTH;
                return this.dungeon.getStairBlockState().func_177226_a((IProperty)BlockStairs.field_176308_b, (Comparable)stairHalf).func_177226_a((IProperty)BlockStairs.field_176309_a, (Comparable)stairFacing);
            }
        }
        return Blocks.field_150350_a.func_176223_P();
    }
}

