/*
 * Decompiled with CFR 0.152.
 */
package team.cqr.cqrepoured.structuregen.generators.castleparts.rooms;

import java.util.Random;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import team.cqr.cqrepoured.structuregen.dungeons.DungeonRandomizedCastle;
import team.cqr.cqrepoured.structuregen.generators.castleparts.rooms.CastleRoomBase;
import team.cqr.cqrepoured.structuregen.generators.castleparts.rooms.EnumRoomType;
import team.cqr.cqrepoured.util.BlockStateGenArray;
import team.cqr.cqrepoured.util.SpiralStaircaseBuilder;

public class CastleRoomTowerSquare
extends CastleRoomBase {
    private static final int MIN_SIZE = 5;
    private EnumFacing connectedSide;
    private int stairYOffset;
    private Vec3i pillarOffset;
    private EnumFacing firstStairSide;

    public CastleRoomTowerSquare(int sideLength, int height, EnumFacing connectedSide, int towerSize, CastleRoomTowerSquare towerBelow, int floor, Random rand) {
        super(sideLength, height, floor, rand);
        this.roomType = EnumRoomType.TOWER_SQUARE;
        this.connectedSide = connectedSide;
        this.defaultFloor = false;
        this.defaultCeiling = false;
        this.pathable = false;
        this.isTower = true;
        if (towerBelow != null) {
            this.firstStairSide = towerBelow.getLastStairSide().func_176746_e();
            this.stairYOffset = 0;
        } else {
            this.firstStairSide = this.connectedSide.func_176746_e();
            this.stairYOffset = 1;
        }
        this.pillarOffset = new Vec3i(this.roomLengthX / 2, this.stairYOffset, this.roomLengthZ / 2);
    }

    @Override
    public void generateRoom(BlockPos castleOrigin, BlockStateGenArray genArray, DungeonRandomizedCastle dungeon) {
        BlockPos stairCenter = this.roomOrigin.func_177971_a(this.pillarOffset);
        SpiralStaircaseBuilder stairs = new SpiralStaircaseBuilder(stairCenter, this.firstStairSide, dungeon.getMainBlockState(), dungeon.getStairBlockState());
        for (int x = 0; x < this.getDecorationLengthX(); ++x) {
            for (int z = 0; z < this.getDecorationLengthZ(); ++z) {
                for (int y = 0; y < this.height; ++y) {
                    IBlockState blockToBuild = Blocks.field_150350_a.func_176223_P();
                    BlockPos pos = this.getNonWallStartPos().func_177982_a(x, y, z);
                    if (stairs.isPartOfStairs(pos)) {
                        blockToBuild = stairs.getBlock(pos);
                    } else if (y == 0) {
                        blockToBuild = dungeon.getFloorBlockState();
                    } else if (y == this.height - 1) {
                        blockToBuild = dungeon.getMainBlockState();
                    }
                    if (blockToBuild.func_177230_c() != Blocks.field_150350_a) {
                        this.usedDecoPositions.add(pos);
                    }
                    genArray.addBlockState(pos, blockToBuild, BlockStateGenArray.GenerationPhase.MAIN, BlockStateGenArray.EnumPriority.MEDIUM);
                }
            }
        }
    }

    public EnumFacing getLastStairSide() {
        EnumFacing result = this.firstStairSide;
        for (int i = this.stairYOffset; i < this.height - 1; ++i) {
            result = result.func_176746_e();
        }
        return result;
    }

    @Override
    public boolean isTower() {
        return true;
    }
}

