/*
 * Decompiled with CFR 0.152.
 */
package team.cqr.cqrepoured.structuregen.generators.stronghold;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.init.Blocks;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraft.world.gen.structure.template.PlacementSettings;
import team.cqr.cqrepoured.CQRMain;
import team.cqr.cqrepoured.structuregen.DungeonDataManager;
import team.cqr.cqrepoured.structuregen.dungeons.DungeonStrongholdOpen;
import team.cqr.cqrepoured.structuregen.generation.DungeonPartPlateau;
import team.cqr.cqrepoured.structuregen.generators.AbstractDungeonGenerator;
import team.cqr.cqrepoured.structuregen.generators.stronghold.open.StrongholdFloorOpen;
import team.cqr.cqrepoured.structuregen.inhabitants.DungeonInhabitant;
import team.cqr.cqrepoured.structuregen.inhabitants.DungeonInhabitantManager;
import team.cqr.cqrepoured.structuregen.structurefile.CQStructure;
import team.cqr.cqrepoured.util.DungeonGenUtils;
import team.cqr.cqrepoured.util.data.FileIOUtil;

public class GeneratorStrongholdOpen
extends AbstractDungeonGenerator<DungeonStrongholdOpen> {
    private List<String> blacklistedRooms = new ArrayList<String>();
    private Tuple<Integer, Integer> structureBounds;
    private PlacementSettings settings = new PlacementSettings();
    private StrongholdFloorOpen[] floors;
    private int dunX;
    private int dunZ;
    private int entranceSizeX = 0;
    private int entranceSizeZ = 0;

    public GeneratorStrongholdOpen(World world, BlockPos pos, DungeonStrongholdOpen dungeon, Random rand, DungeonDataManager.DungeonSpawnType spawnType) {
        super(world, pos, dungeon, rand, spawnType);
        this.structureBounds = new Tuple((Object)dungeon.getRoomSizeX(), (Object)dungeon.getRoomSizeZ());
        this.settings.func_186214_a(Mirror.NONE);
        this.settings.func_186220_a(Rotation.NONE);
        this.settings.func_186225_a(Blocks.field_189881_dj);
        this.settings.func_189946_a(1.0f);
        this.floors = new StrongholdFloorOpen[dungeon.getRandomFloorCount(this.random)];
        this.searchStructureBounds();
        this.computeNotFittingStructures();
    }

    private void computeNotFittingStructures() {
        for (File f : ((DungeonStrongholdOpen)this.dungeon).getRoomFolder().listFiles(FileIOUtil.getNBTFileFilter())) {
            CQStructure struct = this.loadStructureFromFile(f);
            if (struct == null || struct.getSize().func_177958_n() == ((Integer)this.structureBounds.func_76341_a()).intValue() && struct.getSize().func_177952_p() == ((Integer)this.structureBounds.func_76340_b()).intValue()) continue;
            this.blacklistedRooms.add(f.getParent() + "/" + f.getName());
        }
    }

    public DungeonStrongholdOpen getDungeon() {
        return (DungeonStrongholdOpen)this.dungeon;
    }

    private void searchStructureBounds() {
    }

    @Override
    public void preProcess() {
        this.dunX = this.pos.func_177958_n();
        this.dunZ = this.pos.func_177952_p();
        BlockPos initPos = this.pos;
        int rgd = this.getDungeon().getRandomRoomCountForFloor(this.random);
        if (rgd < 2) {
            rgd = 2;
        }
        if (rgd % 2 != 0) {
            ++rgd;
        }
        if ((rgd = new Double(Math.ceil(Math.sqrt(rgd))).intValue()) % 2 == 0) {
            ++rgd;
        }
        StrongholdFloorOpen prevFloor = null;
        for (int i = 0; i < this.floors.length; ++i) {
            boolean isFirst = i == 0;
            StrongholdFloorOpen floor = null;
            floor = isFirst ? new StrongholdFloorOpen(this, rgd, Double.valueOf(Math.floor(rgd / 2)).intValue(), Double.valueOf(Math.floor(rgd / 2)).intValue(), this.random) : new StrongholdFloorOpen(this, rgd, (Integer)prevFloor.getExitStairIndexes().func_76341_a(), (Integer)prevFloor.getExitStairIndexes().func_76340_b(), this.random);
            File stair = null;
            if (isFirst) {
                stair = ((DungeonStrongholdOpen)this.dungeon).getEntranceStair(this.random);
                if (stair == null) {
                    CQRMain.logger.error("No entrance stair rooms for Stronghold Open Dungeon: {}", (Object)this.getDungeon().getDungeonName());
                    return;
                }
            } else {
                stair = ((DungeonStrongholdOpen)this.dungeon).getStairRoom(this.random);
                if (stair == null) {
                    CQRMain.logger.error("No stair rooms for Stronghold Open Dungeon: {}", (Object)this.getDungeon().getDungeonName());
                    return;
                }
            }
            floor.setIsFirstFloor(isFirst);
            int dY = initPos.func_177956_o() - this.loadStructureFromFile(stair).getSize().func_177956_o();
            if (dY <= ((DungeonStrongholdOpen)this.dungeon).getRoomSizeY() + 2) {
                this.floors[i - 1].setExitIsBossRoom(true);
            } else {
                initPos = initPos.func_177973_b(new Vec3i(0, this.loadStructureFromFile(stair).getSize().func_177956_o(), 0));
                if (!isFirst) {
                    initPos = initPos.func_177982_a(0, ((DungeonStrongholdOpen)this.dungeon).getRoomSizeY(), 0);
                }
                if (i + 1 == this.floors.length) {
                    floor.setExitIsBossRoom(true);
                }
                if (isFirst) {
                    floor.setEntranceStairPosition(stair, initPos.func_177958_n(), initPos.func_177956_o(), initPos.func_177952_p());
                } else {
                    floor.setEntranceStairPosition(stair, (Integer)prevFloor.getExitCoordinates().func_76341_a(), initPos.func_177956_o(), (Integer)prevFloor.getExitCoordinates().func_76340_b());
                }
                floor.calculatePositions();
                initPos = new BlockPos(((Integer)floor.getExitCoordinates().func_76341_a()).intValue(), initPos.func_177956_o(), ((Integer)floor.getExitCoordinates().func_76340_b()).intValue());
            }
            prevFloor = floor;
            this.floors[i] = floor;
        }
    }

    @Override
    public void buildStructure() {
        File building = ((DungeonStrongholdOpen)this.dungeon).getEntranceBuilding(this.random);
        DungeonInhabitant mobType = DungeonInhabitantManager.instance().getInhabitantByDistanceIfDefault(((DungeonStrongholdOpen)this.dungeon).getDungeonMob(), this.world, this.pos.func_177958_n(), this.pos.func_177952_p());
        if (building == null || ((DungeonStrongholdOpen)this.dungeon).getEntranceBuildingFolder().listFiles(FileIOUtil.getNBTFileFilter()).length <= 0) {
            CQRMain.logger.error("No entrance buildings for Open Stronghold dungeon: " + this.getDungeon().getDungeonName());
            return;
        }
        CQStructure structure = this.loadStructureFromFile(building);
        if (((DungeonStrongholdOpen)this.dungeon).doBuildSupportPlatform()) {
            this.dungeonGenerator.add(new DungeonPartPlateau(this.world, this.dungeonGenerator, this.pos.func_177958_n() + 4 + structure.getSize().func_177958_n() / 2, this.pos.func_177952_p() + 4 + structure.getSize().func_177952_p() / 2, this.pos.func_177958_n() - 4 - structure.getSize().func_177958_n() / 2, this.pos.func_177956_o(), this.pos.func_177952_p() - 4 - structure.getSize().func_177952_p() / 2, ((DungeonStrongholdOpen)this.dungeon).getSupportBlock(), ((DungeonStrongholdOpen)this.dungeon).getSupportTopBlock(), 8));
        }
        this.entranceSizeX = structure.getSize().func_177958_n();
        this.entranceSizeZ = structure.getSize().func_177958_n();
        BlockPos p = DungeonGenUtils.getCentralizedPosForStructure(this.pos, structure, this.settings);
        structure.addAll(this.world, this.dungeonGenerator, p, this.settings, mobType);
        for (StrongholdFloorOpen floor : this.floors) {
            floor.generateRooms(this.world, this.dungeonGenerator, mobType);
        }
        for (StrongholdFloorOpen floor : this.floors) {
            if (floor == null) {
                CQRMain.logger.error("Floor is null! Not generating it!");
                continue;
            }
            try {
                floor.buildWalls(this.world, this.dungeonGenerator, mobType);
            }
            catch (NullPointerException ex) {
                CQRMain.logger.error("Error whilst trying to construct wall in open stronghold at: X {}  Y {}  Z {}", (Object)this.pos.func_177958_n(), (Object)this.pos.func_177956_o(), (Object)this.pos.func_177952_p());
            }
        }
    }

    @Override
    public void postProcess() {
        if (((DungeonStrongholdOpen)this.dungeon).isCoverBlockEnabled()) {
            // empty if block
        }
    }

    public int getDunX() {
        return this.dunX;
    }

    public int getDunZ() {
        return this.dunZ;
    }

    public PlacementSettings getPlacementSettings() {
        return this.settings;
    }

    public BlockPos getPos() {
        return this.pos;
    }
}

