/*
 * Decompiled with CFR 0.152.
 */
package team.cqr.cqrepoured.structuregen.generators.stronghold.open;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraft.world.gen.structure.template.PlacementSettings;
import team.cqr.cqrepoured.structuregen.generation.DungeonGenerator;
import team.cqr.cqrepoured.structuregen.generation.DungeonPartBlock;
import team.cqr.cqrepoured.structuregen.generators.stronghold.GeneratorStrongholdOpen;
import team.cqr.cqrepoured.structuregen.inhabitants.DungeonInhabitant;
import team.cqr.cqrepoured.structuregen.structurefile.AbstractBlockInfo;
import team.cqr.cqrepoured.structuregen.structurefile.BlockInfo;
import team.cqr.cqrepoured.structuregen.structurefile.CQStructure;
import team.cqr.cqrepoured.util.DungeonGenUtils;

public class StrongholdFloorOpen {
    private final Random random;
    private GeneratorStrongholdOpen generator;
    private BlockPos[][] roomGrid;
    private Tuple<Integer, Integer> entranceStairBlockPosition;
    private Tuple<Integer, Integer> entranceStairIndex;
    private Tuple<Integer, Integer> exitStairBlockPosition;
    private Tuple<Integer, Integer> exitStairIndex;
    private Tuple<BlockPos, BlockPos> exitStairCorners;
    private Tuple<BlockPos, BlockPos> entranceStairCorners;
    private int sideLength = 1;
    private int yPos;
    private File entranceStair = null;
    private boolean exitStairIsBossRoom = false;
    private boolean isFirstFloor = false;

    public StrongholdFloorOpen(GeneratorStrongholdOpen generator, int roomCount, Random rand) {
        this(generator, roomCount, rand.nextInt(roomCount), rand.nextInt(roomCount), rand);
    }

    public StrongholdFloorOpen(GeneratorStrongholdOpen generator, int roomCount, int entranceStairIndexX, int entranceStairIndexZ, Random rand) {
        this.generator = generator;
        this.sideLength = roomCount;
        this.roomGrid = new BlockPos[roomCount][roomCount];
        this.random = rand;
        this.entranceStairIndex = new Tuple((Object)entranceStairIndexX, (Object)entranceStairIndexZ);
        int iX2 = this.random.nextInt(roomCount);
        int iZ2 = this.random.nextInt(roomCount);
        while (iX2 == entranceStairIndexX) {
            iX2 = this.random.nextInt(roomCount);
        }
        while (iZ2 == entranceStairIndexZ) {
            iZ2 = this.random.nextInt(roomCount);
        }
        this.exitStairIndex = new Tuple((Object)iX2, (Object)iZ2);
    }

    public Tuple<Integer, Integer> getExitStairIndexes() {
        return this.exitStairIndex;
    }

    public void setEntranceStairPosition(@Nonnull File entranceStair, int x, int y, int z) {
        this.entranceStair = entranceStair;
        this.yPos = y;
        this.entranceStairBlockPosition = new Tuple((Object)x, (Object)z);
        this.roomGrid[((Integer)this.entranceStairIndex.func_76341_a()).intValue()][((Integer)this.entranceStairIndex.func_76340_b()).intValue()] = new BlockPos(x, y, z);
    }

    public void setIsFirstFloor(boolean val) {
        this.isFirstFloor = val;
    }

    public void setExitIsBossRoom(boolean newVal) {
        this.exitStairIsBossRoom = newVal;
        if (newVal) {
            this.exitStairCorners = null;
        }
    }

    public Tuple<Integer, Integer> getExitCoordinates() {
        return this.exitStairBlockPosition;
    }

    public void calculatePositions() {
        Vec3i v = new Vec3i(this.generator.getDungeon().getRoomSizeX() / 2, 0, this.generator.getDungeon().getRoomSizeZ() / 2);
        for (int iX = 0; iX < this.sideLength; ++iX) {
            for (int iZ = 0; iZ < this.sideLength; ++iZ) {
                if (iX != (Integer)this.entranceStairIndex.func_76341_a() || iZ != (Integer)this.entranceStairIndex.func_76340_b()) {
                    BlockPos pos;
                    int multiplierX = iX - (Integer)this.entranceStairIndex.func_76341_a();
                    int multiplierZ = iZ - (Integer)this.entranceStairIndex.func_76340_b();
                    this.roomGrid[iX][iZ] = pos = new BlockPos((Integer)this.entranceStairBlockPosition.func_76341_a() + multiplierX * this.generator.getDungeon().getRoomSizeX(), this.yPos, (Integer)this.entranceStairBlockPosition.func_76340_b() + multiplierZ * this.generator.getDungeon().getRoomSizeZ());
                    if (iX != (Integer)this.exitStairIndex.func_76341_a() || iZ != (Integer)this.exitStairIndex.func_76340_b()) continue;
                    BlockPos p1 = pos.func_177973_b(v);
                    BlockPos p2 = pos.func_177971_a(v);
                    this.exitStairCorners = new Tuple((Object)p1, (Object)p2);
                    this.exitStairBlockPosition = new Tuple((Object)pos.func_177958_n(), (Object)pos.func_177952_p());
                    continue;
                }
                BlockPos p = new BlockPos(((Integer)this.entranceStairBlockPosition.func_76341_a()).intValue(), this.yPos, ((Integer)this.entranceStairBlockPosition.func_76340_b()).intValue());
                this.entranceStairCorners = new Tuple((Object)p.func_177973_b(v), (Object)p.func_177971_a(v));
            }
        }
        BlockPos exitPos = this.roomGrid[(Integer)this.exitStairIndex.func_76341_a()][(Integer)this.exitStairIndex.func_76340_b()];
        this.entranceStairBlockPosition = new Tuple((Object)exitPos.func_177958_n(), (Object)exitPos.func_177952_p());
    }

    public void generateRooms(World world, DungeonGenerator dungeonGenerator, DungeonInhabitant mobType) {
        for (int x = 0; x < this.sideLength; ++x) {
            for (int z = 0; z < this.sideLength; ++z) {
                BlockPos pos = this.roomGrid[x][z];
                File file = null;
                if (x != (Integer)this.exitStairIndex.func_76341_a() || z != (Integer)this.exitStairIndex.func_76340_b()) {
                    file = x == (Integer)this.entranceStairIndex.func_76341_a() && z == (Integer)this.entranceStairIndex.func_76340_b() ? (this.entranceStair != null ? this.entranceStair : (this.isFirstFloor ? this.generator.getDungeon().getEntranceStair(this.random) : this.generator.getDungeon().getStairRoom(this.random))) : this.generator.getDungeon().getRoom(this.random);
                } else if (this.exitStairIsBossRoom) {
                    file = this.generator.getDungeon().getBossRoom(this.random);
                    this.exitStairIsBossRoom = false;
                }
                if (pos == null || file == null) continue;
                CQStructure structure = this.generator.loadStructureFromFile(file);
                BlockPos p = DungeonGenUtils.getCentralizedPosForStructure(pos, structure, this.generator.getPlacementSettings());
                structure.addAll(world, dungeonGenerator, p, this.generator.getPlacementSettings(), mobType);
            }
        }
    }

    public void buildWalls(World world, DungeonGenerator dungeonGenerator, DungeonInhabitant mobType) {
        if (this.generator.getDungeon().getWallBlock() == null) {
            return;
        }
        HashMap<BlockPos, IBlockState> stateMap = new HashMap<BlockPos, IBlockState>();
        int dimX = this.generator.getDungeon().getRoomSizeX() / 2;
        int dimZ = this.generator.getDungeon().getRoomSizeZ() / 2;
        BlockPos p1 = this.roomGrid[this.sideLength - 1][this.sideLength - 1].func_177982_a(1, 0, 1).func_177982_a(dimX, -1, dimZ);
        BlockPos p2 = this.roomGrid[this.sideLength - 1][0].func_177982_a(1, 0, -1).func_177982_a(dimX, -1, -dimZ);
        BlockPos p3 = this.roomGrid[0][this.sideLength - 1].func_177982_a(-1, 0, 1).func_177982_a(-dimX, -1, dimZ);
        BlockPos p4 = this.roomGrid[0][0].func_177982_a(-1, 0, -1).func_177982_a(-dimX, -1, -dimZ);
        IBlockState state = this.generator.getDungeon().getWallBlock();
        int addY = 2 + this.generator.getDungeon().getRoomSizeY();
        for (BlockPos p12 : BlockPos.func_177975_b((BlockPos)p1, (BlockPos)p2.func_177982_a(0, addY, 0))) {
            stateMap.put(p12, state);
        }
        for (BlockPos p13 : BlockPos.func_177975_b((BlockPos)p1, (BlockPos)p3.func_177982_a(0, addY, 0))) {
            stateMap.put(p13, state);
        }
        for (BlockPos p42 : BlockPos.func_177975_b((BlockPos)p4, (BlockPos)p2.func_177982_a(0, addY, 0))) {
            stateMap.put(p42, state);
        }
        for (BlockPos p43 : BlockPos.func_177975_b((BlockPos)p4, (BlockPos)p3.func_177982_a(0, addY, 0))) {
            stateMap.put(p43, state);
        }
        for (BlockPos pT : BlockPos.func_177975_b((BlockPos)p1.func_177982_a(0, 2 + this.generator.getDungeon().getRoomSizeY(), 0), (BlockPos)p4.func_177982_a(0, addY, 0))) {
            if (pT.func_177958_n() >= ((BlockPos)this.entranceStairCorners.func_76341_a()).func_177958_n() && pT.func_177958_n() <= ((BlockPos)this.entranceStairCorners.func_76340_b()).func_177958_n() && pT.func_177952_p() >= ((BlockPos)this.entranceStairCorners.func_76341_a()).func_177952_p() && pT.func_177952_p() <= ((BlockPos)this.entranceStairCorners.func_76340_b()).func_177952_p()) continue;
            stateMap.put(pT, state);
        }
        for (BlockPos pB : BlockPos.func_177975_b((BlockPos)p1, (BlockPos)p4)) {
            if (!this.exitStairIsBossRoom && (pB == null || this.exitStairCorners == null || pB.func_177958_n() >= ((BlockPos)this.exitStairCorners.func_76341_a()).func_177958_n() && pB.func_177958_n() <= ((BlockPos)this.exitStairCorners.func_76340_b()).func_177958_n() && pB.func_177952_p() >= ((BlockPos)this.exitStairCorners.func_76341_a()).func_177952_p() && pB.func_177952_p() <= ((BlockPos)this.exitStairCorners.func_76340_b()).func_177952_p())) continue;
            stateMap.put(pB, state);
        }
        ArrayList<AbstractBlockInfo> blockInfoList = new ArrayList<AbstractBlockInfo>();
        for (Map.Entry entry : stateMap.entrySet()) {
            blockInfoList.add(new BlockInfo(((BlockPos)entry.getKey()).func_177973_b((Vec3i)this.generator.getPos()), (IBlockState)entry.getValue(), null));
        }
        dungeonGenerator.add(new DungeonPartBlock(world, dungeonGenerator, this.generator.getPos(), blockInfoList, new PlacementSettings(), mobType));
    }
}

