/*
 * Decompiled with CFR 0.152.
 */
package team.cqr.cqrepoured.structuregen.generators.stronghold.spiral;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.BlockRotatedPillar;
import net.minecraft.block.BlockTorch;
import net.minecraft.block.properties.IProperty;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraft.world.gen.structure.template.PlacementSettings;
import team.cqr.cqrepoured.init.CQRBlocks;
import team.cqr.cqrepoured.structuregen.dungeons.DungeonVolcano;
import team.cqr.cqrepoured.structuregen.generation.AbstractDungeonPart;
import team.cqr.cqrepoured.structuregen.generation.DungeonGenerator;
import team.cqr.cqrepoured.structuregen.generation.DungeonPartBlock;
import team.cqr.cqrepoured.structuregen.generators.AbstractDungeonGenerator;
import team.cqr.cqrepoured.structuregen.generators.stronghold.spiral.SpiralStrongholdBuilder;
import team.cqr.cqrepoured.structuregen.generators.volcano.StairCaseHelper;
import team.cqr.cqrepoured.structuregen.inhabitants.DungeonInhabitant;
import team.cqr.cqrepoured.structuregen.structurefile.AbstractBlockInfo;
import team.cqr.cqrepoured.structuregen.structurefile.BlockInfo;
import team.cqr.cqrepoured.util.ESkyDirection;

public class StrongholdBuilder {
    private final Random random;
    private AbstractDungeonGenerator<DungeonVolcano> generator;
    private DungeonGenerator dungeonGenerator;
    private BlockPos startPos;
    private DungeonVolcano dungeon;
    private int blocksRemainingToWall;
    private EnumFacing direction;
    private World world;
    private List<AbstractDungeonPart> strongholdParts = new ArrayList<AbstractDungeonPart>();

    public StrongholdBuilder(AbstractDungeonGenerator<DungeonVolcano> generator, DungeonGenerator dungeonGenerator, BlockPos start, int distanceToWall, DungeonVolcano dungeon, EnumFacing expansionDirection, World world, Random rand) {
        this.generator = generator;
        this.dungeonGenerator = dungeonGenerator;
        this.startPos = start;
        this.dungeon = dungeon;
        this.blocksRemainingToWall = distanceToWall;
        this.direction = expansionDirection;
        this.world = world;
        this.random = rand;
    }

    public void generate(int cX, int cZ, DungeonInhabitant mobType) {
        Vec3i expansionVector = new Vec3i(0, 0, 0);
        switch (this.direction) {
            case EAST: {
                expansionVector = new Vec3i(3, 0, 0);
                break;
            }
            case NORTH: {
                expansionVector = new Vec3i(0, 0, -3);
                break;
            }
            case SOUTH: {
                expansionVector = new Vec3i(0, 0, 3);
                break;
            }
            case WEST: {
                expansionVector = new Vec3i(-3, 0, 0);
                break;
            }
        }
        BlockPos pos = this.startPos;
        ArrayList<AbstractBlockInfo> blockInfoList = new ArrayList<AbstractBlockInfo>();
        for (int i = 0; i < this.blocksRemainingToWall / 4 + 2; ++i) {
            this.buildSegment(pos.func_177973_b((Vec3i)this.startPos), blockInfoList);
            pos = pos.func_177971_a(expansionVector);
        }
        this.strongholdParts.add(new DungeonPartBlock(this.world, this.dungeonGenerator, this.startPos, blockInfoList, new PlacementSettings(), mobType));
        this.buildStronghold(pos.func_177982_a(0, -1, 0), this.world, cX, cZ, mobType);
    }

    private void buildStronghold(BlockPos pos, World world2, int cX, int cZ, DungeonInhabitant mobType) {
        SpiralStrongholdBuilder stronghold = new SpiralStrongholdBuilder(this.generator, this.dungeonGenerator, ESkyDirection.fromFacing(this.direction), this.dungeon, this.random);
        stronghold.calculateFloors(pos, world2, mobType);
        stronghold.buildFloors(pos.func_177982_a(0, -1, 0), this.world, mobType);
        this.strongholdParts.addAll(stronghold.getStrongholdParts());
    }

    private void buildSegment(BlockPos startPosCentered, List<AbstractBlockInfo> blockInfoList) {
        BlockPos corner1 = null;
        BlockPos corner2 = null;
        BlockPos pillar1 = null;
        BlockPos pillar2 = null;
        BlockPos torch1 = null;
        BlockPos torch2 = null;
        BlockPos air1 = null;
        BlockPos air2 = null;
        switch (this.direction) {
            case EAST: {
                corner1 = startPosCentered.func_177982_a(0, 0, -3);
                corner2 = startPosCentered.func_177982_a(3, 0, 3);
                air1 = startPosCentered.func_177982_a(0, 1, -2);
                air2 = startPosCentered.func_177982_a(3, 5, -2);
                pillar1 = startPosCentered.func_177982_a(1, 0, 2);
                pillar2 = startPosCentered.func_177982_a(1, 0, -2);
                torch1 = startPosCentered.func_177982_a(1, 4, 1);
                torch2 = startPosCentered.func_177982_a(1, 4, -1);
                break;
            }
            case NORTH: {
                corner1 = startPosCentered.func_177982_a(-3, 0, 0);
                corner2 = startPosCentered.func_177982_a(3, 0, -3);
                air1 = startPosCentered.func_177982_a(-2, 1, 0);
                air2 = startPosCentered.func_177982_a(2, 5, -3);
                pillar1 = startPosCentered.func_177982_a(2, 0, -1);
                pillar2 = startPosCentered.func_177982_a(-2, 0, -1);
                torch1 = startPosCentered.func_177982_a(1, 4, -1);
                torch2 = startPosCentered.func_177982_a(-1, 4, -1);
                break;
            }
            case SOUTH: {
                corner1 = startPosCentered.func_177982_a(3, 0, 0);
                corner2 = startPosCentered.func_177982_a(-3, 0, 3);
                air1 = startPosCentered.func_177982_a(2, 1, 0);
                air2 = startPosCentered.func_177982_a(-2, 5, 3);
                pillar1 = startPosCentered.func_177982_a(-2, 0, 1);
                pillar2 = startPosCentered.func_177982_a(2, 0, 1);
                torch1 = startPosCentered.func_177982_a(-1, 4, 1);
                torch2 = startPosCentered.func_177982_a(1, 4, 1);
                break;
            }
            case WEST: {
                corner1 = startPosCentered.func_177982_a(0, 0, 3);
                corner2 = startPosCentered.func_177982_a(-3, 0, -3);
                air1 = startPosCentered.func_177982_a(0, 1, 2);
                air2 = startPosCentered.func_177982_a(-3, 5, 2);
                pillar1 = startPosCentered.func_177982_a(-1, 0, -2);
                pillar2 = startPosCentered.func_177982_a(-1, 0, 2);
                torch1 = startPosCentered.func_177982_a(-1, 4, -1);
                torch2 = startPosCentered.func_177982_a(-1, 4, 1);
                break;
            }
        }
        if (corner1 != null && corner2 != null && pillar1 != null && pillar2 != null) {
            this.buildFloorAndCeiling(corner1, corner2, 5, blockInfoList);
            this.buildPillar(pillar1, blockInfoList);
            blockInfoList.add(new BlockInfo(torch1, CQRBlocks.UNLIT_TORCH.func_176223_P().func_177226_a((IProperty)BlockTorch.field_176596_a, (Comparable)StairCaseHelper.getFacingWithRotation(this.direction, Rotation.COUNTERCLOCKWISE_90)), null));
            this.buildPillar(pillar2, blockInfoList);
            blockInfoList.add(new BlockInfo(torch2, CQRBlocks.UNLIT_TORCH.func_176223_P().func_177226_a((IProperty)BlockTorch.field_176596_a, (Comparable)StairCaseHelper.getFacingWithRotation(this.direction, Rotation.CLOCKWISE_90)), null));
        }
    }

    private void buildPillar(BlockPos bottom, List<AbstractBlockInfo> blockInfoList) {
        for (int iY = 1; iY <= 4; ++iY) {
            BlockPos pos = bottom.func_177982_a(0, iY, 0);
            blockInfoList.add(new BlockInfo(pos, CQRBlocks.GRANITE_PILLAR.func_176223_P().func_177226_a((IProperty)BlockRotatedPillar.field_176298_M, (Comparable)EnumFacing.Axis.Y), null));
        }
        blockInfoList.add(new BlockInfo(bottom.func_177982_a(0, 5, 0), CQRBlocks.GRANITE_CARVED.func_176223_P(), null));
    }

    private void buildFloorAndCeiling(BlockPos start, BlockPos end, int ceilingHeight, List<AbstractBlockInfo> blockInfoList) {
        BlockPos endP = new BlockPos(end.func_177958_n(), start.func_177956_o(), end.func_177952_p());
        for (BlockPos p : BlockPos.func_177980_a((BlockPos)start, (BlockPos)endP)) {
            blockInfoList.add(new BlockInfo(p, CQRBlocks.GRANITE_SMALL.func_176223_P(), null));
        }
        for (BlockPos p : BlockPos.func_177980_a((BlockPos)start.func_177982_a(0, ceilingHeight + 1, 0), (BlockPos)endP.func_177982_a(0, ceilingHeight + 1, 0))) {
            blockInfoList.add(new BlockInfo(p, CQRBlocks.GRANITE_SQUARE.func_176223_P(), null));
        }
    }

    public List<AbstractDungeonPart> getStrongholdParts() {
        return this.strongholdParts;
    }
}

