/*
 * Decompiled with CFR 0.152.
 */
package team.cqr.cqrepoured.structuregen.generators.volcano;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.function.Consumer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.gen.structure.template.PlacementSettings;
import team.cqr.cqrepoured.objects.factories.GearedMobFactory;
import team.cqr.cqrepoured.structuregen.DungeonDataManager;
import team.cqr.cqrepoured.structuregen.dungeons.DungeonVolcano;
import team.cqr.cqrepoured.structuregen.generation.DungeonPartBlock;
import team.cqr.cqrepoured.structuregen.generation.DungeonPartCover;
import team.cqr.cqrepoured.structuregen.generation.DungeonPartPlateau;
import team.cqr.cqrepoured.structuregen.generators.AbstractDungeonGenerator;
import team.cqr.cqrepoured.structuregen.generators.stronghold.spiral.StrongholdBuilder;
import team.cqr.cqrepoured.structuregen.generators.volcano.StairCaseHelper;
import team.cqr.cqrepoured.structuregen.inhabitants.DungeonInhabitant;
import team.cqr.cqrepoured.structuregen.inhabitants.DungeonInhabitantManager;
import team.cqr.cqrepoured.structuregen.structurefile.AbstractBlockInfo;
import team.cqr.cqrepoured.structuregen.structurefile.BlockInfo;
import team.cqr.cqrepoured.structuregen.structurefile.BlockInfoLootChest;
import team.cqr.cqrepoured.structuregen.structurefile.BlockInfoSpawner;
import team.cqr.cqrepoured.util.CQRWeightedRandom;
import team.cqr.cqrepoured.util.DungeonGenUtils;

public class GeneratorVolcano
extends AbstractDungeonGenerator<DungeonVolcano> {
    private final int volcanoHeight;
    private final double steepness;
    private final int minRadius;
    private final int caveHeight;
    private final int caveDepth;
    private final StairCaseHelper.EStairSection startStairSection = StairCaseHelper.getRandomStartSection();
    private final CQRWeightedRandom<IBlockState> volcanoBlocks;
    private final CQRWeightedRandom<IBlockState> volcanoBlocksWithLava;

    public GeneratorVolcano(World world, BlockPos pos, DungeonVolcano dungeon, Random rand, DungeonDataManager.DungeonSpawnType spawnType) {
        super(world, pos, dungeon, rand, spawnType);
        this.volcanoHeight = DungeonGenUtils.randomBetween(dungeon.getMinHeight(), dungeon.getMaxHeight(), this.random);
        this.steepness = dungeon.getSteepness();
        this.minRadius = dungeon.getInnerRadius();
        this.caveHeight = (int)((double)this.volcanoHeight * 0.6);
        this.caveDepth = 30;
        this.volcanoBlocks = ((DungeonVolcano)this.dungeon).getVolcanoBlocks().copy();
        this.volcanoBlocksWithLava = ((DungeonVolcano)this.dungeon).getVolcanoBlocks().copy();
        this.volcanoBlocksWithLava.add(new CQRWeightedRandom.WeightedObject<IBlockState>(((DungeonVolcano)this.dungeon).getLavaBlock(), ((DungeonVolcano)this.dungeon).getLavaWeight()));
    }

    @Override
    public void preProcess() {
    }

    @Override
    public void buildStructure() {
        int iZ;
        int iX;
        int outerRadius;
        int iY;
        int[] outerRadiusArray = new int[this.volcanoHeight + this.caveDepth];
        int[] innerRadiusArray = new int[this.volcanoHeight + this.caveDepth];
        double d = Math.cbrt(((double)this.volcanoHeight + 80.0) / this.steepness);
        int baseRadius = this.minRadius * 2 + (int)(d - Math.cbrt(60.0 / this.steepness));
        for (int iY2 = -this.caveDepth; iY2 < this.volcanoHeight; ++iY2) {
            outerRadiusArray[iY2 + this.caveDepth] = iY2 > -20 ? this.minRadius * 2 + (int)(d - Math.cbrt(((double)iY2 + 80.0) / this.steepness)) : baseRadius + (-20 - iY2) / 5;
            innerRadiusArray[iY2 + this.caveDepth] = this.minRadius + (int)Math.sqrt(((double)this.caveHeight - (double)iY2) / (3000.0 * this.steepness));
        }
        int r = outerRadiusArray[0];
        BlockPos referenceLoc = this.pos.func_177982_a(-r, -this.caveDepth, -r);
        IBlockState[][][] blocks = new IBlockState[r * 2 + 1][this.volcanoHeight + this.caveDepth + 2][r * 2 + 1];
        ArrayList<BlockPos> spawnerAndChestList = new ArrayList<BlockPos>();
        if (((DungeonVolcano)this.dungeon).doBuildSupportPlatform()) {
            this.dungeonGenerator.add(new DungeonPartPlateau(this.world, this.dungeonGenerator, this.pos.func_177958_n() - r, this.pos.func_177952_p() - r, this.pos.func_177958_n() + r, this.pos.func_177956_o() - this.caveDepth, this.pos.func_177952_p() + r, ((DungeonVolcano)this.dungeon).getSupportBlock(), ((DungeonVolcano)this.dungeon).getSupportTopBlock(), 8));
        }
        for (iY = 0; iY < this.volcanoHeight + this.caveDepth; ++iY) {
            outerRadius = outerRadiusArray[iY];
            int innerRadius = innerRadiusArray[iY];
            for (int iX2 = -outerRadius; iX2 <= outerRadius; ++iX2) {
                for (int iZ2 = -outerRadius; iZ2 <= outerRadius; ++iZ2) {
                    if (DungeonGenUtils.isInsideCircle(iX2, iZ2, innerRadius)) {
                        blocks[iX2 + r][iY][iZ2 + r] = Blocks.field_150350_a.func_176223_P();
                        continue;
                    }
                    if (!DungeonGenUtils.isInsideCircle(iX2, iZ2, outerRadius)) continue;
                    blocks[iX2 + r][iY][iZ2 + r] = !DungeonGenUtils.isInsideCircle(iX2, iZ2, innerRadius + 2) ? this.getRandomVolcanoBlockWithLava() : this.getRandomVolcanoBlock();
                }
            }
        }
        for (iY = 0; iY < this.volcanoHeight + this.caveDepth; ++iY) {
            outerRadius = outerRadiusArray[iY];
            for (iX = -outerRadius; iX <= outerRadius; ++iX) {
                for (iZ = -outerRadius; iZ <= outerRadius; ++iZ) {
                    if (!DungeonGenUtils.isInsideCircle(iX, iZ, outerRadius) || DungeonGenUtils.isInsideCircle(iX, iZ, outerRadius - 2) && (iY != this.volcanoHeight + this.caveDepth - 1 || DungeonGenUtils.isInsideCircle(iX, iZ, innerRadiusArray[iY])) || !DungeonGenUtils.percentageRandom(0.05, this.random)) continue;
                    GeneratorVolcano.forEachSpherePosition(new BlockPos(iX, iY, iZ), 2 + this.random.nextInt(3), p -> {
                        if (this.isIndexValid(p.func_177958_n() + r, p.func_177956_o(), p.func_177952_p() + r, blocks) && blocks[p.func_177958_n() + r][p.func_177956_o()][p.func_177952_p() + r] == null) {
                            blocks[p.func_177958_n() + r][p.func_177956_o()][p.func_177952_p() + r] = this.getRandomVolcanoBlockWithLava();
                        }
                    });
                }
            }
        }
        this.generateHoles(blocks);
        for (iY = 0; iY < this.volcanoHeight + this.caveDepth; ++iY) {
            int innerRadius = innerRadiusArray[iY];
            for (iX = -innerRadius; iX <= innerRadius; ++iX) {
                for (iZ = -innerRadius; iZ <= innerRadius; ++iZ) {
                    if (iY < 2 && DungeonGenUtils.isInsideCircle(iX, iZ, innerRadius)) {
                        blocks[iX + r][iY][iZ + r] = ((DungeonVolcano)this.dungeon).getLavaBlock();
                    }
                    if (!DungeonGenUtils.isInsideCircle(iX, iZ, innerRadius + 2) || DungeonGenUtils.isInsideCircle(iX, iZ, innerRadius) || !DungeonGenUtils.percentageRandom(0.05, this.random)) continue;
                    GeneratorVolcano.forEachSpherePosition(new BlockPos(iX, iY, iZ), 1 + this.random.nextInt(3), p -> {
                        if (this.isIndexValid(p.func_177958_n() + r, p.func_177956_o(), p.func_177952_p() + r, blocks) && blocks[p.func_177958_n() + r][p.func_177956_o()][p.func_177952_p() + r] == Blocks.field_150350_a.func_176223_P()) {
                            blocks[p.func_177958_n() + r][p.func_177956_o()][p.func_177952_p() + r] = this.getRandomVolcanoBlock();
                        }
                    });
                }
            }
        }
        if (((DungeonVolcano)this.dungeon).doBuildStairs()) {
            StairCaseHelper.EStairSection stairSection = this.startStairSection;
            int iY3 = -1;
            while ((double)iY3 < (double)(this.caveHeight + this.caveDepth) * 0.9) {
                int y = Math.max(iY3, 1);
                int outerStairRadius = innerRadiusArray[y];
                int innerStairRadius = outerStairRadius / 2;
                for (int iX3 = -outerStairRadius; iX3 <= outerStairRadius; ++iX3) {
                    for (int iZ3 = -outerStairRadius; iZ3 <= outerStairRadius; ++iZ3) {
                        if (!DungeonGenUtils.isInsideCircle(iX3, iZ3, outerStairRadius) || DungeonGenUtils.isInsideCircle(iX3, iZ3, innerStairRadius) || !StairCaseHelper.isLocationFine(stairSection, iX3, iZ3, outerStairRadius)) continue;
                        blocks[iX3 + r][y][iZ3 + r] = ((DungeonVolcano)this.dungeon).getRampBlock();
                        if (!DungeonGenUtils.isInsideCircle(iX3, iZ3, outerStairRadius - 2) || DungeonGenUtils.isInsideCircle(iX3, iZ3, innerStairRadius + 2) || !DungeonGenUtils.percentageRandom(((DungeonVolcano)this.dungeon).getChestChance(), this.random)) continue;
                        spawnerAndChestList.add(new BlockPos(iX3, y - this.caveDepth + 1, iZ3));
                    }
                }
                stairSection = stairSection.getSuccessor();
                ++iY3;
            }
            this.generatePillars(new BlockPos(r + innerRadiusArray[0] / 2, 0, r), 2, (int)((double)(this.caveHeight + this.caveDepth) * 0.95), blocks, ((DungeonVolcano)this.dungeon).getPillarBlock());
            this.generatePillars(new BlockPos(r - innerRadiusArray[0] / 2, 0, r), 2, (int)((double)(this.caveHeight + this.caveDepth) * 0.95), blocks, ((DungeonVolcano)this.dungeon).getPillarBlock());
            this.generatePillars(new BlockPos(r, 0, r + innerRadiusArray[0] / 2), 2, (int)((double)(this.caveHeight + this.caveDepth) * 0.95), blocks, ((DungeonVolcano)this.dungeon).getPillarBlock());
            this.generatePillars(new BlockPos(r, 0, r - innerRadiusArray[0] / 2), 2, (int)((double)(this.caveHeight + this.caveDepth) * 0.95), blocks, ((DungeonVolcano)this.dungeon).getPillarBlock());
        }
        DungeonInhabitant mobType = DungeonInhabitantManager.instance().getInhabitantByDistanceIfDefault(((DungeonVolcano)this.dungeon).getDungeonMob(), this.world, this.pos.func_177958_n(), this.pos.func_177952_p());
        ArrayList<AbstractBlockInfo> blockInfoList = new ArrayList<AbstractBlockInfo>(blocks.length * blocks[0].length * blocks[0][0].length / 2);
        for (int i = 0; i < blocks.length; ++i) {
            for (int j = 0; j < blocks[i].length; ++j) {
                for (int k = 0; k < blocks[i][j].length; ++k) {
                    if (blocks[i][j][k] == null) continue;
                    blockInfoList.add(new BlockInfo(i, j, k, blocks[i][j][k], null));
                }
            }
        }
        this.dungeonGenerator.add(new DungeonPartBlock(this.world, this.dungeonGenerator, referenceLoc, blockInfoList, new PlacementSettings(), mobType));
        this.generateSpawnersAndChests(spawnerAndChestList, mobType);
        this.generateStronghold(innerRadiusArray[0], mobType);
        if (((DungeonVolcano)this.dungeon).isCoverBlockEnabled()) {
            this.dungeonGenerator.add(new DungeonPartCover(this.world, this.dungeonGenerator, this.pos.func_177958_n() - r, this.pos.func_177952_p() - r, this.pos.func_177958_n() + r, this.pos.func_177952_p() + r, ((DungeonVolcano)this.dungeon).getCoverBlock()));
        }
    }

    @Override
    public void postProcess() {
    }

    private void generateHoles(IBlockState[][][] blocks) {
        if (((DungeonVolcano)this.dungeon).isVolcanoDamaged()) {
            ArrayList<BlockPos> list = new ArrayList<BlockPos>((int)((double)this.volcanoHeight * 1.6));
            int i = 0;
            while ((double)i < (double)this.volcanoHeight * 1.6) {
                for (int j = 0; j < 100; ++j) {
                    int z;
                    int y;
                    int x = this.random.nextInt(blocks.length);
                    if (blocks[x][y = this.random.nextInt(blocks[x].length)][z = this.random.nextInt(blocks[x][y].length)] == null || blocks[x][y][z] == Blocks.field_150350_a.func_176223_P()) continue;
                    list.add(new BlockPos(x, y, z));
                    break;
                }
                ++i;
            }
            for (BlockPos pos : list) {
                GeneratorVolcano.forEachSpherePosition(pos, DungeonGenUtils.randomBetween(2, ((DungeonVolcano)this.dungeon).getMaxHoleSize(), this.random), p -> {
                    if (this.isIndexValid(p.func_177958_n(), p.func_177956_o(), p.func_177952_p(), blocks) && blocks[p.func_177958_n()][p.func_177956_o()][p.func_177952_p()] != null && blocks[p.func_177958_n()][p.func_177956_o()][p.func_177952_p()] != Blocks.field_150350_a.func_176223_P()) {
                        blocks[p.func_177958_n()][p.func_177956_o()][p.func_177952_p()] = Blocks.field_150350_a.func_176223_P();
                    }
                });
            }
        }
    }

    private void generatePillars(BlockPos pos, int radius, int height, IBlockState[][][] blocks, IBlockState pillarBlock) {
        for (int iY = 0; iY < height; ++iY) {
            for (int iX = -radius; iX <= radius; ++iX) {
                for (int iZ = -radius; iZ <= radius; ++iZ) {
                    try {
                        blocks[iX + pos.func_177958_n()][iY + pos.func_177956_o()][iZ + pos.func_177952_p()] = pillarBlock;
                        continue;
                    }
                    catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                        // empty catch block
                    }
                }
            }
        }
    }

    private void generateSpawnersAndChests(List<BlockPos> spawnerAndChestList, DungeonInhabitant mobType) {
        if (!spawnerAndChestList.isEmpty()) {
            ResourceLocation[] lootTables = ((DungeonVolcano)this.dungeon).getChestIDs();
            GearedMobFactory mobFactory = new GearedMobFactory(spawnerAndChestList.size(), ((DungeonVolcano)this.dungeon).getRampMob(), this.random);
            int floor = spawnerAndChestList.size();
            ArrayList<AbstractBlockInfo> blockInfoList1 = new ArrayList<AbstractBlockInfo>();
            for (BlockPos pos : spawnerAndChestList) {
                if (this.random.nextBoolean()) {
                    blockInfoList1.add(new BlockInfoLootChest(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), lootTables[this.random.nextInt(lootTables.length)], EnumFacing.NORTH));
                }
                int entityCount = 2 + this.random.nextInt(3);
                ArrayList<Entity> entityList = new ArrayList<Entity>(entityCount);
                for (int i = 0; i < entityCount; ++i) {
                    entityList.add(mobFactory.getGearedEntityByFloor(floor, this.world));
                }
                blockInfoList1.add(new BlockInfoSpawner(pos.func_177958_n(), pos.func_177956_o() + 1, pos.func_177952_p(), entityList));
                --floor;
            }
            this.dungeonGenerator.add(new DungeonPartBlock(this.world, this.dungeonGenerator, this.pos, blockInfoList1, new PlacementSettings(), mobType));
        }
    }

    private void generateStronghold(int radius, DungeonInhabitant mobType) {
        if (((DungeonVolcano)this.dungeon).doBuildStronghold()) {
            BlockPos entranceStartPos;
            StairCaseHelper.EStairSection entranceDirection = this.startStairSection.getSuccessor();
            int entranceDistToWall = radius / 3;
            int wideness = radius - entranceDistToWall;
            switch (entranceDirection) {
                case EAST: 
                case EAST_SEC: {
                    entranceStartPos = this.pos.func_177982_a(wideness, 1 - this.caveDepth, 0);
                    break;
                }
                case NORTH: 
                case NORTH_SEC: {
                    entranceStartPos = this.pos.func_177982_a(0, 1 - this.caveDepth, -wideness);
                    break;
                }
                case SOUTH: 
                case SOUTH_SEC: {
                    entranceStartPos = this.pos.func_177982_a(0, 1 - this.caveDepth, wideness);
                    break;
                }
                default: {
                    entranceStartPos = this.pos.func_177982_a(-wideness, 1 - this.caveDepth, 0);
                }
            }
            StrongholdBuilder entranceBuilder = new StrongholdBuilder(this, this.dungeonGenerator, entranceStartPos, entranceDistToWall, (DungeonVolcano)this.dungeon, entranceDirection.getAsSkyDirection(), this.world, this.random);
            entranceBuilder.generate(this.pos.func_177958_n(), this.pos.func_177952_p(), mobType);
            this.dungeonGenerator.addAll(entranceBuilder.getStrongholdParts());
        }
    }

    public static void forEachSpherePosition(BlockPos center, int radius, Consumer<BlockPos.MutableBlockPos> action) {
        for (BlockPos.MutableBlockPos p : BlockPos.func_191531_b((int)(center.func_177958_n() - radius), (int)(center.func_177956_o() - radius), (int)(center.func_177952_p() - radius), (int)(center.func_177958_n() + radius), (int)(center.func_177956_o() + radius), (int)(center.func_177952_p() + radius))) {
            if (!DungeonGenUtils.isInsideSphere(p.func_177958_n() - center.func_177958_n(), p.func_177956_o() - center.func_177956_o(), p.func_177952_p() - center.func_177952_p(), radius)) continue;
            action.accept(p);
        }
    }

    private boolean isIndexValid(int x, int y, int z, Object[][][] array) {
        return x >= 0 && x < array.length && y >= 0 && y < array[x].length && z >= 0 && z < array[x][y].length;
    }

    private IBlockState getRandomVolcanoBlock() {
        IBlockState state = this.volcanoBlocks.next(this.random);
        return state != null ? state : Blocks.field_150348_b.func_176223_P();
    }

    private IBlockState getRandomVolcanoBlockWithLava() {
        IBlockState state = this.volcanoBlocksWithLava.next(this.random);
        return state != null ? state : Blocks.field_150348_b.func_176223_P();
    }
}

