/*
 * Decompiled with CFR 0.152.
 */
package team.cqr.cqrepoured.structuregen.inhabitants;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import org.apache.commons.io.FileUtils;
import team.cqr.cqrepoured.CQRMain;
import team.cqr.cqrepoured.factions.CQRFaction;
import team.cqr.cqrepoured.factions.FactionRegistry;
import team.cqr.cqrepoured.structuregen.inhabitants.DungeonInhabitant;
import team.cqr.cqrepoured.structuregen.inhabitants.EDefaultInhabitants;
import team.cqr.cqrepoured.util.CQRConfig;
import team.cqr.cqrepoured.util.DungeonGenUtils;

public class DungeonInhabitantManager {
    public static final DungeonInhabitant DEFAULT_DUNGEON_INHABITANT = new DungeonInhabitant(EDefaultInhabitants.DEFAULT);
    private static final DungeonInhabitantManager INSTANCE = new DungeonInhabitantManager();
    private final Random random = new Random();
    private final Map<String, DungeonInhabitant> inhabitantMapping = new HashMap<String, DungeonInhabitant>();
    private final List<List<String>> distantMapping = new ArrayList<List<String>>();

    private DungeonInhabitantManager() {
    }

    public static DungeonInhabitantManager instance() {
        return INSTANCE;
    }

    public void loadDungeonInhabitants() {
        this.inhabitantMapping.clear();
        this.loadDefaultInhabitants();
        this.loadInhabitantConfigs();
        this.loadDistantMapping();
        this.inhabitantMapping.put("DEFAULT", DEFAULT_DUNGEON_INHABITANT);
    }

    private void loadDefaultInhabitants() {
        for (EDefaultInhabitants defInha : EDefaultInhabitants.values()) {
            DungeonInhabitant inha = new DungeonInhabitant(defInha);
            this.inhabitantMapping.put(inha.getName().toUpperCase(), inha);
        }
    }

    private void loadInhabitantConfigs() {
        for (File file : FileUtils.listFiles((File)CQRMain.CQ_INHABITANT_FOLDER, (String[])new String[]{"cfg", "prop", "properties"}, (boolean)true)) {
            try {
                FileInputStream inputStream = new FileInputStream(file);
                Throwable throwable = null;
                try {
                    Properties prop = new Properties();
                    prop.load(inputStream);
                    try {
                        DungeonInhabitant inha = new DungeonInhabitant(prop);
                        this.inhabitantMapping.put(inha.getName().toUpperCase(), inha);
                    }
                    catch (Exception e) {
                        CQRMain.logger.warn(String.format("Failed to create DungeonInhabitant object from file: %s", file.getName()), (Throwable)e);
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (inputStream == null) continue;
                    if (throwable != null) {
                        try {
                            ((InputStream)inputStream).close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    ((InputStream)inputStream).close();
                }
            }
            catch (IOException e) {
                CQRMain.logger.error(String.format("Failed to load file %s", file.getName()), (Throwable)e);
            }
        }
    }

    private void loadDistantMapping() {
        File file = new File(CQRMain.CQ_CONFIG_FOLDER, "defaultInhabitantConfig.properties");
        if (file.exists()) {
            try (BufferedReader br = new BufferedReader(new FileReader(file));){
                String currentLine;
                while ((currentLine = br.readLine()) != null) {
                    if (currentLine.startsWith("#")) continue;
                    String[] entries = currentLine.split(",");
                    ArrayList<String> tmpList = new ArrayList<String>();
                    for (String s : entries) {
                        if (!this.inhabitantMapping.containsKey(s = s.trim()) || s.equalsIgnoreCase(DEFAULT_DUNGEON_INHABITANT.getName())) continue;
                        tmpList.add(s);
                    }
                    if (tmpList.isEmpty()) continue;
                    this.distantMapping.add(tmpList);
                }
            }
            catch (IOException e) {
                CQRMain.logger.error(String.format("Failed to load file %s", file.getName()), (Throwable)e);
            }
        }
    }

    public DungeonInhabitant getInhabitant(String name) {
        return this.inhabitantMapping.getOrDefault(name, DEFAULT_DUNGEON_INHABITANT);
    }

    public DungeonInhabitant getInhabitantByDistance(World world, int blockX, int blockZ) {
        int z1;
        if (this.distantMapping.isEmpty()) {
            return (DungeonInhabitant)this.inhabitantMapping.values().toArray()[this.random.nextInt(this.inhabitantMapping.size())];
        }
        int x1 = blockX - DungeonGenUtils.getSpawnX(world);
        int distToSpawn = (int)Math.sqrt(x1 * x1 + (z1 = blockZ - DungeonGenUtils.getSpawnZ(world)) * z1);
        int index = distToSpawn / CQRConfig.mobs.mobTypeChangeDistance;
        if (index >= this.distantMapping.size()) {
            index = this.random.nextInt(this.distantMapping.size());
        }
        List<String> tmpList = this.distantMapping.get(index);
        return this.getInhabitant(tmpList.get(this.random.nextInt(tmpList.size())));
    }

    public DungeonInhabitant getInhabitantByDistanceIfDefault(String name, World world, int blockX, int blockZ) {
        DungeonInhabitant dungeonInhabitant = this.getInhabitant(name);
        if (dungeonInhabitant != DEFAULT_DUNGEON_INHABITANT) {
            return dungeonInhabitant;
        }
        return this.getInhabitantByDistance(world, blockX, blockZ);
    }

    public List<DungeonInhabitant> getListOfFactionInhabitants(CQRFaction faction, World world) {
        ArrayList<DungeonInhabitant> result = new ArrayList<DungeonInhabitant>();
        for (DungeonInhabitant inha : this.inhabitantMapping.values()) {
            if (inha.getName().equalsIgnoreCase(DEFAULT_DUNGEON_INHABITANT.getName())) continue;
            if (inha.getFactionOverride() != null) {
                if (!faction.equals(FactionRegistry.instance().getFactionInstance(inha.getFactionOverride()))) continue;
                result.add(inha);
                continue;
            }
            Entity entity = EntityList.func_188429_b((ResourceLocation)inha.getEntityID(), (World)world);
            if (entity == null || !FactionRegistry.instance().getFactionOf(entity).equals(faction)) continue;
            result.add(inha);
        }
        return result;
    }
}

