/*
 * Decompiled with CFR 0.152.
 */
package team.cqr.cqrepoured.structuregen.lootchests;

import com.google.common.cache.LoadingCache;
import com.google.common.collect.Queues;
import com.google.common.io.Files;
import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.WorldServer;
import net.minecraft.world.storage.loot.LootEntry;
import net.minecraft.world.storage.loot.LootPool;
import net.minecraft.world.storage.loot.LootTable;
import net.minecraft.world.storage.loot.LootTableManager;
import net.minecraft.world.storage.loot.RandomValueRange;
import net.minecraft.world.storage.loot.conditions.LootCondition;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.event.ForgeEventFactory;
import org.apache.commons.io.FileUtils;
import team.cqr.cqrepoured.CQRMain;
import team.cqr.cqrepoured.init.CQRLoottables;
import team.cqr.cqrepoured.structuregen.lootchests.WeightedItemStack;
import team.cqr.cqrepoured.util.CQRConfig;
import team.cqr.cqrepoured.util.reflection.ReflectionConstructor;
import team.cqr.cqrepoured.util.reflection.ReflectionField;

public class LootTableLoader {
    private static final ReflectionField<ThreadLocal<Deque<?>>> LOOT_CONTEXT = new ReflectionField(ForgeHooks.class, "lootContext", "lootContext");
    private static final ReflectionConstructor<?> LOOT_TABLE_CONTEXT = new ReflectionConstructor("net.minecraftforge.common.ForgeHooks$LootTableContext", ResourceLocation.class, Boolean.TYPE);
    private static final ReflectionField<Gson> GSON_INSTANCE = new ReflectionField(LootTableManager.class, "field_186526_b", "GSON_INSTANCE");
    private static final ReflectionField<LoadingCache<ResourceLocation, LootTable>> FIELD_REGISTERED_LOOT_TABLES = new ReflectionField(LootTableManager.class, "field_186527_c", "registeredLootTables");
    private static LootTable loadingLootTable;

    private static List<WeightedItemStack> getItemList(Properties propFile) {
        ArrayList<WeightedItemStack> items = new ArrayList<WeightedItemStack>();
        Enumeration<Object> fileEntries = propFile.elements();
        while (fileEntries.hasMoreElements()) {
            WeightedItemStack stack;
            String entry = (String)fileEntries.nextElement();
            if (entry.startsWith("#") || (stack = LootTableLoader.createWeightedItemStack(entry)) == null) continue;
            items.add(stack);
        }
        return items;
    }

    private static WeightedItemStack createWeightedItemStack(String entry) {
        StringTokenizer tokenizer = new StringTokenizer(entry, ",");
        int tokenCount = tokenizer.countTokens();
        if (tokenCount >= 5) {
            String item = "minecraft:stone";
            int damage = 0;
            int min_count = 0;
            int max_count = 1;
            int chance = 25;
            boolean enchant = false;
            int min_lvl = 1;
            int max_lvl = 10;
            boolean treasure = false;
            int enchChance = 0;
            item = ((String)tokenizer.nextElement()).trim();
            damage = Integer.parseInt(((String)tokenizer.nextElement()).trim());
            min_count = Integer.parseInt(((String)tokenizer.nextElement()).trim());
            max_count = Integer.parseInt(((String)tokenizer.nextElement()).trim());
            chance = Integer.parseInt(((String)tokenizer.nextElement()).trim());
            if (tokenCount >= 6) {
                enchant = Boolean.parseBoolean(((String)tokenizer.nextElement()).trim());
                min_lvl = Integer.parseInt(((String)tokenizer.nextElement()).trim());
                max_lvl = Integer.parseInt(((String)tokenizer.nextElement()).trim());
                if (tokenCount >= 9) {
                    treasure = Boolean.parseBoolean(((String)tokenizer.nextElement()).trim());
                    if (tokenCount >= 10) {
                        enchChance = Integer.parseInt(((String)tokenizer.nextElement()).trim());
                    }
                }
            }
            WeightedItemStack itemstack = new WeightedItemStack(item, damage, min_count, max_count, chance, enchant, min_lvl, max_lvl, treasure, enchChance);
            return itemstack;
        }
        CQRMain.logger.error("Config string (%s) is invalid! Not enough arguments!", (Object)entry);
        return null;
    }

    public static LootTable fillLootTable(ResourceLocation name, LootTable lootTable) {
        File jsonFile = new File(CQRMain.CQ_CHEST_FOLDER, name.func_110623_a() + ".json");
        File propFile = new File(CQRMain.CQ_CHEST_FOLDER, name.func_110623_a() + ".properties");
        if (jsonFile.exists()) {
            try (FileInputStream inputStream = new FileInputStream(jsonFile);){
                String s = Files.toString((File)jsonFile, (Charset)StandardCharsets.UTF_8);
                ThreadLocal<Deque<?>> lootContext = LOOT_CONTEXT.get(null);
                ArrayDeque que = lootContext.get();
                if (que == null) {
                    que = Queues.newArrayDeque();
                    lootContext.set(que);
                }
                que.push(LOOT_TABLE_CONTEXT.newInstance(name, true));
                lootTable = (LootTable)GSON_INSTANCE.get(null).fromJson(s, LootTable.class);
                que.pop();
                if (lootTable != null) {
                    loadingLootTable = lootTable;
                }
            }
            catch (JsonSyntaxException | IOException e) {
                CQRMain.logger.error("Failed to read json loot table " + jsonFile.getName(), e);
            }
        } else if (propFile.exists()) {
            try (FileInputStream inputStream = new FileInputStream(propFile);){
                Properties properties = new Properties();
                properties.load(inputStream);
                List<WeightedItemStack> items = LootTableLoader.getItemList(properties);
                if (CQRConfig.general.singleLootPoolPerLootTable) {
                    LootEntry[] entries = new LootEntry[items.size()];
                    for (int i = 0; i < items.size(); ++i) {
                        entries[i] = items.get(i).getAsLootEntry(i);
                    }
                    lootTable.addPool(new LootPool(entries, new LootCondition[0], new RandomValueRange((float)Math.min(CQRConfig.general.minItemsPerLootChest, CQRConfig.general.maxItemsPerLootChest), (float)Math.min(Math.max(CQRConfig.general.minItemsPerLootChest, CQRConfig.general.maxItemsPerLootChest), items.size())), new RandomValueRange(0.0f), name.func_110623_a() + "_pool"));
                } else {
                    for (int i = 0; i < items.size(); ++i) {
                        lootTable.addPool(items.get(i).getAsSingleLootPool(i));
                    }
                }
            }
            catch (IOException e) {
                CQRMain.logger.error("Failed to read prop loot table " + propFile.getName(), (Throwable)e);
            }
        }
        return lootTable;
    }

    public static void freezeLootTable() {
        if (loadingLootTable != null) {
            loadingLootTable.freeze();
            loadingLootTable = null;
        }
    }

    public static void registerCustomLootTables(WorldServer worldServer) {
        Collection files = FileUtils.listFiles((File)new File(CQRMain.CQ_CHEST_FOLDER, "chests"), (String[])new String[]{"json", "properties"}, (boolean)false);
        Set<ResourceLocation> cqrChestLootTables = CQRLoottables.getChestLootTables();
        LootTableManager lootTableManager = worldServer.func_184146_ak();
        LoadingCache<ResourceLocation, LootTable> registeredLootTables = FIELD_REGISTERED_LOOT_TABLES.get(lootTableManager);
        for (File file : files) {
            String s = file.getName();
            ResourceLocation name = new ResourceLocation("cqrepoured", "chests/" + s.substring(0, s.lastIndexOf(46)));
            if (cqrChestLootTables.contains(name)) continue;
            LootTable table = new LootTable(new LootPool[0]);
            ForgeEventFactory.loadLootTable((ResourceLocation)name, (LootTable)table, (LootTableManager)lootTableManager);
            registeredLootTables.put((Object)name, (Object)table);
        }
    }
}

